/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.data;

import com.google.typography.font.sfntly.data.ByteArray;
import java.io.IOException;
import java.io.OutputStream;

final class GrowableMemoryByteArray
extends ByteArray<GrowableMemoryByteArray> {
    private static final int INITIAL_LENGTH = 256;
    private byte[] b = new byte[256];

    public GrowableMemoryByteArray() {
        super(0, Integer.MAX_VALUE, true);
    }

    @Override
    protected void internalPut(int n, byte by) {
        this.growTo(n + 1);
        this.b[n] = by;
    }

    @Override
    protected int internalPut(int n, byte[] byArray, int n2, int n3) {
        this.growTo(n + n3);
        System.arraycopy(byArray, n2, this.b, n, n3);
        return n3;
    }

    @Override
    protected int internalGet(int n) {
        return this.b[n];
    }

    @Override
    protected int internalGet(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.b, n, byArray, n2, n3);
        return n3;
    }

    @Override
    public void close() {
        this.b = null;
    }

    @Override
    public int copyTo(OutputStream outputStream, int n, int n2) throws IOException {
        outputStream.write(this.b, n, n2);
        return n2;
    }

    private void growTo(int n) {
        if (n <= this.b.length) {
            return;
        }
        n = Math.max(n, this.b.length * 2);
        byte[] byArray = new byte[n];
        System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        this.b = byArray;
    }
}

