/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public final class FontFactory {
    private static final int LOOKAHEAD_SIZE = 4;
    private boolean fingerprint = false;
    List<Integer> tableOrdering;

    private FontFactory() {
    }

    public static FontFactory getInstance() {
        return new FontFactory();
    }

    public void fingerprintFont(boolean bl) {
        this.fingerprint = bl;
    }

    public boolean fingerprintFont() {
        return this.fingerprint;
    }

    public Font[] loadFonts(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 4);
        if (FontFactory.isCollection(pushbackInputStream)) {
            return this.loadCollection(pushbackInputStream);
        }
        return new Font[]{this.loadSingleOTF(pushbackInputStream)};
    }

    public Font.Builder[] loadFontsForBuilding(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 4);
        if (FontFactory.isCollection(pushbackInputStream)) {
            return this.loadCollectionForBuilding(pushbackInputStream);
        }
        return new Font.Builder[]{this.loadSingleOTFForBuilding(pushbackInputStream)};
    }

    private Font loadSingleOTF(InputStream inputStream) throws IOException {
        return this.loadSingleOTFForBuilding(inputStream).build();
    }

    private Font[] loadCollection(InputStream inputStream) throws IOException {
        Font.Builder[] builderArray = this.loadCollectionForBuilding(inputStream);
        Font[] fontArray = new Font[builderArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = builderArray[i].build();
        }
        return fontArray;
    }

    private Font.Builder loadSingleOTFForBuilding(InputStream object) throws IOException {
        Object object2;
        MessageDigest messageDigest = null;
        if (this.fingerprintFont()) {
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException("Unable to get requested message digest algorithm.", noSuchAlgorithmException);
            }
            object = object2 = new DigestInputStream((InputStream)object, messageDigest);
        }
        object2 = Font.Builder.getOTFBuilder(this, (InputStream)object);
        if (this.fingerprintFont()) {
            ((Font.Builder)object2).setDigest(messageDigest.digest());
        }
        return object2;
    }

    private Font.Builder[] loadCollectionForBuilding(InputStream inputStream) throws IOException {
        WritableFontData writableFontData = WritableFontData.createWritableFontData(inputStream.available());
        writableFontData.copyFrom(inputStream);
        return this.loadCollectionForBuilding(writableFontData);
    }

    private static boolean isCollection(PushbackInputStream pushbackInputStream) throws IOException {
        byte[] byArray = new byte[4];
        pushbackInputStream.read(byArray);
        pushbackInputStream.unread(byArray);
        return Tag.ttcf == Tag.intValue(byArray);
    }

    public Font[] loadFonts(byte[] byArray) throws IOException {
        WritableFontData writableFontData = WritableFontData.createWritableFontData(byArray);
        if (FontFactory.isCollection(writableFontData)) {
            return this.loadCollection(writableFontData);
        }
        return new Font[]{this.loadSingleOTF(writableFontData)};
    }

    public Font.Builder[] loadFontsForBuilding(byte[] byArray) throws IOException {
        WritableFontData writableFontData = WritableFontData.createWritableFontData(byArray);
        if (FontFactory.isCollection(writableFontData)) {
            return this.loadCollectionForBuilding(writableFontData);
        }
        return new Font.Builder[]{this.loadSingleOTFForBuilding(writableFontData, 0)};
    }

    private Font loadSingleOTF(WritableFontData writableFontData) throws IOException {
        return this.loadSingleOTFForBuilding(writableFontData, 0).build();
    }

    private Font[] loadCollection(WritableFontData writableFontData) throws IOException {
        Font.Builder[] builderArray = this.loadCollectionForBuilding(writableFontData);
        Font[] fontArray = new Font[builderArray.length];
        for (int i = 0; i < fontArray.length; ++i) {
            fontArray[i] = builderArray[i].build();
        }
        return fontArray;
    }

    private Font.Builder loadSingleOTFForBuilding(WritableFontData writableFontData, int n) throws IOException {
        Object var3_3 = null;
        if (this.fingerprintFont()) {
            // empty if block
        }
        Font.Builder builder = Font.Builder.getOTFBuilder(this, writableFontData, n);
        return builder;
    }

    private Font.Builder[] loadCollectionForBuilding(WritableFontData writableFontData) throws IOException {
        int n = writableFontData.readULongAsInt(Offset.TTCTag.offset);
        long l = writableFontData.readFixed(Offset.Version.offset);
        int n2 = writableFontData.readULongAsInt(Offset.numFonts.offset);
        Font.Builder[] builderArray = new Font.Builder[n2];
        int n3 = Offset.OffsetTable.offset;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = writableFontData.readULongAsInt(n3);
            builderArray[n4] = this.loadSingleOTFForBuilding(writableFontData, n5);
            ++n4;
            n3 += FontData.DataSize.ULONG.size();
        }
        return builderArray;
    }

    private static boolean isCollection(ReadableFontData readableFontData) {
        byte[] byArray = new byte[4];
        readableFontData.readBytes(0, byArray, 0, byArray.length);
        return Tag.ttcf == Tag.intValue(byArray);
    }

    public void serializeFont(Font font, OutputStream outputStream) throws IOException {
        font.serialize(outputStream, this.tableOrdering);
    }

    public void setSerializationTableOrdering(List<Integer> list) {
        this.tableOrdering = new ArrayList<Integer>(list);
    }

    public Font.Builder newFontBuilder() {
        return Font.Builder.getOTFBuilder(this);
    }

    private static enum Offset {
        TTCTag(0),
        Version(4),
        numFonts(8),
        OffsetTable(12),
        ulDsigTag(0),
        ulDsigLength(4),
        ulDsigOffset(8);

        private final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

