/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.truetype;

import java.io.IOException;
import java.util.ArrayList;
import org.doubletype.ossa.truetype.FontFormatWriter;
import org.doubletype.ossa.truetype.TTName;

public class NameWriter
extends FontFormatWriter {
    public static final String k_regular = "Regular";
    private static final String k_utf16be = "UTF-16BE";
    private static final String k_iso8859_1 = "ISO-8859-1";
    String m_copyright = "\u00a9 Copyright";
    String m_familyName = "Temp";
    String m_subFamilyName = "Regular";
    String m_unique = "eed3si9n: Temp Regular: 2003";
    String m_fullFontName = "Temp";
    String m_version = "0.00";
    String m_psName = "Temp";
    String m_tradeMark = "";
    String m_manufacturer = "eed3si9n";
    String m_year = "2004";
    String m_sample = "The quick brown fox jumps over the lazy dog.";
    private ArrayList<TTName> m_names = new ArrayList();

    private void prepare() {
        this.m_copyright = "\u00a9 Copyright " + this.m_year + ", " + this.m_manufacturer + ".";
        this.m_unique = "dtype: " + this.m_manufacturer + ": " + this.m_familyName + " " + this.m_subFamilyName + ": " + "Version " + this.m_version + ": " + this.m_year;
        this.m_psName = this.m_fullFontName = this.m_familyName;
        if (this.m_tradeMark.length() == 0) {
            this.m_tradeMark = "n/a";
        }
        this.m_names.clear();
        this.addNames();
    }

    private void addNames() {
        this.addMacintoshRomanEnglish(0, this.m_copyright);
        this.addMacintoshRomanEnglish(1, this.m_familyName);
        this.addMacintoshRomanEnglish(2, this.m_subFamilyName);
        this.addMacintoshRomanEnglish(3, this.m_unique);
        this.addMacintoshRomanEnglish(4, this.m_fullFontName);
        this.addMacintoshRomanEnglish(5, "Version " + this.m_version);
        this.addMacintoshRomanEnglish(6, this.m_psName);
        this.addMacintoshRomanEnglish(7, this.m_tradeMark);
        this.addMacintoshRomanEnglish(8, this.m_manufacturer);
        this.addMicrosoftUnicodeEnglish(0, this.m_copyright);
        this.addMicrosoftUnicodeEnglish(1, this.m_familyName);
        this.addMicrosoftUnicodeEnglish(2, this.m_subFamilyName);
        this.addMicrosoftUnicodeEnglish(3, this.m_unique);
        this.addMicrosoftUnicodeEnglish(4, this.m_fullFontName);
        this.addMicrosoftUnicodeEnglish(5, "Version " + this.m_version);
        this.addMicrosoftUnicodeEnglish(6, this.m_psName);
        this.addMicrosoftUnicodeEnglish(7, this.m_tradeMark);
        this.addMicrosoftUnicodeEnglish(8, this.m_manufacturer);
    }

    private void addMacintoshRomanEnglish(int a_nameId, String a_value) {
        try {
            this.add(1, 0, 0, a_nameId, a_value.getBytes(k_iso8859_1));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addMicrosoftUnicodeEnglish(int a_nameId, String a_value) {
        try {
            this.add(3, 1, 1033, a_nameId, a_value.getBytes(k_utf16be));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void add(int a_platformId, int a_encodingId, int a_languageId, int a_nameId, byte[] a_bytes) {
        TTName name = new TTName(a_platformId, a_encodingId, a_languageId, a_nameId, a_bytes);
        this.m_names.add(name);
    }

    @Override
    public void write() throws IOException {
        this.prepare();
        this.writeUInt16(0);
        this.writeUInt16(this.m_names.size());
        this.writeUInt16(12 * this.m_names.size() + 6);
        int offset = 0;
        for (TTName name : this.m_names) {
            this.writeUInt16(name.getPlatformId());
            this.writeUInt16(name.getEncodingId());
            this.writeUInt16(name.getLanguageId());
            this.writeUInt16(name.getNameId());
            this.writeUInt16(name.getStringLength());
            this.writeUInt16(offset);
            offset += name.getStringLength();
        }
        for (TTName name : this.m_names) {
            this.m_buffer.write(name.getBytes());
        }
        this.pad();
    }

    @Override
    protected String getTag() {
        return "name";
    }
}

