/*
 * Decompiled with CFR 0.152.
 */
package org.doubletype.ossa.module;

import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.doubletype.ossa.adapter.EContour;
import org.doubletype.ossa.adapter.EContourPoint;
import org.doubletype.ossa.truetype.TTGlyph;

public class GlyphFile {
    private long m_unicode;
    private String m_author;
    private String m_copyrightYear;
    private Date m_creationDate;
    private Date m_modificationDate;
    private String m_license;
    private Integer m_advanceWidth;
    private List<EContour> m_contours;
    protected long m_modifiedTime;
    protected long m_savedTime;
    private final int k_halfWidth = 512;
    private final int k_fullWidth = 1024;
    public static final int k_defaultPixelSize = 16;

    public GlyphFile(File a_dir, long a_unicode) {
        this.m_modificationDate = this.m_creationDate = new Date();
        this.m_advanceWidth = null;
        this.m_contours = new ArrayList<EContour>();
        this.m_modifiedTime = 0L;
        this.m_savedTime = 0L;
        this.k_halfWidth = 512;
        this.k_fullWidth = 1024;
        this.init();
        this.setUnicode(a_unicode);
        this.setAdvanceWidth(1024);
    }

    public GlyphFile(File a_dir) {
        this.m_modificationDate = this.m_creationDate = new Date();
        this.m_advanceWidth = null;
        this.m_contours = new ArrayList<EContour>();
        this.m_modifiedTime = 0L;
        this.m_savedTime = 0L;
        this.k_halfWidth = 512;
        this.k_fullWidth = 1024;
        this.init();
    }

    private void init() {
        this.m_savedTime = this.m_modifiedTime;
    }

    public void initNotDef(int a_advanceWidth) {
        this.setAdvanceWidth(a_advanceWidth);
        EContour contour = new EContour();
        contour.setType("cubic");
        contour.addContourPoint(new EContourPoint(0.0, 0.0, true));
        contour.addContourPoint(new EContourPoint(438.0, 0.0, true));
        contour.addContourPoint(new EContourPoint(438.0, 683.0, true));
        contour.addContourPoint(new EContourPoint(0.0, 683.0, true));
        this.addContour(contour);
        contour = new EContour();
        contour.setType("cubic");
        contour.addContourPoint(new EContourPoint(365.0, 73.0, true));
        contour.addContourPoint(new EContourPoint(73.0, 73.0, true));
        contour.addContourPoint(new EContourPoint(73.0, 610.0, true));
        contour.addContourPoint(new EContourPoint(365.0, 610.0, true));
        this.addContour(contour);
    }

    public void initNullGlyph() {
        this.setAdvanceWidth(0);
    }

    public void initSpace(int a_advanceWidth) {
        this.setAdvanceWidth(a_advanceWidth);
    }

    public void beforePush() {
    }

    public boolean hasUnsavedChange() {
        return this.m_savedTime != this.m_modifiedTime;
    }

    public void setAuthor(String a_value) {
        this.m_author = a_value;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public void setCopyrightYear(String a_value) {
        this.m_copyrightYear = a_value;
    }

    public String getCopyrightYear() {
        return this.m_copyrightYear;
    }

    public void setCreationDate(Date a_value) {
        this.m_creationDate = a_value;
    }

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public void setModificationDate(Date a_value) {
        this.m_modificationDate = a_value;
    }

    public Date getModificationDate() {
        return this.m_modificationDate;
    }

    public void setAdvanceWidth(int a_width) {
        this.m_advanceWidth = a_width;
    }

    public int getAdvanceWidth() {
        if (this.m_advanceWidth == null) {
            return 512;
        }
        return this.m_advanceWidth;
    }

    private EContour[] toContours() {
        ArrayList<EContour> list = new ArrayList<EContour>();
        for (EContour contour : this.m_contours) {
            list.add(contour.toQuadratic());
        }
        if (list.size() == 0) {
            return null;
        }
        EContour[] retval = new EContour[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            retval[i] = (EContour)list.get(i);
        }
        return retval;
    }

    public void addContour(EContour a_contour) {
        this.m_contours.add(a_contour);
    }

    public long getUnicode() {
        return this.m_unicode;
    }

    protected void setUnicode(long a_unicode) {
        this.m_unicode = a_unicode;
    }

    public boolean isSimple() {
        return true;
    }

    public boolean isWhiteSpace() {
        long unicode = this.getUnicode();
        return unicode == 32L || unicode == 160L || unicode == 8203L || unicode == 8288L || unicode == 12288L || unicode == 65279L;
    }

    public void setLicense(String a_value) {
        this.m_license = a_value;
    }

    public String getLicense() {
        return this.m_license;
    }

    public boolean isRequiredGlyph() {
        long unicode = this.getUnicode();
        return unicode == 1L || unicode == 0L || unicode == 13L || unicode == 32L;
    }

    public TTGlyph toSimpleGlyph() {
        EContour[] contours = this.toContours();
        if (contours == null && !this.isRequiredGlyph()) {
            return null;
        }
        TTGlyph retval = new TTGlyph();
        retval.setSimple(true);
        retval.setAdvanceWidth(this.getAdvanceWidth());
        if (contours == null) {
            return retval;
        }
        ArrayList<EContourPoint> points = new ArrayList<EContourPoint>();
        for (int i = 0; i < contours.length; ++i) {
            EContour contour = contours[i];
            ArrayList<EContourPoint> contourPoints = contour.getContourPoints();
            for (int j = 0; j < contourPoints.size(); ++j) {
                points.add(contourPoints.get(j));
            }
            retval.addEndPoint(points.size() - 1);
        }
        for (EContourPoint point : points) {
            this.loadContourPoint(retval, point);
        }
        return retval;
    }

    private void loadContourPoint(TTGlyph a_glyph, EContourPoint a_point) {
        double x = a_point.getX();
        double y = a_point.getY();
        Point p = new Point((int)x, (int)y);
        int flag = 0;
        if (a_point.isOn()) {
            flag = 1;
        }
        a_glyph.addPoint(p);
        a_glyph.addFlag(flag);
    }
}

