/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash;

public abstract class DebuggerMessage {
    public static final String ARGUMENTS_MARKER = "$arguments";
    public static final String SCOPE_CHAIN_MARKER = "$scopechain";
    public static final int kNumberType = 0;
    public static final int kBooleanType = 1;
    public static final int kStringType = 2;
    public static final int kObjectType = 3;
    public static final int kMovieClipType = 4;
    public static final int kNullType = 5;
    public static final int kUndefinedType = 6;
    public static final int kReferenceType = 7;
    public static final int kArrayType = 8;
    public static final int kObjectEndType = 9;
    public static final int kStrictArrayType = 10;
    public static final int kDateType = 11;
    public static final int kLongStringType = 12;
    public static final int kUnsupportedType = 13;
    public static final int kRecordSetType = 14;
    public static final int kXMLType = 15;
    public static final int kTypedObjectType = 16;
    public static final int kAvmPlusObjectType = 17;
    public static final int kNamespaceType = 18;
    public static final int kTraitsType = 19;
    public static final int kNormalObjectType = 0;
    public static final int kXMLSocketObjectType = 1;
    public static final int kTextFieldObjectType = 2;
    public static final int kButtonObjectType = 3;
    public static final int kNumberObjectType = 4;
    public static final int kBooleanObjectType = 5;
    public static final int kNativeStringObject = 6;
    public static final int kNativeArrayObject = 7;
    public static final int kDateObjectType = 8;
    public static final int kSoundObjectType = 9;
    public static final int kNativeXMLDoc = 10;
    public static final int kNativeXMLNode = 11;
    public static final int kNativeCameraObject = 12;
    public static final int kNativeMicrophoneObject = 13;
    public static final int kNativeCommunicationObject = 14;
    public static final int kNetConnectionObjectType = 15;
    public static final int kNetStreamObjectType = 16;
    public static final int kVideoObjectType = 17;
    public static final int kTextFormatObjectType = 18;
    public static final int kSharedObjectType = 19;
    public static final int kSharedObjectDataType = 20;
    public static final int kPrintJobObjectType = 21;
    public static final int kMovieClipLoaderObjectType = 22;
    public static final int kStyleSheetObjectType = 23;
    public static final int kFapPacketDummyObject = 24;
    public static final int kLoadVarsObject = 25;
    public static final int kTextSnapshotType = 26;

    public abstract int getType();

    public abstract byte[] getData();

    public static String classNameFor(long clsType, boolean isMc) {
        String clsName;
        switch ((int)clsType) {
            case 0: {
                clsName = isMc ? "MovieClip" : "Object";
                break;
            }
            case 1: {
                clsName = "XMLSocket";
                break;
            }
            case 2: {
                clsName = "TextField";
                break;
            }
            case 3: {
                clsName = "Button";
                break;
            }
            case 4: {
                clsName = "Number";
                break;
            }
            case 5: {
                clsName = "Boolean";
                break;
            }
            case 6: {
                clsName = "String";
                break;
            }
            case 7: {
                clsName = "Array";
                break;
            }
            case 8: {
                clsName = "Date";
                break;
            }
            case 9: {
                clsName = "Sound";
                break;
            }
            case 10: {
                clsName = "XML";
                break;
            }
            case 11: {
                clsName = "XMLNode";
                break;
            }
            case 12: {
                clsName = "Camera";
                break;
            }
            case 13: {
                clsName = "Microphone";
                break;
            }
            case 14: {
                clsName = "Communication";
                break;
            }
            case 15: {
                clsName = "Connection";
                break;
            }
            case 16: {
                clsName = "Stream";
                break;
            }
            case 17: {
                clsName = "Video";
                break;
            }
            case 18: {
                clsName = "TextFormat";
                break;
            }
            case 19: {
                clsName = "SharedObject";
                break;
            }
            case 20: {
                clsName = "SharedObjectData";
                break;
            }
            case 21: {
                clsName = "PrintJob";
                break;
            }
            case 22: {
                clsName = "MovieClipLoader";
                break;
            }
            case 23: {
                clsName = "StyleSheet";
                break;
            }
            case 24: {
                clsName = "FapPacket";
                break;
            }
            case 25: {
                clsName = "LoadVars";
                break;
            }
            case 26: {
                clsName = "TextSnapshot";
                break;
            }
            default: {
                clsName = "unknown<" + clsType + ">";
            }
        }
        return clsName;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

