/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFCatalog;
import gnu.jpdf.PDFInfo;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFXref;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class PDFOutput {
    protected OutputStream os;
    protected ByteArrayOutputStream baos;
    protected int offset;
    protected Vector<PDFXref> offsets;
    protected PDFObject rootID;
    protected PDFObject infoID;

    public PDFOutput(OutputStream os) throws IOException {
        this.os = os;
        this.offset = 0;
        this.offsets = new Vector();
        this.baos = new ByteArrayOutputStream();
        this.baos.write("%PDF-1.2\n".getBytes());
        this.baos.write("%\u00e2\u00e3\u00cf\u00d3\n".getBytes());
        this.offset = this.baos.size();
        this.baos.writeTo(os);
    }

    protected void write(PDFObject ob) throws IOException {
        if (ob instanceof PDFCatalog) {
            this.rootID = ob;
        }
        if (ob instanceof PDFInfo) {
            this.infoID = ob;
        }
        this.offsets.addElement(new PDFXref(ob.getSerialID(), this.offset));
        this.baos.reset();
        ob.write(this.baos);
        this.offset += this.baos.size();
        this.baos.writeTo(this.os);
    }

    protected void close() throws IOException {
        this.os.flush();
        this.baos.reset();
        this.baos.write("xref\n".getBytes());
        int firstid = 0;
        int lastid = -1;
        Vector<PDFXref> block = new Vector<PDFXref>();
        block.addElement(new PDFXref(0, 0, 65535));
        for (PDFXref x : this.offsets) {
            if (firstid == -1) {
                firstid = x.id;
            }
            if (lastid > -1 && x.id != lastid + 1) {
                this.writeblock(firstid, block);
                block.removeAllElements();
                firstid = -1;
            }
            block.addElement(x);
            lastid = x.id;
        }
        if (firstid > -1) {
            this.writeblock(firstid, block);
        }
        this.baos.write("trailer\n<<\n".getBytes());
        this.baos.write("/Size ".getBytes());
        this.baos.write(Integer.toString(this.offsets.size() + 1).getBytes());
        this.baos.write("\n".getBytes());
        if (this.rootID == null) {
            throw new IOException("Root object is not present in document");
        }
        this.baos.write("/Root ".getBytes());
        this.baos.write(this.rootID.toString().getBytes());
        this.baos.write("\n".getBytes());
        if (this.infoID != null) {
            this.baos.write("/Info ".getBytes());
            this.baos.write(this.infoID.toString().getBytes());
            this.baos.write("\n".getBytes());
        }
        this.baos.write(">>\nstartxref\n".getBytes());
        this.baos.write(Integer.toString(this.offset).getBytes());
        this.baos.write("\n%%EOF\n".getBytes());
        this.baos.writeTo(this.os);
        this.os.flush();
    }

    protected void writeblock(int firstid, Vector<PDFXref> block) throws IOException {
        this.baos.write(Integer.toString(firstid).getBytes());
        this.baos.write(" ".getBytes());
        this.baos.write(Integer.toString(block.size()).getBytes());
        this.baos.write("\n".getBytes());
        for (PDFXref x : block) {
            this.baos.write(x.toString().getBytes());
            this.baos.write("\n".getBytes());
        }
    }
}

