/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFPage;
import gnu.jpdf.PDFStringHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class PDFOutline
extends PDFObject
implements Serializable {
    private Vector<PDFOutline> outlines = new Vector();
    protected PDFOutline parent;
    private String title = null;
    PDFPage dest = null;
    int l;
    int b;
    int r;
    int t;
    boolean destMode = false;
    static final boolean FITPAGE = false;
    static final boolean FITRECT = true;

    protected PDFOutline() {
        super("/Outlines");
    }

    public PDFOutline(String title, PDFPage dest) {
        this();
        this.title = title;
        this.dest = dest;
    }

    public PDFOutline(String title, PDFPage dest, int l, int b, int r, int t) {
        this(title, dest);
        this.destMode = true;
        this.l = l;
        this.b = b;
        this.r = r;
        this.t = t;
    }

    public PDFOutline add(String title, PDFPage dest) {
        PDFOutline outline = new PDFOutline(title, dest);
        this.pdfDocument.add(outline);
        this.add(outline);
        return outline;
    }

    public PDFOutline add(String title, PDFPage dest, int x, int y, int w, int h) {
        int[] xy1 = dest.cxy(x, y + h);
        int[] xy2 = dest.cxy(x + w, y);
        PDFOutline outline = new PDFOutline(title, dest, xy1[0], xy1[1], xy2[0], xy2[1]);
        this.pdfDocument.add(outline);
        this.add(outline);
        return outline;
    }

    public void add(PDFOutline outline) {
        this.outlines.addElement(outline);
        outline.parent = this;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.writeStart(os);
        if (this.parent != null) {
            os.write("/Title ".getBytes());
            os.write(PDFStringHelper.makePDFString(this.title).getBytes());
            os.write("\n/Dest [".getBytes());
            os.write(this.dest.toString().getBytes());
            if (!this.destMode) {
                os.write(" /Fit]\n/Parent ".getBytes());
            } else {
                os.write(" /FitR ".getBytes());
                os.write(Integer.toString(this.l).getBytes());
                os.write(" ".getBytes());
                os.write(Integer.toString(this.b).getBytes());
                os.write(" ".getBytes());
                os.write(Integer.toString(this.r).getBytes());
                os.write(" ".getBytes());
                os.write(Integer.toString(this.t).getBytes());
                os.write("]\n/Parent ".getBytes());
            }
            os.write(this.parent.toString().getBytes());
            os.write("\n".getBytes());
        }
        if (this.parent == null) {
            os.write("/Count ".getBytes());
            os.write(Integer.toString(this.outlines.size()).getBytes());
            os.write("\n".getBytes());
        } else {
            int c = this.descendants();
            if (c > 0) {
                os.write("/Count ".getBytes());
                os.write(Integer.toString(-c).getBytes());
                os.write("\n".getBytes());
            }
        }
        if (this.outlines.size() > 0) {
            os.write("/First ".getBytes());
            os.write(this.outlines.elementAt(0).toString().getBytes());
            os.write("\n".getBytes());
            os.write("/Last ".getBytes());
            os.write(this.outlines.elementAt(this.outlines.size() - 1).toString().getBytes());
            os.write("\n".getBytes());
        }
        if (this.parent != null) {
            int index = this.parent.getIndex(this);
            if (index > 0) {
                os.write("/Prev ".getBytes());
                os.write(this.parent.getNode(index - 1).toString().getBytes());
                os.write("\n".getBytes());
            }
            if (index < this.parent.getLast()) {
                os.write("/Next ".getBytes());
                os.write(this.parent.getNode(index + 1).toString().getBytes());
                os.write("\n".getBytes());
            }
        }
        this.writeEnd(os);
    }

    protected int getIndex(PDFOutline outline) {
        return this.outlines.indexOf(outline);
    }

    protected int getLast() {
        return this.outlines.size() - 1;
    }

    protected PDFOutline getNode(int i) {
        return this.outlines.elementAt(i);
    }

    public Enumeration<PDFOutline> elements() {
        return this.outlines.elements();
    }

    protected int descendants() {
        int c = this.outlines.size();
        for (PDFOutline o : this.outlines) {
            c += o.descendants();
        }
        return c;
    }
}

