/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFStringHelper;
import java.io.IOException;
import java.io.OutputStream;

public class PDFInfo
extends PDFObject {
    private String author;
    private String creator;
    private String title;
    private String subject;
    private String keywords;

    public PDFInfo() {
        super(null);
    }

    public PDFInfo(String title) {
        this();
        this.title = title;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String v) {
        this.author = v;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String v) {
        this.creator = v;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String v) {
        this.title = v;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String v) {
        this.subject = v;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String v) {
        this.keywords = v;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.writeStart(os);
        if (this.author != null) {
            os.write("/Author (".getBytes());
            os.write(PDFStringHelper.makePDFString(this.author).getBytes());
            os.write(")\n".getBytes());
        }
        if (this.creator != null) {
            os.write("/Creator (".getBytes());
            os.write(PDFStringHelper.makePDFString(this.creator).getBytes());
            os.write(")\n".getBytes());
        }
        os.write("/Producer ".getBytes());
        os.write(PDFStringHelper.makePDFString("gnujpdf - gnujpdf.sourceforge.net").getBytes());
        os.write("\n".getBytes());
        if (this.title != null) {
            os.write("/Title ".getBytes());
            os.write(PDFStringHelper.makePDFString(this.title).getBytes());
            os.write("\n".getBytes());
        }
        if (this.subject != null) {
            os.write("/Subject (".getBytes());
            os.write(PDFStringHelper.makePDFString(this.subject).getBytes());
            os.write(")\n".getBytes());
        }
        if (this.keywords != null) {
            os.write("/Keywords (".getBytes());
            os.write(PDFStringHelper.makePDFString(this.keywords).getBytes());
            os.write(")\n".getBytes());
        }
        this.writeEnd(os);
    }
}

