/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFObject;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PDFFont
extends PDFObject
implements Serializable {
    private String name;
    private String type;
    private String font;
    private String javaFont;
    private int style;
    private static String[][] base14 = new String[][]{{"arial", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}, {"sansserif", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}, {"monospaced", "/Courier", "/Courier-Bold", "/Courier-Oblique", "/Courier-BoldOblique"}, {"timesroman", "/Times-Roman", "/Times-Bold", "/Times-Italic", "/Times-BoldItalic"}, {"courier", "/Courier", "/Courier-Bold", "/Courier-Oblique", "/Courier-BoldOblique"}, {"helvetica", "/Helvetica", "/Helvetica-Bold", "/Helvetica-Oblique", "/Helvetica-BoldOblique"}, {"dialog", "/Courier", "/Courier-Bold", "/Courier-Oblique", "/Courier-BoldOblique"}, {"dialoginput", "/Courier", "/Courier-Bold", "/Courier-Oblique", "/Courier-BoldOblique"}};

    protected PDFFont() {
        this("/F1", "/Type1", "Helvetica", 0);
    }

    public PDFFont(String name, String type, String font, int style) {
        super("/Font");
        this.name = name;
        this.type = type;
        this.style = style;
        String f = font.toLowerCase();
        this.font = font;
        this.javaFont = "/" + font;
        for (int i = 0; i < base14.length; ++i) {
            if (!base14[i][0].equals(f)) continue;
            this.javaFont = base14[i][0];
            this.font = base14[i][1 + style];
            break;
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getFont() {
        return this.font;
    }

    public int getStyle() {
        return this.style;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.writeStart(os);
        os.write("/Subtype ".getBytes());
        os.write(this.type.getBytes());
        os.write("\n/Name ".getBytes());
        os.write(this.name.getBytes());
        os.write("\n/BaseFont ".getBytes());
        os.write(this.font.getBytes());
        os.write("\n/Encoding ".getBytes());
        os.write("/WinAnsiEncoding".getBytes());
        os.write("\n".getBytes());
        this.writeEnd(os);
    }

    protected boolean equals(String type, String font, int style) {
        return this.type.equals(type) && (this.font.equalsIgnoreCase(font) || this.javaFont.equalsIgnoreCase(font));
    }
}

