/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFCatalog;
import gnu.jpdf.PDFFont;
import gnu.jpdf.PDFImage;
import gnu.jpdf.PDFInfo;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFOutline;
import gnu.jpdf.PDFOutput;
import gnu.jpdf.PDFPage;
import gnu.jpdf.PDFPageList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;

public class PDFDocument
implements Serializable {
    protected int objser = 1;
    protected Vector<PDFObject> objects = new Vector();
    private PDFCatalog catalog;
    private PDFInfo info;
    private PDFPageList pdfPageList;
    private PDFOutline outline;
    protected PDFObject defaultOutlineBorder;
    public static final int USENONE = 0;
    public static final int USEOUTLINES = 1;
    public static final int USETHUMBS = 2;
    public static final int FULLSCREEN = 3;
    public static final String[] PDF_PAGE_MODES = new String[]{"/UseNone", "/UseOutlines", "/UseThumbs", "/FullScreen"};
    private int fontid = 0;
    private int imageid = 0;
    private Vector<PDFFont> fonts = new Vector();

    public PDFDocument() {
        this(0);
    }

    public PDFDocument(int pagemode) {
        this.pdfPageList = new PDFPageList();
        this.add(this.pdfPageList);
        this.catalog = new PDFCatalog(this.pdfPageList, pagemode);
        this.add(this.catalog);
        this.info = new PDFInfo();
        this.add(this.info);
        this.add(this.getOutline());
    }

    public synchronized int add(PDFObject obj) {
        this.objects.addElement(obj);
        obj.objser = this.objser++;
        obj.pdfDocument = this;
        if (obj instanceof PDFPage) {
            this.pdfPageList.add((PDFPage)obj);
        }
        return obj.objser;
    }

    public PDFPage getPage(int page) {
        return this.pdfPageList.getPage(page);
    }

    public PDFOutline getOutline() {
        if (this.outline == null) {
            this.outline = new PDFOutline();
            this.catalog.setOutline(this.outline);
        }
        return this.outline;
    }

    public PDFFont getFont(String type, String font, int style) {
        for (PDFFont ft : this.fonts) {
            if (!ft.equals(type, font, style)) continue;
            return ft;
        }
        ++this.fontid;
        PDFFont ft = new PDFFont("/F" + this.fontid, type, font, style);
        this.add(ft);
        this.fonts.addElement(ft);
        return ft;
    }

    public String setImageName(PDFImage img) {
        ++this.imageid;
        img.setName("/Image" + this.imageid);
        return img.getName();
    }

    public void setPDFInfo(PDFInfo info) {
        this.info = info;
    }

    public PDFInfo getPDFInfo() {
        return this.info;
    }

    public void write(OutputStream os) throws IOException {
        PDFOutput pos = new PDFOutput(os);
        for (PDFObject o : this.objects) {
            pos.write(o);
        }
        pos.close();
        os.flush();
    }
}

