/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.graph.GraphPart;
import java.util.Collections;
import java.util.List;

public class GraphPartMulti
extends GraphPart {
    public List<GraphPart> parts;

    public GraphPartMulti(List<GraphPart> parts) {
        super(parts.get((int)0).start, parts.get((int)(parts.size() - 1)).end);
        this.parts = parts;
        this.path = parts.get((int)0).path;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[multi ");
        boolean first = true;
        for (GraphPart g : this.parts) {
            if (first) {
                first = false;
            } else {
                ret.append(", ");
            }
            ret.append(g.toString());
        }
        ret.append("]");
        return ret.toString();
    }

    @Override
    public int getHeight() {
        int ret = 0;
        for (GraphPart p : this.parts) {
            ret += p.getHeight();
        }
        return ret;
    }

    @Override
    public int getPosAt(int offset) {
        int ofs = 0;
        int pos = 0;
        for (GraphPart p : this.parts) {
            for (int i = 0; i < p.getHeight(); ++i) {
                pos = p.start + i;
                if (++ofs != offset) continue;
                return pos;
            }
        }
        return -1;
    }

    @Override
    public List<GraphPart> getSubParts() {
        return Collections.unmodifiableList(this.parts);
    }
}

