/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.xfl;

import com.jpexs.helpers.Helper;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XFLXmlWriter
implements XMLStreamWriter {
    private static final Logger logger = Logger.getLogger(XFLXmlWriter.class.getName());
    private final String newLineCharacters = "\n";
    private boolean newLine = true;
    private boolean newLineNeeded = false;
    private boolean startElementClosed = true;
    private final StringBuilder sb = new StringBuilder();
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private final Stack<String> tagsStack = new Stack();

    public String toString() {
        return this.sb.toString();
    }

    private XFLXmlWriter append(char character) {
        this.sb.append(character);
        this.newLine = false;
        return this;
    }

    private XFLXmlWriter append(String text) {
        this.sb.append(text);
        this.newLine = false;
        return this;
    }

    private void makeNewLine() {
        if (!this.newLine) {
            this.sb.append("\n");
            this.newLine = true;
            for (int i = 0; i < this.tagsStack.size(); ++i) {
                this.sb.append("  ");
            }
        }
    }

    private void closeStartElement() {
        if (!this.startElementClosed) {
            this.append('>');
            this.startElementClosed = true;
        }
    }

    private void ensureStartElementOpen() throws XMLStreamException {
        if (this.startElementClosed) {
            throw new XMLStreamException("Attempted to write attribute out of the start element");
        }
    }

    private void closeStartElementNewLine() {
        this.closeStartElement();
        this.makeNewLine();
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.closeStartElementNewLine();
        this.append('<').append(localName);
        this.tagsStack.add(localName);
        this.startElementClosed = false;
        this.newLineNeeded = false;
    }

    public void writeStartElement(String localName, String[] attributes) throws XMLStreamException {
        this.writeStartElement(localName);
        if (attributes.length % 2 != 0) {
            throw new XMLStreamException("Attribute count should be even");
        }
        for (int i = 0; i < attributes.length / 2; ++i) {
            this.writeAttribute(attributes[i * 2], attributes[i * 2 + 1]);
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElementInternal(this.getPrefix(namespaceURI), localName, namespaceURI);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.setPrefix(prefix, namespaceURI);
        this.writeStartElementInternal(prefix, localName, namespaceURI);
    }

    private void writeStartElementInternal(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.closeStartElementNewLine();
        this.append('<').append(prefix).append(':').append(localName);
        this.writeNamespace(prefix, namespaceURI);
        this.tagsStack.add(localName);
        this.startElementClosed = false;
        this.newLineNeeded = false;
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeEmptyElementInternal(this.getPrefix(namespaceURI), localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.setPrefix(prefix, namespaceURI);
        this.writeEmptyElementInternal(prefix, localName, namespaceURI);
    }

    private void writeEmptyElementInternal(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(prefix, localName, namespaceURI);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeEndElement();
    }

    public void writeEmptyElement(String localName, String[] attributes) throws XMLStreamException {
        this.writeStartElement(localName, attributes);
        this.writeEndElement();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        String localName = this.tagsStack.pop();
        if (this.startElementClosed) {
            if (this.newLineNeeded) {
                this.makeNewLine();
            }
            this.append("</").append(localName).append('>');
        } else {
            this.append(" />");
            this.startElementClosed = true;
        }
        this.newLineNeeded = true;
    }

    public void writeElementValue(String localName, String value) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeCharacters(value);
        this.writeEndElement();
    }

    public void writeElementValue(String localName, float value) throws XMLStreamException {
        this.writeElementValue(localName, Float.toString(value));
    }

    public void writeElementValue(String localName, double value) throws XMLStreamException {
        this.writeElementValue(localName, Double.toString(value));
    }

    public void writeElementValue(String localName, int value) throws XMLStreamException {
        this.writeElementValue(localName, Integer.toString(value));
    }

    public void writeElementValue(String localName, long value) throws XMLStreamException {
        this.writeElementValue(localName, Long.toString(value));
    }

    public void writeElementValueRaw(String localName, String value) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeCharactersRaw(value);
        this.writeEndElement();
    }

    public void writeElementValue(String localName, String value, String[] attributes) throws XMLStreamException {
        this.writeStartElement(localName, attributes);
        this.writeCharacters(value);
        this.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.ensureStartElementOpen();
        this.append(' ').append(localName).append("=\"").append(XFLXmlWriter.escapeAttribute(value)).append('\"');
    }

    public void writeAttribute(String localName, float value) throws XMLStreamException {
        this.writeAttribute(localName, Float.toString(value));
    }

    public void writeAttribute(String localName, double value) throws XMLStreamException {
        this.writeAttribute(localName, Double.toString(value));
    }

    public void writeAttribute(String localName, int value) throws XMLStreamException {
        this.writeAttribute(localName, Integer.toString(value));
    }

    public void writeAttribute(String localName, long value) throws XMLStreamException {
        this.writeAttribute(localName, Long.toString(value));
    }

    public void writeAttribute(String localName, boolean value) throws XMLStreamException {
        this.writeAttribute(localName, value ? "true" : "false");
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.setPrefix(prefix, namespaceURI);
        this.writeAttributeInternal(prefix, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttributeInternal(this.getPrefix(namespaceURI), localName, value);
    }

    private void writeAttributeInternal(String prefix, String localName, String value) throws XMLStreamException {
        this.ensureStartElementOpen();
        this.append(' ').append(prefix).append(':').append(localName).append("=\"").append(XFLXmlWriter.escapeAttribute(value)).append('\"');
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writeAttribute("xmlns", null, prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.closeStartElement();
        this.append("<!--").append(data).append("-->");
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.closeStartElement();
        this.append("<![CDATA[").append(data).append("]]>");
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.closeStartElement();
        this.append(XFLXmlWriter.escapeText(text));
    }

    public void writeCharactersRaw(String text) throws XMLStreamException {
        this.closeStartElement();
        this.append(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writeCharacters(new String(text, start, len));
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        String prefix = this.namespaces.get(uri);
        return prefix;
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.namespaces.put(prefix, prefix);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return null;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    public static String escapeText(String text) {
        String[] from = new String[]{"&", "<", "\"", "'", "\r", "\n"};
        String[] to = new String[]{"&amp;", "&lt;", "&quot;", "&#x27;", "&#xD;", "&#xA;"};
        for (int i = 0; i < from.length; ++i) {
            text = text.replace(from[i], to[i]);
        }
        if (Helper.containsInvalidXMLCharacter(text)) {
            logger.log(Level.WARNING, "The following text contains a character which is invalid in XML: {0}", text);
            return Helper.removeInvalidXMLCharacters(text);
        }
        return text;
    }

    public static String escapeAttribute(String text) {
        String[] from = new String[]{"&", "<", "\"", "'", "\r", "\n"};
        String[] to = new String[]{"&amp;", "&lt;", "&quot;", "&#x27;", "&#xD;", "&#xA;"};
        for (int i = 0; i < from.length; ++i) {
            text = text.replace(from[i], to[i]);
        }
        if (Helper.containsInvalidXMLCharacter(text)) {
            logger.log(Level.WARNING, "The following text contains a character which is invalid in XML: {0}", text);
            return Helper.removeInvalidXMLCharacters(text);
        }
        return text;
    }

    public int length() {
        return this.sb.length();
    }

    public void setLength(int newLength) {
        this.sb.setLength(newLength);
    }

    public boolean isEmpty() {
        return this.sb.length() == 0;
    }
}

