/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.gfx;

import java.io.IOException;
import java.io.OutputStream;

public class GFxOutputStream
extends OutputStream {
    public static final int MaxUInt6 = 63;
    public static final int MaxUInt7 = 127;
    public static final int MaxUInt14 = 16383;
    public static final int MaxUInt22 = 0x3FFFFF;
    public static final int MaxUInt30 = 0x3FFFFFFF;
    public static final int MinSInt5 = -16;
    public static final int MaxSInt5 = 15;
    public static final int MinSInt6 = -32;
    public static final int MaxSInt6 = 31;
    public static final int MinSInt7 = -64;
    public static final int MaxSInt7 = 63;
    public static final int MinSInt8 = -128;
    public static final int MaxSInt8 = 127;
    public static final int MinSInt9 = -256;
    public static final int MaxSInt9 = 255;
    public static final int MinSInt10 = -512;
    public static final int MaxSInt10 = 511;
    public static final int MinSInt11 = -1024;
    public static final int MaxSInt11 = 1023;
    public static final int MinSInt12 = -2048;
    public static final int MaxSInt12 = 2047;
    public static final int MinSInt13 = -4096;
    public static final int MaxSInt13 = 4095;
    public static final int MinSInt14 = -8192;
    public static final int MaxSInt14 = 8191;
    public static final int MinSInt15 = -16384;
    public static final int MaxSInt15 = 16383;
    public static final int MinSInt17 = -65536;
    public static final int MaxSInt17 = 65535;
    public static final int MinSInt18 = -131072;
    public static final int MaxSInt18 = 131071;
    public static final int MinSInt19 = -262144;
    public static final int MaxSInt19 = 262143;
    public static final int MinSInt20 = -524288;
    public static final int MaxSInt20 = 524287;
    public static final int MinSInt22 = -2097152;
    public static final int MaxSInt22 = 0x1FFFFF;
    private final OutputStream os;
    private long pos = 0L;

    public GFxOutputStream(OutputStream os) {
        this.os = os;
    }

    public long getPos() {
        return this.pos;
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
        ++this.pos;
    }

    public void writeSI32(long value) throws IOException {
        this.writeUI32(value);
    }

    public void writeSI16(int value) throws IOException {
        this.writeUI16(value);
    }

    public void writeSI8(int value) throws IOException {
        this.writeUI8(value);
    }

    public void writeUI32(long value) throws IOException {
        this.write((int)(value & 0xFFL));
        this.write((int)(value >> 8 & 0xFFL));
        this.write((int)(value >> 16 & 0xFFL));
        this.write((int)(value >> 24 & 0xFFL));
    }

    public void writeUI16(int value) throws IOException {
        this.write(value & 0xFF);
        this.write(value >> 8 & 0xFF);
    }

    public void writeUI8(int val) throws IOException {
        this.write(val & 0xFF);
    }

    public void writeFLOAT(float value) throws IOException {
        this.writeUI32(Float.floatToIntBits(value));
    }

    public void writeSI15(int v) throws IOException {
        if (v >= -64 && v <= 63) {
            this.writeUI8(v << 1);
            return;
        }
        this.writeUI8(v << 1 | 1);
        this.writeUI8(v >> 7);
    }

    public void writeUI15(int v) throws IOException {
        if (v <= 127) {
            this.writeUI8(v << 1);
            return;
        }
        this.writeUI8(v << 1 | 1);
        this.writeUI8(v >> 7);
    }

    public void writeUI30(int v) throws IOException {
        if (v <= 63) {
            this.writeUI8(v << 2);
            return;
        }
        if (v <= 16383) {
            this.writeUI8(v << 2 | 1);
            this.writeUI8(v >> 6);
            return;
        }
        if (v <= 0x3FFFFF) {
            this.writeUI8(v << 2 | 2);
            this.writeUI8(v >> 6);
            this.writeUI8(v >> 14);
            return;
        }
        this.writeUI8(v << 2 | 3);
        this.writeUI8(v >> 6);
        this.writeUI8(v >> 14);
        this.writeUI8(v >> 22);
    }
}

