/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types.filters;

import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.Filtering;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import java.util.ArrayList;

public class GRADIENTGLOWFILTER
extends FILTER {
    @SWFType(countField="numColors")
    public RGBA[] gradientColors = new RGBA[0];
    @SWFType(value=BasicType.UI8, countField="numColors")
    public int[] gradientRatio;
    @SWFType(value=BasicType.FIXED)
    public double blurX;
    @SWFType(value=BasicType.FIXED)
    public double blurY;
    @SWFType(value=BasicType.FIXED)
    public double angle;
    @SWFType(value=BasicType.FIXED)
    public double distance;
    @SWFType(value=BasicType.FIXED8)
    public float strength;
    public boolean innerShadow;
    public boolean knockout;
    public boolean compositeSource;
    public boolean onTop;
    @SWFType(value=BasicType.UB, count=4)
    public int passes;

    public GRADIENTGLOWFILTER() {
        super(4);
    }

    @Override
    public SerializableImage apply(SerializableImage src) {
        ArrayList<Color> colors = new ArrayList<Color>();
        ArrayList<Float> ratios = new ArrayList<Float>();
        for (int i = 0; i < this.gradientColors.length; ++i) {
            if (i > 0 && this.gradientRatio[i - 1] == this.gradientRatio[i]) continue;
            colors.add(this.gradientColors[i].toColor());
            ratios.add(Float.valueOf((float)this.gradientRatio[i] / 255.0f));
        }
        int type = 1;
        if (this.onTop && !this.innerShadow) {
            type = 3;
        } else if (!this.innerShadow) {
            type = 2;
        }
        float[] ratiosAr = new float[ratios.size()];
        for (int i = 0; i < ratios.size(); ++i) {
            ratiosAr[i] = ((Float)ratios.get(i)).floatValue();
        }
        return Filtering.gradientGlow(src, (int)this.blurX, (int)this.blurY, (float)((int)(this.angle * 180.0 / Math.PI)), this.distance, colors.toArray(new Color[colors.size()]), ratiosAr, type, this.passes, this.strength, this.knockout);
    }

    @Override
    public double getDeltaX() {
        return this.blurX + this.distance * Math.cos(this.angle);
    }

    @Override
    public double getDeltaY() {
        return this.blurY + this.distance * Math.sin(this.angle);
    }
}

