/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.tags.base.NeedsCharacters;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.MORPHGRADIENT;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import java.io.Serializable;
import java.util.Set;

public class MORPHFILLSTYLE
implements NeedsCharacters,
Serializable {
    @SWFType(value=BasicType.UI8)
    @EnumValues(value={@EnumValue(value=0, text="Solid"), @EnumValue(value=16, text="Linear gradient"), @EnumValue(value=18, text="Radial gradient"), @EnumValue(value=19, text="Focal radial gradient", minSwfVersion=8), @EnumValue(value=64, text="Repeating bitmap"), @EnumValue(value=65, text="Clipped bitmap"), @EnumValue(value=66, text="Non smoothed repeating bitmap"), @EnumValue(value=67, text="Non smoothed clipped bitmap")})
    public int fillStyleType;
    public static final int SOLID = 0;
    public static final int LINEAR_GRADIENT = 16;
    public static final int RADIAL_GRADIENT = 18;
    public static final int FOCAL_RADIAL_GRADIENT = 19;
    public static final int REPEATING_BITMAP = 64;
    public static final int CLIPPED_BITMAP = 65;
    public static final int NON_SMOOTHED_REPEATING_BITMAP = 66;
    public static final int NON_SMOOTHED_CLIPPED_BITMAP = 67;
    @Conditional(value={"fillStyleType"}, options={0})
    public RGBA startColor;
    @Conditional(value={"fillStyleType"}, options={0})
    public RGBA endColor;
    @Conditional(value={"fillStyleType"}, options={16, 18})
    public MATRIX startGradientMatrix;
    @Conditional(value={"fillStyleType"}, options={16, 18})
    public MATRIX endGradientMatrix;
    @Conditional(value={"fillStyleType"}, options={16, 18})
    public MORPHGRADIENT gradient;
    @Conditional(value={"fillStyleType"}, options={65, 66, 67})
    public int bitmapId;
    @Conditional(value={"fillStyleType"}, options={65, 66, 67})
    public MATRIX startBitmapMatrix;
    @Conditional(value={"fillStyleType"}, options={65, 66, 67})
    public MATRIX endBitmapMatrix;

    @Override
    public void getNeededCharacters(Set<Integer> needed) {
        if (this.fillStyleType == 64 || this.fillStyleType == 65 || this.fillStyleType == 66 || this.fillStyleType == 67) {
            needed.add(this.bitmapId);
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        if (this.bitmapId == oldCharacterId) {
            this.bitmapId = newCharacterId;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        if (this.bitmapId == characterId) {
            if (this.fillStyleType == 64 || this.fillStyleType == 65 || this.fillStyleType == 66 || this.fillStyleType == 67) {
                this.fillStyleType = 0;
            }
            this.bitmapId = 0;
            return true;
        }
        return false;
    }

    private MATRIX morphMatrix(MATRIX a, MATRIX b, int ratio) {
        if (a == null) {
            return null;
        }
        if (b == null) {
            return null;
        }
        MATRIX ret = new MATRIX();
        double ratio_d = (double)ratio / 65535.0;
        ret.scaleX = (int)Math.round((double)a.getScaleX() + (double)(b.getScaleX() - a.getScaleX()) * ratio_d);
        ret.scaleY = (int)Math.round((double)a.getScaleY() + (double)(b.getScaleY() - a.getScaleY()) * ratio_d);
        ret.rotateSkew0 = (int)Math.round((double)a.getRotateSkew0() + (double)(b.getRotateSkew0() - a.getRotateSkew0()) * ratio_d);
        ret.rotateSkew1 = (int)Math.round((double)a.getRotateSkew1() + (double)(b.getRotateSkew1() - a.getRotateSkew1()) * ratio_d);
        ret.translateX = (int)Math.round((double)a.translateX + (double)(b.translateX - a.translateX) * ratio_d);
        ret.translateY = (int)Math.round((double)a.translateY + (double)(b.translateY - a.translateY) * ratio_d);
        ret.hasRotate = true;
        ret.hasScale = true;
        return ret;
    }

    public FILLSTYLE getFillStyleAt(int ratio) {
        FILLSTYLE ret = new FILLSTYLE();
        ret.bitmapId = this.bitmapId;
        if (this.startBitmapMatrix != null) {
            ret.bitmapMatrix = this.morphMatrix(this.startBitmapMatrix, this.endBitmapMatrix, ratio);
        }
        if (this.startColor != null) {
            ret.color = MORPHGRADIENT.morphColor(this.startColor, this.endColor, ratio);
        }
        ret.fillStyleType = this.fillStyleType;
        if (this.gradient != null) {
            ret.gradient = this.gradient.getGradientAt(ratio);
        }
        if (this.startGradientMatrix != null) {
            ret.gradientMatrix = this.morphMatrix(this.startGradientMatrix, this.endGradientMatrix, ratio);
        }
        return ret;
    }

    public FILLSTYLE getStartFillStyle() {
        FILLSTYLE ret = new FILLSTYLE();
        ret.bitmapId = this.bitmapId;
        ret.bitmapMatrix = this.startBitmapMatrix;
        ret.color = this.startColor;
        ret.fillStyleType = this.fillStyleType;
        if (this.gradient != null) {
            ret.gradient = this.gradient.getStartGradient();
        }
        ret.gradientMatrix = this.startGradientMatrix;
        return ret;
    }

    public FILLSTYLE getEndFillStyle() {
        FILLSTYLE ret = new FILLSTYLE();
        ret.bitmapId = this.bitmapId;
        ret.bitmapMatrix = this.endBitmapMatrix;
        ret.color = this.endColor;
        ret.fillStyleType = this.fillStyleType;
        if (this.gradient != null) {
            ret.gradient = this.gradient.getEndGradient();
        }
        ret.gradientMatrix = this.endGradientMatrix;
        return ret;
    }
}

