/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.types;

import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.helpers.Helper;
import java.io.Serializable;
import java.util.ArrayList;

public class CLIPEVENTFLAGS
implements Serializable {
    public boolean clipEventKeyUp;
    public boolean clipEventKeyDown;
    public boolean clipEventMouseUp;
    public boolean clipEventMouseDown;
    public boolean clipEventMouseMove;
    public boolean clipEventUnload;
    public boolean clipEventEnterFrame;
    public boolean clipEventLoad;
    @Conditional(minSwfVersion=6)
    public boolean clipEventDragOver;
    @Conditional(minSwfVersion=6)
    public boolean clipEventRollOut;
    @Conditional(minSwfVersion=6)
    public boolean clipEventRollOver;
    @Conditional(minSwfVersion=6)
    public boolean clipEventReleaseOutside;
    @Conditional(minSwfVersion=6)
    public boolean clipEventRelease;
    @Conditional(minSwfVersion=6)
    public boolean clipEventPress;
    @Conditional(minSwfVersion=6)
    public boolean clipEventInitialize;
    public boolean clipEventData;
    @Reserved
    @SWFType(value=BasicType.UB, count=5)
    @Conditional(minSwfVersion=6)
    public int reserved;
    @Conditional(minSwfVersion=7)
    public boolean clipEventConstruct = false;
    @Conditional(minSwfVersion=6)
    public boolean clipEventKeyPress = false;
    @Conditional(minSwfVersion=6)
    public boolean clipEventDragOut = false;
    @Reserved
    @SWFType(value=BasicType.UB, count=8)
    @Conditional(minSwfVersion=6)
    public int reserved2;

    public String getHeader(int key, boolean asFileName) {
        String ret = "";
        ArrayList<String> onList = new ArrayList<String>();
        if (this.clipEventKeyUp) {
            ret = "onClipEvent(keyUp)";
        }
        if (this.clipEventKeyDown) {
            ret = "onClipEvent(keyDown)";
        }
        if (this.clipEventMouseUp) {
            ret = "onClipEvent(mouseUp)";
        }
        if (this.clipEventMouseDown) {
            ret = "onClipEvent(mouseDown)";
        }
        if (this.clipEventMouseMove) {
            ret = "onClipEvent(mouseMove)";
        }
        if (this.clipEventUnload) {
            ret = "onClipEvent(unload)";
        }
        if (this.clipEventEnterFrame) {
            ret = "onClipEvent(enterFrame)";
        }
        if (this.clipEventLoad) {
            ret = "onClipEvent(load)";
        }
        if (this.clipEventData) {
            ret = "onClipEvent(data)";
        }
        if (this.clipEventDragOver) {
            onList.add("dragOver");
        }
        if (this.clipEventRollOut) {
            onList.add("rollOut");
        }
        if (this.clipEventRollOver) {
            onList.add("rollOver");
        }
        if (this.clipEventReleaseOutside) {
            onList.add("releaseOutside");
        }
        if (this.clipEventRelease) {
            onList.add("release");
        }
        if (this.clipEventPress) {
            onList.add("press");
        }
        if (this.clipEventInitialize) {
            onList.add("initialize");
        }
        if (this.clipEventConstruct) {
            onList.add("construct");
        }
        if (this.clipEventKeyPress) {
            if (asFileName) {
                onList.add("keyPress " + Helper.makeFileName(CLIPACTIONRECORD.keyToString(key).replace("<", "").replace(">", "")) + "");
            } else {
                onList.add("keyPress \"" + CLIPACTIONRECORD.keyToString(key) + "\"");
            }
        }
        if (this.clipEventDragOut) {
            onList.add("dragOut");
        }
        if (!onList.isEmpty()) {
            ret = "on(" + Helper.joinStrings(onList, ",") + ")";
        }
        return ret.trim();
    }

    public boolean isClear() {
        if (this.clipEventKeyUp) {
            return false;
        }
        if (this.clipEventKeyDown) {
            return false;
        }
        if (this.clipEventMouseUp) {
            return false;
        }
        if (this.clipEventMouseDown) {
            return false;
        }
        if (this.clipEventMouseMove) {
            return false;
        }
        if (this.clipEventUnload) {
            return false;
        }
        if (this.clipEventEnterFrame) {
            return false;
        }
        if (this.clipEventLoad) {
            return false;
        }
        if (this.clipEventDragOver) {
            return false;
        }
        if (this.clipEventRollOut) {
            return false;
        }
        if (this.clipEventRollOver) {
            return false;
        }
        if (this.clipEventReleaseOutside) {
            return false;
        }
        if (this.clipEventRelease) {
            return false;
        }
        if (this.clipEventPress) {
            return false;
        }
        if (this.clipEventInitialize) {
            return false;
        }
        if (this.clipEventData) {
            return false;
        }
        if (this.clipEventConstruct) {
            return false;
        }
        if (this.clipEventKeyPress) {
            return false;
        }
        return !this.clipEventDragOut;
    }
}

