/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.TweenRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TweenDetector {
    public static List<TweenRange> detectRanges(List<DepthState> depthStates) {
        if (depthStates.size() < 2 || depthStates.get((int)0).placeObjectTag == depthStates.get((int)1).placeObjectTag) {
            return new ArrayList<TweenRange>();
        }
        return new ArrayList<TweenRange>(Arrays.asList(new TweenRange(0, depthStates.size() - 1)));
    }

    private static double getErrorLevel(List<Double> yValues, int start, int len) {
        double[] ret = TweenDetector.calc(yValues, start, len);
        double a = ret[0];
        double b = ret[1];
        double sumdelta = 0.0;
        double maxdelta = 0.0;
        for (int i = start; i < start + len; ++i) {
            double yorig = yValues.get(i);
            double ynew = a + b * (double)(i - start);
            double ydelta = Math.abs(ynew - yorig);
            sumdelta += ydelta;
            if (!(ydelta > maxdelta)) continue;
            maxdelta = ydelta;
        }
        return maxdelta;
    }

    private static double[] calc(List<Double> yValues, int start, int len) {
        ArrayList<Double> xValues = new ArrayList<Double>();
        for (int i = 0; i < len; ++i) {
            xValues.add(Double.valueOf(i));
        }
        yValues = yValues.subList(start, start + len);
        double b = TweenDetector.covariance(xValues, yValues) / TweenDetector.variance(xValues);
        double a = TweenDetector.mean(yValues) - b * TweenDetector.mean(xValues);
        return new double[]{a, b};
    }

    private static double covariance(List<Double> x, List<Double> y) {
        double xmean = TweenDetector.mean(x);
        double ymean = TweenDetector.mean(y);
        double result = 0.0;
        for (int i = 0; i < x.size(); ++i) {
            result += (x.get(i) - xmean) * (y.get(i) - ymean);
        }
        return result /= (double)(x.size() - 1);
    }

    private static double mean(List<Double> data) {
        double sum = 0.0;
        for (int i = 0; i < data.size(); ++i) {
            sum += data.get(i).doubleValue();
        }
        return sum / (double)data.size();
    }

    private static double variance(List<Double> data) {
        double mean = TweenDetector.mean(data);
        double sumOfSquaredDeviations = 0.0;
        for (int i = 0; i < data.size(); ++i) {
            sumOfSquaredDeviations += Math.pow(data.get(i) - mean, 2.0);
        }
        return sumOfSquaredDeviations / (double)(data.size() - 1);
    }
}

