/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.Exportable;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

public class Frame
implements TreeItem,
Exportable {
    public final int frame;
    public TreeMap<Integer, DepthState> layers = new TreeMap();
    public RGB backgroundColor = new RGBA(0, 0, 0, 0);
    public final Timeline timeline;
    public List<Integer> sounds = new ArrayList<Integer>();
    public List<String> soundClasses = new ArrayList<String>();
    public List<DoActionTag> actions = new ArrayList<DoActionTag>();
    public List<ASMSourceContainer> actionContainers = new ArrayList<ASMSourceContainer>();
    public List<Tag> innerTags = new ArrayList<Tag>();
    public ShowFrameTag showFrameTag = null;
    public boolean layersChanged;
    public String label = null;
    public boolean namedAnchor = false;

    public Frame(Timeline timeline, int frame) {
        this.timeline = timeline;
        this.frame = frame;
    }

    public Frame(Frame obj, int frame) {
        this.frame = frame;
        this.layers = new TreeMap();
        this.backgroundColor = obj.backgroundColor;
        this.timeline = obj.timeline;
        for (int depth : obj.layers.keySet()) {
            this.layers.put(depth, new DepthState(obj.layers.get(depth), this, true));
        }
    }

    @Override
    public SWF getSwf() {
        return this.timeline.swf;
    }

    public String toString() {
        return "frame " + (this.frame + 1);
    }

    @Override
    public String getExportFileName() {
        return "frame_" + (this.frame + 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Frame) {
            Frame frameObj = (Frame)obj;
            return Objects.equals(this.timeline, frameObj.timeline) && this.frame == frameObj.frame;
        }
        return false;
    }

    public int hashCode() {
        return this.timeline.hashCode() ^ Integer.hashCode(this.frame);
    }

    @Override
    public boolean isModified() {
        for (Tag tag : this.innerTags) {
            if (!tag.isModified()) continue;
            return true;
        }
        for (Tag tag : this.actions) {
            if (!tag.isModified()) continue;
            return true;
        }
        for (ASMSourceContainer aSMSourceContainer : this.actionContainers) {
            if (!aSMSourceContainer.isModified()) continue;
            return true;
        }
        return this.showFrameTag != null && this.showFrameTag.isModified();
    }
}

