/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.font;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharacterRanges {
    private static final List<Language> languages = new ArrayList<Language>();

    public static int rangeCount() {
        return languages.size();
    }

    public static String rangeName(int index) {
        return CharacterRanges.languages.get((int)index).name;
    }

    public static int glyphCount(int index) {
        List<Range> ranges = CharacterRanges.languages.get((int)index).ranges;
        int cnt = 0;
        for (Range r : ranges) {
            for (int i = r.from; i <= r.to; ++i) {
                ++cnt;
            }
        }
        return cnt;
    }

    public static List<String> rangeNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < CharacterRanges.rangeCount(); ++i) {
            ret.add(CharacterRanges.rangeName(i));
        }
        return ret;
    }

    public static int[] rangeCodes(int index) {
        List<Range> ranges = CharacterRanges.languages.get((int)index).ranges;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (Range r : ranges) {
            for (int i = r.from; i <= r.to; ++i) {
                ret.add(i);
            }
        }
        int[] retArr = new int[ret.size()];
        for (int i = 0; i < ret.size(); ++i) {
            retArr[i] = (Integer)ret.get(i);
        }
        return retArr;
    }

    static {
        BufferedReader br = new BufferedReader(new InputStreamReader(CharacterRanges.class.getResourceAsStream("/com/jpexs/decompiler/flash/tags/font/character_ranges.txt")));
        try {
            String s;
            while ((s = br.readLine()) != null) {
                String[] ranges;
                String[] parts = s.split(":");
                Language lng = new Language(parts[0]);
                for (String r : ranges = parts[1].split(",")) {
                    if (r.contains("-")) {
                        String[] fromTo = r.split("-");
                        lng.ranges.add(new Range(Integer.parseInt(fromTo[0], 16), Integer.parseInt(fromTo[1], 16)));
                        continue;
                    }
                    lng.ranges.add(new Range(Integer.parseInt(r, 16)));
                }
                languages.add(lng);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CharacterRanges.class.getName()).log(Level.SEVERE, "Cannot read unicode character ranges", ex);
        }
    }

    private static class Language {
        String name;
        List<Range> ranges;

        public Language(String name) {
            this.name = name;
            this.ranges = new ArrayList<Range>();
        }

        public Language(String name, List<Range> ranges) {
            this.name = name;
            this.ranges = ranges;
        }
    }

    private static class Range {
        public int from;
        public int to;

        public Range(int fromto) {
            this.from = fromto;
            this.to = fromto;
        }

        public Range(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            if (this.from == this.to) {
                return "" + this.from;
            }
            return "" + this.from + "-" + this.to;
        }
    }
}

