/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.base;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.morphshape.CanvasMorphShapeExporter;
import com.jpexs.decompiler.flash.exporters.morphshape.SVGMorphShapeExporter;
import com.jpexs.decompiler.flash.exporters.shape.BitmapExporter;
import com.jpexs.decompiler.flash.exporters.shape.SVGShapeExporter;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public abstract class MorphShapeTag
extends DrawableTag {
    public static final int MAX_RATIO = 65535;
    @SWFType(value=BasicType.UI16)
    public int characterId;
    public RECT startBounds;
    public RECT endBounds;
    public MORPHFILLSTYLEARRAY morphFillStyles;
    public MORPHLINESTYLEARRAY morphLineStyles;
    public SHAPE startEdges;
    public SHAPE endEdges;

    public MorphShapeTag(SWF swf, int id, String name, ByteArrayRange data) {
        super(swf, id, name, data);
    }

    public abstract int getShapeNum();

    @Override
    public RECT getRect() {
        return this.getRect(new HashSet<BoundedTag>());
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed) {
        this.morphFillStyles.getNeededCharacters(needed);
        this.startEdges.getNeededCharacters(needed);
        this.endEdges.getNeededCharacters(needed);
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        modified |= this.morphFillStyles.replaceCharacter(oldCharacterId, newCharacterId);
        modified |= this.startEdges.replaceCharacter(oldCharacterId, newCharacterId);
        if (modified |= this.endEdges.replaceCharacter(oldCharacterId, newCharacterId)) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        modified |= this.morphFillStyles.removeCharacter(characterId);
        modified |= this.startEdges.removeCharacter(characterId);
        if (modified |= this.endEdges.removeCharacter(characterId)) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public int getCharacterId() {
        return this.characterId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterId = characterId;
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        RECT rect = new RECT();
        rect.Xmin = Math.min(this.startBounds.Xmin, this.endBounds.Xmin);
        rect.Ymin = Math.min(this.startBounds.Ymin, this.endBounds.Ymin);
        rect.Xmax = Math.max(this.startBounds.Xmax, this.endBounds.Xmax);
        rect.Ymax = Math.max(this.startBounds.Ymax, this.endBounds.Ymax);
        return rect;
    }

    public RECT getStartBounds() {
        return this.startBounds;
    }

    public RECT getEndBounds() {
        return this.endBounds;
    }

    public MORPHFILLSTYLEARRAY getFillStyles() {
        return this.morphFillStyles;
    }

    public MORPHLINESTYLEARRAY getLineStyles() {
        return this.morphLineStyles;
    }

    public SHAPE getStartEdges() {
        return this.startEdges;
    }

    public SHAPE getEndEdges() {
        return this.endEdges;
    }

    public SHAPEWITHSTYLE getShapeAtRatio(int ratio) {
        ArrayList<SHAPERECORD> finalRecords = new ArrayList<SHAPERECORD>();
        FILLSTYLEARRAY fillStyles = this.morphFillStyles.getFillStylesAt(ratio);
        LINESTYLEARRAY lineStyles = this.morphLineStyles.getLineStylesAt(this.getShapeNum(), ratio);
        int startPosX = 0;
        int startPosY = 0;
        int endPosX = 0;
        int endPosY = 0;
        int posX = 0;
        int posY = 0;
        int startIndex = 0;
        for (int endIndex = 0; startIndex < this.startEdges.shapeRecords.size() && endIndex < this.endEdges.shapeRecords.size(); ++startIndex, ++endIndex) {
            SHAPERECORD edge1 = this.startEdges.shapeRecords.get(startIndex);
            SHAPERECORD edge2 = this.endEdges.shapeRecords.get(endIndex);
            if (edge1 instanceof StyleChangeRecord || edge2 instanceof StyleChangeRecord) {
                StyleChangeRecord scr2;
                StyleChangeRecord scr1;
                if (edge1 instanceof StyleChangeRecord) {
                    scr1 = (StyleChangeRecord)edge1;
                    if (scr1.stateMoveTo) {
                        startPosX = scr1.moveDeltaX;
                        startPosY = scr1.moveDeltaY;
                    }
                } else {
                    scr1 = new StyleChangeRecord();
                    --startIndex;
                }
                if (edge2 instanceof StyleChangeRecord) {
                    scr2 = (StyleChangeRecord)edge2;
                    if (scr2.stateMoveTo) {
                        endPosX = scr2.moveDeltaX;
                        endPosY = scr2.moveDeltaY;
                    }
                } else {
                    scr2 = new StyleChangeRecord();
                    --endIndex;
                }
                StyleChangeRecord scr = scr1.clone();
                if (scr1.stateMoveTo || scr2.stateMoveTo) {
                    scr.moveDeltaX = startPosX + (endPosX - startPosX) * ratio / 65535;
                    scr.moveDeltaY = startPosY + (endPosY - startPosY) * ratio / 65535;
                    scr.stateMoveTo = scr.moveDeltaX != posX || scr.moveDeltaY != posY;
                }
                finalRecords.add(scr);
                continue;
            }
            if (edge1 instanceof EndShapeRecord) {
                finalRecords.add(edge1);
                break;
            }
            if (edge2 instanceof EndShapeRecord) {
                finalRecords.add(edge2);
                break;
            }
            if (edge1 instanceof CurvedEdgeRecord || edge2 instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer1 = null;
                if (edge1 instanceof CurvedEdgeRecord) {
                    cer1 = (CurvedEdgeRecord)edge1;
                } else if (edge1 instanceof StraightEdgeRecord) {
                    cer1 = SHAPERECORD.straightToCurve((StraightEdgeRecord)edge1);
                }
                CurvedEdgeRecord cer2 = null;
                if (edge2 instanceof CurvedEdgeRecord) {
                    cer2 = (CurvedEdgeRecord)edge2;
                } else if (edge2 instanceof StraightEdgeRecord) {
                    cer2 = SHAPERECORD.straightToCurve((StraightEdgeRecord)edge2);
                }
                if (cer2 == null || cer1 == null) continue;
                CurvedEdgeRecord cer = new CurvedEdgeRecord();
                cer.controlDeltaX = cer1.controlDeltaX + (cer2.controlDeltaX - cer1.controlDeltaX) * ratio / 65535;
                cer.controlDeltaY = cer1.controlDeltaY + (cer2.controlDeltaY - cer1.controlDeltaY) * ratio / 65535;
                cer.anchorDeltaX = cer1.anchorDeltaX + (cer2.anchorDeltaX - cer1.anchorDeltaX) * ratio / 65535;
                cer.anchorDeltaY = cer1.anchorDeltaY + (cer2.anchorDeltaY - cer1.anchorDeltaY) * ratio / 65535;
                startPosX += cer1.controlDeltaX + cer1.anchorDeltaX;
                startPosY += cer1.controlDeltaY + cer1.anchorDeltaY;
                endPosX += cer2.controlDeltaX + cer2.anchorDeltaX;
                endPosY += cer2.controlDeltaY + cer2.anchorDeltaY;
                posX += cer.controlDeltaX + cer.anchorDeltaX;
                posY += cer.controlDeltaY + cer.anchorDeltaY;
                finalRecords.add(cer);
                continue;
            }
            StraightEdgeRecord ser1 = null;
            if (edge1 instanceof StraightEdgeRecord) {
                ser1 = (StraightEdgeRecord)edge1;
            }
            StraightEdgeRecord ser2 = null;
            if (edge2 instanceof StraightEdgeRecord) {
                ser2 = (StraightEdgeRecord)edge2;
            }
            if (ser2 == null || ser1 == null) continue;
            StraightEdgeRecord ser = new StraightEdgeRecord();
            ser.generalLineFlag = true;
            ser.vertLineFlag = false;
            ser.deltaX = ser1.deltaX + (ser2.deltaX - ser1.deltaX) * ratio / 65535;
            ser.deltaY = ser1.deltaY + (ser2.deltaY - ser1.deltaY) * ratio / 65535;
            startPosX += ser1.deltaX;
            startPosY += ser1.deltaY;
            endPosX += ser2.deltaX;
            endPosY += ser2.deltaY;
            posX += ser.deltaX;
            posY += ser.deltaX;
            finalRecords.add(ser);
        }
        SHAPEWITHSTYLE shape = new SHAPEWITHSTYLE();
        shape.fillStyles = fillStyles;
        shape.lineStyles = lineStyles;
        shape.shapeRecords = finalRecords;
        return shape;
    }

    @Override
    public int getUsedParameters() {
        return 4;
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, ColorTransform colorTransform) {
        SHAPEWITHSTYLE shape = this.getShapeAtRatio(ratio);
        BitmapExporter.export(this.swf, shape, null, image, transformation, strokeTransformation, colorTransform);
    }

    @Override
    public void toSVG(SVGExporter exporter, int ratio, ColorTransform colorTransform, int level) {
        if (ratio == -2) {
            SHAPEWITHSTYLE beginShapes = this.getShapeAtRatio(0);
            SHAPEWITHSTYLE endShapes = this.getShapeAtRatio(65535);
            SVGMorphShapeExporter shapeExporter = new SVGMorphShapeExporter(this.swf, beginShapes, endShapes, exporter, null, colorTransform, 1.0);
            shapeExporter.export();
        } else {
            SHAPEWITHSTYLE shapes = this.getShapeAtRatio(ratio);
            SVGShapeExporter shapeExporter = new SVGShapeExporter(this.swf, shapes, exporter, null, colorTransform, 1.0);
            shapeExporter.export();
        }
    }

    @Override
    public int getNumFrames() {
        return 65536;
    }

    @Override
    public boolean isSingleFrame() {
        return true;
    }

    @Override
    public Shape getOutline(int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, boolean stroked) {
        return transformation.toTransform().createTransformedShape(this.getShapeAtRatio(ratio).getOutline(this.swf, stroked));
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        CanvasMorphShapeExporter cmse = new CanvasMorphShapeExporter(this.swf, this.getShapeAtRatio(0), this.getShapeAtRatio(65535), null, unitDivisor, 0, 0);
        cmse.export();
        result.append(cmse.getShapeData());
    }
}

