/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.sound.SoundExportFormat;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

@SWFVersion(from=1)
public class DefineSoundTag
extends CharacterTag
implements SoundTag {
    public static final int ID = 14;
    public static final String NAME = "DefineSound";
    @SWFType(value=BasicType.UI16)
    public int soundId;
    @SWFType(value=BasicType.UB, count=4)
    @EnumValues(value={@EnumValue(value=0, text="Uncompressed, native-endian"), @EnumValue(value=1, text="ADPCM"), @EnumValue(value=2, text="MP3", minSwfVersion=4), @EnumValue(value=3, text="Uncompressed, little-endian", minSwfVersion=4), @EnumValue(value=4, text="Nellymoser 16 kHz", minSwfVersion=10), @EnumValue(value=5, text="Nellymoser 8 kHz", minSwfVersion=10), @EnumValue(value=6, text="Nellymoser", minSwfVersion=6), @EnumValue(value=11, text="Speex", minSwfVersion=10)})
    public int soundFormat;
    @SWFType(value=BasicType.UB, count=2)
    @EnumValues(value={@EnumValue(value=0, text="5.5 kHz"), @EnumValue(value=1, text="11 kHz"), @EnumValue(value=2, text="22 kHz"), @EnumValue(value=3, text="44 kHz")})
    public int soundRate;
    public boolean soundSize;
    public boolean soundType;
    @SWFType(value=BasicType.UI32)
    public long soundSampleCount;
    public ByteArrayRange soundData;

    public DefineSoundTag(SWF swf) {
        super(swf, 14, NAME, null);
        this.soundId = swf.getNextCharacterId();
        this.soundData = ByteArrayRange.EMPTY;
    }

    public DefineSoundTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 14, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.soundId = sis.readUI16("soundId");
        this.soundFormat = (int)sis.readUB(4, "soundFormat");
        this.soundRate = (int)sis.readUB(2, "soundRate");
        this.soundSize = sis.readUB(1, "soundSize") == 1L;
        this.soundType = sis.readUB(1, "soundType") == 1L;
        this.soundSampleCount = sis.readUI32("soundSampleCount");
        this.soundData = sis.readByteRangeEx(sis.available(), "soundData");
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.soundId);
        sos.writeUB(4, this.soundFormat);
        sos.writeUB(2, this.soundRate);
        sos.writeUB(1, this.soundSize ? 1L : 0L);
        sos.writeUB(1, this.soundType ? 1L : 0L);
        sos.writeUI32(this.soundSampleCount);
        sos.write(this.soundData);
    }

    @Override
    public int getCharacterId() {
        return this.soundId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.soundId = characterId;
    }

    @Override
    public SoundExportFormat getExportFormat() {
        if (this.soundFormat == 2) {
            return SoundExportFormat.MP3;
        }
        if (this.soundFormat == 1) {
            return SoundExportFormat.WAV;
        }
        if (this.soundFormat == 3) {
            return SoundExportFormat.WAV;
        }
        if (this.soundFormat == 0) {
            return SoundExportFormat.WAV;
        }
        if (this.soundFormat == 6 || this.soundFormat == 4 || this.soundFormat == 5) {
            return SoundExportFormat.WAV;
        }
        return SoundExportFormat.FLV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadID3v2(InputStream in) {
        int size = -1;
        try {
            in.mark(10);
            size = this.readID3v2Header(in);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException iOException) {}
        }
        try {
            if (size > 0) {
                byte[] rawid3v2 = new byte[size];
                in.read(rawid3v2, 0, rawid3v2.length);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readID3v2Header(InputStream in) throws IOException {
        byte[] id3header = new byte[4];
        int size = -10;
        in.read(id3header, 0, 3);
        if (id3header[0] == 73 && id3header[1] == 68 && id3header[2] == 51) {
            in.read(id3header, 0, 3);
            byte majorVersion = id3header[0];
            byte revision = id3header[1];
            in.read(id3header, 0, 4);
            size = (id3header[0] << 21) + (id3header[1] << 14) + (id3header[2] << 7) + id3header[3];
        }
        return size + 10;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean setSound(InputStream is, int newSoundFormat) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 17[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean importSupported() {
        return true;
    }

    @Override
    public int getSoundRate() {
        return this.soundRate;
    }

    @Override
    public boolean getSoundType() {
        return this.soundType;
    }

    @Override
    public List<ByteArrayRange> getRawSoundData() {
        ArrayList<ByteArrayRange> ret = new ArrayList<ByteArrayRange>();
        if (this.soundFormat == 2) {
            ret.add(this.soundData.getSubRange(2, this.soundData.getLength() - 2));
            return ret;
        }
        ret.add(this.soundData);
        return ret;
    }

    @Override
    public int getSoundFormatId() {
        return this.soundFormat;
    }

    @Override
    public long getTotalSoundSampleCount() {
        return this.soundSampleCount;
    }

    @Override
    public boolean getSoundSize() {
        return this.soundSize;
    }

    @Override
    public SoundFormat getSoundFormat() {
        int[] rateMap = new int[]{5512, 11025, 22050, 44100};
        return new SoundFormat(this.getSoundFormatId(), rateMap[this.getSoundRate()], this.getSoundType());
    }

    @Override
    public void getTagInfo(TagInfo tagInfo) {
        super.getTagInfo(tagInfo);
        SoundFormat soundFormat = this.getSoundFormat();
        tagInfo.addInfo("general", "codecName", soundFormat.getFormatName());
        tagInfo.addInfo("general", "exportFormat", (Object)soundFormat.getNativeExportFormat());
        tagInfo.addInfo("general", "samplingRate", soundFormat.samplingRate);
        tagInfo.addInfo("general", "stereo", soundFormat.stereo);
        tagInfo.addInfo("general", "sampleCount", this.soundSampleCount);
    }
}

