/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightSpecialType;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.MissingCharacterHandler;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.dynamictext.CharacterWithStyle;
import com.jpexs.decompiler.flash.tags.dynamictext.DynamicTextModel;
import com.jpexs.decompiler.flash.tags.dynamictext.GlyphCharacter;
import com.jpexs.decompiler.flash.tags.dynamictext.Paragraph;
import com.jpexs.decompiler.flash.tags.dynamictext.SameStyleTextRecord;
import com.jpexs.decompiler.flash.tags.dynamictext.TextStyle;
import com.jpexs.decompiler.flash.tags.dynamictext.Word;
import com.jpexs.decompiler.flash.tags.enums.TextRenderMode;
import com.jpexs.decompiler.flash.tags.text.ParsedSymbol;
import com.jpexs.decompiler.flash.tags.text.TextAlign;
import com.jpexs.decompiler.flash.tags.text.TextLexer;
import com.jpexs.decompiler.flash.tags.text.TextParseException;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.DynamicTextGlyphEntry;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@SWFVersion(from=4)
public class DefineEditTextTag
extends TextTag {
    public static final int ID = 37;
    public static final String NAME = "DefineEditText";
    @SWFType(value=BasicType.UI16)
    public int characterID;
    public RECT bounds;
    public boolean hasText;
    public boolean wordWrap;
    public boolean multiline;
    public boolean password;
    public boolean readOnly;
    public boolean hasTextColor;
    public boolean hasMaxLength;
    public boolean hasFont;
    public boolean hasFontClass;
    public boolean autoSize;
    public boolean hasLayout;
    public boolean noSelect;
    public boolean border;
    public boolean wasStatic;
    public boolean html;
    public boolean useOutlines;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasFont"})
    public int fontId;
    @Conditional(value={"hasFontClass"})
    public String fontClass;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasFont|hasFontClass"})
    public int fontHeight;
    @Conditional(value={"hasTextColor"})
    public RGBA textColor;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasMaxLength"})
    public int maxLength;
    @SWFType(value=BasicType.UI8)
    @Conditional(value={"hasLayout"})
    @EnumValues(value={@EnumValue(value=0, text="Left"), @EnumValue(value=1, text="Right"), @EnumValue(value=2, text="Center"), @EnumValue(value=3, text="Justify")})
    public int align;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasLayout"})
    public int leftMargin;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasLayout"})
    public int rightMargin;
    @SWFType(value=BasicType.UI16)
    @Conditional(value={"hasLayout"})
    public int indent;
    @SWFType(value=BasicType.SI16)
    @Conditional(value={"hasLayout"})
    public int leading;
    public String variableName;
    @Conditional(value={"hasText"})
    public String initialText;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_JUSTIFY = 3;

    public DefineEditTextTag(SWF swf) {
        super(swf, 37, NAME, null);
        this.characterID = swf.getNextCharacterId();
        this.bounds = new RECT();
        this.variableName = "";
    }

    public DefineEditTextTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 37, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.bounds = sis.readRECT("bounds");
        this.hasText = sis.readUB(1, "hasText") == 1L;
        this.wordWrap = sis.readUB(1, "wordWrap") == 1L;
        this.multiline = sis.readUB(1, "multiline") == 1L;
        this.password = sis.readUB(1, "password") == 1L;
        this.readOnly = sis.readUB(1, "readOnly") == 1L;
        this.hasTextColor = sis.readUB(1, "hasTextColor") == 1L;
        this.hasMaxLength = sis.readUB(1, "hasMaxLength") == 1L;
        this.hasFont = sis.readUB(1, "hasFont") == 1L;
        this.hasFontClass = sis.readUB(1, "hasFontClass") == 1L;
        this.autoSize = sis.readUB(1, "autoSize") == 1L;
        this.hasLayout = sis.readUB(1, "hasLayout") == 1L;
        this.noSelect = sis.readUB(1, "noSelect") == 1L;
        this.border = sis.readUB(1, "border") == 1L;
        this.wasStatic = sis.readUB(1, "wasStatic") == 1L;
        this.html = sis.readUB(1, "html") == 1L;
        boolean bl = this.useOutlines = sis.readUB(1, "useOutlines") == 1L;
        if (this.hasFont) {
            this.fontId = sis.readUI16("fontId");
        }
        if (this.hasFontClass) {
            this.fontClass = sis.readString("fontClass");
        }
        if (this.hasFont || this.hasFontClass) {
            this.fontHeight = sis.readUI16("fontHeight");
        }
        if (this.hasTextColor) {
            this.textColor = sis.readRGBA("textColor");
        }
        if (this.hasMaxLength) {
            this.maxLength = sis.readUI16("maxLength");
        }
        if (this.hasLayout) {
            this.align = sis.readUI8("align");
            this.leftMargin = sis.readUI16("leftMargin");
            this.rightMargin = sis.readUI16("rightMargin");
            this.indent = sis.readUI16("indent");
            this.leading = sis.readSI16("leading");
        }
        this.variableName = sis.readString("variableName");
        if (this.hasText) {
            this.initialText = sis.readString("initialText");
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeRECT(this.bounds);
        sos.writeUB(1, this.hasText ? 1L : 0L);
        sos.writeUB(1, this.wordWrap ? 1L : 0L);
        sos.writeUB(1, this.multiline ? 1L : 0L);
        sos.writeUB(1, this.password ? 1L : 0L);
        sos.writeUB(1, this.readOnly ? 1L : 0L);
        sos.writeUB(1, this.hasTextColor ? 1L : 0L);
        sos.writeUB(1, this.hasMaxLength ? 1L : 0L);
        sos.writeUB(1, this.hasFont ? 1L : 0L);
        sos.writeUB(1, this.hasFontClass ? 1L : 0L);
        sos.writeUB(1, this.autoSize ? 1L : 0L);
        sos.writeUB(1, this.hasLayout ? 1L : 0L);
        sos.writeUB(1, this.noSelect ? 1L : 0L);
        sos.writeUB(1, this.border ? 1L : 0L);
        sos.writeUB(1, this.wasStatic ? 1L : 0L);
        sos.writeUB(1, this.html ? 1L : 0L);
        sos.writeUB(1, this.useOutlines ? 1L : 0L);
        if (this.hasFont) {
            sos.writeUI16(this.fontId);
        }
        if (this.hasFontClass) {
            sos.writeString(this.fontClass);
        }
        if (this.hasFont || this.hasFontClass) {
            sos.writeUI16(this.fontHeight);
        }
        if (this.hasTextColor) {
            sos.writeRGBA(this.textColor);
        }
        if (this.hasMaxLength) {
            sos.writeUI16(this.maxLength);
        }
        if (this.hasLayout) {
            sos.writeUI8(this.align);
            sos.writeUI16(this.leftMargin);
            sos.writeUI16(this.rightMargin);
            sos.writeUI16(this.indent);
            sos.writeSI16(this.leading);
        }
        sos.writeString(this.variableName);
        if (this.hasText) {
            sos.writeString(this.initialText);
        }
    }

    @Override
    public RECT getBounds() {
        return this.bounds;
    }

    @Override
    public MATRIX getTextMatrix() {
        MATRIX matrix = new MATRIX();
        matrix.translateX = this.bounds.Xmin;
        matrix.translateY = this.bounds.Ymin;
        return matrix;
    }

    @Override
    public void setBounds(RECT r) {
        this.bounds = r;
    }

    private String stripTags(String inp) {
        boolean intag = false;
        String outp = "";
        inp = inp.replaceAll("<br ?/?>", "\r\n");
        for (int i = 0; i < inp.length(); ++i) {
            if (!intag && inp.charAt(i) == '<') {
                intag = true;
                continue;
            }
            if (intag && inp.charAt(i) == '>') {
                intag = false;
                continue;
            }
            if (intag) continue;
            outp = outp + inp.charAt(i);
        }
        return outp;
    }

    private String entitiesReplace(String s) {
        s = s.replace("&lt;", "<");
        s = s.replace("&gt;", ">");
        s = s.replace("&amp;", "&");
        s = s.replace("&quot;", "\"");
        return s;
    }

    @Override
    public List<String> getTexts() {
        String ret = "";
        if (this.hasText) {
            ret = this.initialText;
        }
        if (this.html) {
            ret = this.stripTags(ret);
            ret = this.entitiesReplace(ret);
        }
        return Arrays.asList(ret);
    }

    private List<CharacterWithStyle> getTextWithStyle() {
        String str = "";
        TextStyle style = new TextStyle();
        style.font = this.fontClass != null ? this.swf.getFontByClass(this.fontClass) : this.swf.getFont(this.fontId);
        style.fontHeight = this.fontHeight;
        style.fontLeading = this.leading;
        if (this.hasTextColor) {
            style.textColor = this.textColor;
        }
        if (this.hasText) {
            str = this.initialText;
        }
        final ArrayList<CharacterWithStyle> ret = new ArrayList<CharacterWithStyle>();
        if (this.html) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            final Stack<TextStyle> styles = new Stack<TextStyle>();
            styles.add(style);
            try {
                SAXParser saxParser = factory.newSAXParser();
                DefaultHandler handler = new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        TextStyle style = (TextStyle)styles.peek();
                        switch (qName) {
                            case "p": {
                                break;
                            }
                            case "b": {
                                style = style.clone();
                                style.bold = true;
                                styles.add(style);
                                break;
                            }
                            case "i": {
                                style = style.clone();
                                style.italic = true;
                                styles.add(style);
                                break;
                            }
                            case "u": {
                                style = style.clone();
                                style.underlined = true;
                                styles.add(style);
                                break;
                            }
                            case "font": {
                                String face;
                                char firstChar;
                                String size;
                                style = style.clone();
                                String color = attributes.getValue("color");
                                if (color != null && color.startsWith("#")) {
                                    style.textColor = new RGBA(Color.decode(color));
                                }
                                if ((size = attributes.getValue("size")) != null && size.length() > 0 && (firstChar = size.charAt(0)) != '+' && firstChar != '-') {
                                    int fontSize = Integer.parseInt(size);
                                    style.fontHeight = (int)Math.round((double)fontSize * 20.0);
                                    style.fontLeading = DefineEditTextTag.this.leading;
                                }
                                if ((face = attributes.getValue("face")) != null && face.length() > 0) {
                                    FontTag insideFont;
                                    style.fontFace = face;
                                    style.font = insideFont = DefineEditTextTag.this.swf.getFontByName(face);
                                    if (insideFont != null) {
                                        style.fontFace = null;
                                    }
                                }
                                styles.add(style);
                                break;
                            }
                            case "br": 
                            case "sbr": {
                                CharacterWithStyle cs = new CharacterWithStyle();
                                cs.character = (char)10;
                                cs.style = style;
                                ret.add(cs);
                            }
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        switch (qName) {
                            case "b": 
                            case "i": 
                            case "u": 
                            case "font": {
                                styles.pop();
                                break;
                            }
                            case "p": {
                                TextStyle style = (TextStyle)styles.peek();
                                CharacterWithStyle cs = new CharacterWithStyle();
                                cs.character = (char)10;
                                cs.style = style;
                                ret.add(cs);
                            }
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        String txt = new String(ch, start, length);
                        TextStyle style = (TextStyle)styles.peek();
                        DefineEditTextTag.this.addCharacters(ret, txt, style);
                    }
                };
                str = "<!DOCTYPE html [\n    <!ENTITY nbsp \"&#160;\"> \n]><root>" + str + "</root>";
                saxParser.parse((InputStream)new ByteArrayInputStream(str.getBytes(Utf8Helper.charset)), handler);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(DefineEditTextTag.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.addCharacters(ret, str, style);
        }
        return ret;
    }

    private void addCharacters(List<CharacterWithStyle> list, String str, TextStyle style) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            CharacterWithStyle cs = new CharacterWithStyle();
            cs.character = ch;
            cs.style = style;
            list.add(cs);
        }
    }

    @Override
    public List<Integer> getFontIds() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        ret.add(this.fontId);
        return ret;
    }

    @Override
    public HighlightedText getFormattedText(boolean ignoreLetterSpacing) {
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
        writer.append("[");
        String[] alignNames = new String[]{"left", "right", "center", "justify"};
        String alignment = this.align < alignNames.length ? alignNames[this.align] : "unknown";
        writer.newLine();
        writer.append("xmin ").append(this.bounds.Xmin).newLine();
        writer.append("ymin ").append(this.bounds.Ymin).newLine();
        writer.append("xmax ").append(this.bounds.Xmax).newLine();
        writer.append("ymax ").append(this.bounds.Ymax).newLine();
        if (this.wordWrap) {
            writer.append("wordwrap 1").newLine();
        }
        if (this.multiline) {
            writer.append("multiline 1").newLine();
        }
        if (this.password) {
            writer.append("password 1").newLine();
        }
        if (this.readOnly) {
            writer.append("readonly 1").newLine();
        }
        if (this.autoSize) {
            writer.append("autosize 1").newLine();
        }
        if (this.noSelect) {
            writer.append("noselect 1").newLine();
        }
        if (this.border) {
            writer.append("border 1").newLine();
        }
        if (this.wasStatic) {
            writer.append("wasstatic 1").newLine();
        }
        if (this.html) {
            writer.append("html 1").newLine();
        }
        if (this.useOutlines) {
            writer.append("useoutlines 1").newLine();
        }
        if (this.hasFont) {
            writer.append("font ").append(this.fontId).newLine();
            writer.append("height ").append(this.fontHeight).newLine();
        }
        if (this.hasTextColor) {
            writer.append("color ").append(this.textColor.toHexARGB()).newLine();
        }
        if (this.hasFontClass) {
            writer.append("fontclass ").append(this.fontClass).newLine();
        }
        if (this.hasMaxLength) {
            writer.append("maxlength ").append(this.maxLength).newLine();
        }
        writer.append("align ").append(alignment).newLine();
        if (this.hasLayout) {
            writer.append("leftmargin ").append(this.leftMargin).newLine();
            writer.append("rightmargin ").append(this.rightMargin).newLine();
            writer.append("indent ").append(this.indent).newLine();
            writer.append("leading ").append(this.leading).newLine();
        }
        if (!this.variableName.isEmpty()) {
            writer.append("variablename ").append(this.variableName).newLine();
        }
        writer.append("]");
        if (this.hasText) {
            String text = this.initialText.replace("\\", "\\\\").replace("[", "\\[").replace("]", "\\]");
            writer.hilightSpecial(text, HighlightSpecialType.TEXT);
        }
        return new HighlightedText(writer);
    }

    @Override
    public boolean setFormattedText(MissingCharacterHandler missingCharHandler, String formattedText, String[] texts) throws TextParseException {
        try {
            ParsedSymbol s;
            TextLexer lexer = new TextLexer(new StringReader(formattedText));
            formattedText = "";
            RECT bounds = new RECT(this.bounds);
            boolean wordWrap = false;
            boolean multiline = false;
            boolean password = false;
            boolean readOnly = false;
            boolean autoSize = false;
            boolean noSelect = false;
            boolean border = false;
            boolean wasStatic = false;
            boolean html = false;
            boolean useOutlines = false;
            int fontId = -1;
            int fontHeight = -1;
            String fontClass = null;
            RGBA textColor = null;
            int maxLength = -1;
            int align = -1;
            int leftMargin = -1;
            int rightMargin = -1;
            int indent = -1;
            int leading = -1;
            String variableName = null;
            int textIdx = 0;
            block94: while ((s = lexer.yylex()) != null) {
                block12 : switch (s.type) {
                    case PARAMETER: {
                        String paramName = (String)s.values[0];
                        String paramValue = (String)s.values[1];
                        switch (paramName) {
                            case "xmin": {
                                try {
                                    bounds.Xmin = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid xmin value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "ymin": {
                                try {
                                    bounds.Ymin = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid ymin value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "xmax": {
                                try {
                                    bounds.Xmax = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid xmax value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "ymax": {
                                try {
                                    bounds.Ymax = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new TextParseException("Invalid ymax value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "wordwrap": {
                                if (!paramValue.equals("1")) continue block94;
                                wordWrap = true;
                                break block12;
                            }
                            case "multiline": {
                                if (!paramValue.equals("1")) continue block94;
                                multiline = true;
                                break block12;
                            }
                            case "password": {
                                if (!paramValue.equals("1")) continue block94;
                                password = true;
                                break block12;
                            }
                            case "readonly": {
                                if (!paramValue.equals("1")) continue block94;
                                readOnly = true;
                                break block12;
                            }
                            case "autosize": {
                                if (!paramValue.equals("1")) continue block94;
                                autoSize = true;
                                break block12;
                            }
                            case "noselect": {
                                if (!paramValue.equals("1")) continue block94;
                                noSelect = true;
                                break block12;
                            }
                            case "border": {
                                if (!paramValue.equals("1")) continue block94;
                                border = true;
                                break block12;
                            }
                            case "wasstatic": {
                                if (!paramValue.equals("1")) continue block94;
                                wasStatic = true;
                                break block12;
                            }
                            case "html": {
                                if (!paramValue.equals("1")) continue block94;
                                html = true;
                                break block12;
                            }
                            case "useoutlines": {
                                if (!paramValue.equals("1")) continue block94;
                                useOutlines = true;
                                break block12;
                            }
                            case "font": {
                                try {
                                    fontId = Integer.parseInt(paramValue);
                                    FontTag ft = this.swf.getFont(fontId);
                                    if (ft == null) {
                                        throw new TextParseException("Font not found.", lexer.yyline());
                                    }
                                    this.hasFont = true;
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid font value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "fontclass": {
                                fontClass = paramValue;
                                break block12;
                            }
                            case "height": {
                                try {
                                    fontHeight = Integer.parseInt(paramValue);
                                    this.hasFont = true;
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid height value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "color": {
                                Matcher m = Pattern.compile("#([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])([0-9a-f][0-9a-f])").matcher(paramValue);
                                if (m.matches()) {
                                    textColor = new RGBA(Integer.parseInt(m.group(2), 16), Integer.parseInt(m.group(3), 16), Integer.parseInt(m.group(4), 16), Integer.parseInt(m.group(1), 16));
                                    break block12;
                                }
                                throw new TextParseException("Invalid color. Valid format is #aarrggbb. Found: " + paramValue, lexer.yyline());
                            }
                            case "maxlength": {
                                try {
                                    maxLength = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid maxLength value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "align": {
                                switch (paramValue) {
                                    case "left": {
                                        align = 0;
                                        break block12;
                                    }
                                    case "right": {
                                        align = 1;
                                        break block12;
                                    }
                                    case "center": {
                                        align = 2;
                                        break block12;
                                    }
                                    case "justify": {
                                        align = 3;
                                        break block12;
                                    }
                                }
                                throw new TextParseException("Invalid align value. Expected one of: left,right,center or justify. Found: " + paramValue, lexer.yyline());
                            }
                            case "leftmargin": {
                                try {
                                    leftMargin = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid leftmargin value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "rightmargin": {
                                try {
                                    rightMargin = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid rightmargin value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "indent": {
                                try {
                                    indent = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid indent value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "leading": {
                                try {
                                    leading = Integer.parseInt(paramValue);
                                    break block12;
                                }
                                catch (NumberFormatException ne) {
                                    throw new TextParseException("Invalid leading value. Number expected. Found: " + paramValue, lexer.yyline());
                                }
                            }
                            case "variablename": {
                                variableName = paramValue;
                                break block12;
                            }
                            default: {
                                throw new TextParseException("Unrecognized parameter name: " + paramName, lexer.yyline());
                            }
                        }
                    }
                    case TEXT: {
                        String s2 = (String)s.values[0];
                        if (s2 == null) {
                            s2 = "";
                        }
                        formattedText = formattedText + (texts == null || textIdx >= texts.length ? s2 : texts[textIdx++]);
                        formattedText = formattedText.replace("\r\n", "\r");
                    }
                }
            }
            this.setModified(true);
            this.bounds = bounds;
            if (formattedText.length() > 0) {
                this.initialText = formattedText;
                this.hasText = true;
            } else {
                this.hasText = false;
            }
            this.wordWrap = wordWrap;
            this.multiline = multiline;
            this.password = password;
            this.readOnly = readOnly;
            this.noSelect = noSelect;
            this.border = border;
            this.wasStatic = wasStatic;
            this.html = html;
            this.useOutlines = useOutlines;
            if (textColor != null) {
                this.hasTextColor = true;
                this.textColor = textColor;
            } else {
                this.hasTextColor = false;
            }
            if (maxLength > -1) {
                this.maxLength = maxLength;
                this.hasMaxLength = true;
            } else {
                this.hasMaxLength = false;
            }
            if (fontId > -1) {
                this.fontId = fontId;
            }
            if (fontHeight > -1) {
                this.fontHeight = fontHeight;
            }
            if (fontClass != null) {
                this.fontClass = fontClass;
                this.hasFontClass = true;
            } else {
                this.hasFontClass = false;
            }
            this.autoSize = autoSize;
            this.align = align;
            if (leftMargin > -1 || rightMargin > -1 || indent > -1 || leading > -1) {
                this.leftMargin = leftMargin;
                this.rightMargin = rightMargin;
                this.indent = indent;
                this.leading = leading;
                this.hasLayout = true;
            } else {
                this.hasLayout = false;
            }
            if (variableName == null) {
                variableName = "";
            }
            this.variableName = variableName;
        }
        catch (IOException ex) {
            Logger.getLogger(DefineEditTextTag.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return true;
    }

    @Override
    public void updateTextBounds() {
    }

    @Override
    public boolean alignText(TextAlign textAlign) {
        return true;
    }

    @Override
    public boolean translateText(int diff) {
        return true;
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        return this.bounds;
    }

    @Override
    public int getCharacterId() {
        return this.characterID;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.characterID = characterId;
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed) {
        if (this.hasFont) {
            needed.add(this.fontId);
        }
        if (this.html && this.hasText) {
            List<CharacterWithStyle> chs = this.getTextWithStyle();
            for (CharacterWithStyle ch : chs) {
                if (ch.style.font == null) continue;
                needed.add(ch.style.font.getFontId());
            }
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        if (this.fontId == oldCharacterId) {
            this.fontId = newCharacterId;
            this.setModified(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        if (this.fontId == characterId) {
            this.hasFont = false;
            this.fontId = 0;
            this.setModified(true);
            return true;
        }
        return false;
    }

    @Override
    public int getUsedParameters() {
        return 0;
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, ColorTransform colorTransform) {
        this.render(TextRenderMode.BITMAP, image, null, null, transformation, colorTransform, 1.0);
    }

    @Override
    public void toSVG(SVGExporter exporter, int ratio, ColorTransform colorTransform, int level) {
        this.render(TextRenderMode.SVG, null, exporter, null, new Matrix(), colorTransform, 1.0);
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        this.render(TextRenderMode.HTML5_CANVAS, null, null, result, new Matrix(), null, unitDivisor);
    }

    private void render(TextRenderMode renderMode, SerializableImage image, SVGExporter svgExporter, StringBuilder htmlCanvasBuilder, Matrix transformation, ColorTransform colorTransform, double zoom) {
        if (this.border) {
            RGBA borderColor = new RGBA(Color.black);
            RGBA fillColor = new RGBA(Color.white);
            switch (renderMode) {
                case BITMAP: {
                    DefineEditTextTag.drawBorder(this.swf, image, borderColor, fillColor, this.getRect(), this.getTextMatrix(), transformation, colorTransform);
                    break;
                }
                case HTML5_CANVAS: {
                    DefineEditTextTag.drawBorderHtmlCanvas(this.swf, htmlCanvasBuilder, borderColor, fillColor, this.getRect(), this.getTextMatrix(), colorTransform, zoom);
                    break;
                }
                case SVG: {
                    DefineEditTextTag.drawBorderSVG(this.swf, svgExporter, borderColor, fillColor, this.getRect(), this.getTextMatrix(), colorTransform, zoom);
                }
            }
        }
        if (this.hasText) {
            ArrayList<SameStyleTextRecord> line;
            ArrayList lines;
            DynamicTextModel textModel = new DynamicTextModel();
            List<CharacterWithStyle> txt = this.getTextWithStyle();
            TextStyle lastStyle = null;
            char prevChar = '\u0000';
            boolean lastWasWhiteSpace = false;
            for (int i = 0; i < txt.size(); ++i) {
                Iterator<Paragraph> cs = txt.get(i);
                char c = ((CharacterWithStyle)((Object)cs)).character;
                if (c != '\r' && c != '\n') {
                    if (lastWasWhiteSpace && !Character.isWhitespace(c)) {
                        textModel.newWord();
                        lastWasWhiteSpace = false;
                    }
                    if (((CharacterWithStyle)((Object)cs)).style != lastStyle) {
                        textModel.style = lastStyle = ((CharacterWithStyle)((Object)cs)).style;
                        textModel.newRecord();
                    }
                    Character nextChar = null;
                    if (i + 1 < txt.size()) {
                        nextChar = Character.valueOf(txt.get((int)(i + 1)).character);
                    }
                    FontTag font = lastStyle.font;
                    DynamicTextGlyphEntry dynamicTextGlyphEntry = new DynamicTextGlyphEntry();
                    dynamicTextGlyphEntry.fontFace = lastStyle.fontFace;
                    if (dynamicTextGlyphEntry.fontFace == null && font != null) {
                        dynamicTextGlyphEntry.fontFace = font.getFontName();
                    }
                    dynamicTextGlyphEntry.fontStyle = (lastStyle.bold ? 1 : 0) | (lastStyle.italic ? 2 : 0);
                    dynamicTextGlyphEntry.character = c;
                    dynamicTextGlyphEntry.glyphIndex = -1;
                    String string = dynamicTextGlyphEntry.fontFace != null ? dynamicTextGlyphEntry.fontFace : FontTag.defaultFontName;
                    int fontStyle = font == null ? dynamicTextGlyphEntry.fontStyle : font.getFontStyle();
                    dynamicTextGlyphEntry.glyphAdvance = (int)Math.round(20.0 * (double)FontTag.getSystemFontAdvance(string, fontStyle, (int)((double)lastStyle.fontHeight / 20.0), Character.valueOf(c), nextChar));
                    textModel.addGlyph(c, dynamicTextGlyphEntry);
                    if (Character.isWhitespace(c)) {
                        lastWasWhiteSpace = true;
                    }
                } else if (this.multiline) {
                    textModel.newParagraph();
                }
                prevChar = c;
            }
            textModel.calculateTextWidths();
            if (this.multiline && this.wordWrap) {
                lines = new ArrayList();
                for (Paragraph paragraph : textModel.paragraphs) {
                    line = new ArrayList();
                    int lineLength = 0;
                    for (Word word : paragraph.words) {
                        if (lineLength + word.width <= this.bounds.getWidth()) {
                            line.addAll(word.records);
                            lineLength += word.width;
                            continue;
                        }
                        lines.add(line);
                        line = new ArrayList();
                        line.addAll(word.records);
                        lineLength = 0;
                    }
                    if (line.isEmpty()) continue;
                    lines.add(line);
                }
            } else {
                lines = new ArrayList();
                for (Paragraph paragraph : textModel.paragraphs) {
                    line = new ArrayList<SameStyleTextRecord>();
                    for (Word word : paragraph.words) {
                        for (SameStyleTextRecord tr : word.records) {
                            line.add(tr);
                        }
                    }
                    lines.add(line);
                }
            }
            for (List list : lines) {
                boolean removed = true;
                while (removed) {
                    removed = false;
                    while (list.size() > 0 && ((SameStyleTextRecord)list.get((int)(list.size() - 1))).glyphEntries.isEmpty()) {
                        list.remove(list.size() - 1);
                        removed = true;
                    }
                    if (list.size() <= 0) continue;
                    SameStyleTextRecord lastRecord = (SameStyleTextRecord)list.get(list.size() - 1);
                    while (lastRecord.glyphEntries.size() > 0 && Character.isWhitespace(lastRecord.glyphEntries.get((int)(lastRecord.glyphEntries.size() - 1)).character)) {
                        lastRecord.glyphEntries.remove(lastRecord.glyphEntries.size() - 1);
                        removed = true;
                    }
                }
            }
            textModel.calculateTextWidths();
            ArrayList<TEXTRECORD> allTextRecords = new ArrayList<TEXTRECORD>();
            boolean bl = false;
            int yOffset = -this.leading;
            for (List list : lines) {
                int n;
                int n2 = 0;
                int currentOffset = 0;
                if (list.isEmpty()) {
                    currentOffset = n;
                } else {
                    for (SameStyleTextRecord tr : list) {
                        int lineHeight;
                        n2 += tr.width;
                        n = lineHeight = tr.style.fontHeight + tr.style.fontLeading;
                        if (lineHeight <= currentOffset) continue;
                        currentOffset = lineHeight;
                    }
                }
                yOffset += currentOffset;
                int alignOffset = 0;
                switch (this.align) {
                    case 0: {
                        alignOffset = 0;
                        break;
                    }
                    case 1: {
                        alignOffset = this.bounds.getWidth() - n2;
                        break;
                    }
                    case 2: {
                        alignOffset = (this.bounds.getWidth() - n2) / 2;
                        break;
                    }
                }
                for (SameStyleTextRecord tr : list) {
                    tr.xOffset = alignOffset;
                    alignOffset += tr.width;
                }
                for (SameStyleTextRecord tr : list) {
                    FontTag ft;
                    TEXTRECORD tr2 = new TEXTRECORD();
                    int fid = this.fontId;
                    if (this.fontClass != null && (ft = this.swf.getFontByClass(this.fontClass)) != null) {
                        fid = ft.getFontId();
                    }
                    if (tr.style.font != null) {
                        fid = tr.style.font.getFontId();
                    }
                    tr2.styleFlagsHasFont = fid != 0;
                    tr2.fontId = fid;
                    tr2.textHeight = tr.style.fontHeight;
                    if (tr.style.textColor != null) {
                        tr2.styleFlagsHasColor = true;
                        tr2.textColorA = tr.style.textColor;
                    }
                    tr2.styleFlagsHasXOffset = true;
                    tr2.xOffset = tr.xOffset;
                    if (yOffset != 0) {
                        tr2.styleFlagsHasYOffset = true;
                        tr2.yOffset = yOffset;
                    }
                    tr2.glyphEntries = new ArrayList<GLYPHENTRY>(tr.glyphEntries.size());
                    for (GlyphCharacter ge : tr.glyphEntries) {
                        tr2.glyphEntries.add(ge.glyphEntry);
                    }
                    allTextRecords.add(tr2);
                }
            }
            switch (renderMode) {
                case BITMAP: {
                    DefineEditTextTag.staticTextToImage(this.swf, allTextRecords, 2, image, this.getTextMatrix(), transformation, colorTransform);
                    break;
                }
                case HTML5_CANVAS: {
                    DefineEditTextTag.staticTextToHtmlCanvas(zoom, this.swf, allTextRecords, 2, htmlCanvasBuilder, this.getBounds(), this.getTextMatrix(), colorTransform);
                    break;
                }
                case SVG: {
                    DefineEditTextTag.staticTextToSVG(this.swf, allTextRecords, 2, svgExporter, this.getBounds(), this.getTextMatrix(), colorTransform, zoom);
                }
            }
        }
    }

    @Override
    public ExportRectangle calculateTextBounds() {
        return null;
    }

    @Override
    public int getNumFrames() {
        return 1;
    }

    @Override
    public boolean isSingleFrame() {
        return true;
    }
}

