/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers.svg;

import java.util.ArrayList;
import java.util.List;

public class CubicToQuad {
    private Point[] calcPowerCoefficients(Point p1, Point c1, Point c2, Point p2) {
        Point a = p2.sub(p1).add(c1.sub(c2).mul(3.0));
        Point b = p1.add(c2).mul(3.0).sub(c1.mul(6.0));
        Point c = c1.sub(p1).mul(3.0);
        Point d = p1;
        return new Point[]{a, b, c, d};
    }

    private Point calcPoint(Point a, Point b, Point c, Point d, double t) {
        return a.mul(t).add(b).mul(t).add(c).mul(t).add(d);
    }

    private Point calcPointQuad(Point a, Point b, Point c, double t) {
        return a.mul(t).add(b).mul(t).add(c);
    }

    private Point calcPointDerivative(Point a, Point b, Point c, Point d, double t) {
        return a.mul(3.0 * t).add(b.mul(2.0)).mul(t).add(c);
    }

    private double[] quadSolve(double a, double b, double c) {
        if (a == 0.0) {
            double[] dArray;
            if (b == 0.0) {
                dArray = new double[]{};
            } else {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = -c / b;
            }
            return dArray;
        }
        double D = b * b - 4.0 * a * c;
        if (D < 0.0) {
            return new double[0];
        }
        if (D == 0.0) {
            return new double[]{-b / (2.0 * a)};
        }
        double DSqrt = Math.sqrt(D);
        return new double[]{(-b - DSqrt) / (2.0 * a), (-b + DSqrt) / (2.0 * a)};
    }

    private double cubicRoot(double x) {
        return x < 0.0 ? -Math.pow(-x, 0.0) : Math.pow(x, 0.0);
    }

    private double[] cubicSolve(double a, double b, double c, double d) {
        if (a == 0.0) {
            return this.quadSolve(b, c, d);
        }
        double xn = -b / (3.0 * a);
        double yn = ((a * xn + b) * xn + c) * xn + d;
        double deltaSq = (b * b - 3.0 * a * c) / (9.0 * a * a);
        double hSq = 4.0 * a * a * Math.pow(deltaSq, 3.0);
        double D3 = yn * yn - hSq;
        if (D3 > 0.0) {
            double D3Sqrt = Math.sqrt(D3);
            return new double[]{xn + this.cubicRoot((-yn + D3Sqrt) / (2.0 * a)) + this.cubicRoot((-yn - D3Sqrt) / (2.0 * a))};
        }
        if (D3 == 0.0) {
            double delta1 = this.cubicRoot(yn / (2.0 * a));
            return new double[]{xn - 2.0 * delta1, xn + delta1};
        }
        double theta = Math.acos(-yn / Math.sqrt(hSq)) / 3.0;
        double delta = Math.sqrt(deltaSq);
        return new double[]{xn + 2.0 * delta * Math.cos(theta), xn + 2.0 * delta * Math.cos(theta + 2.0943951023931953), xn + 2.0 * delta * Math.cos(theta + 4.1887902047863905)};
    }

    private double minDistanceToQuad(Point point, Point p1, Point c1, Point p2) {
        Point a = p1.add(p2).sub(c1.mul(2.0));
        Point b = c1.sub(p1).mul(2.0);
        Point c = p1;
        double e3 = 2.0 * a.sqr();
        double e2 = 3.0 * a.dot(b);
        double e1 = b.sqr() + 2.0 * a.dot(c.sub(point));
        double e0 = c.sub(point).dot(b);
        double[] solveResult = this.cubicSolve(e3, e2, e1, e0);
        ArrayList<Double> candidates = new ArrayList<Double>();
        for (double t : solveResult) {
            if (!(t > 0.0) || !(t < 1.0)) continue;
            candidates.add(t);
        }
        candidates.add(0.0);
        candidates.add(1.0);
        double minDistance = 1.0E9;
        for (int i = 0; i < candidates.size(); ++i) {
            double distance = this.calcPointQuad(a, b, c, (Double)candidates.get(i)).sub(point).dist();
            if (!(distance < minDistance)) continue;
            minDistance = distance;
        }
        return minDistance;
    }

    private Point[] processSegment(Point a, Point b, Point c, Point d, double t1, double t2) {
        Point f1 = this.calcPoint(a, b, c, d, t1);
        Point f2 = this.calcPoint(a, b, c, d, t2);
        Point f1_ = this.calcPointDerivative(a, b, c, d, t1);
        Point f2_ = this.calcPointDerivative(a, b, c, d, t2);
        double D = -f1_.x * f2_.y + f2_.x * f1_.y;
        if (Math.abs(D) < 1.0E-8) {
            return new Point[]{f1, f1.add(f2).div(2.0), f2};
        }
        double cx = (f1_.x * (f2.y * f2_.x - f2.x * f2_.y) + f2_.x * (f1.x * f1_.y - f1.y * f1_.x)) / D;
        double cy = (f1_.y * (f2.y * f2_.x - f2.x * f2_.y) + f2_.y * (f1.x * f1_.y - f1.y * f1_.x)) / D;
        return new Point[]{f1, new Point(cx, cy), f2};
    }

    private boolean isSegmentApproximationClose(Point a, Point b, Point c, Point d, double tmin, double tmax, Point p1, Point c1, Point p2, double errorBound) {
        int n = 10;
        double dt = (tmax - tmin) / (double)n;
        for (double t = tmin + dt; t < tmax - dt; t += dt) {
            Point point = this.calcPoint(a, b, c, d, t);
            if (!(this.minDistanceToQuad(point, p1, c1, p2) > errorBound)) continue;
            return false;
        }
        return true;
    }

    private boolean _isApproximationClose(Point a, Point b, Point c, Point d, List<Point[]> quadCurves, double errorBound) {
        double dt = 1.0 / (double)quadCurves.size();
        for (int i = 0; i < quadCurves.size(); ++i) {
            Point p2;
            Point c1;
            Point p1 = quadCurves.get(i)[0];
            if (this.isSegmentApproximationClose(a, b, c, d, (double)i * dt, (double)(i + 1) * dt, p1, c1 = quadCurves.get(i)[1], p2 = quadCurves.get(i)[2], errorBound)) continue;
            return false;
        }
        return true;
    }

    private List<Point[]> fromFlatArray(double[] points) {
        ArrayList<Point[]> result = new ArrayList<Point[]>();
        int segmentsNumber = (points.length - 2) / 4;
        for (int i = 0; i < segmentsNumber; ++i) {
            result.add(new Point[]{new Point(points[4 * i], points[4 * i + 1]), new Point(points[4 * i + 2], points[4 * i + 3]), new Point(points[4 * i + 4], points[4 * i + 5])});
        }
        return result;
    }

    private List<Double> toFlatArray(List<Point[]> quadsList) {
        ArrayList<Double> result = new ArrayList<Double>();
        result.add(quadsList.get((int)0)[0].x);
        result.add(quadsList.get((int)0)[0].y);
        for (int i = 0; i < quadsList.size(); ++i) {
            result.add(quadsList.get((int)i)[1].x);
            result.add(quadsList.get((int)i)[1].y);
            result.add(quadsList.get((int)i)[2].x);
            result.add(quadsList.get((int)i)[2].y);
        }
        return result;
    }

    private boolean isApproximationClose(double p1x, double p1y, double c1x, double c1y, double c2x, double c2y, double p2x, double p2y, double[] quads, double errorBound) {
        Point[] pc = this.calcPowerCoefficients(new Point(p1x, p1y), new Point(c1x, c1y), new Point(c2x, c2y), new Point(p2x, p2y));
        return this._isApproximationClose(pc[0], pc[1], pc[2], pc[3], this.fromFlatArray(quads), errorBound);
    }

    public List<Double> cubicToQuad(double p1x, double p1y, double c1x, double c1y, double c2x, double c2y, double p2x, double p2y, double errorBound) {
        Point p1 = new Point(p1x, p1y);
        Point c1 = new Point(c1x, c1y);
        Point c2 = new Point(c2x, c2y);
        Point p2 = new Point(p2x, p2y);
        Point[] pc = this.calcPowerCoefficients(p1, c1, c2, p2);
        Point a = pc[0];
        Point b = pc[1];
        Point c = pc[2];
        Point d = pc[3];
        ArrayList<Point[]> approximation = new ArrayList<Point[]>();
        for (int segmentsCount = 1; segmentsCount <= 8; ++segmentsCount) {
            approximation.clear();
            for (double t = 0.0; t < 1.0; t += 1.0 / (double)segmentsCount) {
                approximation.add(this.processSegment(a, b, c, d, t, t + 1.0 / (double)segmentsCount));
            }
            if ((segmentsCount != 1 || !(((Point[])approximation.get(0))[1].sub(p1).dot(c1.sub(p1)) < 0.0) && !(((Point[])approximation.get(0))[1].sub(p2).dot(c2.sub(p2)) < 0.0)) && this._isApproximationClose(a, b, c, d, approximation, errorBound)) break;
        }
        return this.toFlatArray(approximation);
    }

    class Point {
        public double x;
        public double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public Point add(Point point) {
            return new Point(this.x + point.x, this.y + point.y);
        }

        public Point sub(Point point) {
            return new Point(this.x - point.x, this.y - point.y);
        }

        public Point mul(double value) {
            return new Point(this.x * value, this.y * value);
        }

        public Point div(double value) {
            return new Point(this.x / value, this.y / value);
        }

        public double dist() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }

        public double sqr() {
            return this.x * this.x + this.y * this.y;
        }

        public double dot(Point point) {
            return this.x * point.x + this.y * point.y;
        }
    }
}

