/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.action.ConstantPoolTooBigException;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.action.parser.pcode.ASMParser;
import com.jpexs.decompiler.flash.action.parser.script.ActionScript2Parser;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AS2ScriptImporter {
    private static final Logger logger = Logger.getLogger(AS2ScriptImporter.class.getName());

    public int importScripts(String scriptsFolder, Map<String, ASMSource> asms) {
        if (!scriptsFolder.endsWith(File.separator)) {
            scriptsFolder = scriptsFolder + File.separator;
        }
        HashMap existingNamesMap = new HashMap();
        int importCount = 0;
        for (String key : asms.keySet()) {
            String txt;
            ASMSource asm = asms.get(key);
            String currentOutDir = scriptsFolder + key + File.separator;
            ArrayList<String> existingNames = (ArrayList<String>)existingNamesMap.get(currentOutDir = new File(currentOutDir).getParentFile().toString() + File.separator);
            if (existingNames == null) {
                existingNames = new ArrayList<String>();
                existingNamesMap.put(currentOutDir, existingNames);
            }
            String name = Helper.makeFileName(asm.getExportFileName());
            int i = 1;
            String baseName = name;
            while (existingNames.contains(name)) {
                name = baseName + "_" + ++i;
            }
            existingNames.add(name);
            String fileName = Path.combine(currentOutDir, name) + ".as";
            if (new File(fileName).exists()) {
                txt = Helper.readTextFile(fileName);
                ActionScript2Parser par = new ActionScript2Parser(asm.getSwf().version);
                try {
                    asm.setActions(par.actionsFromString(txt));
                }
                catch (ActionParseException ex) {
                    logger.log(Level.SEVERE, "%error% on line %line%, file: %file%".replace("%error%", ex.text).replace("%line%", Long.toString(ex.line)).replace("%file%", fileName), ex);
                }
                catch (CompilationException ex) {
                    logger.log(Level.SEVERE, "%error% on line %line%, file: %file%".replace("%error%", ex.text).replace("%line%", Long.toString(ex.line)).replace("%file%", fileName), ex);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "error during script import, file: %file%".replace("%file%", fileName), ex);
                }
                asm.setModified();
                ++importCount;
            }
            if (new File(fileName = Path.combine(currentOutDir, name) + ".pcode").exists()) {
                txt = Helper.readTextFile(fileName);
                try {
                    asm.setActions(ASMParser.parse(0L, true, txt, asm.getSwf().version, false));
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "error during script import, file: %file%".replace("%file%", fileName), ex);
                }
                catch (ActionParseException ex) {
                    logger.log(Level.SEVERE, "%error% on line %line%, file: %file%".replace("%error%", ex.text).replace("%line%", Long.toString(ex.line)).replace("%file%", fileName), ex);
                }
                asm.setModified();
                ++importCount;
            }
            if (new File(fileName = Path.combine(currentOutDir, name) + ".hex").exists()) {
                txt = Helper.readTextFile(fileName);
                asm.setActionBytes(Helper.getBytesFromHexaText(txt));
                asm.setModified();
                ++importCount;
            }
            if (!new File(fileName = Path.combine(currentOutDir, name) + ".txt").exists()) continue;
            txt = Helper.readTextFile(fileName);
            try {
                asm.setConstantPools(Helper.getConstantPoolsFromText(txt));
            }
            catch (ConstantPoolTooBigException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            asm.setModified();
            ++importCount;
        }
        return importCount;
    }
}

