/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy.conversion;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFBundle;
import com.jpexs.decompiler.flash.iggy.IggyFile;
import com.jpexs.decompiler.flash.iggy.conversion.IggyToSwfConvertor;
import com.jpexs.decompiler.flash.iggy.conversion.SwfToIggyConvertor;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.MemoryInputStream;
import com.jpexs.helpers.streams.SeekableInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class IggySwfBundle
implements SWFBundle {
    private IggyFile iggyFile;

    public IggySwfBundle(InputStream is) throws IOException {
        this(is, null);
    }

    public IggySwfBundle(File filename) throws IOException {
        this(null, filename);
    }

    protected IggySwfBundle(InputStream is, File filename) throws IOException {
        this.initBundle(is, filename);
    }

    protected void initBundle(InputStream is, File filename) throws IOException {
        if (filename == null) {
            filename = File.createTempFile("bundle", ".iggy");
            Helper.saveStream(is, filename);
        }
        this.iggyFile = new IggyFile(filename);
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public Set<String> getKeys() {
        TreeSet<String> ret = new TreeSet<String>();
        for (int i = 0; i < this.length(); ++i) {
            ret.add(this.iggyFile.getSwfName());
        }
        return ret;
    }

    private int keyToSwfIndex(String key) {
        for (int i = 0; i < this.length(); ++i) {
            if (!key.equals(this.iggyFile.getSwfName())) continue;
            return i;
        }
        throw new IllegalArgumentException("Key " + key + " does not exist!");
    }

    @Override
    public SeekableInputStream getSWF(String key) throws IOException {
        SWF swf = IggyToSwfConvertor.getSwf(this.iggyFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        swf.saveTo(baos);
        MemoryInputStream mis = new MemoryInputStream(baos.toByteArray());
        return mis;
    }

    @Override
    public Map<String, SeekableInputStream> getAll() throws IOException {
        HashMap<String, SeekableInputStream> ret = new HashMap<String, SeekableInputStream>();
        for (String key : this.getKeys()) {
            ret.put(key, this.getSWF(key));
        }
        return ret;
    }

    @Override
    public String getExtension() {
        return "iggy";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean putSWF(String key, InputStream is) throws IOException {
        try {
            SWF swf = new SWF(is, false, false);
            SwfToIggyConvertor.updateIggy(this.iggyFile.getSwf(), swf);
            this.iggyFile.saveChanges();
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }
}

