/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.iggy;

import com.jpexs.decompiler.flash.iggy.DataType;
import com.jpexs.decompiler.flash.iggy.IggyCharAdvances;
import com.jpexs.decompiler.flash.iggy.IggyCharIndices;
import com.jpexs.decompiler.flash.iggy.IggyCharKerning;
import com.jpexs.decompiler.flash.iggy.IggyCharOffset;
import com.jpexs.decompiler.flash.iggy.IggyShape;
import com.jpexs.decompiler.flash.iggy.IggyTag;
import com.jpexs.decompiler.flash.iggy.annotations.IggyArrayFieldType;
import com.jpexs.decompiler.flash.iggy.annotations.IggyFieldType;
import com.jpexs.decompiler.flash.iggy.streams.IggyIndexBuilder;
import com.jpexs.decompiler.flash.iggy.streams.ReadDataStreamInterface;
import com.jpexs.decompiler.flash.iggy.streams.SeekMode;
import com.jpexs.decompiler.flash.iggy.streams.WriteDataStreamInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IggyFont
extends IggyTag {
    public static final int ID = 65302;
    @IggyFieldType(value=DataType.uint16_t)
    int type;
    @IggyFieldType(value=DataType.uint16_t)
    int fontId;
    @IggyArrayFieldType(value=DataType.uint8_t, count=28)
    byte[] zeroone;
    @IggyFieldType(value=DataType.uint16_t)
    int char_count2;
    @IggyFieldType(value=DataType.uint16_t)
    int ascent;
    @IggyFieldType(value=DataType.uint16_t)
    int descent;
    @IggyFieldType(value=DataType.uint16_t)
    int leading;
    @IggyFieldType(value=DataType.uint64_t)
    long flags;
    @IggyFieldType(value=DataType.uint32_t)
    long kern_count;
    @IggyArrayFieldType(value=DataType.float_t, count=5)
    float[] unk_float;
    @IggyFieldType(value=DataType.uint64_t)
    long zero_padd;
    @IggyFieldType(value=DataType.uint64_t)
    long what_2;
    @IggyFieldType(value=DataType.uint64_t)
    long zero_padd_2;
    @IggyFieldType(value=DataType.uint64_t)
    long one_padd;
    @IggyFieldType(value=DataType.uint16_t)
    int xscale;
    @IggyFieldType(value=DataType.uint16_t)
    int yscale;
    @IggyFieldType(value=DataType.uint64_t)
    long zero_padd_3;
    @IggyFieldType(value=DataType.float_t)
    float ssr1;
    @IggyFieldType(value=DataType.float_t)
    float ssr2;
    @IggyFieldType(value=DataType.uint32_t)
    long char_count;
    @IggyFieldType(value=DataType.uint64_t)
    long zero_padd_4;
    @IggyFieldType(value=DataType.uint64_t)
    long what_3;
    @IggyFieldType(value=DataType.wchar_t, count=40)
    String subName = "";
    @IggyFieldType(value=DataType.uint8_t, count=48)
    byte[] zeroes48a;
    @IggyFieldType(value=DataType.uint8_t, count=48)
    byte[] zeroes48b;
    @IggyFieldType(value=DataType.float_t)
    float sss1;
    @IggyFieldType(value=DataType.uint32_t)
    long one_padd2;
    @IggyFieldType(value=DataType.float_t)
    float sss2;
    @IggyFieldType(value=DataType.uint32_t)
    long one_padd3;
    @IggyFieldType(value=DataType.float_t)
    float sss3;
    @IggyFieldType(value=DataType.uint32_t)
    long one_padd4;
    @IggyFieldType(value=DataType.float_t)
    float sss4;
    @IggyFieldType(value=DataType.uint32_t)
    long one_padd5;
    @IggyFieldType(value=DataType.wchar_t, count=16)
    String name;
    List<IggyCharOffset> charOffsets;
    List<IggyShape> glyphs;
    IggyCharIndices codePoints;
    IggyCharAdvances charScales;
    IggyCharKerning charKernings;

    public IggyFont(int type, int fontId, byte[] zeroone, int char_count2, int ascent, int descent, int leading, long flags, long kern_count, float[] unk_float, long zero_padd, long what_2, long zero_padd_2, long one_padd, int xscale, int yscale, long zero_padd_3, float ssr1, float ssr2, long char_count, long zero_padd_4, long what_3, byte[] zeroes48a, byte[] zeroes48b, float sss1, long one_padd2, float sss2, long one_padd3, float sss3, long one_padd4, float sss4, long one_padd5, String name, List<IggyCharOffset> charOffsets, List<IggyShape> glyphs, IggyCharIndices codePoints, IggyCharAdvances charScales, IggyCharKerning charKernings) {
        this.type = type;
        this.fontId = fontId;
        this.zeroone = zeroone;
        this.char_count2 = char_count2;
        this.ascent = ascent;
        this.descent = descent;
        this.leading = leading;
        this.flags = flags;
        this.kern_count = kern_count;
        this.unk_float = unk_float;
        this.zero_padd = zero_padd;
        this.what_2 = what_2;
        this.zero_padd_2 = zero_padd_2;
        this.one_padd = one_padd;
        this.xscale = xscale;
        this.yscale = yscale;
        this.zero_padd_3 = zero_padd_3;
        this.ssr1 = ssr1;
        this.ssr2 = ssr2;
        this.char_count = char_count;
        this.zero_padd_4 = zero_padd_4;
        this.what_3 = what_3;
        this.zeroes48a = zeroes48a;
        this.zeroes48b = zeroes48b;
        this.sss1 = sss1;
        this.one_padd2 = one_padd2;
        this.sss2 = sss2;
        this.one_padd3 = one_padd3;
        this.sss3 = sss3;
        this.one_padd4 = one_padd4;
        this.sss4 = sss4;
        this.one_padd5 = one_padd5;
        this.name = name;
        this.charOffsets = charOffsets;
        this.glyphs = glyphs;
        this.codePoints = codePoints;
        this.charScales = charScales;
        this.charKernings = charKernings;
    }

    public IggyFont(ReadDataStreamInterface stream) throws IOException {
        this.readFromDataStream(stream);
    }

    private long readAbsoluteOffset(ReadDataStreamInterface stream) throws IOException {
        long offset = stream.readUI64();
        if (offset == 1L) {
            return 0L;
        }
        return stream.position() - 8L + offset;
    }

    private void writeAbsoluteOffset(WriteDataStreamInterface stream, long offset) throws IOException {
        if (offset == 0L) {
            stream.writeUI64(1L);
        } else {
            stream.writeUI64(offset - stream.position());
        }
    }

    private void writeRelativeOffset(WriteDataStreamInterface stream, long offset) throws IOException {
        if (offset == 0L) {
            stream.writeUI64(1L);
        } else {
            stream.writeUI64(offset);
        }
    }

    private long makeAbsOffset(ReadDataStreamInterface s, long offset) {
        return offset == 1L ? 0L : offset + s.position() - 8L;
    }

    private long makeAbsOffset(WriteDataStreamInterface s, long offset) {
        return offset == 1L ? 0L : offset + s.position() - 8L;
    }

    @Override
    public void readFromDataStream(ReadDataStreamInterface s) throws IOException {
        this.type = s.readUI16();
        this.fontId = s.readUI16();
        this.zeroone = s.readBytes(28);
        this.char_count2 = s.readUI16();
        this.ascent = s.readUI16();
        this.descent = s.readUI16();
        this.leading = s.readUI16();
        this.flags = s.readUI64();
        long start_of_char_struct = s.readUI64();
        long abs_start_of_char_struct = this.makeAbsOffset(s, start_of_char_struct);
        long start_of_char_index = s.readUI64();
        long abs_start_of_char_index = this.makeAbsOffset(s, start_of_char_index);
        long start_of_scale = s.readUI64();
        long abs_start_of_scale = this.makeAbsOffset(s, start_of_scale);
        this.kern_count = s.readUI32();
        this.unk_float = new float[5];
        for (int i = 0; i < this.unk_float.length; ++i) {
            this.unk_float[i] = s.readFloat();
        }
        long start_of_kern = s.readUI64();
        long abs_start_of_kern = this.makeAbsOffset(s, start_of_kern);
        this.zero_padd = s.readUI64();
        this.what_2 = s.readUI64();
        this.zero_padd_2 = s.readUI64();
        long start_of_name = s.readUI64();
        long abs_start_of_name = this.makeAbsOffset(s, start_of_name);
        this.one_padd = s.readUI64();
        this.xscale = s.readUI16();
        this.yscale = s.readUI16();
        this.zero_padd_3 = s.readUI64();
        this.ssr1 = s.readFloat();
        this.ssr2 = s.readFloat();
        this.char_count = s.readUI32();
        this.zero_padd_4 = s.readUI64();
        this.what_3 = s.readUI64();
        StringBuilder subNameBuilder = new StringBuilder();
        boolean snFinish = false;
        for (int i = 0; i < 20; ++i) {
            char c = (char)s.readUI16();
            if (c == '\u0000') {
                snFinish = true;
            }
            if (snFinish) continue;
            subNameBuilder.append(c);
        }
        this.subName = subNameBuilder.toString();
        this.zeroes48a = s.readBytes(48);
        this.sss1 = s.readFloat();
        this.one_padd2 = s.readUI32();
        this.sss2 = s.readFloat();
        this.one_padd3 = s.readUI32();
        this.sss3 = s.readFloat();
        this.one_padd4 = s.readUI32();
        this.sss4 = s.readFloat();
        this.one_padd5 = s.readUI32();
        this.zeroes48b = s.readBytes(48);
        if (abs_start_of_name != 0L) {
            s.seek(abs_start_of_name, SeekMode.SET);
            this.name = s.readWChar();
            s.pad8bytes();
        }
        if (abs_start_of_char_struct != 0L) {
            s.seek(abs_start_of_char_struct, SeekMode.SET);
            this.charOffsets = new ArrayList<IggyCharOffset>();
            ArrayList<Long> charAddresses = new ArrayList<Long>();
            int i = 0;
            while ((long)i < this.char_count) {
                IggyCharOffset iggyOffset = new IggyCharOffset(s);
                this.charOffsets.add(iggyOffset);
                if (iggyOffset.offset == 1L) {
                    charAddresses.add(0L);
                } else {
                    charAddresses.add(iggyOffset.offset + s.position() - 8L);
                }
                ++i;
            }
            this.glyphs = new ArrayList<IggyShape>();
            i = 0;
            while ((long)i < this.char_count) {
                long addr = (Long)charAddresses.get(i);
                if (addr != 0L) {
                    s.seek(addr, SeekMode.SET);
                    this.glyphs.add(new IggyShape(s));
                } else {
                    this.glyphs.add(null);
                }
                ++i;
            }
        }
        if (abs_start_of_char_index != 0L) {
            s.seek(abs_start_of_char_index, SeekMode.SET);
            this.codePoints = new IggyCharIndices(s, this.char_count);
        }
        if (abs_start_of_scale != 0L) {
            s.seek(abs_start_of_scale, SeekMode.SET);
            this.charScales = new IggyCharAdvances(s, this.char_count);
        }
        if (abs_start_of_kern != 0L) {
            s.seek(abs_start_of_kern, SeekMode.SET);
            this.charKernings = new IggyCharKerning(s, this.kern_count);
        }
    }

    @Override
    public void writeToDataStream(WriteDataStreamInterface s) throws IOException {
        boolean FILL_LATER_IF_AVAILABLE = true;
        IggyIndexBuilder ib = s.getIndexing();
        ib.writeConstLength(6);
        s.writeUI16(this.type);
        s.writeUI16(this.fontId);
        s.writeBytes(this.zeroone);
        s.writeUI16(this.char_count2);
        s.writeUI16(this.ascent);
        s.writeUI16(this.descent);
        s.writeUI16(this.leading);
        s.writeUI64(this.flags);
        long start_of_char_struct_ofs_pos = s.position();
        s.writeUI64(1L);
        long start_of_char_index_ofs_pos = s.position();
        s.writeUI64(1L);
        long start_of_scale_ofs_pos = s.position();
        s.writeUI64(1L);
        s.writeUI32(this.kern_count);
        for (int i = 0; i < this.unk_float.length; ++i) {
            s.writeFloat(this.unk_float[i]);
        }
        long start_of_kern_ofs_pos = s.position();
        s.writeUI64(1L);
        s.writeUI64(this.zero_padd);
        ib.writeConstLength(7);
        s.writeUI64(this.what_2);
        s.writeUI64(this.zero_padd_2);
        long start_of_name_ofs_pos = s.position();
        s.writeUI64(1L);
        s.writeUI64(this.one_padd);
        s.writeUI16(this.xscale);
        s.writeUI16(this.yscale);
        s.writeUI64(this.zero_padd_3);
        s.writeFloat(this.ssr1);
        s.writeFloat(this.ssr2);
        s.writeUI32(this.char_count);
        s.writeUI64(this.zero_padd_4);
        s.writeUI64(this.what_3);
        for (int i = 0; i < 20; ++i) {
            if (i < this.subName.length()) {
                s.writeUI16(this.subName.charAt(i));
                continue;
            }
            s.writeUI16(0);
        }
        s.writeBytes(this.zeroes48a);
        s.writeFloat(this.sss1);
        s.writeUI32(this.one_padd2);
        s.writeFloat(this.sss2);
        s.writeUI32(this.one_padd3);
        s.writeFloat(this.sss3);
        s.writeUI32(this.one_padd4);
        s.writeFloat(this.sss4);
        s.writeUI32(this.one_padd5);
        s.writeBytes(this.zeroes48b);
        if (this.name != null) {
            s.setOlderOffsetToThisPos(start_of_name_ofs_pos);
            for (char c : this.name.toCharArray()) {
                s.writeUI16(c);
            }
            s.writeUI16(0);
            int len = this.name.length() * 2 + 2;
            ib.write16bitArray(this.name.length() + 1);
            ib.pad8bytes();
            int pad8 = 8 - len % 8;
            if (pad8 < 8) {
                for (int i = 0; i < pad8; ++i) {
                    s.write(0);
                }
            }
        }
        if (this.charOffsets != null) {
            s.setOlderOffsetToThisPos(start_of_char_struct_ofs_pos);
            ib.writeConstLengthArray(2, this.charOffsets.size());
            ArrayList<Long> toFixOffsets = new ArrayList<Long>();
            for (IggyCharOffset ofs : this.charOffsets) {
                ofs.offset = 1L;
                ofs.writeToDataStream(s);
                toFixOffsets.add(s.position() - 8L);
            }
            for (int i = 0; i < this.glyphs.size(); ++i) {
                IggyShape shp = this.glyphs.get(i);
                if (shp == null) continue;
                s.setOlderOffsetToThisPos((Long)toFixOffsets.get(i));
                shp.writeToDataStream(s);
            }
        }
        if (this.codePoints != null) {
            s.setOlderOffsetToThisPos(start_of_char_index_ofs_pos);
            for (char c : this.codePoints.chars) {
                s.writeUI16(c);
            }
            ib.write16bitArray(this.codePoints.chars.size());
            ib.pad8bytes();
            s.pad8bytes();
        }
        if (this.charScales != null) {
            s.setOlderOffsetToThisPos(start_of_scale_ofs_pos);
            this.charScales.writeToDataStream(s);
            ib.write32bitArray(this.charScales.advances.size());
            ib.pad8bytes();
            s.pad8bytes();
        }
        if (this.charKernings != null) {
            s.setOlderOffsetToThisPos(start_of_kern_ofs_pos);
            ib.writeConstLengthArray(1, this.kern_count);
            this.charKernings.writeToDataStream(s);
            ib.pad8bytes();
            s.pad8bytes();
        }
    }

    public int getType() {
        return this.type;
    }

    public long getFlags() {
        return this.flags;
    }

    public int getXscale() {
        return this.xscale;
    }

    public int getYscale() {
        return this.yscale;
    }

    public long getCharacterCount() {
        return this.char_count;
    }

    public String getName() {
        return this.name;
    }

    public List<IggyShape> getChars() {
        return this.glyphs;
    }

    public IggyCharIndices getCharIndices() {
        return this.codePoints;
    }

    public IggyCharAdvances getCharAdvances() {
        return this.charScales;
    }

    public IggyCharKerning getCharKernings() {
        return this.charKernings;
    }

    public float[] getUnk_float() {
        return this.unk_float;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public long getWhat_2() {
        return this.what_2;
    }

    public long getWhat_3() {
        return this.what_3;
    }

    public List<IggyCharOffset> getCharOffsets() {
        return this.charOffsets;
    }

    @Override
    public int getTagType() {
        return 65302;
    }

    @Override
    public String toString() {
        return String.format("IggyFontTag (%04X)", 65302);
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setFontId(int fontId) {
        this.fontId = fontId;
    }

    public void setCharCount2(int char_count2) {
        this.char_count2 = char_count2;
    }

    public void setAscent(int ascent) {
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.descent = descent;
    }

    public void setLeading(int leading) {
        this.leading = leading;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public void setUnkFloat(float[] unk_float) {
        this.unk_float = unk_float;
    }

    public void setWhat2(long what_2) {
        this.what_2 = what_2;
    }

    public void setXScale(int xscale) {
        this.xscale = xscale;
    }

    public void setYScale(int yscale) {
        this.yscale = yscale;
    }

    public void setSsr1(float ssr1) {
        this.ssr1 = ssr1;
    }

    public void setSsr2(float ssr2) {
        this.ssr2 = ssr2;
    }

    public void setCharCount(long char_count) {
        this.char_count = char_count;
    }

    public void setWhat3(long what_3) {
        this.what_3 = what_3;
    }

    public void setSubName(String subName) {
        this.subName = subName;
    }

    public void setSss1(float sss1) {
        this.sss1 = sss1;
    }

    public void setSss2(float sss2) {
        this.sss2 = sss2;
    }

    public void setSss3(float sss3) {
        this.sss3 = sss3;
    }

    public void setSss4(float sss4) {
        this.sss4 = sss4;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCharOffsets(List<IggyCharOffset> charOffsets) {
        this.charOffsets = charOffsets;
    }

    public void setGlyphs(List<IggyShape> glyphs) {
        this.glyphs = glyphs;
    }

    public void setCodePoints(IggyCharIndices codePoints) {
        this.codePoints = codePoints;
    }

    public void setCharScales(IggyCharAdvances charScales) {
        this.charScales = charScales;
    }

    public void setCharKernings(IggyCharKerning charKernings) {
        this.charKernings = charKernings;
    }
}

