/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.shape;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.Point;
import com.jpexs.decompiler.flash.exporters.shape.ShapeExporterBase;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;

public class CanvasShapeExporter
extends ShapeExporterBase {
    protected static final String DRAW_COMMAND_M = "M";
    protected static final String DRAW_COMMAND_L = "L";
    protected static final String DRAW_COMMAND_Q = "Q";
    protected String currentDrawCommand = "";
    protected StringBuilder pathData = new StringBuilder();
    protected StringBuilder shapeData = new StringBuilder();
    protected StringBuilder strokeData = new StringBuilder();
    protected StringBuilder fillData = new StringBuilder();
    protected double deltaX = 0.0;
    protected double deltaY = 0.0;
    protected Matrix fillMatrix = null;
    protected String lastRadColor = null;
    protected SWF swf;
    protected int repeatCnt = 0;
    protected double unitDivisor;
    protected RGB basicFill;
    protected StringBuilder lineFillData = null;
    protected String lineLastRadColor = null;
    protected Matrix lineFillMatrix = null;
    protected int lineRepeatCnt = 0;
    protected int fillWidth = 0;
    protected int fillHeight = 0;

    public static String getJsPrefix() {
        return "<script>var canvas=document.getElementById(\"myCanvas\");\r\nvar ctx=canvas.getContext(\"2d\");\r\nenhanceContext(ctx);\r\nvar ctrans = new cxform(0,0,0,0,255,255,255,255);\r\n";
    }

    public static String getHtmlPrefix(int width, int height) {
        return "<!DOCTYPE html>\r\n<html>\r\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" /><script type=\"text/javascript\" src=\"canvas.js\"></script><style type=\"text/css\">#resizable {position:relative; display:inline-block; margin:0; padding:0;font-size:0px;} #width_size {width:10px; position:absolute; right:-5px; top:0px; bottom:0px; cursor:e-resize;-webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;} #height_size {height:10px; position:absolute; bottom:-5px; left:0px; right:0px; cursor:n-resize;-webkit-touch-callout: none; -webkit-user-select: none; -khtml-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;} #myCanvas {margin:0; padding:0;} </style></head><body>\r\n\r\n<div id=\"resizable\"><canvas id=\"myCanvas\" width=\"" + width + "\" height=\"" + height + "\" style=\"border:1px solid #c3c3c3;\">\r\nYour browser does not support the HTML5 canvas tag.\r\n</canvas><div id=\"width_size\">&nbsp;</div><div id=\"height_size\">&nbsp;</div></div>\r\n\r\n";
    }

    public static String getJsSuffix() {
        return "</script>\r\n";
    }

    public static String getHtmlSuffix() {
        return "</body>\r\n</html>";
    }

    private String getDrawJs(int width, int height, String id, RECT rect) {
        return "var originalWidth=" + width + ";\r\nvar originalHeight=" + height + ";\r\n function drawFrame(){\r\n\tctx.save();\r\n\tctx.transform(canvas.width/originalWidth,0,0,canvas.height/originalHeight,0,0);\r\n\tplace(\"" + id + "\",canvas,ctx,[" + 1.0 / this.unitDivisor + ",0.0,0.0," + 1.0 / this.unitDivisor + "," + (double)(-rect.Xmin) / this.unitDivisor + "," + (double)(-rect.Ymin) / this.unitDivisor + "],ctrans,1,0,0,0);\r\n\tctx.restore();\r\n}\r\n\tdrawFrame();\r\n";
    }

    public String getHtml(String needed, String id, RECT rect) {
        int width = (int)((double)rect.getWidth() / this.unitDivisor);
        int height = (int)((double)rect.getHeight() / this.unitDivisor);
        return CanvasShapeExporter.getHtmlPrefix(width, height) + CanvasShapeExporter.getJsPrefix() + needed + this.getDrawJs(width, height, id, rect) + CanvasShapeExporter.getJsSuffix() + CanvasShapeExporter.getHtmlSuffix();
    }

    public String getShapeData() {
        return this.shapeData.toString();
    }

    public CanvasShapeExporter(RGB basicFill, double unitDivisor, SWF swf, SHAPE shape, ColorTransform colorTransform, int deltaX, int deltaY) {
        super(swf, shape, colorTransform);
        this.swf = swf;
        this.unitDivisor = unitDivisor;
        this.basicFill = basicFill;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
    }

    @Override
    public void beginShape() {
        this.shapeData = new StringBuilder();
    }

    @Override
    public void endShape() {
    }

    @Override
    public void beginFills() {
    }

    @Override
    public void endFills() {
    }

    @Override
    public void beginLines() {
    }

    @Override
    public void endLines(boolean close) {
        if (close) {
            this.pathData.append('Z').append(" ");
        }
        this.finalizePath();
    }

    @Override
    public void beginFill(RGB color) {
        this.finalizePath();
        if (color == null) {
            this.fillData.append("\tctx.fillStyle=defaultFill;\r\n");
        } else {
            this.fillData.append("\tctx.fillStyle=").append(CanvasShapeExporter.color(color)).append(";\r\n");
        }
    }

    @Override
    public void beginGradientFill(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        this.finalizePath();
        int REPEAT_CNT = 5;
        int n = this.repeatCnt = spreadMethod == 0 ? 0 : 5;
        if (type == 16) {
            Point start = matrix.transform(new Point(-16384 - 32768 * this.repeatCnt, 0.0));
            Point end = matrix.transform(new Point(16384 + 32768 * this.repeatCnt, 0.0));
            start.x += this.deltaX;
            start.y += this.deltaY;
            end.x += this.deltaX;
            end.y += this.deltaY;
            this.fillData.append("\tvar grd=ctx.createLinearGradient(").append(start.x / this.unitDivisor).append(",").append(start.y / this.unitDivisor).append(",").append(end.x / this.unitDivisor).append(",").append(end.y / this.unitDivisor).append(");\r\n");
        } else {
            this.fillMatrix = matrix;
            this.fillData.append("\tvar grd=ctx.createRadialGradient(").append(focalPointRatio * 16384.0f).append(",0,0,0,0,").append(16384 + 32768 * this.repeatCnt).append(");\r\n");
        }
        int repeatTotal = this.repeatCnt * 2 + 1;
        double oneHeight = 1.0 / (double)repeatTotal;
        double pos = 0.0;
        boolean revert = false;
        if (type != 16 && spreadMethod == 1) {
            revert = true;
        }
        for (int i = 0; i < repeatTotal; ++i) {
            if (spreadMethod == 1) {
                revert = !revert;
            }
            for (GRADRECORD r : gradientRecords) {
                this.fillData.append("\tgrd.addColorStop(").append(pos + oneHeight * (double)(revert ? 255 - r.ratio : r.ratio) / 255.0).append(",").append(CanvasShapeExporter.color(r.color)).append(");\r\n");
                this.lastRadColor = CanvasShapeExporter.color(r.color);
            }
            pos += oneHeight;
        }
        this.fillData.append("\tctx.fillStyle = grd;\r\n");
    }

    public static String color(int color) {
        return CanvasShapeExporter.color(new RGBA(color));
    }

    public static String color(RGB rgb) {
        if (rgb instanceof RGBA && ((RGBA)rgb).alpha < 255) {
            RGBA rgba = (RGBA)rgb;
            return "tocolor(ctrans.apply([" + rgba.red + "," + rgba.green + "," + rgba.blue + "," + rgba.getAlphaFloat() + "]))";
        }
        return "tocolor(ctrans.apply([" + rgb.red + "," + rgb.green + "," + rgb.blue + ",1]))";
    }

    @Override
    public void beginBitmapFill(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        SerializableImage img;
        this.finalizePath();
        ImageTag image = this.swf.getImage(bitmapId);
        if (image != null && (img = image.getImageCached()) != null) {
            this.fillWidth = img.getWidth();
            this.fillHeight = img.getHeight();
            if (colorTransform != null) {
                colorTransform.apply(img);
            }
            if (matrix != null) {
                this.fillMatrix = matrix;
            }
            this.fillData.append("\tvar fimg = ctrans.applyToImage(imageObj").append(bitmapId).append(");\r\n");
            this.fillData.append("\tvar pat=ctx.createPattern(fimg,\"repeat\");\r\n");
            this.fillData.append("\tctx.fillStyle = pat;\r\n");
            return;
        }
        this.fillData.append("\tctx.fillStyle=").append(CanvasShapeExporter.color(Color.RED.getRGB())).append(";\r\n");
    }

    @Override
    public void endFill() {
        this.finalizePath();
    }

    @Override
    public void lineStyle(double thickness, RGB color, boolean pixelHinting, String scaleMode, int startCaps, int endCaps, int joints, float miterLimit) {
        this.finalizePath();
        thickness /= 20.0;
        this.strokeData.append("\tvar scaleMode = \"").append(scaleMode).append("\";\r\n");
        if (color != null) {
            this.strokeData.append("\tctx.strokeStyle=").append(CanvasShapeExporter.color(color)).append(";\r\n");
        }
        this.strokeData.append("\tctx.lineWidth=").append(thickness == 0.0 ? 1.0 : thickness).append(";\r\n");
        switch (startCaps) {
            case 1: {
                this.strokeData.append("\tctx.lineCap=\"butt\";\r\n");
                break;
            }
            case 2: {
                this.strokeData.append("\tctx.lineCap=\"square\";\r\n");
                break;
            }
            default: {
                this.strokeData.append("\tctx.lineCap=\"round\";\r\n");
            }
        }
        switch (joints) {
            case 1: {
                this.strokeData.append("\tctx.lineJoin=\"bevel\";\r\n");
                break;
            }
            case 0: {
                this.strokeData.append("\tctx.lineJoin=\"round\";\r\n");
                break;
            }
            default: {
                this.strokeData.append("\tctx.lineJoin=\"miter\";\r\n");
                this.strokeData.append("\tctx.miterLimit=").append(miterLimit).append(";\r\n");
            }
        }
    }

    @Override
    public void lineGradientStyle(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        this.lineFillData = new StringBuilder();
        int REPEAT_CNT = 5;
        int n = this.lineRepeatCnt = spreadMethod == 0 ? 0 : 5;
        if (type == 16) {
            Point start = matrix.transform(new Point(-16384 - 32768 * this.lineRepeatCnt, 0.0));
            Point end = matrix.transform(new Point(16384 + 32768 * this.lineRepeatCnt, 0.0));
            start.x += this.deltaX;
            start.y += this.deltaY;
            end.x += this.deltaX;
            end.y += this.deltaY;
            this.lineFillData.append("\tvar grd=ctx.createLinearGradient(").append(Double.toString(start.x / this.unitDivisor)).append(",").append(Double.toString(start.y / this.unitDivisor)).append(",").append(Double.toString(end.x / this.unitDivisor)).append(",").append(Double.toString(end.y / this.unitDivisor)).append(");\r\n");
        } else {
            this.lineFillMatrix = matrix;
            this.lineFillData.append("\tvar grd=ctx.createRadialGradient(").append(focalPointRatio * 16384.0f).append(",0,0,0,0,").append(16384 + 32768 * this.lineRepeatCnt).append(");\r\n");
        }
        int repeatTotal = this.lineRepeatCnt * 2 + 1;
        double oneHeight = 1.0 / (double)repeatTotal;
        double pos = 0.0;
        boolean revert = false;
        if (type != 16 && spreadMethod == 1) {
            revert = true;
        }
        for (int i = 0; i < repeatTotal; ++i) {
            if (spreadMethod == 1) {
                revert = !revert;
            }
            for (GRADRECORD r : gradientRecords) {
                this.lineFillData.append("\tgrd.addColorStop(").append(Double.toString(pos + oneHeight * (double)(revert ? 255 - r.ratio : r.ratio) / 255.0)).append(",").append(CanvasShapeExporter.color(r.color)).append(");\r\n");
                this.lineLastRadColor = CanvasShapeExporter.color(r.color);
            }
            pos += oneHeight;
        }
        this.lineFillData.append("\tctx.fillStyle = grd;\r\n");
        String preStrokeData = "";
        preStrokeData = preStrokeData + "\tvar lcanvas = document.createElement(\"canvas\");\r\n";
        preStrokeData = preStrokeData + "\tlcanvas.width = canvas.width;\r\n";
        preStrokeData = preStrokeData + "\tlcanvas.height=canvas.height;\r\n";
        preStrokeData = preStrokeData + "\tvar lctx = lcanvas.getContext(\"2d\");\r\n";
        preStrokeData = preStrokeData + "\tenhanceContext(lctx);\r\n";
        preStrokeData = preStrokeData + "\tlctx.applyTransforms(ctx._matrix);\r\n";
        preStrokeData = preStrokeData + "\tctx = lctx;\r\n";
        this.strokeData.insert(0, preStrokeData);
    }

    @Override
    public void moveTo(double x, double y) {
        this.currentDrawCommand = DRAW_COMMAND_M;
        this.pathData.append(this.currentDrawCommand).append(" ");
        this.pathData.append(Helper.doubleStr((x += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((y += this.deltaY) / this.unitDivisor)).append(" ");
    }

    @Override
    public void lineTo(double x, double y) {
        if (!this.currentDrawCommand.equals(DRAW_COMMAND_L)) {
            this.currentDrawCommand = DRAW_COMMAND_L;
            this.pathData.append(this.currentDrawCommand).append(" ");
        }
        this.pathData.append(Helper.doubleStr((x += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((y += this.deltaY) / this.unitDivisor)).append(" ");
    }

    @Override
    public void curveTo(double controlX, double controlY, double anchorX, double anchorY) {
        if (!this.currentDrawCommand.equals(DRAW_COMMAND_Q)) {
            this.currentDrawCommand = DRAW_COMMAND_Q;
            this.pathData.append(this.currentDrawCommand).append(" ");
        }
        this.pathData.append(Helper.doubleStr((controlX += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((controlY += this.deltaY) / this.unitDivisor)).append(" ").append(Helper.doubleStr((anchorX += this.deltaX) / this.unitDivisor)).append(" ").append(Helper.doubleStr((anchorY += this.deltaY) / this.unitDivisor)).append(" ");
    }

    protected void finalizePath() {
        if (this.pathData != null && this.pathData.length() > 0) {
            this.shapeData.append("\tvar pathData=\"").append(this.pathData.toString().trim()).append("\";\r\n");
            String drawStroke = "\tdrawPath(ctx,pathData,true,scaleMode);\r\n";
            String drawFill = "\tdrawPath(ctx,pathData,false);\r\n";
            this.pathData = new StringBuilder();
            if (this.lineFillData != null) {
                StringBuilder preLineFillData = new StringBuilder();
                preLineFillData.append("\tvar oldctx = ctx;\r\n");
                preLineFillData.append("\tctx.save();\r\n");
                preLineFillData.append((CharSequence)this.strokeData);
                preLineFillData.append(drawStroke);
                preLineFillData.append("\tvar lfcanvas = document.createElement(\"canvas\");\r\n");
                preLineFillData.append("\tlfcanvas.width = canvas.width;\r\n");
                preLineFillData.append("\tlfcanvas.height=canvas.height;\r\n");
                preLineFillData.append("\tvar lfctx = lfcanvas.getContext(\"2d\");\r\n");
                preLineFillData.append("\tenhanceContext(lfctx);\r\n");
                preLineFillData.append("\tlfctx.applyTransforms(ctx._matrix);\r\n");
                preLineFillData.append("\tctx = lfctx;");
                if (this.lineLastRadColor != null) {
                    preLineFillData.append("\tctx.fillStyle=").append(this.lineLastRadColor).append(";\r\n\tctx.fill(\"evenodd\");\r\n");
                }
                if (this.lineFillMatrix != null) {
                    preLineFillData.append("\tctx.transform(").append(Helper.doubleStr(this.lineFillMatrix.scaleX / this.unitDivisor)).append(",").append(Helper.doubleStr(this.lineFillMatrix.rotateSkew0 / this.unitDivisor)).append(",").append(Helper.doubleStr(this.lineFillMatrix.rotateSkew1 / this.unitDivisor)).append(",").append(Helper.doubleStr(this.lineFillMatrix.scaleY / this.unitDivisor)).append(",").append(Helper.doubleStr((this.lineFillMatrix.translateX + this.deltaX) / this.unitDivisor)).append(",").append(Helper.doubleStr((this.lineFillMatrix.translateY + this.deltaY) / this.unitDivisor)).append(");\r\n");
                }
                this.lineFillData.insert(0, preLineFillData);
                this.lineFillData.append("\tctx.fillRect(").append(-16384 - 32768 * this.lineRepeatCnt).append(",").append(-16384 - 32768 * this.lineRepeatCnt).append(",").append(32768 + 65536 * this.lineRepeatCnt).append(",").append(32768 + 65536 * this.lineRepeatCnt).append(");\r\n");
                this.lineFillData.append("\tctx = oldctx;\r\n");
                this.lineFillData.append("\tvar limgd = lctx.getImageData(0, 0, lcanvas.width, lcanvas.height);\r\n\tvar lpix = limgd.data;\r\n\tvar lfimgd = lfctx.getImageData(0, 0, lfcanvas.width, lfcanvas.height);\r\n\tvar lfpix = lfimgd.data;\r\n\tvar imgd = ctx.getImageData(0, 0, canvas.width, canvas.height);\r\n\tvar pix = imgd.data;\r\n\tfor (var i = 0; i < lpix.length; i += 4) {\r\n\t\tif(lpix[i+3]>0){ pix[i] = lfpix[i]; pix[i+1] = lfpix[i+1]; pix[i+2] = lfpix[i+2]; pix[i+3] = lfpix[i+3];}\r\n\t}\r\n\tctx.putImageData(imgd, 0, 0);\r\n");
                this.lineFillData.append("\tctx.restore();\r\n");
                this.strokeData = new StringBuilder();
            } else {
                this.pathData.append((CharSequence)this.strokeData);
            }
            if (this.fillMatrix != null) {
                this.pathData.append(drawFill);
                if (this.lastRadColor != null) {
                    this.pathData.append("\tctx.fillStyle=").append(this.lastRadColor).append(";\r\n\tctx.fill(\"evenodd\");\r\n");
                }
                this.pathData.append("\tctx.save();\r\n");
                this.pathData.append("\tctx.clip();\r\n");
                this.pathData.append("\tctx.transform(").append(Helper.doubleStr(this.fillMatrix.scaleX / this.unitDivisor)).append(",").append(Helper.doubleStr(this.fillMatrix.rotateSkew0 / this.unitDivisor)).append(",").append(Helper.doubleStr(this.fillMatrix.rotateSkew1 / this.unitDivisor)).append(",").append(Helper.doubleStr(this.fillMatrix.scaleY / this.unitDivisor)).append(",").append(Helper.doubleStr((this.fillMatrix.translateX + this.deltaX) / this.unitDivisor)).append(",").append(Helper.doubleStr((this.fillMatrix.translateY + this.deltaY) / this.unitDivisor)).append(");\r\n");
                if (this.fillWidth > 0) {
                    double s_w = (double)(this.fillWidth + 1) / (double)this.fillWidth;
                    double s_h = (double)(this.fillHeight + 1) / (double)this.fillHeight;
                    this.pathData.append("\tctx.transform(").append(s_w).append(",0,0,").append(s_h).append(",-0.5,-0.5);\r\n");
                }
                this.pathData.append((CharSequence)this.fillData);
                this.pathData.append("\tctx.fillRect(").append(-16384 - 32768 * this.repeatCnt).append(",").append(-16384 - 32768 * this.repeatCnt).append(",").append(32768 + 65536 * this.repeatCnt).append(",").append(32768 + 65536 * this.repeatCnt).append(");\r\n");
                this.pathData.append("\tctx.restore();\r\n");
                this.shapeData.append((CharSequence)this.pathData);
            } else {
                if (this.fillData != null && this.fillData.length() > 0) {
                    this.pathData.append(drawFill).append("\tctx.fill(\"evenodd\");\r\n");
                }
                this.shapeData.append((CharSequence)this.fillData).append((CharSequence)this.pathData);
            }
            if (this.strokeData != null && this.strokeData.length() > 0) {
                this.shapeData.append(drawStroke).append("\r\n");
            } else if (this.lineFillData != null) {
                this.shapeData.append((CharSequence)this.lineFillData);
            }
        }
        this.repeatCnt = 0;
        this.pathData = new StringBuilder();
        this.fillData = new StringBuilder();
        this.strokeData = new StringBuilder();
        this.fillMatrix = null;
        this.lastRadColor = null;
        this.lineRepeatCnt = 0;
        this.lineFillData = null;
        this.lineLastRadColor = null;
        this.lineFillMatrix = null;
        this.fillWidth = 0;
        this.fillHeight = 0;
    }
}

