/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.script;

import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.exporters.script.Dependency;
import com.jpexs.decompiler.graph.DottedChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LinkReportExporter {
    private String newLineChar = "\n";
    private String indentStr = "  ";

    public LinkReportExporter() {
    }

    public LinkReportExporter(String newLineChar) {
        this.newLineChar = newLineChar;
    }

    public LinkReportExporter(String newLineChar, String indentStr) {
        this.newLineChar = newLineChar;
        this.indentStr = indentStr;
    }

    private String indent(int cnt) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cnt; ++i) {
            sb.append(this.indentStr);
        }
        return sb.toString();
    }

    public String generateReport(SWF swf, List<ScriptPack> as3scripts, EventListener evl) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> extDeps = new HashSet<String>();
        sb.append("<report>").append(this.newLineChar);
        sb.append(this.indent(1)).append("<scripts>").append(this.newLineChar);
        ArrayList<ScriptPack> revList = new ArrayList<ScriptPack>(as3scripts);
        Collections.reverse(revList);
        ArrayList<DottedChain> existingObjects = new ArrayList<DottedChain>();
        for (ScriptPack sp : as3scripts) {
            existingObjects.add(sp.getClassPath().packageStr.add(sp.getClassPath().className, sp.getClassPath().namespaceSuffix));
        }
        for (ScriptPack sp : revList) {
            String scriptName = "script" + sp.scriptIndex;
            sb.append(this.indent(2)).append("<script name=\"").append(scriptName).append("\">").append(this.newLineChar);
            ScriptInfo script = sp.abc.script_info.get(sp.scriptIndex);
            for (int traitIndex : sp.traitIndices) {
                Trait trait = script.traits.traits.get(traitIndex);
                sb.append(this.reportTrait(extDeps, existingObjects, swf, sp.abc, trait));
            }
            sb.append(this.indent(2)).append("</script>").append(this.newLineChar);
        }
        sb.append(this.indent(1)).append("</scripts>").append(this.newLineChar);
        sb.append("</report>").append(this.newLineChar);
        return sb.toString();
    }

    private String multiNameToId(ABC abc, Multiname multiName) {
        Namespace ns = multiName.getNamespace(abc.constants);
        NamespaceSet nss = multiName.getNamespaceSet(abc.constants);
        if (nss != null && nss.namespaces.length == 1) {
            ns = abc.constants.getNamespace(nss.namespaces[0]);
        }
        String pkgName = ns == null ? "" : ns.getName(abc.constants).toRawString();
        String clsName = multiName.getName(abc.constants, new ArrayList<DottedChain>(), true, true);
        return pkgName.isEmpty() ? clsName : pkgName + ":" + clsName;
    }

    private String dottedChainToId(DottedChain dc) {
        if (dc.getWithoutLast().isEmpty()) {
            return dc.getLast();
        }
        return dc.getWithoutLast().toRawString() + ":" + dc.getLast();
    }

    private String reportTrait(Set<String> externalDefs, List<DottedChain> existingObjects, SWF swf, ABC abc, Trait t) {
        StringBuilder sb = new StringBuilder();
        if (t instanceof TraitClass) {
            TraitClass tc = (TraitClass)t;
            sb.append(this.indent(3)).append("<def id=\"").append(this.multiNameToId(abc, tc.getName(abc))).append("\" />").append(this.newLineChar);
            ClassInfo ci = abc.class_info.get(tc.class_info);
            InstanceInfo ii = abc.instance_info.get(tc.class_info);
            HashSet<String> allDeps = new HashSet<String>();
            String superPre = ii.super_index != 0 ? this.multiNameToId(abc, abc.constants.getMultiname(ii.super_index)) : "Object";
            allDeps.add(superPre);
            sb.append(this.indent(3)).append("<pre id=\"").append(superPre).append("\" />").append(this.newLineChar);
            for (int iface : ii.interfaces) {
                String ifacePre = this.multiNameToId(abc, abc.constants.getMultiname(iface));
                allDeps.add(ifacePre);
                sb.append(this.indent(3)).append("<pre id=\"").append(ifacePre).append("\" />").append(this.newLineChar);
            }
            Object object = ci.static_traits.traits.iterator();
            while (object.hasNext()) {
                Trait ct = (Trait)object.next();
                this.reportTrait(externalDefs, existingObjects, swf, abc, ct);
            }
            for (Trait it : ii.instance_traits.traits) {
                this.reportTrait(externalDefs, existingObjects, swf, abc, it);
            }
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            ArrayList<String> uses = new ArrayList<String>();
            sb.append(this.indent(3)).append("<dep id=\"AS3\" />").append(this.newLineChar);
            tc.getDependencies(null, abc, dependencies, uses, new DottedChain(new String[]{"FAKE!PACKAGE"}, ""), new ArrayList<DottedChain>());
            for (Dependency dependency : dependencies) {
                String reportDepId;
                DottedChain dc = dependency.getId();
                if ("*".equals(dc.getLast()) || dc.getWithoutLast().isEmpty() && !existingObjects.contains(dc) || allDeps.contains(reportDepId = this.dottedChainToId(dc))) continue;
                sb.append(this.indent(3)).append("<dep id=\"").append(reportDepId).append("\" />").append(this.newLineChar);
                allDeps.add(reportDepId);
            }
        }
        return sb.toString();
    }
}

