/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpacker.JPacker;
import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.modes.FrameExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ButtonExportSettings;
import com.jpexs.decompiler.flash.exporters.settings.FrameExportSettings;
import com.jpexs.decompiler.flash.exporters.settings.SpriteExportSettings;
import com.jpexs.decompiler.flash.exporters.shape.CanvasShapeExporter;
import com.jpexs.decompiler.flash.helpers.BMPFile;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.filters.BEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.COLORMATRIXFILTER;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import com.jpexs.decompiler.flash.types.filters.DROPSHADOWFILTER;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.GLOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTBEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTGLOWFILTER;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.utf8.Utf8Helper;
import gnu.jpdf.PDFJob;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import net.kroo.elliot.GifSequenceWriter;
import net.weiner.kevin.AnimatedGifEncoder;
import org.monte.media.avi.AVIWriter;

public class FrameExporter {
    private static final Logger logger = Logger.getLogger(FrameExporter.class.getName());

    public List<File> exportFrames(AbortRetryIgnoreHandler handler, String outdir, SWF swf, int containerId, List<Integer> frames, ButtonExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        FrameExportMode fem;
        switch (settings.mode) {
            case BMP: {
                fem = FrameExportMode.BMP;
                break;
            }
            case PNG: {
                fem = FrameExportMode.PNG;
                break;
            }
            case SVG: {
                fem = FrameExportMode.SVG;
                break;
            }
            default: {
                throw new Error("Unsupported button export mode");
            }
        }
        FrameExportSettings fes = new FrameExportSettings(fem, settings.zoom);
        return this.exportFrames(handler, outdir, swf, containerId, frames, fes, evl);
    }

    public List<File> exportFrames(AbortRetryIgnoreHandler handler, String outdir, SWF swf, int containerId, List<Integer> frames, SpriteExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        FrameExportMode fem;
        switch (settings.mode) {
            case PNG: {
                fem = FrameExportMode.PNG;
                break;
            }
            case GIF: {
                fem = FrameExportMode.GIF;
                break;
            }
            case AVI: {
                fem = FrameExportMode.AVI;
                break;
            }
            case SVG: {
                fem = FrameExportMode.SVG;
                break;
            }
            case CANVAS: {
                fem = FrameExportMode.CANVAS;
                break;
            }
            case PDF: {
                fem = FrameExportMode.PDF;
                break;
            }
            case BMP: {
                fem = FrameExportMode.BMP;
                break;
            }
            default: {
                throw new Error("Unsupported sprite export mode");
            }
        }
        FrameExportSettings fes = new FrameExportSettings(fem, settings.zoom);
        return this.exportFrames(handler, outdir, swf, containerId, frames, fes, evl);
    }

    public List<File> exportFrames(AbortRetryIgnoreHandler handler, String outdir, SWF swf, int containerId, List<Integer> frames, final FrameExportSettings settings, final EventListener evl) throws IOException, InterruptedException {
        Timeline tim0;
        ArrayList<File> ret = new ArrayList<File>();
        if (swf.getTags().isEmpty()) {
            return ret;
        }
        String path = "";
        if (containerId == 0) {
            tim0 = swf.getTimeline();
        } else {
            tim0 = ((Timelined)((Object)swf.getCharacter(containerId))).getTimeline();
            path = File.separator + Helper.makeFileName(swf.getCharacter(containerId).getExportFileName());
        }
        final Timeline tim = tim0;
        if (frames == null) {
            int frameCnt = tim.getFrameCount();
            frames = new ArrayList<Integer>();
            for (int i = 0; i < frameCnt; ++i) {
                frames.add(i);
            }
        }
        File foutdir = new File(outdir + path);
        Path.createDirectorySafe(foutdir);
        final List<Integer> fframes = frames;
        Color backgroundColor = null;
        SetBackgroundColorTag setBgColorTag = swf.getBackgroundColor();
        if (setBgColorTag != null) {
            backgroundColor = setBgColorTag.backgroundColor.toColor();
        }
        if (settings.mode == FrameExportMode.SVG) {
            for (int i = 0; i < frames.size(); ++i) {
                if (evl != null) {
                    Tag parentTag = tim.getParentTag();
                    evl.handleExportingEvent("frame", i + 1, frames.size(), parentTag == null ? "" : parentTag.getName());
                }
                int fi = i;
                Color fbackgroundColor = null;
                new RetryTask(() -> {
                    int frame = (Integer)fframes.get(fi);
                    File f = new File(foutdir + File.separator + frame + ".svg");
                    try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));){
                        ExportRectangle rect = new ExportRectangle(tim.displayRect);
                        rect.xMax *= settings.zoom;
                        rect.yMax *= settings.zoom;
                        rect.xMin *= settings.zoom;
                        rect.yMin *= settings.zoom;
                        SVGExporter exporter = new SVGExporter(rect, settings.zoom);
                        if (fbackgroundColor != null) {
                            exporter.setBackGroundColor(fbackgroundColor);
                        }
                        tim.toSVG(frame, 0, null, 0, exporter, null, 0);
                        ((OutputStream)fos).write(Utf8Helper.getBytes(exporter.getSVG()));
                    }
                    ret.add(f);
                }, handler).run();
                if (evl == null) continue;
                Tag parentTag = tim.getParentTag();
                evl.handleExportedEvent("frame", i + 1, frames.size(), parentTag == null ? "" : parentTag.getName());
            }
            return ret;
        }
        if (settings.mode == FrameExportMode.CANVAS) {
            if (evl != null) {
                Tag parentTag = tim.getParentTag();
                evl.handleExportingEvent("canvas", 1, 1, parentTag == null ? "" : parentTag.getName());
            }
            Timeline ftim = tim;
            Color fbackgroundColor = null;
            SWF fswf = swf;
            new RetryTask(() -> {
                Object object;
                File fcanvas = new File(foutdir + File.separator + "canvas.js");
                Helper.saveStream(SWF.class.getClassLoader().getResourceAsStream("com/jpexs/helpers/resource/canvas.js"), fcanvas);
                ret.add(fcanvas);
                File f = new File(foutdir + File.separator + "frames.js");
                File fmin = new File(foutdir + File.separator + "frames.min.js");
                int width = (int)((double)ftim.displayRect.getWidth() * settings.zoom / 20.0);
                int height = (int)((double)ftim.displayRect.getHeight() * settings.zoom / 20.0);
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(f));){
                    ((OutputStream)fos).write(Utf8Helper.getBytes("\r\n"));
                    HashSet<Integer> library = new HashSet<Integer>();
                    ftim.getNeededCharacters(fframes, library);
                    SWF.writeLibrary(fswf, library, fos);
                    String currentName = ftim.id == 0 ? "main" : SWF.getTypePrefix(fswf.getCharacter(ftim.id)) + ftim.id;
                    StringBuilder sb = new StringBuilder();
                    sb.append("function ").append(currentName).append("(ctx,ctrans,frame,ratio,time){\r\n");
                    sb.append("\tctx.save();\r\n");
                    sb.append("\tctx.transform(1,0,0,1,").append((double)(-ftim.displayRect.Xmin) * settings.zoom / 20.0).append(",").append((double)(-ftim.displayRect.Ymin) * settings.zoom / 20.0).append(");\r\n");
                    FrameExporter.framesToHtmlCanvas(sb, 20.0 / settings.zoom, ftim, fframes, 0, null, 0, ftim.displayRect, null, fbackgroundColor);
                    sb.append("\tctx.restore();\r\n");
                    sb.append("}\r\n\r\n");
                    sb.append("var frame = -1;\r\n");
                    sb.append("var time = 0;\r\n");
                    sb.append("var frames = [];\r\n");
                    object = fframes.iterator();
                    while (object.hasNext()) {
                        int i = (Integer)object.next();
                        sb.append("frames.push(").append(i).append(");\r\n");
                    }
                    sb.append("\r\n");
                    RGB backgroundColor1 = new RGB(255, 255, 255);
                    if (setBgColorTag != null) {
                        backgroundColor1 = setBgColorTag.backgroundColor;
                    }
                    sb.append("var backgroundColor = \"").append(backgroundColor1.toHexRGB()).append("\";\r\n");
                    sb.append("var originalWidth = ").append(width).append(";\r\n");
                    sb.append("var originalHeight= ").append(height).append(";\r\n");
                    sb.append("function nextFrame(ctx,ctrans){\r\n");
                    sb.append("\tvar oldframe = frame;\r\n");
                    sb.append("\tframe = (frame+1)%frames.length;\r\n");
                    sb.append("\tif(frame==oldframe){time++;}else{time=0;};\r\n");
                    sb.append("\tdrawFrame();\r\n");
                    sb.append("}\r\n\r\n");
                    sb.append("function drawFrame(){\r\n");
                    sb.append("\tctx.fillStyle = backgroundColor;\r\n");
                    sb.append("\tctx.fillRect(0,0,canvas.width,canvas.height);\r\n");
                    sb.append("\tctx.save();\r\n");
                    sb.append("\tctx.transform(canvas.width/originalWidth,0,0,canvas.height/originalHeight,0,0);\r\n");
                    sb.append("\t").append(currentName).append("(ctx,ctrans,frames[frame],0,time);\r\n");
                    sb.append("\tctx.restore();\r\n");
                    sb.append("}\r\n\r\n");
                    if (ftim.swf.frameRate > 0.0f) {
                        sb.append("window.setInterval(function(){nextFrame(ctx,ctrans);},").append((int)(1000.0 / (double)ftim.swf.frameRate)).append(");\r\n");
                    }
                    sb.append("nextFrame(ctx,ctrans);\r\n");
                    ((OutputStream)fos).write(Utf8Helper.getBytes(sb.toString()));
                }
                boolean packed = false;
                if (Configuration.packJavaScripts.get().booleanValue()) {
                    try {
                        JPacker.main((String[])new String[]{"-q", "-b", "62", "-o", fmin.getAbsolutePath(), f.getAbsolutePath()});
                        f.delete();
                        packed = true;
                    }
                    catch (Error | Exception e) {
                        logger.log(Level.WARNING, "JPacker: Cannot minimize script");
                        f.renameTo(fmin);
                    }
                } else {
                    f.renameTo(fmin);
                }
                File fh = new File(foutdir + File.separator + "frames.html");
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(fh));){
                    FileInputStream fis = new FileInputStream(fmin);
                    object = null;
                    try {
                        int cnt;
                        ((OutputStream)fos).write(Utf8Helper.getBytes(CanvasShapeExporter.getHtmlPrefix(width, height)));
                        ((OutputStream)fos).write(Utf8Helper.getBytes(CanvasShapeExporter.getJsPrefix()));
                        byte[] buf = new byte[1000];
                        while ((cnt = fis.read(buf)) > 0) {
                            ((OutputStream)fos).write(buf, 0, cnt);
                        }
                        if (packed) {
                            ((OutputStream)fos).write(Utf8Helper.getBytes(";"));
                        }
                        ((OutputStream)fos).write(Utf8Helper.getBytes(CanvasShapeExporter.getJsSuffix()));
                        ((OutputStream)fos).write(Utf8Helper.getBytes(CanvasShapeExporter.getHtmlSuffix()));
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (fis != null) {
                            if (object != null) {
                                try {
                                    fis.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                fis.close();
                            }
                        }
                    }
                }
                fmin.delete();
                ret.add(f);
            }, handler).run();
            if (evl != null) {
                Tag parentTag = tim.getParentTag();
                evl.handleExportedEvent("canvas", 1, 1, parentTag == null ? "" : parentTag.getName());
            }
            return ret;
        }
        final Timeline ftim = tim;
        final Color fbackgroundColor = backgroundColor;
        Iterator<BufferedImage> frameImages = new Iterator<BufferedImage>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return fframes.size() > this.pos;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public BufferedImage next() {
                String tagName;
                if (!this.hasNext()) {
                    return null;
                }
                Tag parentTag = tim.getParentTag();
                String string = tagName = parentTag == null ? "" : parentTag.getName();
                if (evl != null) {
                    evl.handleExportingEvent("frame", this.pos + 1, fframes.size(), tagName);
                }
                int fframe = (Integer)fframes.get(this.pos++);
                BufferedImage result = SWF.frameToImageGet(ftim, fframe, fframe, null, 0, ftim.displayRect, new Matrix(), null, fbackgroundColor, settings.zoom).getBufferedImage();
                if (evl != null) {
                    evl.handleExportedEvent("frame", this.pos, fframes.size(), tagName);
                }
                return result;
            }
        };
        switch (settings.mode) {
            case GIF: {
                new RetryTask(() -> {
                    File f = new File(foutdir + File.separator + "frames.gif");
                    FrameExporter.makeGIF(frameImages, swf.frameRate, f, evl);
                    ret.add(f);
                }, handler).run();
                break;
            }
            case BMP: {
                int i = 0;
                while (frameImages.hasNext()) {
                    int fi = i++;
                    new RetryTask(() -> {
                        File f = new File(foutdir + File.separator + ((Integer)fframes.get(fi) + 1) + ".bmp");
                        BMPFile.saveBitmap((Image)frameImages.next(), f);
                        ret.add(f);
                    }, handler).run();
                }
                break;
            }
            case PNG: {
                int i = 0;
                while (frameImages.hasNext()) {
                    int fi = i++;
                    new RetryTask(() -> {
                        File file = new File(foutdir + File.separator + ((Integer)fframes.get(fi) + 1) + ".png");
                        ImageHelper.write((BufferedImage)frameImages.next(), ImageFormat.PNG, file);
                        ret.add(file);
                    }, handler).run();
                }
                break;
            }
            case PDF: {
                if (!frameImages.hasNext()) break;
                new RetryTask(() -> {
                    File f = new File(foutdir + File.separator + "frames.pdf");
                    PDFJob job = new PDFJob((OutputStream)new BufferedOutputStream(new FileOutputStream(f)));
                    PageFormat pf = new PageFormat();
                    pf.setOrientation(1);
                    Paper p = new Paper();
                    BufferedImage img0 = (BufferedImage)frameImages.next();
                    p.setSize(img0.getWidth() + 10, img0.getHeight() + 10);
                    pf.setPaper(p);
                    int i = 0;
                    while (frameImages.hasNext()) {
                        BufferedImage img = (BufferedImage)frameImages.next();
                        Graphics g = job.getGraphics(pf);
                        g.drawImage(img, 5, 5, img.getWidth(), img.getHeight(), null);
                        g.dispose();
                        ++i;
                    }
                    job.end();
                    ret.add(f);
                }, handler).run();
                break;
            }
            case AVI: {
                new RetryTask(() -> {
                    File f = new File(foutdir + File.separator + "frames.avi");
                    FrameExporter.makeAVI(frameImages, swf.frameRate, f, evl);
                    ret.add(f);
                }, handler).run();
            }
        }
        return ret;
    }

    private static String jsArrColor(RGB rgb) {
        return "[" + rgb.red + "," + rgb.green + "," + rgb.blue + "," + (rgb instanceof RGBA ? ((RGBA)rgb).getAlphaFloat() : 1.0f) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeAVI(Iterator<BufferedImage> images, float frameRate, File file, EventListener evl) throws IOException {
        if (!images.hasNext()) {
            return;
        }
        AVIWriter out = new AVIWriter(file);
        BufferedImage img0 = images.next();
        out.addVideoTrack("png ", 1L, (long)((int)frameRate), img0.getWidth(), img0.getHeight(), 0, 0);
        try {
            out.write(0, img0, 1L);
            while (images.hasNext()) {
                out.write(0, images.next(), 1L);
            }
        }
        finally {
            out.close();
        }
    }

    public static void makeGIF(Iterator<BufferedImage> images, float frameRate, File file, EventListener evl) throws IOException {
        if (!images.hasNext()) {
            return;
        }
        AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        encoder.setRepeat(0);
        encoder.start(file.getAbsolutePath());
        encoder.setDelay((int)(1000.0 / (double)frameRate));
        while (images.hasNext()) {
            encoder.addFrame(images.next());
        }
        encoder.finish();
    }

    public static void makeGIFOld(Iterator<BufferedImage> images, float frameRate, File file, EventListener evl) throws IOException {
        if (!images.hasNext()) {
            return;
        }
        try (FileImageOutputStream output = new FileImageOutputStream(file);){
            BufferedImage img0 = images.next();
            GifSequenceWriter writer = new GifSequenceWriter((ImageOutputStream)output, img0.getType(), (int)(1000.0 / (double)frameRate), true);
            writer.writeToSequence((RenderedImage)img0);
            while (images.hasNext()) {
                writer.writeToSequence((RenderedImage)images.next());
            }
            writer.close();
        }
    }

    public static void framesToHtmlCanvas(StringBuilder result, double unitDivisor, Timeline timeline, List<Integer> frames, int time, DepthState stateUnderCursor, int mouseButton, RECT displayRect, ColorTransform colorTransform, Color backGroundColor) {
        if (frames == null) {
            frames = new ArrayList<Integer>();
            for (int i = 0; i < timeline.getFrameCount(); ++i) {
                frames.add(i);
            }
        }
        result.append("\tvar clips = [];\r\n");
        result.append("\tvar frame_cnt = ").append(timeline.getFrameCount()).append(";\r\n");
        result.append("\tframe = frame % frame_cnt;\r\n");
        result.append("\tswitch(frame){\r\n");
        int maxDepth = timeline.getMaxDepth();
        Stack<Integer> clipDepths = new Stack<Integer>();
        for (int frame : frames) {
            result.append("\t\tcase ").append(frame).append(":\r\n");
            Frame frameObj = timeline.getFrame(frame);
            for (int i = 1; i <= maxDepth + 1; ++i) {
                DefineSpriteTag sp;
                Timeline tim;
                while (!clipDepths.isEmpty() && (Integer)clipDepths.peek() <= i) {
                    clipDepths.pop();
                    result.append("\t\t\tvar o = clips.pop();\r\n");
                    result.append("\t\t\tctx.globalCompositeOperation = \"destination-in\";\r\n");
                    result.append("\t\t\tctx.setTransform(1,0,0,1,0,0);\r\n");
                    result.append("\t\t\tctx.drawImage(o.clipCanvas,0,0);\r\n");
                    result.append("\t\t\tvar ms=o.ctx._matrix;\r\n");
                    result.append("\t\t\to.ctx.setTransform(1,0,0,1,0,0);\r\n");
                    result.append("\t\t\to.ctx.globalCompositeOperation = \"source-over\";\r\n");
                    result.append("\t\t\to.ctx.drawImage(canvas,0,0);\r\n");
                    result.append("\t\t\to.ctx.applyTransforms(ms);\r\n");
                    result.append("\t\t\tctx = o.ctx;\r\n");
                    result.append("\t\t\tcanvas = o.canvas;\r\n");
                }
                if (!frameObj.layers.containsKey(i)) continue;
                DepthState layer = frameObj.layers.get(i);
                if (!timeline.swf.getCharacters().containsKey(layer.characterId) || !layer.isVisible) continue;
                CharacterTag character = timeline.swf.getCharacter(layer.characterId);
                Matrix placeMatrix = new Matrix(layer.matrix);
                placeMatrix.scaleX /= unitDivisor;
                placeMatrix.scaleY /= unitDivisor;
                placeMatrix.rotateSkew0 /= unitDivisor;
                placeMatrix.rotateSkew1 /= unitDivisor;
                placeMatrix.translateX /= unitDivisor;
                placeMatrix.translateY /= unitDivisor;
                int f = 0;
                String fstr = "0";
                if (character instanceof DefineSpriteTag && (tim = (sp = (DefineSpriteTag)character).getTimeline()).getFrameCount() > 0) {
                    f = layer.time % tim.getFrameCount();
                    fstr = "(" + f + "+time)%" + tim.getFrameCount();
                }
                if (layer.clipDepth != -1) {
                    clipDepths.push(layer.clipDepth);
                    result.append("\t\t\tclips.push({ctx:ctx,canvas:canvas});\r\n");
                    result.append("\t\t\tvar ccanvas = createCanvas(canvas.width,canvas.height);\r\n");
                    result.append("\t\t\tvar cctx = ccanvas.getContext(\"2d\");\r\n");
                    result.append("\t\t\tenhanceContext(cctx);\r\n");
                    result.append("\t\t\tcctx.applyTransforms(ctx._matrix);\r\n");
                    result.append("\t\t\tcanvas = ccanvas;\r\n");
                    result.append("\t\t\tctx = cctx;\r\n");
                }
                if (layer.filters != null && layer.filters.size() > 0) {
                    result.append("\t\t\tvar oldctx = ctx;\r\n");
                    result.append("\t\t\tvar fcanvas = createCanvas(canvas.width,canvas.height);");
                    result.append("\t\t\tvar fctx = fcanvas.getContext(\"2d\");\r\n");
                    result.append("\t\t\tenhanceContext(fctx);\r\n");
                    result.append("\t\t\tfctx.applyTransforms(ctx._matrix);\r\n");
                    result.append("\t\t\tctx = fctx;\r\n");
                }
                ColorTransform ctrans = layer.colorTransForm;
                String ctrans_str = "ctrans";
                if (ctrans != null) {
                    ctrans_str = "ctrans.merge(new cxform(" + ctrans.getRedAdd() + "," + ctrans.getGreenAdd() + "," + ctrans.getBlueAdd() + "," + ctrans.getAlphaAdd() + "," + ctrans.getRedMulti() + "," + ctrans.getGreenMulti() + "," + ctrans.getBlueMulti() + "," + ctrans.getAlphaMulti() + "))";
                }
                result.append("\t\t\tplace(\"").append(SWF.getTypePrefix(character)).append(layer.characterId).append("\",canvas,ctx,[").append(placeMatrix.scaleX).append(",").append(placeMatrix.rotateSkew0).append(",").append(placeMatrix.rotateSkew1).append(",").append(placeMatrix.scaleY).append(",").append(placeMatrix.translateX).append(",").append(placeMatrix.translateY).append("],").append(ctrans_str).append(",").append("").append(layer.blendMode < 1 ? 1 : layer.blendMode).append(",").append(fstr).append(",").append(layer.ratio < 0 ? 0 : layer.ratio).append(",time").append(");\r\n");
                if (layer.filters != null && layer.filters.size() > 0) {
                    for (FILTER filter : layer.filters) {
                        String type;
                        if (filter instanceof COLORMATRIXFILTER) {
                            COLORMATRIXFILTER cmf = (COLORMATRIXFILTER)filter;
                            result.append("\t\t\tfcanvas = Filters.colorMatrix(fcanvas,fcanvas.getContext(\"2d\"),[");
                            for (int k = 0; k < cmf.matrix.length; ++k) {
                                if (k > 0) {
                                    result.append(",");
                                }
                                result.append(cmf.matrix[k]);
                            }
                            result.append("]");
                            result.append(");\r\n");
                        }
                        if (filter instanceof CONVOLUTIONFILTER) {
                            CONVOLUTIONFILTER cf = (CONVOLUTIONFILTER)filter;
                            int height = cf.matrix.length;
                            int width = cf.matrix[0].length;
                            float[] matrix2 = new float[width * height];
                            for (int y = 0; y < height; ++y) {
                                for (int x = 0; x < width; ++x) {
                                    matrix2[y * width + x] = cf.matrix[x][y] * cf.divisor + cf.bias;
                                }
                            }
                            String mat = "[";
                            for (int k = 0; k < matrix2.length; ++k) {
                                if (k > 0) {
                                    mat = mat + ",";
                                }
                                mat = mat + matrix2[k];
                            }
                            mat = mat + "]";
                            result.append("\t\t\tfcanvas = Filters.convolution(fcanvas,fcanvas.getContext(\"2d\"),").append(mat).append(",false);\r\n");
                        }
                        if (filter instanceof GLOWFILTER) {
                            GLOWFILTER gf = (GLOWFILTER)filter;
                            result.append("\t\t\tfcanvas = Filters.glow(fcanvas,fcanvas.getContext(\"2d\"),").append(gf.blurX).append(",").append(gf.blurY).append(",").append(gf.strength).append(",").append(FrameExporter.jsArrColor(gf.glowColor)).append(",").append(gf.innerGlow ? "true" : "false").append(",").append(gf.knockout ? "true" : "false").append(",").append(gf.passes).append(");\r\n");
                        }
                        if (filter instanceof DROPSHADOWFILTER) {
                            DROPSHADOWFILTER ds = (DROPSHADOWFILTER)filter;
                            result.append("\t\t\tfcanvas = Filters.dropShadow(fcanvas,fcanvas.getContext(\"2d\"),").append(ds.blurX).append(",").append(ds.blurY).append(",").append((int)(ds.angle * 180.0 / Math.PI)).append(",").append(ds.distance).append(",").append(FrameExporter.jsArrColor(ds.dropShadowColor)).append(",").append(ds.innerShadow ? "true" : "false").append(",").append(ds.passes).append(",").append(ds.strength).append(",").append(ds.knockout ? "true" : "false").append(");\r\n");
                        }
                        if (filter instanceof BEVELFILTER) {
                            BEVELFILTER bv = (BEVELFILTER)filter;
                            String type2 = "Filters.INNER";
                            if (bv.onTop && !bv.innerShadow) {
                                type2 = "Filters.FULL";
                            } else if (!bv.innerShadow) {
                                type2 = "Filters.OUTER";
                            }
                            result.append("\t\t\tfcanvas = Filters.bevel(fcanvas,fcanvas.getContext(\"2d\"),").append(bv.blurX).append(",").append(bv.blurY).append(",").append(bv.strength).append(",").append(type2).append(",").append(FrameExporter.jsArrColor(bv.highlightColor)).append(",").append(FrameExporter.jsArrColor(bv.shadowColor)).append(",").append((int)(bv.angle * 180.0 / Math.PI)).append(",").append(bv.distance).append(",").append(bv.knockout ? "true" : "false").append(",").append(bv.passes).append(");\r\n");
                        }
                        if (filter instanceof GRADIENTBEVELFILTER) {
                            GRADIENTBEVELFILTER gbf = (GRADIENTBEVELFILTER)filter;
                            String colArr = "[";
                            String ratArr = "[";
                            for (int k = 0; k < gbf.gradientColors.length; ++k) {
                                if (k > 0) {
                                    colArr = colArr + ",";
                                    ratArr = ratArr + ",";
                                }
                                colArr = colArr + FrameExporter.jsArrColor(gbf.gradientColors[k]);
                                ratArr = ratArr + (float)gbf.gradientRatio[k] / 255.0f;
                            }
                            colArr = colArr + "]";
                            ratArr = ratArr + "]";
                            type = "Filters.INNER";
                            if (gbf.onTop && !gbf.innerShadow) {
                                type = "Filters.FULL";
                            } else if (!gbf.innerShadow) {
                                type = "Filters.OUTER";
                            }
                            result.append("\t\t\tfcanvas = Filters.gradientBevel(fcanvas,fcanvas.getContext(\"2d\"),").append(colArr).append(",").append(ratArr).append(",").append(gbf.blurX).append(",").append(gbf.blurY).append(",").append(gbf.strength).append(",").append(type).append(",").append((int)(gbf.angle * 180.0 / Math.PI)).append(",").append(gbf.distance).append(",").append(gbf.knockout ? "true" : "false").append(",").append(gbf.passes).append(");\r\n");
                        }
                        if (!(filter instanceof GRADIENTGLOWFILTER)) continue;
                        GRADIENTGLOWFILTER ggf = (GRADIENTGLOWFILTER)filter;
                        String colArr = "[";
                        String ratArr = "[";
                        for (int k = 0; k < ggf.gradientColors.length; ++k) {
                            if (k > 0) {
                                colArr = colArr + ",";
                                ratArr = ratArr + ",";
                            }
                            colArr = colArr + FrameExporter.jsArrColor(ggf.gradientColors[k]);
                            ratArr = ratArr + (float)ggf.gradientRatio[k] / 255.0f;
                        }
                        colArr = colArr + "]";
                        ratArr = ratArr + "]";
                        type = "Filters.INNER";
                        if (ggf.onTop && !ggf.innerShadow) {
                            type = "Filters.FULL";
                        } else if (!ggf.innerShadow) {
                            type = "Filters.OUTER";
                        }
                        result.append("\t\t\tfcanvas = Filters.gradientGlow(fcanvas,fcanvas.getContext(\"2d\"),").append(ggf.blurX).append(",").append(ggf.blurY).append(",").append((int)(ggf.angle * 180.0 / Math.PI)).append(",").append(ggf.distance).append(",").append(colArr).append(",").append(ratArr).append(",").append(type).append(",").append(ggf.passes).append(",").append(ggf.strength).append(",").append(ggf.knockout ? "true" : "false").append(");\r\n");
                    }
                    result.append("\t\t\tctx = oldctx;\r\n");
                    result.append("\t\t\tvar ms=ctx._matrix;\r\n");
                    result.append("\t\t\tctx.setTransform(1,0,0,1,0,0);\r\n");
                    result.append("\t\t\tctx.drawImage(fcanvas,0,0);\r\n");
                    result.append("\t\t\tctx.applyTransforms(ms);\r\n");
                }
                if (layer.clipDepth == -1) continue;
                result.append("\t\t\tclips[clips.length-1].clipCanvas = canvas;\r\n");
                result.append("\t\t\tcanvas = createCanvas(canvas.width,canvas.height);\r\n");
                result.append("\t\t\tvar nctx = canvas.getContext(\"2d\");\r\n");
                result.append("\t\t\tenhanceContext(nctx);\r\n");
                result.append("\t\t\tnctx.applyTransforms(ctx._matrix);\r\n");
                result.append("\t\t\tctx = nctx;\r\n");
            }
            result.append("\t\t\tbreak;\r\n");
        }
        result.append("\t}\r\n");
    }
}

