/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.configuration;

import com.jpexs.decompiler.flash.configuration.ConfigurationItemChangeListener;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationItem<T> {
    private final String name;
    protected boolean hasValue;
    private T value;
    private T defaultValue;
    private boolean modified;
    private List<ConfigurationItemChangeListener<T>> listeners;

    public ConfigurationItem(String name) {
        this.name = name;
    }

    public ConfigurationItem(String name, T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public ConfigurationItem(String name, T defaultValue, T value) {
        this.name = name;
        this.hasValue = true;
        this.defaultValue = defaultValue;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public T get() {
        if (!this.hasValue) {
            return this.defaultValue;
        }
        return this.value;
    }

    public T get(T defaultValue) {
        if (!this.hasValue) {
            return defaultValue;
        }
        return this.value;
    }

    public void set(T value) {
        this.hasValue = true;
        this.modified = true;
        this.value = value;
        this.fireConfigurationItemChanged(value);
    }

    public void unset() {
        this.hasValue = false;
        this.modified = true;
        this.value = null;
        this.fireConfigurationItemChanged(this.defaultValue);
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String toString() {
        return this.name;
    }

    private void fireConfigurationItemChanged(T newValue) {
        if (this.listeners != null) {
            for (ConfigurationItemChangeListener<T> listener : this.listeners) {
                listener.configurationItemChanged(newValue);
            }
        }
    }

    public void addListener(ConfigurationItemChangeListener<T> l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ConfigurationItemChangeListener<T>>();
        }
        this.listeners.add(l);
    }

    public void removeListener(ConfigurationItemChangeListener<T> l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }
}

