/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.clauses;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.swf5.ActionWith;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class WithActionItem
extends ActionItem {
    public GraphTargetItem scope;
    public List<GraphTargetItem> items;

    public WithActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem scope, List<GraphTargetItem> items) {
        super(instruction, lineStartIns, 16);
        this.scope = scope;
        this.items = items;
    }

    public WithActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, ActionItem scope) {
        super(instruction, lineStartIns, 16);
        this.scope = scope;
        this.items = new ArrayList<GraphTargetItem>();
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("with");
        if (writer.getFormatting().spaceBeforeParenthesesWithParentheses) {
            writer.append(" ");
        }
        writer.append("(");
        this.scope.toString(writer, localData);
        writer.append(")").startBlock();
        for (GraphTargetItem ti : this.items) {
            ti.toString(writer, localData).newLine();
        }
        return writer.endBlock();
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        List<GraphSourceItem> data = generator.generate(localData, this.items);
        ArrayList<Action> dataA = new ArrayList<Action>();
        for (GraphSourceItem s : data) {
            if (!(s instanceof Action)) continue;
            dataA.add((Action)s);
        }
        int codeLen = Action.actionsToBytes(dataA, false, 10).length;
        return WithActionItem.toSourceMerge(localData, generator, this.scope, new ActionWith(codeLen), data);
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

