/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.clauses;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.ConstantPool;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.swf4.ActionJump;
import com.jpexs.decompiler.flash.action.swf7.ActionTry;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class TryActionItem
extends ActionItem
implements Block {
    public List<GraphTargetItem> tryCommands;
    public List<GraphTargetItem> catchExceptions;
    public List<List<GraphTargetItem>> catchCommands;
    public List<GraphTargetItem> finallyCommands;

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        if (this.tryCommands != null) {
            ret.add(this.tryCommands);
        }
        ret.addAll(this.catchCommands);
        if (this.finallyCommands != null) {
            ret.add(this.finallyCommands);
        }
        return ret;
    }

    public TryActionItem(List<GraphTargetItem> tryCommands, List<GraphTargetItem> catchExceptions, List<List<GraphTargetItem>> catchCommands, List<GraphTargetItem> finallyCommands) {
        super(null, null, 16);
        this.tryCommands = tryCommands;
        this.catchExceptions = catchExceptions;
        this.catchCommands = catchCommands;
        this.finallyCommands = finallyCommands;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("try");
        this.appendBlock(null, writer, localData, this.tryCommands);
        for (int e = 0; e < this.catchExceptions.size(); ++e) {
            writer.newLine();
            writer.append("catch");
            if (writer.getFormatting().spaceBeforeParenthesesCatchParentheses) {
                writer.append(" ");
            }
            writer.append("(");
            this.catchExceptions.get(e).toStringNoQuotes(writer, localData);
            writer.append(")");
            List<GraphTargetItem> commands = this.catchCommands.get(e);
            this.appendBlock(null, writer, localData, commands);
        }
        if (this.catchExceptions.isEmpty() || this.finallyCommands.size() > 0) {
            writer.newLine();
            writer.append("finally");
            this.appendBlock(null, writer, localData, this.finallyCommands);
        }
        return writer;
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        for (GraphTargetItem graphTargetItem : this.tryCommands) {
            if (graphTargetItem instanceof ContinueItem) {
                ret.add((ContinueItem)graphTargetItem);
            }
            if (!(graphTargetItem instanceof Block)) continue;
            ret.addAll(((Block)((Object)graphTargetItem)).getContinues());
        }
        if (this.finallyCommands != null) {
            for (GraphTargetItem graphTargetItem : this.finallyCommands) {
                if (graphTargetItem instanceof ContinueItem) {
                    ret.add((ContinueItem)graphTargetItem);
                }
                if (!(graphTargetItem instanceof Block)) continue;
                ret.addAll(((Block)((Object)graphTargetItem)).getContinues());
            }
        }
        for (List list : this.catchCommands) {
            for (GraphTargetItem ti : list) {
                if (ti instanceof ContinueItem) {
                    ret.add((ContinueItem)ti);
                }
                if (!(ti instanceof Block)) continue;
                ret.addAll(((Block)((Object)ti)).getContinues());
            }
        }
        return ret;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        List<Action> tryCommandsA = asGenerator.toActionList(asGenerator.generate(localData, this.tryCommands));
        List<Action> finallyCommandsA = this.finallyCommands == null ? null : asGenerator.toActionList(asGenerator.generate(localData, this.finallyCommands));
        List<Action> catchCommandsA = null;
        String catchName = null;
        if (this.catchExceptions != null && !this.catchExceptions.isEmpty()) {
            catchName = this.catchExceptions.get(0).toStringNoQuotes(LocalData.create(new ConstantPool(asGenerator.getConstantPool())));
        }
        int catchSize = 0;
        if (this.catchCommands != null && !this.catchCommands.isEmpty()) {
            catchCommandsA = asGenerator.toActionList(asGenerator.generate(localData, this.catchCommands.get(0)));
            catchSize = Action.actionsToBytes(catchCommandsA, false, 10).length;
            tryCommandsA.add(new ActionJump(catchSize));
        }
        int finallySize = 0;
        if (finallyCommandsA != null) {
            finallySize = Action.actionsToBytes(finallyCommandsA, false, 10).length;
        }
        int trySize = Action.actionsToBytes(tryCommandsA, false, 10).length;
        ret.add(new ActionTry(false, this.finallyCommands != null, this.catchCommands != null, catchName, 0, trySize, catchSize, finallySize, 10));
        ret.addAll(tryCommandsA);
        if (catchCommandsA != null) {
            ret.addAll(catchCommandsA);
        }
        if (finallyCommandsA != null) {
            ret.addAll(finallyCommandsA);
        }
        return ret;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

