/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.clauses;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.SetMemberActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.collections.MyEntry;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassActionItem
extends ActionItem
implements Block {
    public List<GraphTargetItem> functions;
    public List<GraphTargetItem> staticFunctions;
    public GraphTargetItem extendsOp;
    public List<GraphTargetItem> implementsOp;
    public GraphTargetItem className;
    public GraphTargetItem constructor;
    public List<MyEntry<GraphTargetItem, GraphTargetItem>> vars;
    public List<MyEntry<GraphTargetItem, GraphTargetItem>> staticVars;
    public Set<String> uninitializedVars;

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        if (this.functions != null) {
            ret.add(this.functions);
        }
        if (this.staticFunctions != null) {
            ret.add(this.staticFunctions);
        }
        return ret;
    }

    public ClassActionItem(GraphTargetItem className, GraphTargetItem extendsOp, List<GraphTargetItem> implementsOp, GraphTargetItem constructor, List<GraphTargetItem> functions, List<MyEntry<GraphTargetItem, GraphTargetItem>> vars, List<GraphTargetItem> staticFunctions, List<MyEntry<GraphTargetItem, GraphTargetItem>> staticVars) {
        super(null, null, 16);
        this.className = className;
        this.functions = functions;
        this.vars = vars;
        this.extendsOp = extendsOp;
        this.implementsOp = implementsOp;
        this.staticFunctions = staticFunctions;
        this.staticVars = staticVars;
        this.constructor = constructor;
        ArrayList<GraphTargetItem> allFunc = new ArrayList<GraphTargetItem>(functions);
        if (constructor != null) {
            allFunc.add(constructor);
        }
        this.uninitializedVars = new HashSet<String>();
        ArrayList<GraphTargetItem> allUsages = new ArrayList<GraphTargetItem>();
        for (GraphTargetItem it : allFunc) {
            if (!(it instanceof FunctionActionItem)) continue;
            FunctionActionItem functionActionItem = (FunctionActionItem)it;
            this.detectUnitializedVars(functionActionItem.actions, allUsages);
        }
        HashSet<String> allMembers = new HashSet<String>();
        for (GraphTargetItem graphTargetItem : allUsages) {
            allMembers.add(graphTargetItem.toStringNoQuotes(LocalData.empty));
        }
        this.uninitializedVars.addAll(allMembers);
        for (MyEntry myEntry : vars) {
            String s = ((GraphTargetItem)myEntry.getKey()).toStringNoQuotes(LocalData.empty);
            if (!this.uninitializedVars.contains(s)) continue;
            this.uninitializedVars.remove(s);
        }
    }

    private boolean isThis(GraphTargetItem item) {
        if (item instanceof VariableActionItem) {
            return "this".equals(((VariableActionItem)item).getVariableName());
        }
        return false;
    }

    private void detectUnitializedVars(GraphTargetItem item, List<GraphTargetItem> ret) {
        if (item == null) {
            return;
        }
        if (item instanceof GetMemberActionItem) {
            GetMemberActionItem gm = (GetMemberActionItem)item;
            if (this.isThis(gm.object)) {
                ret.add(gm.memberName);
            } else {
                this.detectUnitializedVars(gm.object, ret);
            }
        }
        if (item instanceof SetMemberActionItem) {
            SetMemberActionItem sm = (SetMemberActionItem)item;
            if (this.isThis(sm.object)) {
                ret.add(sm.objectName);
            } else {
                this.detectUnitializedVars(sm.object, ret);
            }
        }
        if (item instanceof Block) {
            Block bl = (Block)((Object)item);
            for (List<GraphTargetItem> list : bl.getSubs()) {
                this.detectUnitializedVars(list, ret);
            }
        }
        this.detectUnitializedVars(item.getAllSubItems(), ret);
    }

    private void detectUnitializedVars(List<GraphTargetItem> items, List<GraphTargetItem> ret) {
        for (GraphTargetItem it : items) {
            this.detectUnitializedVars(it, ret);
        }
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.startClass(this.className.toStringNoQuotes(localData));
        writer.append("class ");
        this.className.toStringNoQuotes(writer, localData);
        if (this.extendsOp != null) {
            writer.append(" extends ");
            this.extendsOp.toStringNoQuotes(writer, localData);
        }
        if (!this.implementsOp.isEmpty()) {
            writer.append(" implements ");
            boolean first = true;
            for (GraphTargetItem t : this.implementsOp) {
                if (!first) {
                    writer.append(", ");
                }
                first = false;
                Action.getWithoutGlobal(t).toString(writer, localData);
            }
        }
        writer.startBlock();
        if (this.constructor != null) {
            this.constructor.toString(writer, localData).newLine();
        }
        for (MyEntry<GraphTargetItem, GraphTargetItem> myEntry : this.vars) {
            writer.append("var ");
            myEntry.getKey().toStringNoQuotes(writer, localData);
            writer.append(" = ");
            myEntry.getValue().toString(writer, localData);
            writer.append(";").newLine();
        }
        for (String string : this.uninitializedVars) {
            writer.append("var ");
            writer.append(string);
            writer.append(";").newLine();
        }
        for (MyEntry myEntry : this.staticVars) {
            writer.append("static var ");
            ((GraphTargetItem)myEntry.getKey()).toStringNoQuotes(writer, localData);
            writer.append(" = ");
            ((GraphTargetItem)myEntry.getValue()).toString(writer, localData);
            writer.append(";").newLine();
        }
        for (GraphTargetItem graphTargetItem : this.functions) {
            graphTargetItem.toString(writer, localData).newLine();
        }
        for (GraphTargetItem graphTargetItem : this.staticFunctions) {
            writer.append("static ");
            graphTargetItem.toString(writer, localData).newLine();
        }
        writer.endBlock();
        writer.endClass();
        return writer;
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        return ret;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        SourceGeneratorLocalData localData2 = Helper.deepCopy(localData);
        asGenerator.setInMethod(localData2, true);
        ret.addAll(asGenerator.generateTraits(localData2, false, this.className, this.extendsOp, this.implementsOp, this.constructor, this.functions, this.vars, this.staticFunctions, this.staticVars));
        return ret;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

