/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.swf5.ActionTypeOf;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.EcmaType;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Set;

public class TypeOfActionItem
extends ActionItem {
    public TypeOfActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value) {
        super(instruction, lineStartIns, 0, value);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("typeof ");
        writer.spaceBeforeCallParenthesies(1);
        this.value.toString(writer, localData);
        return writer;
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.value.getNeededSources());
        return ret;
    }

    @Override
    public Object getResult() {
        return TypeOfActionItem.getResult(this.value.getResult());
    }

    public static String getResult(Object obj) {
        Object res = obj;
        EcmaType type = EcmaScript.type(res);
        switch (type) {
            case STRING: {
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case NUMBER: {
                return "number";
            }
            case OBJECT: {
                return "object";
            }
            case UNDEFINED: {
                return "undefined";
            }
            case NULL: {
                return "null";
            }
        }
        return "object";
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        dependencies.add(this.value);
        return this.value.isCompileTime(dependencies);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return TypeOfActionItem.toSourceMerge(localData, generator, this.value, new ActionTypeOf());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

