/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.GetPropertyActionItem;
import com.jpexs.decompiler.flash.action.model.SetTypeActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.ActionSetProperty;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionStoreRegister;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;

public class SetPropertyActionItem
extends ActionItem
implements SetTypeActionItem {
    public GraphTargetItem target;
    public int propertyIndex;
    private int tempRegister = -1;

    @Override
    public GraphPart getFirstPart() {
        return this.value.getFirstPart();
    }

    @Override
    public void setValue(GraphTargetItem value) {
        this.value = value;
    }

    @Override
    public int getTempRegister() {
        return this.tempRegister;
    }

    @Override
    public void setTempRegister(int tempRegister) {
        this.tempRegister = tempRegister;
    }

    @Override
    public GraphTargetItem getValue() {
        return this.value;
    }

    public SetPropertyActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem target, int propertyIndex, GraphTargetItem value) {
        super(instruction, lineStartIns, 14, value);
        this.target = target;
        this.propertyIndex = propertyIndex;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.isEmptyString(this.target)) {
            writer.append(Action.propertyNames[this.propertyIndex]).append(" = ");
            return this.value.toString(writer, localData);
        }
        this.target.toString(writer, localData);
        writer.append("." + Action.propertyNames[this.propertyIndex]).append(" = ");
        return this.value.toString(writer, localData);
    }

    @Override
    public GraphTargetItem getObject() {
        return new GetPropertyActionItem(this.getSrc(), this.getLineStartItem(), this.target, this.propertyIndex);
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.target.getNeededSources());
        ret.addAll(this.value.getNeededSources());
        return ret;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        int tmpReg = asGenerator.getTempRegister(localData);
        try {
            List<GraphSourceItem> list = SetPropertyActionItem.toSourceMerge(localData, generator, this.target, new ActionPush(this.propertyIndex), this.value, new ActionStoreRegister(tmpReg), new ActionSetProperty(), new ActionPush(new RegisterNumber(tmpReg)));
            return list;
        }
        finally {
            asGenerator.releaseTempRegister(localData, tmpReg);
        }
    }

    @Override
    public List<GraphSourceItem> toSourceIgnoreReturnValue(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return SetPropertyActionItem.toSourceMerge(localData, generator, this.target, new ActionPush(this.propertyIndex), this.value, new ActionSetProperty());
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

