/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.swf5.ActionCallMethod;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.List;

public class CallMethodActionItem
extends ActionItem {
    public GraphTargetItem methodName;
    public GraphTargetItem scriptObject;
    public List<GraphTargetItem> arguments;

    @Override
    public List<GraphTargetItem> getAllSubItems() {
        ArrayList<GraphTargetItem> ret = new ArrayList<GraphTargetItem>();
        ret.addAll(this.arguments);
        ret.add(this.scriptObject);
        return ret;
    }

    public CallMethodActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem scriptObject, GraphTargetItem methodName, List<GraphTargetItem> arguments) {
        super(instruction, lineStartIns, 0);
        this.methodName = methodName;
        this.arguments = arguments;
        this.scriptObject = scriptObject;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        boolean blankMethod = false;
        boolean dvai = this.methodName instanceof DirectValueActionItem;
        if (dvai) {
            if (((DirectValueActionItem)this.methodName).value == Undefined.INSTANCE) {
                blankMethod = true;
            }
            if (((DirectValueActionItem)this.methodName).value instanceof String && ((DirectValueActionItem)this.methodName).value.equals("")) {
                blankMethod = true;
            }
            if (!blankMethod) {
                if (this.scriptObject.getPrecedence() > this.precedence) {
                    writer.append("(");
                    this.scriptObject.toString(writer, localData);
                    writer.append(")");
                } else {
                    this.scriptObject.toString(writer, localData);
                }
                writer.append(".");
                writer.append(IdentifiersDeobfuscation.printIdentifier(false, this.methodName.toStringNoQuotes(localData), new String[0]));
            } else {
                this.scriptObject.toString(writer, localData);
            }
        } else {
            writer.append("this[");
            this.methodName.appendTry(writer, localData);
            writer.append("].call");
        }
        writer.spaceBeforeCallParenthesies(this.arguments.size());
        writer.append("(");
        if (!dvai) {
            writer.append("this");
        }
        for (int t = 0; t < this.arguments.size(); ++t) {
            if (t > 0 || !dvai) {
                writer.append(",");
            }
            this.arguments.get(t).toStringNL(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        ret.addAll(this.methodName.getNeededSources());
        ret.addAll(this.scriptObject.getNeededSources());
        for (GraphTargetItem ti : this.arguments) {
            ret.addAll(ti.getNeededSources());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return CallMethodActionItem.toSourceMerge(localData, generator, this.toSourceCall(localData, generator, this.arguments), this.scriptObject, this.methodName, new ActionCallMethod());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

