/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.usages;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.graph.DottedChain;
import java.util.ArrayList;
import java.util.Objects;

public abstract class MultinameUsage {
    protected final ABC abc;
    private final int multinameIndex;

    public MultinameUsage(ABC abc, int multinameIndex) {
        this.abc = abc;
        this.multinameIndex = multinameIndex;
    }

    public int getMultinameIndex() {
        return this.multinameIndex;
    }

    public ABC getAbc() {
        return this.abc;
    }

    protected boolean sameMultinameName(MultinameUsage other) {
        Multiname thisM = this.abc.constants.getMultiname(this.multinameIndex);
        Multiname otherM = other.abc.constants.getMultiname(other.multinameIndex);
        if (thisM == null && otherM == null) {
            return false;
        }
        if (thisM == null || otherM == null) {
            return false;
        }
        if ((thisM.kind == 7 || thisM.kind == 13) && otherM.kind == thisM.kind) {
            String thisName = thisM.getName(this.abc.constants, new ArrayList<DottedChain>(), true, true);
            String otherName = otherM.getName(other.abc.constants, new ArrayList<DottedChain>(), true, true);
            Namespace thisNs = thisM.getNamespace(this.abc.constants);
            Namespace otherNs = otherM.getNamespace(other.abc.constants);
            if (!Objects.equals(thisName, otherName)) {
                return false;
            }
            if (thisNs.kind == 8 && otherNs.kind == 8) {
                return Objects.equals(thisNs.getName(this.abc.constants), otherNs.getName(other.abc.constants));
            }
            if (thisNs.kind == 8 || otherNs.kind == 8) {
                return false;
            }
            if (!(thisNs.kind != 22 && thisNs.kind != 23 || otherNs.kind != 22 && otherNs.kind != 23)) {
                return Objects.equals(thisNs.getName(this.abc.constants), otherNs.getName(other.abc.constants));
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.abc);
        hash = 97 * hash + this.multinameIndex;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultinameUsage other = (MultinameUsage)obj;
        if (this.multinameIndex != other.multinameIndex) {
            return false;
        }
        return Objects.equals(this.abc, other.abc);
    }

    public abstract boolean collides(MultinameUsage var1);
}

