/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.helpers.Helper;

public class ValueKind {
    public static final int CONSTANT_DecimalOrFloat = 2;
    public static final int CONSTANT_Int = 3;
    public static final int CONSTANT_UInt = 4;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_True = 11;
    public static final int CONSTANT_False = 10;
    public static final int CONSTANT_Null = 12;
    public static final int CONSTANT_Undefined = 0;
    public static final int CONSTANT_Namespace = 8;
    public static final int CONSTANT_PackageNamespace = 22;
    public static final int CONSTANT_PackageInternalNs = 23;
    public static final int CONSTANT_ProtectedNamespace = 24;
    public static final int CONSTANT_ExplicitNamespace = 25;
    public static final int CONSTANT_StaticProtectedNs = 26;
    public static final int CONSTANT_PrivateNs = 5;
    public static final int CONSTANT_Float4 = 30;
    private static final int[] optionalKinds = new int[]{3, 4, 6, 2, 1, 11, 10, 12, 0, 8, 22, 23, 24, 25, 26, 5};
    private static final String[] optionalKindNames = new String[]{"Int", "UInt", "Double", "Decimal", "Utf8", "True", "False", "Null", "Undefined", "Namespace", "PackageNamespace", "PackageInternalNs", "ProtectedNamespace", "ExplicitNamespace", "StaticProtectedNs", "PrivateNamespace"};
    public int value_index;
    public int value_kind;

    public ValueKind() {
    }

    public ValueKind(int value_index, int value_kind) {
        this.value_index = value_index;
        this.value_kind = value_kind;
    }

    public static int nsKindToValueKind(int nsKind) {
        switch (nsKind) {
            case 25: {
                return 25;
            }
            case 8: {
                return 8;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 5: {
                return 5;
            }
            case 24: {
                return 24;
            }
            case 26: {
                return 26;
            }
        }
        return 0;
    }

    public String toString() {
        String s = "";
        s = s + this.value_index + ":";
        boolean found = false;
        for (int i = 0; i < optionalKinds.length; ++i) {
            if (optionalKinds[i] != this.value_kind) continue;
            s = s + optionalKindNames[i];
            found = true;
            break;
        }
        if (!found) {
            s = s + "?";
        }
        return s;
    }

    public boolean isNamespace() {
        switch (this.value_kind) {
            case 5: 
            case 8: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public String toString(AVM2ConstantPool constants) {
        String ret = "?";
        switch (this.value_kind) {
            case 3: {
                ret = "" + constants.getInt(this.value_index);
                break;
            }
            case 4: {
                ret = "" + constants.getUInt(this.value_index);
                break;
            }
            case 6: {
                ret = "" + constants.getDouble(this.value_index);
                break;
            }
            case 2: {
                ret = "" + constants.getDecimal(this.value_index);
                break;
            }
            case 1: {
                ret = "\"" + Helper.escapeActionScriptString(constants.getString(this.value_index)) + "\"";
                break;
            }
            case 11: {
                ret = "true";
                break;
            }
            case 10: {
                ret = "false";
                break;
            }
            case 12: {
                ret = "null";
                break;
            }
            case 0: {
                ret = "undefined";
                break;
            }
            case 5: 
            case 8: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                ret = "\"" + constants.getNamespace(this.value_index).getName(constants).toRawString() + "\"";
            }
        }
        return ret;
    }

    public String toASMString(AVM2ConstantPool constants) {
        String ret = "?";
        switch (this.value_kind) {
            case 3: {
                ret = "Integer(" + constants.getInt(this.value_index) + ")";
                break;
            }
            case 4: {
                ret = "UInteger(" + constants.getUInt(this.value_index) + ")";
                break;
            }
            case 6: {
                ret = "Double(" + constants.getDouble(this.value_index) + ")";
                break;
            }
            case 2: {
                ret = "Decimal(" + constants.getDecimal(this.value_index) + ")";
                break;
            }
            case 1: {
                ret = "Utf8(\"" + Helper.escapeActionScriptString(constants.getString(this.value_index)) + "\")";
                break;
            }
            case 11: {
                ret = "True";
                break;
            }
            case 10: {
                ret = "False";
                break;
            }
            case 12: {
                ret = "Null";
                break;
            }
            case 0: {
                ret = "Undefined";
                break;
            }
            case 5: 
            case 8: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                ret = constants.getNamespace(this.value_index).getKindStr() + "(\"" + constants.getNamespace(this.value_index).getName(constants).toRawString() + "\")";
            }
        }
        return ret;
    }
}

