/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Multiname {
    public static final int QNAME = 7;
    public static final int QNAMEA = 13;
    public static final int RTQNAME = 15;
    public static final int RTQNAMEA = 16;
    public static final int RTQNAMEL = 17;
    public static final int RTQNAMELA = 18;
    public static final int MULTINAME = 9;
    public static final int MULTINAMEA = 14;
    public static final int MULTINAMEL = 27;
    public static final int MULTINAMELA = 28;
    public static final int TYPENAME = 29;
    private static final int[] multinameKinds = new int[]{7, 13, 9, 14, 15, 16, 27, 17, 18, 28, 29};
    private static final String[] multinameKindNames = new String[]{"Qname", "QnameA", "Multiname", "MultinameA", "RTQname", "RTQnameA", "MultinameL", "RTQnameL", "RTQnameLA", "MultinameLA", "TypeName"};
    public int kind;
    public int name_index;
    public int namespace_index;
    public final int namespace_set_index;
    public final int qname_index;
    public final int[] params;
    @Internal
    public boolean deleted;
    @Internal
    private boolean displayNamespace = false;

    public String getNamespaceSuffix() {
        if (this.displayNamespace) {
            return "#" + this.namespace_index;
        }
        return "";
    }

    public void setDisplayNamespace(boolean displayNamespace) {
        this.displayNamespace = displayNamespace;
    }

    private boolean validType() {
        boolean cnt = false;
        for (int i = 0; i < multinameKinds.length; ++i) {
            if (multinameKinds[i] != this.kind) continue;
            cnt = true;
        }
        return cnt;
    }

    public Multiname() {
        this.kind = -1;
        this.namespace_index = 0;
        this.namespace_set_index = 0;
        this.qname_index = 0;
        this.params = null;
    }

    private Multiname(int kind, int name_index, int namespace_index, int namespace_set_index, int qname_index, int[] params) {
        this.kind = kind;
        this.name_index = name_index;
        this.namespace_index = namespace_index;
        this.namespace_set_index = namespace_set_index;
        this.qname_index = qname_index;
        this.params = params;
        if (!this.validType()) {
            throw new RuntimeException("Invalid multiname kind:" + kind);
        }
    }

    public boolean hasOwnName() {
        return this.kind == 7 || this.kind == 13 || this.kind == 15 || this.kind == 16 || this.kind == 9 || this.kind == 14;
    }

    public boolean hasOwnNamespace() {
        return this.kind == 7 || this.kind == 13;
    }

    public boolean hasOwnNamespaceSet() {
        return this.kind == 9 || this.kind == 14 || this.kind == 27 || this.kind == 28;
    }

    public static Multiname createQName(boolean attribute, int name_index, int namespace_index) {
        return new Multiname(attribute ? 13 : 7, name_index, namespace_index, 0, 0, null);
    }

    public static Multiname createRTQName(boolean attribute, int name_index) {
        return new Multiname(attribute ? 16 : 15, name_index, 0, 0, 0, null);
    }

    public static Multiname createRTQNameL(boolean attribute) {
        return new Multiname(attribute ? 18 : 17, 0, 0, 0, 0, null);
    }

    public static Multiname createMultiname(boolean attribute, int name_index, int namespace_set_index) {
        return new Multiname(attribute ? 14 : 9, name_index, 0, namespace_set_index, 0, null);
    }

    public static Multiname createMultinameL(boolean attribute, int namespace_set_index) {
        return new Multiname(attribute ? 28 : 27, 0, 0, namespace_set_index, 0, null);
    }

    public static Multiname createTypeName(int qname_index, int[] params) {
        return new Multiname(29, 0, 0, 0, qname_index, params);
    }

    public boolean isAttribute() {
        if (this.kind == 13) {
            return true;
        }
        if (this.kind == 14) {
            return true;
        }
        if (this.kind == 16) {
            return true;
        }
        if (this.kind == 18) {
            return true;
        }
        return this.kind == 28;
    }

    public boolean isRuntime() {
        if (this.kind == 15) {
            return true;
        }
        if (this.kind == 16) {
            return true;
        }
        if (this.kind == 27) {
            return true;
        }
        return this.kind == 28;
    }

    public boolean needsName() {
        if (this.kind == 17) {
            return true;
        }
        if (this.kind == 18) {
            return true;
        }
        if (this.kind == 27) {
            return true;
        }
        return this.kind == 28;
    }

    public boolean needsNs() {
        if (this.kind == 15) {
            return true;
        }
        if (this.kind == 16) {
            return true;
        }
        if (this.kind == 17) {
            return true;
        }
        return this.kind == 18;
    }

    public String getKindStr() {
        String kindStr = "?";
        for (int k = 0; k < multinameKinds.length; ++k) {
            if (multinameKinds[k] != this.kind) continue;
            kindStr = multinameKindNames[k];
            break;
        }
        return kindStr;
    }

    public String toString() {
        String kindStr = this.getKindStr();
        StringBuilder sb = new StringBuilder();
        sb.append("kind=").append(kindStr);
        sb.append(" name_index=").append(this.name_index);
        sb.append(" namespace_index=").append(this.namespace_index);
        sb.append(" namespace_set_index=").append(this.namespace_set_index);
        sb.append(" qname_index=").append(this.qname_index);
        sb.append(" params_size:");
        sb.append(this.params == null ? "null" : Integer.valueOf(this.params.length));
        return sb.toString();
    }

    public static String namespaceToString(AVM2ConstantPool constants, int index) {
        if (index == 0) {
            return "null";
        }
        int type = constants.getNamespace((int)index).kind;
        int name_index = constants.getNamespace((int)index).name_index;
        String name = name_index == 0 ? null : constants.getNamespace(index).getName(constants).toRawString();
        int sub = -1;
        for (int n = 1; n < constants.getNamespaceCount(); ++n) {
            if (constants.getNamespace((int)n).kind == type && constants.getNamespace((int)n).name_index == name_index) {
                ++sub;
            }
            if (n == index) break;
        }
        return constants.getNamespace(index).getKindStr() + "(" + (name == null ? "null" : "\"" + Helper.escapeActionScriptString(name) + "\"") + (sub > 0 ? ",\"" + sub + "\"" : "") + ")";
    }

    private static String namespaceSetToString(AVM2ConstantPool constants, int index) {
        if (index == 0) {
            return "null";
        }
        StringBuilder ret = new StringBuilder();
        ret.append("[");
        for (int n = 0; n < constants.getNamespaceSet((int)index).namespaces.length; ++n) {
            if (n > 0) {
                ret.append(",");
            }
            int ns = constants.getNamespaceSet((int)index).namespaces[n];
            ret.append(Multiname.namespaceToString(constants, ns));
        }
        ret.append("]");
        return ret.toString();
    }

    private static String multinameToString(AVM2ConstantPool constants, int index, List<DottedChain> fullyQualifiedNames) {
        if (index == 0) {
            return "null";
        }
        return constants.getMultiname(index).toString(constants, fullyQualifiedNames);
    }

    public String toString(AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames) {
        switch (this.kind) {
            case 7: 
            case 13: {
                return this.getKindStr() + "(" + Multiname.namespaceToString(constants, this.namespace_index) + "," + (this.name_index == 0 ? "null" : "\"" + Helper.escapeActionScriptString(constants.getString(this.name_index)) + "\"") + ")";
            }
            case 15: 
            case 16: {
                return this.getKindStr() + "(" + (this.name_index == 0 ? "null" : "\"" + Helper.escapeActionScriptString(constants.getString(this.name_index))) + "\")";
            }
            case 17: 
            case 18: {
                return this.getKindStr() + "()";
            }
            case 9: 
            case 14: {
                return this.getKindStr() + "(" + (this.name_index == 0 ? "null" : "\"" + Helper.escapeActionScriptString(constants.getString(this.name_index)) + "\"") + "," + Multiname.namespaceSetToString(constants, this.namespace_set_index) + ")";
            }
            case 27: 
            case 28: {
                return this.getKindStr() + "(" + Multiname.namespaceSetToString(constants, this.namespace_set_index) + ")";
            }
            case 29: {
                String tret = this.getKindStr() + "(";
                tret = tret + Multiname.multinameToString(constants, this.qname_index, fullyQualifiedNames);
                tret = tret + "<";
                if (this.params != null) {
                    for (int i = 0; i < this.params.length; ++i) {
                        if (i > 0) {
                            tret = tret + ",";
                        }
                        tret = tret + Multiname.multinameToString(constants, this.params[i], fullyQualifiedNames);
                    }
                }
                tret = tret + ">";
                tret = tret + ")";
                return tret;
            }
        }
        return null;
    }

    private String typeNameToStr(AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames, boolean dontDeobfuscate, boolean withSuffix) {
        if (constants.getMultiname((int)this.qname_index).name_index == this.name_index) {
            return "ambiguousTypeName";
        }
        StringBuilder typeNameStr = new StringBuilder();
        typeNameStr.append(constants.getMultiname(this.qname_index).getName(constants, fullyQualifiedNames, dontDeobfuscate, withSuffix));
        if (this.params != null && this.params.length > 0) {
            typeNameStr.append(".<");
            for (int i = 0; i < this.params.length; ++i) {
                int param;
                if (i > 0) {
                    typeNameStr.append(",");
                }
                if ((param = this.params[i]) == 0) {
                    typeNameStr.append("*");
                    continue;
                }
                typeNameStr.append(constants.getMultiname(param).getName(constants, fullyQualifiedNames, dontDeobfuscate, withSuffix));
            }
            typeNameStr.append(">");
        }
        return typeNameStr.toString();
    }

    public String getName(AVM2ConstantPool constants, List<DottedChain> fullyQualifiedNames, boolean dontDeobfuscate, boolean withSuffix) {
        if (this.kind == 29) {
            return this.typeNameToStr(constants, fullyQualifiedNames, dontDeobfuscate, withSuffix);
        }
        if (this.name_index == -1) {
            return "";
        }
        if (this.name_index == 0) {
            return this.isAttribute() ? "@*" : "*";
        }
        String name = constants.getString(this.name_index);
        if (fullyQualifiedNames != null && fullyQualifiedNames.contains(DottedChain.parseWithSuffix(name))) {
            DottedChain dc = this.getNameWithNamespace(constants, withSuffix);
            return dontDeobfuscate ? dc.toRawString() : dc.toPrintableString(true);
        }
        return (this.isAttribute() ? "@" : "") + (dontDeobfuscate ? name : IdentifiersDeobfuscation.printIdentifier(true, name, new String[0])) + (withSuffix ? this.getNamespaceSuffix() : "");
    }

    public DottedChain getNameWithNamespace(AVM2ConstantPool constants, boolean withSuffix) {
        NamespaceSet nss;
        Namespace ns = this.getNamespace(constants);
        if (ns == null && (nss = this.getNamespaceSet(constants)) != null && nss.namespaces.length == 1) {
            ns = constants.getNamespace(nss.namespaces[0]);
        }
        String name = this.getName(constants, null, false, false);
        if (ns != null) {
            return ns.getName(constants).add(name, withSuffix ? this.getNamespaceSuffix() : "");
        }
        return new DottedChain(new String[]{name}, withSuffix ? this.getNamespaceSuffix() : "");
    }

    public Namespace getNamespace(AVM2ConstantPool constants) {
        if (this.namespace_index == 0 || this.namespace_index == -1) {
            return null;
        }
        return constants.getNamespace(this.namespace_index);
    }

    public NamespaceSet getNamespaceSet(AVM2ConstantPool constants) {
        if (this.namespace_set_index == 0) {
            return null;
        }
        if (this.namespace_set_index == -1) {
            return null;
        }
        return constants.getNamespaceSet(this.namespace_set_index);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + this.kind;
        hash = 53 * hash + this.name_index;
        hash = 53 * hash + this.namespace_index;
        hash = 53 * hash + this.namespace_set_index;
        hash = 53 * hash + this.qname_index;
        hash = 53 * hash + Objects.hashCode(this.params);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Multiname other = (Multiname)obj;
        if (this.kind != other.kind) {
            return false;
        }
        if (this.name_index != other.name_index) {
            return false;
        }
        if (this.namespace_index != other.namespace_index) {
            return false;
        }
        if (this.namespace_set_index != other.namespace_set_index) {
            return false;
        }
        if (this.qname_index != other.qname_index) {
            return false;
        }
        return Arrays.equals(this.params, other.params);
    }

    public boolean isMULTINAMEwithOneNs(AVM2ConstantPool pool) {
        return this.kind == 9 && pool.getNamespaceSet((int)this.namespace_set_index).namespaces.length == 1;
    }

    public int getSingleNamespaceIndex(AVM2ConstantPool pool) {
        if (this.isMULTINAMEwithOneNs(pool)) {
            return pool.getNamespaceSet((int)this.namespace_set_index).namespaces[0];
        }
        return this.namespace_index;
    }

    public Namespace getSingleNamespace(AVM2ConstantPool pool) {
        int index = this.getSingleNamespaceIndex(pool);
        if (index < 0) {
            return null;
        }
        return pool.getNamespace(index);
    }

    private boolean isEfectivelyQname(AVM2ConstantPool thisCpool) {
        return this.kind == 7 || this.kind == 13 || this.isMULTINAMEwithOneNs(thisCpool);
    }

    public boolean qnameEquals(AVM2ConstantPool thisCpool, Multiname other, AVM2ConstantPool otherCpool) {
        if (!this.isEfectivelyQname(thisCpool) || !other.isEfectivelyQname(otherCpool)) {
            return false;
        }
        Namespace otherNs = other.getSingleNamespace(otherCpool);
        Namespace thisNs = this.getSingleNamespace(thisCpool);
        if (otherNs.kind != thisNs.kind) {
            return false;
        }
        if (otherNs.kind == 5) {
            return false;
        }
        if (!Objects.equals(otherNs.getName(otherCpool).toRawString(), thisNs.getName(thisCpool).toRawString())) {
            return false;
        }
        return Objects.equals(other.getName(otherCpool, new ArrayList<DottedChain>(), true, true), this.getName(thisCpool, new ArrayList<DottedChain>(), true, true));
    }
}

