/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.methodinfo_parser;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.methodinfo_parser.MethodInfoLexer;
import com.jpexs.decompiler.flash.abc.methodinfo_parser.MethodInfoParseException;
import com.jpexs.decompiler.flash.abc.methodinfo_parser.ParsedSymbol;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.configuration.Configuration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class MethodInfoParser {
    public static boolean parseSlotConst(String text, TraitSlotConst trait, ABC abc) throws MethodInfoParseException {
        MethodInfoLexer lexer = new MethodInfoLexer(new InputStreamReader(new ByteArrayInputStream(text.getBytes())));
        int type_index = -1;
        ValueKind value = new ValueKind(0, 0);
        try {
            ParsedSymbol symbType = lexer.yylex();
            if (symbType.type == 21) {
                type_index = 0;
            } else if (symbType.type == 18) {
                type_index = (int)((Long)symbType.value).longValue();
            } else {
                throw new MethodInfoParseException("Multiname or * expected", lexer.yyline());
            }
            ParsedSymbol symbEqual = lexer.yylex();
            if (symbEqual.type == 22) {
                ParsedSymbol symbValue;
                String nstype = "";
                do {
                    symbValue = lexer.yylex();
                    if (symbValue.type < 8 || symbValue.type > 13) continue;
                    nstype = nstype + symbValue.type + ":";
                } while (symbValue.type >= 8 && symbValue.type <= 13);
                if (!nstype.isEmpty() && symbValue.type != 14) {
                    throw new MethodInfoParseException("Namespace expected", lexer.yyline());
                }
                boolean id = false;
                switch (symbValue.type) {
                    case 1: {
                        value = new ValueKind(abc.constants.getIntId((Long)symbValue.value, true), 3);
                        break;
                    }
                    case 2: {
                        value = new ValueKind(abc.constants.getDoubleId((Double)symbValue.value, true), 6);
                        break;
                    }
                    case 7: {
                        value = new ValueKind(abc.constants.getStringId((String)symbValue.value, true), 1);
                        break;
                    }
                    case 3: {
                        value = new ValueKind(0, 11);
                        break;
                    }
                    case 4: {
                        value = new ValueKind(0, 10);
                        break;
                    }
                    case 5: {
                        value = new ValueKind(0, 12);
                        break;
                    }
                    case 6: {
                        value = new ValueKind(0, 0);
                        break;
                    }
                    case 14: {
                        if (nstype.equals("9:")) {
                            value = new ValueKind((int)((Long)symbValue.value).longValue(), 22);
                            break;
                        }
                        if (nstype.equals("9:10:")) {
                            value = new ValueKind((int)((Long)symbValue.value).longValue(), 23);
                            break;
                        }
                        if (nstype.equals("13:")) {
                            value = new ValueKind((int)((Long)symbValue.value).longValue(), 24);
                            break;
                        }
                        if (nstype.equals("12:")) {
                            value = new ValueKind((int)((Long)symbValue.value).longValue(), 25);
                            break;
                        }
                        if (nstype.equals("11:13:")) {
                            value = new ValueKind((int)((Long)symbValue.value).longValue(), 26);
                            break;
                        }
                        if (nstype.equals("8:")) {
                            value = new ValueKind((int)((Long)symbValue.value).longValue(), 5);
                            break;
                        }
                        if (nstype.isEmpty()) {
                            value = new ValueKind((int)((Long)symbValue.value).longValue(), 8);
                            break;
                        }
                        throw new MethodInfoParseException("Invalid type of namespace", lexer.yyline());
                    }
                    default: {
                        throw new MethodInfoParseException("Unexpected symbol", lexer.yyline());
                    }
                }
                ParsedSymbol symb = lexer.yylex();
                if (symb.type != 20) {
                    throw new MethodInfoParseException("Unexpected symbol", lexer.yyline());
                }
            } else if (symbEqual.type != 20) {
                throw new MethodInfoParseException("Unexpected symbol", lexer.yyline());
            }
        }
        catch (IOException ex) {
            return false;
        }
        trait.type_index = type_index;
        trait.value_kind = value.value_kind;
        trait.value_index = value.value_index;
        return true;
    }

    public static boolean parseReturnType(String text, MethodInfo update) throws MethodInfoParseException {
        MethodInfoLexer lexer = new MethodInfoLexer(new InputStreamReader(new ByteArrayInputStream(text.getBytes())));
        int type = -1;
        try {
            ParsedSymbol symb = lexer.yylex();
            if (symb.type == 21) {
                type = 0;
            } else if (symb.type == 18) {
                type = (int)((Long)symb.value).longValue();
            } else {
                throw new MethodInfoParseException("Multiname or * expected", lexer.yyline());
            }
            symb = lexer.yylex();
            if (symb.type != 20) {
                throw new MethodInfoParseException("Only one return type allowed", lexer.yyline());
            }
            update.ret_type = type;
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static boolean parseParams(String text, MethodInfo update, ABC abc) throws MethodInfoParseException {
        int p;
        MethodInfoLexer lexer = new MethodInfoLexer(new InputStreamReader(new ByteArrayInputStream(text.getBytes())));
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<Long> paramTypes = new ArrayList<Long>();
        ArrayList<ValueKind> optionalValues = new ArrayList<ValueKind>();
        boolean hasOptional = false;
        boolean needsRest = false;
        try {
            ParsedSymbol symb = lexer.yylex();
            while (symb.type != 20) {
                block43: {
                    block41: {
                        ParsedSymbol symbEqual;
                        block42: {
                            ParsedSymbol symbValue;
                            if (symb.type == 17) {
                                needsRest = true;
                                symb = lexer.yylex();
                                if (symb.type != 19) {
                                    throw new MethodInfoParseException("Identifier expected", lexer.yyline());
                                }
                                symb = lexer.yylex();
                                if (symb.type != 20) {
                                    throw new MethodInfoParseException("End expected after rest params", lexer.yyline());
                                }
                                break;
                            }
                            if (symb.type != 19) {
                                throw new MethodInfoParseException("Identifier expected", lexer.yyline());
                            }
                            paramNames.add((String)symb.value);
                            symb = lexer.yylex();
                            if (symb.type != 15) break block41;
                            ParsedSymbol symbType = lexer.yylex();
                            if (symbType.type == 21) {
                                paramTypes.add(new Long(0L));
                            } else {
                                if (symbType.type != 18) throw new MethodInfoParseException("Multiname or * expected", lexer.yyline());
                                paramTypes.add((Long)symbType.value);
                            }
                            symbEqual = lexer.yylex();
                            if (symbEqual.type != 22) break block42;
                            hasOptional = true;
                            String nstype = "";
                            do {
                                symbValue = lexer.yylex();
                                if (symbValue.type < 8 || symbValue.type > 13) continue;
                                nstype = nstype + symbValue.type + ":";
                            } while (symbValue.type >= 8 && symbValue.type <= 13);
                            if (!nstype.isEmpty() && symbValue.type != 14) {
                                throw new MethodInfoParseException("Namespace expected", lexer.yyline());
                            }
                            boolean id = false;
                            switch (symbValue.type) {
                                case 1: {
                                    optionalValues.add(new ValueKind(abc.constants.getIntId((Long)symbValue.value, true), 3));
                                    break;
                                }
                                case 2: {
                                    optionalValues.add(new ValueKind(abc.constants.getDoubleId((Double)symbValue.value, true), 6));
                                    break;
                                }
                                case 7: {
                                    optionalValues.add(new ValueKind(abc.constants.getStringId((String)symbValue.value, true), 1));
                                    break;
                                }
                                case 3: {
                                    optionalValues.add(new ValueKind(0, 11));
                                    break;
                                }
                                case 4: {
                                    optionalValues.add(new ValueKind(0, 10));
                                    break;
                                }
                                case 5: {
                                    optionalValues.add(new ValueKind(0, 12));
                                    break;
                                }
                                case 6: {
                                    optionalValues.add(new ValueKind(0, 0));
                                    break;
                                }
                                case 14: {
                                    if (nstype.equals("9:")) {
                                        optionalValues.add(new ValueKind((int)((Long)symbValue.value).longValue(), 22));
                                        break;
                                    }
                                    if (nstype.equals("9:10:")) {
                                        optionalValues.add(new ValueKind((int)((Long)symbValue.value).longValue(), 23));
                                        break;
                                    }
                                    if (nstype.equals("13:")) {
                                        optionalValues.add(new ValueKind((int)((Long)symbValue.value).longValue(), 24));
                                        break;
                                    }
                                    if (nstype.equals("12:")) {
                                        optionalValues.add(new ValueKind((int)((Long)symbValue.value).longValue(), 25));
                                        break;
                                    }
                                    if (nstype.equals("11:13:")) {
                                        optionalValues.add(new ValueKind((int)((Long)symbValue.value).longValue(), 26));
                                        break;
                                    }
                                    if (nstype.equals("8:")) {
                                        optionalValues.add(new ValueKind((int)((Long)symbValue.value).longValue(), 5));
                                        break;
                                    }
                                    if (!nstype.isEmpty()) throw new MethodInfoParseException("Invalid type of namespace", lexer.yyline());
                                    optionalValues.add(new ValueKind((int)((Long)symbValue.value).longValue(), 8));
                                    break;
                                }
                                default: {
                                    throw new MethodInfoParseException("Unexpected symbol", lexer.yyline());
                                }
                            }
                            symb = lexer.yylex();
                            if (symb.type != 16 && symb.type == 20) {
                                break;
                            }
                            break block43;
                        }
                        if (symbEqual.type == 16) {
                            if (hasOptional) {
                                throw new MethodInfoParseException("Parameter must have default value", lexer.yyline());
                            }
                            break block43;
                        } else {
                            if (symbEqual.type != 20) throw new MethodInfoParseException("Unexpected symbol", lexer.yyline());
                            if (hasOptional) {
                                throw new MethodInfoParseException("Parameter must have default value", lexer.yyline());
                            }
                            break;
                        }
                    }
                    if (symb.type != 16) {
                        if (symb.type != 20) throw new MethodInfoParseException("Unexpected symbol", lexer.yyline());
                        break;
                    }
                }
                symb = lexer.yylex();
            }
        }
        catch (IOException iex) {
            return false;
        }
        if (needsRest && !optionalValues.isEmpty()) {
            throw new MethodInfoParseException("Rest parameter canot be combined with default values", lexer.yyline());
        }
        update.param_types = new int[paramTypes.size()];
        for (int p2 = 0; p2 < paramTypes.size(); ++p2) {
            update.param_types[p2] = (int)((Long)paramTypes.get(p2)).longValue();
        }
        update.optional = optionalValues.toArray(new ValueKind[optionalValues.size()]);
        update.unsetFlagHas_optional();
        if (!optionalValues.isEmpty()) {
            update.setFlagHas_optional();
        }
        update.unsetFlagNeed_rest();
        if (needsRest) {
            update.setFlagNeed_rest();
        }
        update.unsetFlagHas_paramnames();
        update.paramNames = new int[0];
        boolean useParamNames = false;
        for (p = 0; p < paramNames.size(); ++p) {
            if (((String)paramNames.get(p)).equals("param" + (p + 1))) continue;
            useParamNames = true;
        }
        if (!Configuration.paramNamesEnable.get().booleanValue()) {
            useParamNames = false;
        }
        if (!useParamNames) return true;
        update.setFlagHas_paramnames();
        update.paramNames = new int[paramNames.size()];
        p = 0;
        while (p < paramNames.size()) {
            update.paramNames[p] = abc.constants.getStringId((String)paramNames.get(p), true);
            ++p;
        }
        return true;
    }
}

