/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.parser.script;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.model.ApplyTypeAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.PropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TypeItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class AbcIndexing {
    private AbcIndexing parent = null;
    private final List<ABC> abcs = new ArrayList<ABC>();
    private ABC selectedAbc = null;
    private final Map<GraphTargetItem, ClassIndex> classes = new HashMap<GraphTargetItem, ClassIndex>();
    private final Map<PropertyDef, TraitIndex> instanceProperties = new HashMap<PropertyDef, TraitIndex>();
    private final Map<PropertyDef, TraitIndex> classProperties = new HashMap<PropertyDef, TraitIndex>();
    private final Map<PropertyNsDef, TraitIndex> instanceNsProperties = new HashMap<PropertyNsDef, TraitIndex>();
    private final Map<PropertyNsDef, TraitIndex> classNsProperties = new HashMap<PropertyNsDef, TraitIndex>();
    private final Map<PropertyNsDef, TraitIndex> scriptProperties = new HashMap<PropertyNsDef, TraitIndex>();

    public AbcIndexing(AbcIndexing parent) {
        this(null, parent);
    }

    public AbcIndexing(SWF swf, AbcIndexing parent) {
        this.parent = parent;
        if (swf != null) {
            for (ABCContainerTag at : swf.getAbcList()) {
                this.addAbc(at.getABC());
            }
        }
    }

    public AbcIndexing(SWF swf) {
        this(swf, null);
    }

    public AbcIndexing() {
        this(null, null);
    }

    public ClassIndex findClass(GraphTargetItem cls) {
        if (!this.classes.containsKey(cls)) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.findClass(cls);
        }
        return this.classes.get(cls);
    }

    public TraitIndex findScriptProperty(DottedChain ns) {
        return this.findScriptProperty(ns.getLast(), ns.getWithoutLast());
    }

    public TraitIndex findScriptProperty(String propName, DottedChain ns) {
        PropertyNsDef nsd = new PropertyNsDef(propName, ns, null, 0);
        if (!this.scriptProperties.containsKey(nsd)) {
            if (this.parent != null) {
                return this.parent.findScriptProperty(propName, ns);
            }
            return null;
        }
        return this.scriptProperties.get(nsd);
    }

    public TraitIndex findNsProperty(PropertyNsDef prop, boolean findStatic, boolean findInstance) {
        TraitIndex ret;
        if (findStatic && this.classNsProperties.containsKey(prop)) {
            if (!this.classNsProperties.containsKey(prop)) {
                if (this.parent != null && (ret = this.parent.findNsProperty(prop, findStatic, findInstance)) != null) {
                    return ret;
                }
            } else {
                return this.classNsProperties.get(prop);
            }
        }
        if (findInstance && this.instanceNsProperties.containsKey(prop)) {
            if (!this.instanceNsProperties.containsKey(prop)) {
                if (this.parent != null && (ret = this.parent.findNsProperty(prop, findStatic, findInstance)) != null) {
                    return ret;
                }
            } else {
                return this.instanceNsProperties.get(prop);
            }
        }
        return null;
    }

    public TraitIndex findProperty(PropertyDef prop, boolean findStatic, boolean findInstance) {
        ClassIndex ci;
        TraitIndex ret;
        if (findStatic && this.classProperties.containsKey(prop)) {
            if (!this.classProperties.containsKey(prop)) {
                if (this.parent != null && (ret = this.parent.findProperty(prop, findStatic, findInstance)) != null) {
                    return ret;
                }
            } else {
                return this.classProperties.get(prop);
            }
        }
        if (findInstance && this.instanceProperties.containsKey(prop)) {
            if (!this.instanceProperties.containsKey(prop)) {
                if (this.parent != null && (ret = this.parent.findProperty(prop, findStatic, findInstance)) != null) {
                    return ret;
                }
            } else {
                return this.instanceProperties.get(prop);
            }
        }
        if ((ci = this.findClass(prop.parent)) != null && ci.parent != null && (prop.abc == null || prop.propNsIndex == 0)) {
            ci = ci.parent;
            DottedChain parentClass = ci.abc.instance_info.get(ci.index).getName(ci.abc.constants).getNameWithNamespace(ci.abc.constants, true);
            TraitIndex pti = this.findProperty(new PropertyDef(prop.propName, new TypeItem(parentClass), ci.abc, ci.abc.instance_info.get((int)ci.index).protectedNS), findStatic, findInstance);
            if (pti != null) {
                return pti;
            }
            return this.findProperty(new PropertyDef(prop.propName, new TypeItem(parentClass), null, 0), findStatic, findInstance);
        }
        return null;
    }

    public static GraphTargetItem multinameToType(int m_index, AVM2ConstantPool constants) {
        if (m_index == 0) {
            return TypeItem.UNBOUNDED;
        }
        Multiname m = constants.getMultiname(m_index);
        if (m.kind == 29) {
            GraphTargetItem obj = AbcIndexing.multinameToType(m.qname_index, constants);
            ArrayList<GraphTargetItem> params = new ArrayList<GraphTargetItem>();
            for (int pm : m.params) {
                params.add(AbcIndexing.multinameToType(pm, constants));
            }
            return new ApplyTypeAVM2Item(null, null, obj, params);
        }
        return new TypeItem(m.getNameWithNamespace(constants, true));
    }

    private static GraphTargetItem getTraitReturnType(ABC abc, Trait t) {
        if (t instanceof TraitSlotConst) {
            TraitSlotConst tsc = (TraitSlotConst)t;
            if (tsc.type_index == 0) {
                return TypeItem.UNBOUNDED;
            }
            return PropertyAVM2Item.multinameToType(tsc.type_index, abc.constants);
        }
        if (t instanceof TraitMethodGetterSetter) {
            TraitMethodGetterSetter tmgs = (TraitMethodGetterSetter)t;
            if (tmgs.kindType == 2) {
                return PropertyAVM2Item.multinameToType(abc.method_info.get((int)tmgs.method_info).ret_type, abc.constants);
            }
            if (tmgs.kindType == 3) {
                if (abc.method_info.get((int)tmgs.method_info).param_types.length > 0) {
                    return PropertyAVM2Item.multinameToType(abc.method_info.get((int)tmgs.method_info).param_types[0], abc.constants);
                }
                return TypeItem.UNBOUNDED;
            }
        }
        if (t instanceof TraitFunction) {
            return new TypeItem(DottedChain.FUNCTION);
        }
        return TypeItem.UNBOUNDED;
    }

    protected void indexTraits(ABC abc, int name_index, Traits ts, Map<PropertyDef, TraitIndex> map, Map<PropertyNsDef, TraitIndex> mapNs) {
        for (Trait t : ts.traits) {
            ValueKind propValue = null;
            if (t instanceof TraitSlotConst) {
                TraitSlotConst tsc = (TraitSlotConst)t;
                propValue = new ValueKind(tsc.value_index, tsc.value_kind);
            }
            if (map != null) {
                PropertyDef dp = new PropertyDef(t.getName(abc).getName(abc.constants, new ArrayList<DottedChain>(), true, true), AbcIndexing.multinameToType(name_index, abc.constants), abc, abc.constants.getMultiname((int)t.name_index).namespace_index);
                map.put(dp, new TraitIndex(t, abc, AbcIndexing.getTraitReturnType(abc, t), propValue, AbcIndexing.multinameToType(name_index, abc.constants)));
            }
            if (mapNs == null) continue;
            Multiname m = abc.constants.getMultiname(t.name_index);
            PropertyNsDef ndp = new PropertyNsDef(t.getName(abc).getName(abc.constants, new ArrayList<DottedChain>(), true, true), m == null || m.namespace_index == 0 ? DottedChain.EMPTY : m.getNamespace(abc.constants).getName(abc.constants), abc, m == null ? 0 : m.namespace_index);
            TraitIndex ti = new TraitIndex(t, abc, AbcIndexing.getTraitReturnType(abc, t), propValue, AbcIndexing.multinameToType(name_index, abc.constants));
            if (mapNs.containsKey(ndp)) continue;
            mapNs.put(ndp, ti);
        }
    }

    public void refreshSelected() {
        this.refreshAbc(this.getSelectedAbc());
    }

    public void refreshAbc(ABC abc) {
        if (abc == null) {
            return;
        }
        this.removeAbc(abc);
        this.addAbc(abc);
    }

    public void removeAbc(ABC abc) {
        this.abcs.remove(abc);
        HashSet<GraphTargetItem> gti_keys = new HashSet<GraphTargetItem>(this.classes.keySet());
        for (GraphTargetItem graphTargetItem : gti_keys) {
            if (this.classes.get((Object)graphTargetItem).abc != abc) continue;
            this.classes.remove(graphTargetItem);
        }
        HashSet<PropertyDef> pd_keys = new HashSet<PropertyDef>(this.instanceProperties.keySet());
        for (PropertyDef key : pd_keys) {
            if (this.instanceProperties.get((Object)key).abc != abc) continue;
            this.instanceProperties.remove(key);
        }
        pd_keys = new HashSet<PropertyDef>(this.classProperties.keySet());
        for (PropertyDef key : pd_keys) {
            if (this.classProperties.get((Object)key).abc != abc) continue;
            this.classProperties.remove(key);
        }
        HashSet<PropertyNsDef> hashSet = new HashSet<PropertyNsDef>(this.scriptProperties.keySet());
        for (PropertyNsDef key : hashSet) {
            if (this.scriptProperties.get((Object)key).abc != abc) continue;
            this.scriptProperties.remove(key);
        }
        HashSet<PropertyNsDef> hashSet2 = new HashSet<PropertyNsDef>(this.classNsProperties.keySet());
        for (PropertyNsDef key : hashSet2) {
            if (this.classNsProperties.get((Object)key).abc != abc) continue;
            this.classNsProperties.remove(key);
        }
        HashSet<PropertyNsDef> hashSet3 = new HashSet<PropertyNsDef>(this.instanceNsProperties.keySet());
        for (PropertyNsDef key : hashSet3) {
            if (this.instanceNsProperties.get((Object)key).abc != abc) continue;
            this.instanceNsProperties.remove(key);
        }
    }

    public void addAbc(ABC abc) {
        int i;
        if (abc == null) {
            return;
        }
        ArrayList<ClassIndex> addedClasses = new ArrayList<ClassIndex>();
        for (i = 0; i < abc.instance_info.size(); ++i) {
            InstanceInfo ii = abc.instance_info.get(i);
            if (ii.deleted) continue;
            ClassInfo ci = abc.class_info.get(i);
            ClassIndex cindex = new ClassIndex(i, abc, null);
            addedClasses.add(cindex);
            GraphTargetItem cname = AbcIndexing.multinameToType(ii.name_index, abc.constants);
            this.classes.put(cname, cindex);
            this.indexTraits(abc, ii.name_index, ii.instance_traits, this.instanceProperties, this.instanceNsProperties);
            this.indexTraits(abc, ii.name_index, ci.static_traits, this.classProperties, this.classNsProperties);
        }
        for (i = 0; i < abc.script_info.size(); ++i) {
            this.indexTraits(abc, 0, abc.script_info.get((int)i).traits, null, this.scriptProperties);
        }
        for (ClassIndex cindex : addedClasses) {
            int parentClassName = abc.instance_info.get((int)cindex.index).super_index;
            if (parentClassName <= 0) continue;
            TypeItem parentClass = new TypeItem(abc.constants.getMultiname(parentClassName).getNameWithNamespace(abc.constants, true));
            ClassIndex parentClassIndex = this.findClass(parentClass);
            if (parentClassIndex == null) {
                // empty if block
            }
            cindex.parent = parentClassIndex;
        }
        this.abcs.add(abc);
        this.selectedAbc = abc;
    }

    public void selectAbc(ABC abc) {
        if (this.abcs.contains(abc)) {
            this.selectedAbc = abc;
        } else {
            this.addAbc(abc);
        }
    }

    public ABC getSelectedAbc() {
        return this.selectedAbc;
    }

    public DottedChain nsValueToName(String valueStr) {
        for (ABC abc : this.abcs) {
            DottedChain ret = abc.nsValueToName(valueStr);
            if (ret.isEmpty()) continue;
            return ret;
        }
        if (this.parent != null) {
            return this.parent.nsValueToName(valueStr);
        }
        return null;
    }

    public static class ClassIndex {
        public int index;
        public ABC abc;
        public ClassIndex parent;

        public String toString() {
            return this.abc.constants.getMultiname(this.abc.instance_info.get((int)this.index).name_index).getNameWithNamespace(this.abc.constants, true).toPrintableString(true);
        }

        public ClassIndex(int index, ABC abc, ClassIndex parent) {
            this.index = index;
            this.abc = abc;
            this.parent = parent;
        }
    }

    public static class TraitIndex {
        public Trait trait;
        public ABC abc;
        public GraphTargetItem returnType;
        public ValueKind value;
        public GraphTargetItem objType;

        public TraitIndex(Trait trait, ABC abc, GraphTargetItem type, ValueKind value, GraphTargetItem objType) {
            this.trait = trait;
            this.abc = abc;
            this.returnType = type;
            this.value = value;
            this.objType = objType;
        }
    }

    public static class PropertyNsDef {
        private final String propName;
        private final DottedChain ns;
        private int propNsIndex = 0;
        private ABC abc = null;

        private void setPrivate(ABC abc, int propNsIndex) {
            this.propNsIndex = propNsIndex;
            this.abc = abc;
        }

        public String getPropertyName() {
            return this.propName;
        }

        public String toString() {
            return this.ns.toString() + ":" + this.propName + (this.propNsIndex > 0 ? "[ns:" + this.propNsIndex + "]" : "");
        }

        public PropertyNsDef(String propName, DottedChain ns, ABC abc, int nsIndex) {
            this.propName = propName;
            this.ns = ns;
            if (abc == null || nsIndex <= 0) {
                return;
            }
            int k = abc.constants.getNamespace((int)nsIndex).kind;
            if (k != 22) {
                this.setPrivate(abc, nsIndex);
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + Objects.hashCode(this.propName);
            hash = 19 * hash + Objects.hashCode(this.ns);
            hash = 19 * hash + this.propNsIndex;
            hash = 19 * hash + System.identityHashCode(this.abc);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyNsDef other = (PropertyNsDef)obj;
            if (!Objects.equals(this.propName, other.propName)) {
                return false;
            }
            if (!Objects.equals(this.ns, other.ns)) {
                return false;
            }
            if (this.propNsIndex != other.propNsIndex) {
                return false;
            }
            return this.abc == other.abc;
        }
    }

    public static class PropertyDef {
        private final String propName;
        private final GraphTargetItem parent;
        private int propNsIndex = 0;
        private ABC abc = null;

        public String toString() {
            return this.parent.toString() + ":" + this.propName + (this.propNsIndex > 0 ? "[ns:" + this.propNsIndex + "]" : "");
        }

        private void setPrivate(ABC abc, int propNsIndex) {
            this.propNsIndex = propNsIndex;
            this.abc = abc;
        }

        public String getPropertyName() {
            return this.propName;
        }

        public PropertyDef(String propName, GraphTargetItem parent, ABC abc, int propNsIndex) {
            this.propName = propName;
            this.parent = parent;
            if (abc == null || propNsIndex <= 0) {
                return;
            }
            int k = abc.constants.getNamespace((int)propNsIndex).kind;
            if (k != 22) {
                this.setPrivate(abc, propNsIndex);
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + Objects.hashCode(this.propName);
            hash = 17 * hash + Objects.hashCode(this.parent);
            hash = 17 * hash + this.propNsIndex;
            hash = 17 * hash + System.identityHashCode(this.abc);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyDef other = (PropertyDef)obj;
            if (!Objects.equals(this.propName, other.propName)) {
                return false;
            }
            if (!Objects.equals(this.parent, other.parent)) {
                return false;
            }
            if (this.propNsIndex != other.propNsIndex) {
                return false;
            }
            return this.abc == other.abc;
        }
    }
}

