/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.parser.pcode;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.DeobfuscatePopIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.instructions.UnknownInstruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.stack.PushShortIns;
import com.jpexs.decompiler.flash.abc.avm2.parser.AVM2ParseException;
import com.jpexs.decompiler.flash.abc.avm2.parser.pcode.Flasm3Lexer;
import com.jpexs.decompiler.flash.abc.avm2.parser.pcode.MissingSymbolHandler;
import com.jpexs.decompiler.flash.abc.avm2.parser.pcode.ParsedSymbol;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.Float4;
import com.jpexs.decompiler.flash.abc.types.MetadataInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.helpers.Helper;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ASM3Parser {
    public static AVM2Code parse(ABC abc, Reader reader, Trait trait, MethodBody body, MethodInfo info) throws IOException, AVM2ParseException, InterruptedException {
        return ASM3Parser.parse(abc, reader, trait, null, body, info);
    }

    private static int checkMultinameIndex(AVM2ConstantPool constants, int index, int line) throws AVM2ParseException {
        if (index < 0 || index >= constants.getMultinameCount()) {
            throw new AVM2ParseException("Invalid multiname index", line);
        }
        return index;
    }

    private static void expected(int type, String expStr, Flasm3Lexer lexer) throws IOException, AVM2ParseException {
        ParsedSymbol s = lexer.lex();
        if (s.type != type) {
            throw new AVM2ParseException(expStr + " expected", lexer.yyline());
        }
    }

    private static void expected(ParsedSymbol s, int type, String expStr) throws IOException, AVM2ParseException {
        if (s.type != type) {
            throw new AVM2ParseException(expStr + " expected", 0L);
        }
    }

    private static void parseTraitParams(ABC abc, Flasm3Lexer lexer, Trait t) throws IOException, AVM2ParseException {
        ParsedSymbol symb;
        ArrayList metadata = new ArrayList();
        int flags = 0;
        block5: while (true) {
            symb = lexer.lex();
            if (symb.type == 45) {
                symb = lexer.lex();
                switch (symb.type) {
                    case 83: {
                        flags |= 1;
                        continue block5;
                    }
                    case 85: {
                        flags |= 2;
                        continue block5;
                    }
                    case 84: {
                        flags |= 4;
                        continue block5;
                    }
                }
                throw new AVM2ParseException("Invalid trait flag", lexer.yyline());
            }
            if (symb.type != 86) break;
            symb = lexer.lex();
            ASM3Parser.expected(symb, 1, "string metadata");
            String mkey = (String)symb.value;
            symb = lexer.lex();
            HashMap<String, String> items = new HashMap<String, String>();
            while (symb.type == 87) {
                symb = lexer.lex();
                ASM3Parser.expected(symb, 1, "string key");
                String key = (String)symb.value;
                symb = lexer.lex();
                ASM3Parser.expected(symb, 1, "string value");
                String val = (String)symb.value;
                items.put(key, val);
                symb = lexer.lex();
            }
            ASM3Parser.expected(symb, 88, "end");
            symb = lexer.lex();
            if (symb.type != 9) {
                lexer.pushback(symb);
            }
            metadata.add(new AbstractMap.SimpleEntry(mkey, items));
        }
        lexer.pushback(symb);
        t.kindFlags = flags;
        if ((flags & 4) > 0) {
            int[] metadataArray = new int[metadata.size()];
            for (int i = 0; i < metadata.size(); ++i) {
                Map.Entry entry = (Map.Entry)metadata.get(i);
                int mkey = abc.constants.getStringId((String)entry.getKey(), true);
                Map items = (Map)entry.getValue();
                int[] keys = new int[items.size()];
                int[] vals = new int[items.size()];
                int pos = 0;
                for (String key : items.keySet()) {
                    int ikey = abc.constants.getStringId(key, true);
                    int ival = abc.constants.getStringId((String)items.get(key), true);
                    keys[pos] = ikey;
                    vals[pos] = ival;
                    ++pos;
                }
                MetadataInfo mi = new MetadataInfo(mkey, keys, vals);
                metadataArray[i] = abc.getMetadataId(mi, true);
            }
            t.metadata = metadataArray;
        }
    }

    public static boolean parseSlotConst(ABC abc, Reader reader, AVM2ConstantPool constants, TraitSlotConst tsc) throws IOException, AVM2ParseException {
        Flasm3Lexer lexer = new Flasm3Lexer(reader);
        ASM3Parser.expected(72, "trait", lexer);
        ParsedSymbol symb = lexer.lex();
        if (symb.type == 73) {
            tsc.kindType = 0;
        } else if (symb.type == 74) {
            tsc.kindType = 6;
        } else {
            throw new AVM2ParseException("slot or const expected", lexer.yyline());
        }
        int name_index = ASM3Parser.parseMultiName(constants, lexer);
        ASM3Parser.parseTraitParams(abc, lexer, tsc);
        ASM3Parser.expected(81, "slotid", lexer);
        symb = lexer.lex();
        ASM3Parser.expected(symb, 4, "Integer");
        int slotid = (int)((Long)symb.value).longValue();
        ASM3Parser.expected(43, "type", lexer);
        int type = ASM3Parser.parseMultiName(constants, lexer);
        ASM3Parser.expected(82, "value", lexer);
        ValueKind val = ASM3Parser.parseValue(constants, lexer);
        tsc.slot_id = slotid;
        tsc.type_index = type;
        tsc.value_kind = val.value_kind;
        tsc.value_index = val.value_index;
        tsc.name_index = name_index;
        return true;
    }

    private static int parseNamespaceSet(AVM2ConstantPool constants, Flasm3Lexer lexer) throws AVM2ParseException, IOException {
        ArrayList<Integer> namespaceList = new ArrayList<Integer>();
        ParsedSymbol s = lexer.lex();
        if (s.type == 27) {
            return 0;
        }
        ASM3Parser.expected(s, 28, "[");
        s = lexer.lex();
        if (s.type != 29) {
            lexer.pushback(s);
            do {
                namespaceList.add(ASM3Parser.parseNamespace(constants, lexer));
                s = lexer.lex();
            } while (s.type == 26);
            ASM3Parser.expected(s, 29, "]");
        }
        block1: for (int n = 1; n < constants.getNamespaceSetCount(); ++n) {
            int[] nss = constants.getNamespaceSet((int)n).namespaces;
            if (nss.length != namespaceList.size()) continue;
            for (int i = 0; i < nss.length; ++i) {
                if (nss[i] != (Integer)namespaceList.get(i)) continue block1;
            }
            return n;
        }
        int[] nss = new int[namespaceList.size()];
        for (int i = 0; i < nss.length; ++i) {
            nss[i] = (Integer)namespaceList.get(i);
        }
        return constants.addNamespaceSet(new NamespaceSet(nss));
    }

    private static int parseNamespace(AVM2ConstantPool constants, Flasm3Lexer lexer) throws AVM2ParseException, IOException {
        ParsedSymbol type = lexer.lex();
        int kind = 0;
        switch (type.type) {
            case 27: {
                return 0;
            }
            case 32: {
                kind = 8;
                break;
            }
            case 33: {
                kind = 5;
                break;
            }
            case 34: {
                kind = 22;
                break;
            }
            case 35: {
                kind = 23;
                break;
            }
            case 36: {
                kind = 24;
                break;
            }
            case 37: {
                kind = 25;
                break;
            }
            case 38: {
                kind = 26;
                break;
            }
            default: {
                throw new AVM2ParseException("Namespace kind expected", lexer.yyline());
            }
        }
        ASM3Parser.expected(24, "(", lexer);
        ParsedSymbol name = lexer.lex();
        if (name.type != 27 && name.type != 1) {
            throw new AVM2ParseException("String or null expected", lexer.yyline());
        }
        ParsedSymbol c = lexer.lex();
        int index = 0;
        if (c.type == 26) {
            ParsedSymbol extra = lexer.lex();
            ASM3Parser.expected(extra, 1, "String");
            try {
                index = Integer.parseInt((String)extra.value);
            }
            catch (NumberFormatException nfe) {
                throw new AVM2ParseException("Number expected", lexer.yyline());
            }
        } else {
            lexer.pushback(c);
        }
        ASM3Parser.expected(25, ")", lexer);
        return constants.getNamespaceId(kind, name.type == 27 ? null : (String)name.value, index, true);
    }

    private static int parseMultiName(AVM2ConstantPool constants, Flasm3Lexer lexer) throws AVM2ParseException, IOException {
        ParsedSymbol s = lexer.lex();
        int kind = 0;
        switch (s.type) {
            case 27: {
                return 0;
            }
            case 13: {
                kind = 7;
                break;
            }
            case 14: {
                kind = 13;
                break;
            }
            case 15: {
                kind = 15;
                break;
            }
            case 16: {
                kind = 16;
                break;
            }
            case 17: {
                kind = 17;
                break;
            }
            case 18: {
                kind = 18;
                break;
            }
            case 19: {
                kind = 9;
                break;
            }
            case 20: {
                kind = 14;
                break;
            }
            case 21: {
                kind = 27;
                break;
            }
            case 22: {
                kind = 28;
                break;
            }
            case 23: {
                kind = 29;
                break;
            }
            default: {
                throw new AVM2ParseException("Name expected", lexer.yyline());
            }
        }
        Multiname multiname = null;
        switch (kind) {
            case 7: 
            case 13: {
                int name_index;
                ASM3Parser.expected(24, "(", lexer);
                int namespace_index = ASM3Parser.parseNamespace(constants, lexer);
                ASM3Parser.expected(26, ",", lexer);
                ParsedSymbol name = lexer.lex();
                if (name.type == 27) {
                    name_index = 0;
                } else {
                    ASM3Parser.expected(name, 1, "String");
                    name_index = constants.getStringId((String)name.value, true);
                }
                ASM3Parser.expected(25, ")", lexer);
                multiname = Multiname.createQName(kind == 13, name_index, namespace_index);
                break;
            }
            case 15: 
            case 16: {
                int name_index;
                ASM3Parser.expected(24, "(", lexer);
                ParsedSymbol rtqName = lexer.lex();
                if (rtqName.type == 27) {
                    name_index = 0;
                } else {
                    ASM3Parser.expected(rtqName, 1, "String");
                    name_index = constants.getStringId((String)rtqName.value, true);
                }
                ASM3Parser.expected(25, ")", lexer);
                multiname = Multiname.createRTQName(kind == 16, name_index);
                break;
            }
            case 17: 
            case 18: {
                ASM3Parser.expected(24, "(", lexer);
                ASM3Parser.expected(25, ")", lexer);
                multiname = Multiname.createRTQNameL(kind == 18);
                break;
            }
            case 9: 
            case 14: {
                int name_index;
                ASM3Parser.expected(24, "(", lexer);
                ParsedSymbol mName = lexer.lex();
                if (mName.type == 27) {
                    name_index = 0;
                } else {
                    ASM3Parser.expected(mName, 1, "String");
                    name_index = constants.getStringId((String)mName.value, true);
                }
                ASM3Parser.expected(26, ",", lexer);
                int namespace_set_index = ASM3Parser.parseNamespaceSet(constants, lexer);
                ASM3Parser.expected(25, ")", lexer);
                multiname = Multiname.createMultiname(kind == 14, name_index, namespace_set_index);
                break;
            }
            case 27: 
            case 28: {
                ASM3Parser.expected(24, "(", lexer);
                int namespace_set_index = ASM3Parser.parseNamespaceSet(constants, lexer);
                ASM3Parser.expected(25, ")", lexer);
                multiname = Multiname.createMultinameL(kind == 28, namespace_set_index);
                break;
            }
            case 29: {
                ASM3Parser.expected(24, "(", lexer);
                int qname_index = ASM3Parser.parseMultiName(constants, lexer);
                ASM3Parser.expected(30, "<", lexer);
                ArrayList<Integer> paramsList = new ArrayList<Integer>();
                paramsList.add(ASM3Parser.parseMultiName(constants, lexer));
                ParsedSymbol nt = lexer.lex();
                while (nt.type == 26) {
                    paramsList.add(ASM3Parser.parseMultiName(constants, lexer));
                    nt = lexer.lex();
                }
                int[] params = Helper.toIntArray(paramsList);
                ASM3Parser.expected(nt, 31, ">");
                ASM3Parser.expected(25, ")", lexer);
                multiname = Multiname.createTypeName(qname_index, params);
                break;
            }
        }
        return constants.getMultinameId(multiname, true);
    }

    public static ValueKind parseValue(AVM2ConstantPool constants, Flasm3Lexer lexer) throws IOException, AVM2ParseException {
        ParsedSymbol type = lexer.lex();
        int value_index = 0;
        int value_kind = 0;
        switch (type.type) {
            case 64: {
                value_kind = 3;
                ASM3Parser.expected(24, "(", lexer);
                ParsedSymbol value = lexer.lex();
                if (value.type == 27) {
                    value_index = 0;
                } else {
                    ASM3Parser.expected(value, 4, "Integer or null");
                    value_index = constants.getIntId((Long)value.value, true);
                }
                ASM3Parser.expected(25, ")", lexer);
                break;
            }
            case 65: {
                value_kind = 4;
                ASM3Parser.expected(24, "(", lexer);
                ParsedSymbol value = lexer.lex();
                if (value.type == 27) {
                    value_index = 0;
                } else {
                    ASM3Parser.expected(value, 4, "UInteger");
                    value_index = constants.getUIntId((Long)value.value, true);
                }
                ASM3Parser.expected(25, ")", lexer);
                break;
            }
            case 66: {
                value_kind = 6;
                ASM3Parser.expected(24, "(", lexer);
                ParsedSymbol value = lexer.lex();
                if (value.type == 27) {
                    value_index = 0;
                } else {
                    ASM3Parser.expected(value, 5, "Double or null");
                    value_index = constants.getDoubleId((Double)value.value, true);
                }
                ASM3Parser.expected(25, ")", lexer);
                break;
            }
            case 4: {
                value_kind = 3;
                value_index = constants.getIntId((Long)type.value, true);
                break;
            }
            case 5: {
                value_kind = 6;
                value_index = constants.getDoubleId((Double)type.value, true);
                break;
            }
            case 1: {
                value_kind = 1;
                value_index = constants.getStringId((String)type.value, true);
                break;
            }
            case 68: {
                value_kind = 1;
                ASM3Parser.expected(24, "(", lexer);
                ParsedSymbol value = lexer.lex();
                if (value.type == 27) {
                    value_index = 0;
                    break;
                }
                ASM3Parser.expected(value, 1, "String or null");
                ASM3Parser.expected(25, ")", lexer);
                value_index = constants.getStringId((String)value.value, true);
                break;
            }
            case 69: {
                value_kind = 11;
                break;
            }
            case 70: {
                value_kind = 10;
                break;
            }
            case 27: {
                value_kind = 12;
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                switch (type.type) {
                    case 32: {
                        value_kind = 8;
                        break;
                    }
                    case 35: {
                        value_kind = 23;
                        break;
                    }
                    case 36: {
                        value_kind = 24;
                        break;
                    }
                    case 37: {
                        value_kind = 25;
                        break;
                    }
                    case 38: {
                        value_kind = 26;
                        break;
                    }
                    case 33: {
                        value_kind = 5;
                        break;
                    }
                    case 34: {
                        value_kind = 22;
                    }
                }
                lexer.pushback(type);
                value_index = ASM3Parser.parseNamespace(constants, lexer);
                break;
            }
            default: {
                if (!Configuration._debugMode.get().booleanValue()) break;
                throw new AVM2ParseException("Not supported valueType.", lexer.yyline());
            }
        }
        return new ValueKind(value_index, value_kind);
    }

    public static AVM2Code parse(ABC abc, Reader reader, Trait trait, MissingSymbolHandler missingHandler, MethodBody body, MethodInfo info) throws IOException, AVM2ParseException, InterruptedException {
        int i;
        ParsedSymbol symb;
        AVM2ConstantPool constants = abc.constants;
        AVM2Code code = new AVM2Code();
        int openedBlocks = 0;
        boolean autoCloseBlocks = true;
        ArrayList<OffsetItem> offsetItems = new ArrayList<OffsetItem>();
        ArrayList<LabelItem> labelItems = new ArrayList<LabelItem>();
        ArrayList<ABCException> exceptions = new ArrayList<ABCException>();
        ArrayList<Integer> exceptionIndices = new ArrayList<Integer>();
        int offset = 0;
        Flasm3Lexer lexer = new Flasm3Lexer(reader);
        AVM2Instruction lastIns = null;
        ArrayList<String> exceptionsFrom = new ArrayList<String>();
        ArrayList<String> exceptionsTo = new ArrayList<String>();
        ArrayList<String> exceptionsTargets = new ArrayList<String>();
        info.flags = 0;
        info.name_index = 0;
        ArrayList<Integer> paramTypes = new ArrayList<Integer>();
        ArrayList<Integer> paramNames = new ArrayList<Integer>();
        ArrayList<ValueKind> optional = new ArrayList<ValueKind>();
        do {
            symb = lexer.lex();
            if (Arrays.asList(58, 63, 75).contains(symb.type)) {
                ++openedBlocks;
                continue;
            }
            if (symb.type == 72) {
                ++openedBlocks;
                if (trait == null) {
                    throw new AVM2ParseException("No trait expected", lexer.yyline());
                }
                symb = lexer.lex();
                switch (symb.type) {
                    case 75: 
                    case 76: 
                    case 77: {
                        if (!(trait instanceof TraitMethodGetterSetter)) {
                            throw new AVM2ParseException("Unxpected trait type", lexer.yyline());
                        }
                        TraitMethodGetterSetter tm = (TraitMethodGetterSetter)trait;
                        switch (symb.type) {
                            case 75: {
                                tm.kindType = 1;
                                break;
                            }
                            case 76: {
                                tm.kindType = 2;
                                break;
                            }
                            case 77: {
                                tm.kindType = 3;
                            }
                        }
                        tm.name_index = ASM3Parser.parseMultiName(constants, lexer);
                        ASM3Parser.parseTraitParams(abc, lexer, trait);
                        ASM3Parser.expected(80, "dispid", lexer);
                        symb = lexer.lex();
                        ASM3Parser.expected(symb, 4, "Integer");
                        tm.disp_id = (int)((Long)symb.value).longValue();
                        break;
                    }
                    case 79: {
                        if (!(trait instanceof TraitFunction)) {
                            throw new AVM2ParseException("Unxpected trait type", lexer.yyline());
                        }
                        ASM3Parser.parseTraitParams(abc, lexer, trait);
                    }
                }
                continue;
            }
            if (symb.type == 44) {
                symb = lexer.lex();
                if (symb.type == 27) {
                    info.name_index = 0;
                    continue;
                }
                ASM3Parser.expected(symb, 1, "String or null");
                info.name_index = constants.getStringId((String)symb.value, true);
                continue;
            }
            if (symb.type == 54) {
                paramTypes.add(ASM3Parser.parseMultiName(constants, lexer));
                continue;
            }
            if (symb.type == 55) {
                symb = lexer.lex();
                if (symb.type == 27) {
                    paramNames.add(0);
                    continue;
                }
                ASM3Parser.expected(symb, 1, "String or null");
                paramNames.add(constants.getStringId((String)symb.value, true));
                continue;
            }
            if (symb.type == 56) {
                optional.add(ASM3Parser.parseValue(constants, lexer));
                continue;
            }
            if (symb.type == 59) {
                symb = lexer.lex();
                ASM3Parser.expected(symb, 4, "Integer");
                body.max_stack = (int)((Long)symb.value).longValue();
                continue;
            }
            if (symb.type == 60) {
                symb = lexer.lex();
                ASM3Parser.expected(symb, 4, "Integer");
                body.max_regs = (int)((Long)symb.value).longValue();
                continue;
            }
            if (symb.type == 61) {
                symb = lexer.lex();
                ASM3Parser.expected(symb, 4, "Integer");
                body.init_scope_depth = (int)((Long)symb.value).longValue();
                continue;
            }
            if (symb.type == 62) {
                symb = lexer.lex();
                ASM3Parser.expected(symb, 4, "Integer");
                body.max_scope_depth = (int)((Long)symb.value).longValue();
                continue;
            }
            if (symb.type == 57) {
                info.ret_type = ASM3Parser.parseMultiName(constants, lexer);
                continue;
            }
            if (symb.type == 45) {
                symb = lexer.lex();
                switch (symb.type) {
                    case 46: {
                        info.setFlagExplicit();
                        break;
                    }
                    case 47: {
                        info.setFlagHas_optional();
                        break;
                    }
                    case 48: {
                        info.setFlagHas_paramnames();
                        break;
                    }
                    case 49: {
                        info.setFlagIgnore_Rest();
                        break;
                    }
                    case 50: {
                        info.setFlagNeed_activation();
                        break;
                    }
                    case 51: {
                        info.setFlagNeed_Arguments();
                        break;
                    }
                    case 52: {
                        info.setFlagNeed_rest();
                        break;
                    }
                    case 53: {
                        info.setFlagSetsdxns();
                    }
                }
                continue;
            }
            if (symb.type == 39) {
                ASM3Parser.expected(40, "From", lexer);
                symb = lexer.lex();
                ASM3Parser.expected(symb, 6, "Identifier");
                exceptionsFrom.add((String)symb.value);
                ASM3Parser.expected(41, "To", lexer);
                symb = lexer.lex();
                ASM3Parser.expected(symb, 6, "Identifier");
                exceptionsTo.add((String)symb.value);
                ASM3Parser.expected(42, "Target", lexer);
                symb = lexer.lex();
                ASM3Parser.expected(symb, 6, "Identifier");
                exceptionsTargets.add((String)symb.value);
                ASM3Parser.expected(43, "Type", lexer);
                ABCException ex = new ABCException();
                ex.type_index = ASM3Parser.parseMultiName(constants, lexer);
                ASM3Parser.expected(44, "Name", lexer);
                ex.name_index = ASM3Parser.parseMultiName(constants, lexer);
                exceptions.add(ex);
                continue;
            }
            if (symb.type == 10) {
                int exIndex = (Integer)symb.value;
                int listIndex = exceptionIndices.indexOf(exIndex);
                if (listIndex == -1) {
                    throw new AVM2ParseException("Undefinex exception index", lexer.yyline());
                }
                ((ABCException)exceptions.get((int)listIndex)).start = offset;
                continue;
            }
            if (symb.type == 11) {
                int exIndex = (Integer)symb.value;
                int listIndex = exceptionIndices.indexOf(exIndex);
                if (listIndex == -1) {
                    throw new AVM2ParseException("Undefinex exception index", lexer.yyline());
                }
                ((ABCException)exceptions.get((int)listIndex)).end = offset;
                continue;
            }
            if (symb.type == 12) {
                int exIndex = (Integer)symb.value;
                int listIndex = exceptionIndices.indexOf(exIndex);
                if (listIndex == -1) {
                    throw new AVM2ParseException("Undefinex exception index", lexer.yyline());
                }
                ((ABCException)exceptions.get((int)listIndex)).target = offset;
                continue;
            }
            if (symb.type == 7) break;
            if (symb.type == 9) {
                if (lastIns == null) continue;
                lastIns.comment = (String)symb.value;
                continue;
            }
            if (symb.type == 88) {
                if (openedBlocks > 0) {
                    --openedBlocks;
                    continue;
                }
                throw new AVM2ParseException("End block encountered but there is no block opened", lexer.yyline());
            }
            if (symb.type == 3) {
                if (((String)symb.value).toLowerCase(Locale.ENGLISH).equals("exception")) {
                    ParsedSymbol exIndex = lexer.lex();
                    if (exIndex.type != 4) {
                        throw new AVM2ParseException("Index expected", lexer.yyline());
                    }
                    ParsedSymbol exName = lexer.lex();
                    if (exName.type != 2) {
                        throw new AVM2ParseException("Multiname expected", lexer.yyline());
                    }
                    ParsedSymbol exType = lexer.lex();
                    if (exType.type != 2) {
                        throw new AVM2ParseException("Multiname expected", lexer.yyline());
                    }
                    ABCException ex = new ABCException();
                    ex.name_index = ASM3Parser.checkMultinameIndex(constants, (int)((Long)exName.value).longValue(), lexer.yyline());
                    ex.type_index = ASM3Parser.checkMultinameIndex(constants, (int)((Long)exType.value).longValue(), lexer.yyline());
                    exceptions.add(ex);
                    exceptionIndices.add((int)((Long)exIndex.value).longValue());
                    continue;
                }
                boolean insFound = false;
                for (InstructionDefinition def : AVM2Code.instructionSet) {
                    if (def == null || def instanceof UnknownInstruction || !def.instructionName.equals((String)symb.value)) continue;
                    insFound = true;
                    ArrayList<Integer> operandsList = new ArrayList<Integer>();
                    block35: for (int i2 = 0; i2 < def.operands.length; ++i2) {
                        ParsedSymbol parsedOperand = lexer.lex();
                        switch (def.operands[i2]) {
                            case 257: {
                                lexer.pushback(parsedOperand);
                                operandsList.add(ASM3Parser.parseMultiName(constants, lexer));
                                continue block35;
                            }
                            case 279: {
                                lexer.pushback(parsedOperand);
                                operandsList.add(ASM3Parser.parseNamespace(constants, lexer));
                                continue block35;
                            }
                            case 260: {
                                if (parsedOperand.type == 27) {
                                    operandsList.add(0);
                                    continue block35;
                                }
                                if (parsedOperand.type == 1) {
                                    int sid = constants.getStringId((String)parsedOperand.value, false);
                                    if (sid == -1) {
                                        if (missingHandler != null && missingHandler.missingString((String)parsedOperand.value)) {
                                            sid = constants.addString((String)parsedOperand.value);
                                        } else {
                                            throw new AVM2ParseException("Unknown String", lexer.yyline());
                                        }
                                    }
                                    operandsList.add(sid);
                                    continue block35;
                                }
                                throw new AVM2ParseException("String or null expected", lexer.yyline());
                            }
                            case 270: {
                                int iid;
                                if (parsedOperand.type == 27) {
                                    operandsList.add(0);
                                    continue block35;
                                }
                                if (parsedOperand.type == 4) {
                                    long intVal = (Long)parsedOperand.value;
                                    iid = constants.getIntId(intVal, false);
                                    if (iid == -1) {
                                        if (missingHandler != null && missingHandler.missingInt(intVal)) {
                                            iid = constants.addInt(intVal);
                                        } else {
                                            throw new AVM2ParseException("Unknown int", lexer.yyline());
                                        }
                                    }
                                    operandsList.add(iid);
                                    continue block35;
                                }
                                throw new AVM2ParseException("Integer or null expected", lexer.yyline());
                            }
                            case 271: {
                                int iid;
                                if (parsedOperand.type == 27) {
                                    operandsList.add(0);
                                    continue block35;
                                }
                                if (parsedOperand.type == 4) {
                                    long intVal = (Long)parsedOperand.value;
                                    iid = constants.getUIntId(intVal, false);
                                    if (iid == -1) {
                                        if (missingHandler != null && missingHandler.missingUInt(intVal)) {
                                            iid = constants.addUInt(intVal);
                                        } else {
                                            throw new AVM2ParseException("Unknown uint", lexer.yyline());
                                        }
                                    }
                                    operandsList.add(iid);
                                    continue block35;
                                }
                                throw new AVM2ParseException("Integer or null expected", lexer.yyline());
                            }
                            case 272: {
                                if (parsedOperand.type == 27) {
                                    operandsList.add(0);
                                    continue block35;
                                }
                                if (parsedOperand.type == 4 || parsedOperand.type == 5) {
                                    int did;
                                    double doubleVal = 0.0;
                                    if (parsedOperand.type == 4) {
                                        doubleVal = ((Long)parsedOperand.value).longValue();
                                    }
                                    if (parsedOperand.type == 5) {
                                        doubleVal = (Double)parsedOperand.value;
                                    }
                                    if ((did = constants.getDoubleId(doubleVal, false)) == -1) {
                                        if (missingHandler != null && missingHandler.missingDouble(doubleVal)) {
                                            did = constants.addDouble(doubleVal);
                                        } else {
                                            throw new AVM2ParseException("Unknown double", lexer.yyline());
                                        }
                                    }
                                    operandsList.add(did);
                                    continue block35;
                                }
                                throw new AVM2ParseException("Double or null expected", lexer.yyline());
                            }
                            case 277: {
                                if (parsedOperand.type == 27) {
                                    operandsList.add(0);
                                    continue block35;
                                }
                                if (parsedOperand.type == 4 || parsedOperand.type == 5) {
                                    int fid;
                                    float floatVal = 0.0f;
                                    if (parsedOperand.type == 4) {
                                        floatVal = ((Long)parsedOperand.value).longValue();
                                    }
                                    if (parsedOperand.type == 5) {
                                        floatVal = (float)((Double)parsedOperand.value).doubleValue();
                                    }
                                    if ((fid = constants.getFloatId(floatVal, false)) == -1) {
                                        if (missingHandler != null && missingHandler.missingFloat(floatVal)) {
                                            fid = constants.addFloat(Float.valueOf(floatVal));
                                        } else {
                                            throw new AVM2ParseException("Unknown float", lexer.yyline());
                                        }
                                    }
                                    operandsList.add(fid);
                                    continue block35;
                                }
                                throw new AVM2ParseException("Float or null expected", lexer.yyline());
                            }
                            case 278: {
                                if (parsedOperand.type == 27) {
                                    operandsList.add(0);
                                    continue block35;
                                }
                                float[] float4Vals = new float[4];
                                for (int k = 0; k < 4; ++k) {
                                    float floatVal;
                                    if (parsedOperand.type == 4 || parsedOperand.type == 5) {
                                        floatVal = 0.0f;
                                        if (parsedOperand.type == 4) {
                                            floatVal = ((Long)parsedOperand.value).longValue();
                                        }
                                        if (parsedOperand.type == 5) {
                                            floatVal = (float)((Double)parsedOperand.value).doubleValue();
                                        }
                                    } else {
                                        throw new AVM2ParseException("4 floats or null expected", lexer.yyline());
                                    }
                                    float4Vals[k] = floatVal;
                                    if (k + 1 >= 4) continue;
                                    parsedOperand = lexer.lex();
                                }
                                Float4 float4Val = new Float4(float4Vals);
                                int f4id = constants.getFloat4Id(float4Val, false);
                                if (f4id == -1) {
                                    if (missingHandler != null && missingHandler.missingFloat4(float4Val)) {
                                        f4id = constants.addFloat4(float4Val);
                                    } else {
                                        throw new AVM2ParseException("Unknown float4", lexer.yyline());
                                    }
                                }
                                operandsList.add(f4id);
                                continue block35;
                            }
                            case 779: {
                                if (parsedOperand.type == 6) {
                                    offsetItems.add(new OffsetItem((String)parsedOperand.value, code.code.size(), i2));
                                    operandsList.add(0);
                                    continue block35;
                                }
                                throw new AVM2ParseException("Offset expected", lexer.yyline());
                            }
                            case 786: {
                                if (parsedOperand.type == 6) {
                                    offsetItems.add(new CaseOffsetItem((String)parsedOperand.value, code.code.size(), i2));
                                    operandsList.add(0);
                                    continue block35;
                                }
                                throw new AVM2ParseException("Offset expected", lexer.yyline());
                            }
                            case 1024: {
                                if (parsedOperand.type == 4) {
                                    int patCount = (int)((Long)parsedOperand.value).longValue();
                                    operandsList.add(patCount);
                                    for (int c = 0; c <= patCount; ++c) {
                                        parsedOperand = lexer.lex();
                                        if (parsedOperand.type != 6) {
                                            throw new AVM2ParseException("Offset expected", lexer.yyline());
                                        }
                                        offsetItems.add(new CaseOffsetItem((String)parsedOperand.value, code.code.size(), i2 + (c + 1)));
                                        operandsList.add(0);
                                    }
                                    continue block35;
                                }
                                throw new AVM2ParseException("Case count expected", lexer.yyline());
                            }
                            case 1280: {
                                if (parsedOperand.type == 4) {
                                    long val = (Long)parsedOperand.value;
                                    if (val < -128L || val > 127L) {
                                        throw new AVM2ParseException("Byte value expected (-128 to 127). Use pushshort or pushint to push larger values", lexer.yyline());
                                    }
                                    operandsList.add((int)val);
                                    continue block35;
                                }
                                throw new AVM2ParseException("Integer expected", lexer.yyline());
                            }
                            default: {
                                if (parsedOperand.type == 4) {
                                    long val = (Long)parsedOperand.value;
                                    if (def instanceof PushShortIns && (val < -32768L || val > 32767L)) {
                                        throw new AVM2ParseException("Short value expected (-32768 to 32767). Use pushint to push larger values", lexer.yyline());
                                    }
                                    operandsList.add((int)val);
                                    continue block35;
                                }
                                throw new AVM2ParseException("Integer expected", lexer.yyline());
                            }
                        }
                    }
                    int[] operands = new int[operandsList.size()];
                    for (int i3 = 0; i3 < operandsList.size(); ++i3) {
                        operands[i3] = (Integer)operandsList.get(i3);
                    }
                    lastIns = new AVM2Instruction((long)offset, def, operands);
                    code.code.add(lastIns);
                    offset += lastIns.getBytesLength();
                    break;
                }
                if (symb.value.toString().toLowerCase().equals("ffdec_deobfuscatepop")) {
                    lastIns = new AVM2Instruction((long)offset, DeobfuscatePopIns.getInstance(), null);
                    code.code.add(lastIns);
                    offset += lastIns.getBytesLength();
                    insFound = true;
                }
                if (insFound) continue;
                throw new AVM2ParseException("Invalid instruction name:" + (String)symb.value, lexer.yyline());
            }
            if (symb.type == 8) {
                labelItems.add(new LabelItem((String)symb.value, offset));
                continue;
            }
            throw new AVM2ParseException("Unexpected symbol", lexer.yyline());
        } while (symb.type != 7);
        if (!autoCloseBlocks && openedBlocks > 0) {
            throw new AVM2ParseException("End of the block expected: " + openedBlocks + "x", lexer.yyline());
        }
        code.compact();
        for (LabelItem li : labelItems) {
            int ind = exceptionsFrom.indexOf(li.label);
            if (ind > -1) {
                ((ABCException)exceptions.get((int)ind)).start = li.offset;
            }
            if ((ind = exceptionsTo.indexOf(li.label)) > -1) {
                ((ABCException)exceptions.get((int)ind)).end = li.offset;
            }
            if ((ind = exceptionsTargets.indexOf(li.label)) <= -1) continue;
            ((ABCException)exceptions.get((int)ind)).target = li.offset;
        }
        for (OffsetItem oi : offsetItems) {
            for (LabelItem li : labelItems) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (!oi.label.equals(li.label)) continue;
                AVM2Instruction ins = code.code.get((int)oi.insPosition);
                int relOffset = oi instanceof CaseOffsetItem ? li.offset - (int)ins.getAddress() : li.offset - ((int)ins.getAddress() + ins.getBytesLength());
                ins.operands[oi.insOperandIndex] = relOffset;
            }
        }
        body.exceptions = new ABCException[exceptions.size()];
        for (int e = 0; e < exceptions.size(); ++e) {
            body.exceptions[e] = (ABCException)exceptions.get(e);
        }
        info.param_types = new int[paramTypes.size()];
        for (i = 0; i < paramTypes.size(); ++i) {
            info.param_types[i] = (Integer)paramTypes.get(i);
        }
        if (info.flagHas_paramnames()) {
            info.paramNames = new int[paramNames.size()];
            for (i = 0; i < paramNames.size(); ++i) {
                info.paramNames[i] = (Integer)paramNames.get(i);
            }
        }
        if (info.flagHas_optional()) {
            info.optional = new ValueKind[optional.size()];
            for (i = 0; i < optional.size(); ++i) {
                info.optional[i] = (ValueKind)optional.get(i);
            }
        }
        abc.refreshMultinameNamespaceSuffixes();
        return code;
    }

    private static class LabelItem {
        public String label = "";
        public int offset;

        public LabelItem(String label, int offset) {
            this.label = label;
            this.offset = offset;
        }
    }

    private static class CaseOffsetItem
    extends OffsetItem {
        public CaseOffsetItem(String label, long insOffset, int insOperandIndex) {
            super(label, insOffset, insOperandIndex);
        }
    }

    private static class OffsetItem {
        public String label = "";
        public long insPosition;
        public int insOperandIndex;

        public OffsetItem(String label, long insOffset, int insOperandIndex) {
            this.label = label;
            this.insPosition = insOffset;
            this.insOperandIndex = insOperandIndex;
        }
    }
}

