/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.UnboundedTypeItem;
import java.util.List;

public class SubtractAVM2Item
extends BinaryOpItem {
    public SubtractAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem leftSide, GraphTargetItem rightSide) {
        super(instruction, lineStartIns, 4, leftSide, rightSide, "-", "Number", "Number");
    }

    @Override
    public Object getResult() {
        return this.leftSide.getResultAsNumber() - this.rightSide.getResultAsNumber();
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.rightSide.getPrecedence() >= this.precedence) {
            if (this.leftSide.getPrecedence() > this.precedence) {
                writer.append("(");
                this.leftSide.toString(writer, localData);
                writer.append(")");
            } else {
                this.leftSide.toString(writer, localData);
            }
            writer.append(" ");
            writer.append(this.operator);
            writer.append(" ");
            writer.append("(");
            this.rightSide.toString(writer, localData);
            return writer.append(")");
        }
        return super.appendTo(writer, localData);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        if (this.rightSide instanceof IntegerValueAVM2Item) {
            IntegerValueAVM2Item iv = (IntegerValueAVM2Item)this.rightSide;
            if (iv.value == 1L) {
                return SubtractAVM2Item.toSourceMerge(localData, generator, this.leftSide, new AVM2Instruction(0L, 147, null));
            }
        }
        return SubtractAVM2Item.toSourceMerge(localData, generator, this.leftSide, this.rightSide, new AVM2Instruction(0L, 161, null));
    }

    @Override
    public GraphTargetItem returnType() {
        return new UnboundedTypeItem();
    }
}

