/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.Set;

public class ConvertAVM2Item
extends AVM2Item {
    public GraphTargetItem type;

    public ConvertAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value, GraphTargetItem type) {
        super(instruction, lineStartIns, value.getPrecedence(), value);
        this.type = type;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        this.type.toString(writer, localData).append("(");
        this.value.toString(writer, localData);
        writer.append(")");
        return writer;
    }

    @Override
    public GraphTargetItem getNotCoerced() {
        return this.value.getNotCoerced();
    }

    @Override
    public GraphTargetItem getNotCoercedNoDup() {
        return this.value.getNotCoercedNoDup();
    }

    @Override
    public Object getResult() {
        switch (this.type.toString()) {
            case "Boolean": {
                return EcmaScript.toBoolean(this.value.getResult());
            }
            case "Number": {
                return this.value.getResultAsNumber();
            }
            case "int": {
                return EcmaScript.toInt32(this.value.getResultAsNumber());
            }
            case "uint": {
                return EcmaScript.toUint32(this.value.getResult());
            }
            case "String": {
                return this.value.getResultAsString();
            }
            case "Object": {
                return this.value.getResult();
            }
        }
        return new Object();
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        dependencies.add(this.value);
        return this.value.isConvertedCompileTime(dependencies);
    }

    @Override
    public GraphTargetItem returnType() {
        return this.type;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }
}

