/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.instructions.construction;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.AVM2LocalData;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.avm2.LocalDataArea;
import com.jpexs.decompiler.flash.abc.avm2.exceptions.AVM2ExecutionException;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2InstructionFlag;
import com.jpexs.decompiler.flash.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.decompiler.flash.abc.avm2.model.NameValuePair;
import com.jpexs.decompiler.flash.abc.avm2.model.NewObjectAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NullAVM2Item;
import com.jpexs.decompiler.flash.ecma.ObjectType;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.PopItem;
import java.util.ArrayList;
import java.util.List;

public class NewObjectIns
extends InstructionDefinition {
    public NewObjectIns() {
        super(85, "newobject", new int[]{258}, true, new AVM2InstructionFlag[0]);
    }

    @Override
    public boolean execute(LocalDataArea lda, AVM2ConstantPool constants, AVM2Instruction ins) throws AVM2ExecutionException {
        if (ins.operands[0] == 0) {
            lda.operandStack.push(ObjectType.EMPTY_OBJECT);
            return true;
        }
        return false;
    }

    @Override
    public void translate(AVM2LocalData localData, TranslateStack stack, AVM2Instruction ins, List<GraphTargetItem> output, String path) throws InterruptedException {
        int argCount = ins.operands[0];
        ArrayList<NameValuePair> args = new ArrayList<NameValuePair>(argCount);
        for (int a = 0; a < argCount; ++a) {
            GraphTargetItem value = stack.pop();
            if (value instanceof PopItem) {
                stack.push(new NullAVM2Item(ins, localData.lineStartInstruction));
                return;
            }
            GraphTargetItem name = stack.pop();
            if (value instanceof PopItem) {
                stack.push(new NullAVM2Item(ins, localData.lineStartInstruction));
                return;
            }
            args.add(0, new NameValuePair(name, value));
        }
        stack.push(new NewObjectAVM2Item((GraphSourceItem)ins, localData.lineStartInstruction, args));
    }

    @Override
    public int getStackPopCount(AVM2Instruction ins, ABC abc) {
        return ins.operands[0] * 2;
    }

    @Override
    public int getStackPushCount(AVM2Instruction ins, ABC abc) {
        return 1;
    }
}

