/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.fastavm2;

import com.jpexs.decompiler.flash.abc.avm2.fastavm2.AVM2InstructionItem;
import com.jpexs.decompiler.flash.abc.avm2.fastavm2.FastAVM2List;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import java.util.Iterator;

public final class FastAVM2ListIterator
implements Iterator<AVM2InstructionItem> {
    private AVM2InstructionItem item;
    private final FastAVM2List list;
    private boolean started = false;

    FastAVM2ListIterator(FastAVM2List list) {
        this.item = list.first();
        this.list = list;
    }

    FastAVM2ListIterator(FastAVM2List list, int index) {
        this.item = list.first();
        this.list = list;
        for (int i = 0; i < index; ++i) {
            if (!this.hasNext()) {
                throw new Error("Invalid index");
            }
            this.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.item != null && (!this.started || this.item != this.list.first());
    }

    @Override
    public AVM2InstructionItem next() {
        AVM2InstructionItem result = this.item;
        this.item = this.item.next;
        this.started = true;
        return result;
    }

    public AVM2InstructionItem prev() {
        this.item = this.item.prev;
        if (this.item == this.list.first()) {
            this.started = false;
        }
        return this.item;
    }

    public void setCurrent(AVM2InstructionItem item) {
        this.item = item;
        if (item == this.list.first()) {
            this.started = false;
        }
    }

    @Override
    public void remove() {
        this.item = this.list.removeItem(this.item.prev);
    }

    public void add(AVM2Instruction ins) {
        this.item = this.list.insertItemAfter((AVM2InstructionItem)this.item.prev, (AVM2Instruction)ins).next;
    }

    public void add(AVM2InstructionItem insItem) {
        this.item = this.list.insertItemAfter((AVM2InstructionItem)this.item.prev, (AVM2InstructionItem)insItem).next;
    }

    public void addBefore(AVM2InstructionItem insItem) {
        this.list.insertItemBefore(this.item.prev, insItem);
    }

    public AVM2InstructionItem peek(int index) {
        AVM2InstructionItem item = this.item;
        for (int i = 0; i < index && item != null; ++i) {
            item = item.next;
        }
        return item;
    }
}

