/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import com.jpexs.debugger.flash.SWD;
import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.DisassemblyListener;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWFCompression;
import com.jpexs.decompiler.flash.SWFContainerItem;
import com.jpexs.decompiler.flash.SWFHeader;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.SwfOpenException;
import com.jpexs.decompiler.flash.UrlResolver;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.RenameType;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Code;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.AbcMultiNameCollisionFixer;
import com.jpexs.decompiler.flash.abc.avm2.deobfuscation.DeobfuscationLevel;
import com.jpexs.decompiler.flash.abc.avm2.model.GetLexAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.InitPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NameValuePair;
import com.jpexs.decompiler.flash.abc.avm2.model.NewArrayAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.NewObjectAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.SetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.StringAVM2Item;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionGraphSource;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.ActionListReader;
import com.jpexs.decompiler.flash.action.ActionLocalData;
import com.jpexs.decompiler.flash.action.model.ConstantPool;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.clauses.ClassActionItem;
import com.jpexs.decompiler.flash.action.model.clauses.InterfaceActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionEquals;
import com.jpexs.decompiler.flash.action.swf4.ActionGetVariable;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.ActionSetVariable;
import com.jpexs.decompiler.flash.action.swf4.ConstantIndex;
import com.jpexs.decompiler.flash.action.swf5.ActionCallFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionCallMethod;
import com.jpexs.decompiler.flash.action.swf5.ActionConstantPool;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineLocal;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineLocal2;
import com.jpexs.decompiler.flash.action.swf5.ActionEquals2;
import com.jpexs.decompiler.flash.action.swf5.ActionGetMember;
import com.jpexs.decompiler.flash.action.swf5.ActionNewMethod;
import com.jpexs.decompiler.flash.action.swf5.ActionNewObject;
import com.jpexs.decompiler.flash.action.swf5.ActionSetMember;
import com.jpexs.decompiler.flash.action.swf7.ActionDefineFunction2;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.dumpview.DumpInfo;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSwfNode;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.script.AS2ScriptExporter;
import com.jpexs.decompiler.flash.exporters.script.AS3ScriptExporter;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.decompiler.flash.exporters.shape.ShapeExportData;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.helpers.HighlightedTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerPlugin;
import com.jpexs.decompiler.flash.helpers.collections.MyEntry;
import com.jpexs.decompiler.flash.helpers.hilight.Highlighting;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.flash.tags.DebugIDTag;
import com.jpexs.decompiler.flash.tags.DefineBinaryDataTag;
import com.jpexs.decompiler.flash.tags.DefineSoundTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.EnableDebugger2Tag;
import com.jpexs.decompiler.flash.tags.EnableDebuggerTag;
import com.jpexs.decompiler.flash.tags.EnableTelemetryTag;
import com.jpexs.decompiler.flash.tags.ExportAssetsTag;
import com.jpexs.decompiler.flash.tags.FileAttributesTag;
import com.jpexs.decompiler.flash.tags.JPEGTablesTag;
import com.jpexs.decompiler.flash.tags.MetadataTag;
import com.jpexs.decompiler.flash.tags.ProtectTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SymbolClassTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagStub;
import com.jpexs.decompiler.flash.tags.VideoFrameTag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.Exportable;
import com.jpexs.decompiler.flash.tags.base.FontTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.ImportTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.SymbolClassTypeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.tags.gfx.DefineCompactedFont;
import com.jpexs.decompiler.flash.timeline.AS2Package;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.FrameScript;
import com.jpexs.decompiler.flash.timeline.TagScript;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.treeitems.SWFList;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFField;
import com.jpexs.decompiler.flash.xfl.FLAVersion;
import com.jpexs.decompiler.flash.xfl.XFLConverter;
import com.jpexs.decompiler.flash.xfl.XFLExportSettings;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.ScopeStack;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.NulStream;
import com.jpexs.helpers.ProgressListener;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public final class SWF
implements SWFContainerItem,
Timelined {
    public static final int DEFAULT_VERSION = 10;
    public static final int MAX_VERSION = 32;
    @SWFField
    private List<Tag> tags = new ArrayList<Tag>();
    @Internal
    public ReadOnlyTagList readOnlyTags;
    public boolean hasEndTag = true;
    public RECT displayRect;
    public float frameRate;
    public int frameCount;
    public int version;
    @Internal
    public long fileSize;
    public SWFCompression compression = SWFCompression.NONE;
    @Internal
    public long compressedSize;
    public byte[] lzmaProperties;
    @Internal
    public byte[] uncompressedData;
    @Internal
    public byte[] originalUncompressedData;
    public boolean gfx = false;
    @Internal
    public SWFList swfList;
    @Internal
    private String file;
    @Internal
    private String fileTitle;
    @Internal
    private volatile Map<Integer, CharacterTag> characters;
    @Internal
    private volatile Map<Integer, List<CharacterIdTag>> characterIdTags;
    @Internal
    private volatile Map<Integer, Set<Integer>> dependentCharacters;
    @Internal
    private volatile List<ABCContainerTag> abcList;
    @Internal
    private volatile JPEGTablesTag jtt;
    @Internal
    public Map<Integer, String> sourceFontNamesMap = new HashMap<Integer, String>();
    public static final double unitDivisor = 20.0;
    private static final Logger logger = Logger.getLogger(SWF.class.getName());
    @Internal
    private boolean isModified;
    @Internal
    private Timeline timeline;
    @Internal
    public DumpInfoSwfNode dumpInfo;
    @Internal
    public DefineBinaryDataTag binaryData;
    @Internal
    private final HashMap<DottedChain, DottedChain> deobfuscated = new HashMap();
    @Internal
    private final IdentifiersDeobfuscation deobfuscation = new IdentifiersDeobfuscation();
    @Internal
    private final Cache<String, SerializableImage> frameCache = Cache.getInstance(false, false, "frame");
    @Internal
    private final Cache<CharacterTag, RECT> rectCache = Cache.getInstance(true, true, "rect");
    @Internal
    private final Cache<SHAPE, ShapeExportData> shapeExportDataCache = Cache.getInstance(true, true, "shapeExportData");
    @Internal
    private final Cache<SoundTag, byte[]> soundCache = Cache.getInstance(false, false, "sound");
    @Internal
    private final Cache<ASMSource, ActionList> as2PcodeCache = Cache.getInstance(true, true, "as2pcode");
    @Internal
    private final Cache<ASMSource, HighlightedText> as2Cache = Cache.getInstance(true, false, "as2");
    @Internal
    private final Cache<ScriptPack, HighlightedText> as3Cache = Cache.getInstance(true, false, "as3");
    public static List<String> swfSignatures = Arrays.asList("FWS", "CWS", "ZWS", "GFX", "CFX", "ABC");
    private final HashSet<EventListener> listeners = new HashSet();

    public void updateCharacters() {
        this.characters = null;
        this.characterIdTags = null;
    }

    public void clearTagSwfs() {
        this.resetTimelines(this);
        this.updateCharacters();
        for (Tag tag : this.getTags()) {
            if (tag instanceof DefineSpriteTag) {
                DefineSpriteTag spriteTag = (DefineSpriteTag)tag;
                for (Tag tag1 : spriteTag.getTags()) {
                    tag1.setSwf(null);
                }
                for (int i = spriteTag.getTags().size() - 1; i >= 0; --i) {
                    spriteTag.removeTag(i);
                }
            }
            if (tag instanceof DefineBinaryDataTag) {
                DefineBinaryDataTag binaryTag = (DefineBinaryDataTag)tag;
                if (binaryTag.innerSwf != null) {
                    binaryTag.innerSwf.clearTagSwfs();
                }
            }
            tag.setSwf(null);
        }
        this.tags.clear();
        if (this.abcList != null) {
            this.abcList.clear();
        }
        if (this.swfList != null) {
            this.swfList.swfs.clear();
        }
        this.as2PcodeCache.clear();
        this.as2Cache.clear();
        this.as3Cache.clear();
        this.frameCache.clear();
        this.soundCache.clear();
        this.timeline = null;
        this.clearDumpInfo(this.dumpInfo);
        this.dumpInfo = null;
        this.jtt = null;
        this.binaryData = null;
    }

    private void clearDumpInfo(DumpInfo di) {
        for (DumpInfo childInfo : di.getChildInfos()) {
            this.clearDumpInfo(childInfo);
        }
        di.getChildInfos().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, CharacterTag> getCharacters() {
        if (this.characters == null) {
            SWF sWF = this;
            synchronized (sWF) {
                if (this.characters == null) {
                    HashMap<Integer, CharacterTag> chars = new HashMap<Integer, CharacterTag>();
                    HashMap<Integer, List<CharacterIdTag>> charIdtags = new HashMap<Integer, List<CharacterIdTag>>();
                    this.parseCharacters(this.getTags(), chars, charIdtags);
                    this.characters = Collections.unmodifiableMap(chars);
                    this.characterIdTags = Collections.unmodifiableMap(charIdtags);
                }
            }
        }
        return this.characters;
    }

    public List<CharacterIdTag> getCharacterIdTags(int characterId) {
        if (this.characterIdTags == null) {
            this.getCharacters();
        }
        return this.characterIdTags.get(characterId);
    }

    public CharacterIdTag getCharacterIdTag(int characterId, int tagId) {
        List<CharacterIdTag> characterIdTags = this.getCharacterIdTags(characterId);
        if (characterIdTags != null) {
            for (CharacterIdTag t : characterIdTags) {
                if (((Tag)((Object)t)).getId() != tagId || t.getCharacterId() != characterId) continue;
                return t;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Set<Integer>> getDependentCharacters() {
        if (this.dependentCharacters == null) {
            SWF sWF = this;
            synchronized (sWF) {
                if (this.dependentCharacters == null) {
                    HashMap<Integer, Set<Integer>> dep = new HashMap<Integer, Set<Integer>>();
                    for (Tag tag : this.getTags()) {
                        if (!(tag instanceof CharacterTag)) continue;
                        int characterId = ((CharacterTag)tag).getCharacterId();
                        HashSet<Integer> needed = new HashSet<Integer>();
                        tag.getNeededCharacters(needed);
                        for (Integer needed1 : needed) {
                            HashSet<Integer> s = (HashSet<Integer>)dep.get(needed1);
                            if (s == null) {
                                s = new HashSet<Integer>();
                                dep.put(needed1, s);
                            }
                            s.add(characterId);
                        }
                    }
                    this.dependentCharacters = dep;
                }
            }
        }
        return this.dependentCharacters;
    }

    public Set<Integer> getDependentCharacters(int characterId) {
        HashSet<Integer> visited = new HashSet<Integer>();
        LinkedHashSet<Integer> dependents2 = new LinkedHashSet<Integer>();
        Set<Integer> deps = this.getDependentCharacters().get(characterId);
        if (deps != null) {
            dependents2.addAll(deps);
        }
        block0: while (visited.size() != dependents2.size()) {
            Iterator iterator = dependents2.iterator();
            while (iterator.hasNext()) {
                int chId = (Integer)iterator.next();
                if (visited.contains(chId)) continue;
                visited.add(chId);
                if (!this.getCharacters().containsKey(chId)) continue;
                deps = this.getDependentCharacters().get(chId);
                if (deps == null) continue block0;
                dependents2.addAll(deps);
                continue block0;
            }
        }
        LinkedHashSet<Integer> dependents = new LinkedHashSet<Integer>();
        for (Integer chId : dependents2) {
            if (!this.getCharacters().containsKey(chId)) continue;
            dependents.add(chId);
        }
        return dependents;
    }

    public CharacterTag getCharacter(int characterId) {
        return this.getCharacters().get(characterId);
    }

    public String getExportName(int characterId) {
        CharacterTag characterTag = this.getCharacters().get(characterId);
        String exportName = characterTag != null ? characterTag.getExportName() : null;
        return exportName;
    }

    public FontTag getFontByClass(String fontClass) {
        if (fontClass == null) {
            return null;
        }
        for (Tag t : this.getTags()) {
            if (!(t instanceof FontTag) || !fontClass.equals(((FontTag)t).getClassName())) continue;
            return (FontTag)t;
        }
        return null;
    }

    public FontTag getFontByName(String fontName) {
        if (fontName == null) {
            return null;
        }
        for (Tag t : this.getTags()) {
            if (!(t instanceof FontTag) || !fontName.equals(((FontTag)t).getFontName())) continue;
            return (FontTag)t;
        }
        return null;
    }

    public FontTag getFont(int fontId) {
        CharacterTag characterTag = this.getCharacters().get(fontId);
        if (characterTag instanceof FontTag) {
            return (FontTag)characterTag;
        }
        if (characterTag != null) {
            logger.log(Level.SEVERE, "CharacterTag should be a FontTag. characterId: {0}", fontId);
        }
        return null;
    }

    public ImageTag getImage(int imageId) {
        CharacterTag characterTag = this.getCharacters().get(imageId);
        if (characterTag instanceof ImageTag) {
            return (ImageTag)characterTag;
        }
        if (characterTag != null) {
            logger.log(Level.SEVERE, "CharacterTag should be an ImageTag. characterId: {0}", imageId);
        }
        return null;
    }

    public DefineSoundTag getSound(int soundId) {
        CharacterTag characterTag = this.getCharacters().get(soundId);
        if (characterTag instanceof DefineSoundTag) {
            return (DefineSoundTag)characterTag;
        }
        if (characterTag != null) {
            logger.log(Level.SEVERE, "CharacterTag should be a DefineSoundTag. characterId: {0}", soundId);
        }
        return null;
    }

    public TextTag getText(int textId) {
        CharacterTag characterTag = this.getCharacters().get(textId);
        if (characterTag instanceof TextTag) {
            return (TextTag)characterTag;
        }
        if (characterTag != null) {
            logger.log(Level.SEVERE, "CharacterTag should be a TextTag. characterId: {0}", textId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ABCContainerTag> getAbcList() {
        if (this.abcList == null) {
            SWF sWF = this;
            synchronized (sWF) {
                if (this.abcList == null) {
                    ArrayList<ABCContainerTag> newAbcList = new ArrayList<ABCContainerTag>();
                    SWF.getAbcTags(this.getTags(), newAbcList);
                    this.abcList = newAbcList;
                }
            }
        }
        return this.abcList;
    }

    public boolean isAS3() {
        FileAttributesTag fileAttributes = this.getFileAttributes();
        return fileAttributes != null && fileAttributes.actionScript3 || fileAttributes == null && !this.getAbcList().isEmpty();
    }

    public MetadataTag getMetadata() {
        for (Tag t : this.getTags()) {
            if (!(t instanceof MetadataTag)) continue;
            return (MetadataTag)t;
        }
        return null;
    }

    public FileAttributesTag getFileAttributes() {
        for (Tag t : this.getTags()) {
            if (!(t instanceof FileAttributesTag)) continue;
            return (FileAttributesTag)t;
        }
        return null;
    }

    public SetBackgroundColorTag getBackgroundColor() {
        for (Tag t : this.getTags()) {
            if (!(t instanceof SetBackgroundColorTag)) continue;
            return (SetBackgroundColorTag)t;
        }
        return null;
    }

    public EnableTelemetryTag getEnableTelemetry() {
        for (Tag t : this.getTags()) {
            if (!(t instanceof EnableTelemetryTag)) continue;
            return (EnableTelemetryTag)t;
        }
        return null;
    }

    public int getNextCharacterId() {
        int max = 0;
        HashSet<Integer> ids = new HashSet<Integer>(this.getCharacters().keySet());
        for (Tag t : this.tags) {
            if (!(t instanceof ImportTag)) continue;
            ids.addAll(((ImportTag)((Object)t)).getAssets().keySet());
        }
        Iterator<Tag> iterator = ids.iterator();
        while (iterator.hasNext()) {
            int characterId = (Integer)((Object)iterator.next());
            if (characterId <= max) continue;
            max = characterId;
        }
        return max + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JPEGTablesTag getJtt() {
        if (this.jtt == null) {
            SWF sWF = this;
            synchronized (sWF) {
                if (this.jtt == null) {
                    for (Tag t : this.getTags()) {
                        if (!(t instanceof JPEGTablesTag)) continue;
                        this.jtt = (JPEGTablesTag)t;
                        break;
                    }
                }
            }
        }
        return this.jtt;
    }

    public String getDocumentClass() {
        for (Tag t : this.getTags()) {
            if (!(t instanceof SymbolClassTag)) continue;
            SymbolClassTag sc = (SymbolClassTag)t;
            for (int i = 0; i < sc.tags.size(); ++i) {
                if (sc.tags.get(i) != 0) continue;
                return sc.names.get(i);
            }
        }
        return null;
    }

    public void fixCharactersOrder(boolean checkAll) {
        HashSet<Integer> addedCharacterIds = new HashSet<Integer>();
        HashSet<CharacterTag> movedTags = new HashSet<CharacterTag>();
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag tag = this.tags.get(i);
            if (checkAll || tag.isModified()) {
                HashSet<Integer> needed = new HashSet<Integer>();
                tag.getNeededCharacters(needed);
                if (tag instanceof CharacterTag) {
                    CharacterTag characterTag = (CharacterTag)tag;
                    needed.remove(characterTag.getCharacterId());
                }
                boolean moved = false;
                for (Integer id : needed) {
                    CharacterTag neededCharacter;
                    if (addedCharacterIds.contains(id) || (neededCharacter = this.getCharacter(id)) == null) continue;
                    if (movedTags.contains(neededCharacter)) {
                        logger.log(Level.SEVERE, "Fixing characters order failed, recursion detected.");
                        return;
                    }
                    this.tags.remove(neededCharacter);
                    this.tags.add(i, neededCharacter);
                    movedTags.add(neededCharacter);
                    moved = true;
                }
                if (moved) {
                    --i;
                    continue;
                }
            }
            if (!(tag instanceof CharacterTag)) continue;
            addedCharacterIds.add(((CharacterTag)tag).getCharacterId());
        }
    }

    public void resetTimelines(Timelined timelined) {
        timelined.resetTimeline();
        if (timelined instanceof SWF) {
            for (Tag t : ((SWF)timelined).getTags()) {
                if (!(t instanceof Timelined)) continue;
                this.resetTimelines((Timelined)((Object)t));
            }
        }
    }

    private void parseCharacters(Iterable<Tag> list, Map<Integer, CharacterTag> characters, Map<Integer, List<CharacterIdTag>> characterIdTags) {
        for (Tag t : list) {
            if (t instanceof CharacterIdTag) {
                int characterId = ((CharacterIdTag)((Object)t)).getCharacterId();
                if (t instanceof CharacterTag) {
                    if (characters.containsKey(characterId)) {
                        logger.log(Level.SEVERE, "SWF already contains characterId={0}", characterId);
                    }
                    if (characterId != 0) {
                        characters.put(characterId, (CharacterTag)t);
                        characterIdTags.put(characterId, new ArrayList());
                    }
                } else if (characterIdTags.containsKey(characterId)) {
                    characterIdTags.get(characterId).add((CharacterIdTag)((Object)t));
                }
            }
            if (!(t instanceof DefineSpriteTag)) continue;
            this.parseCharacters(((DefineSpriteTag)t).getTags(), characters, characterIdTags);
        }
    }

    private void checkInvalidSprites() {
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag t = this.tags.get(i);
            if (!(t instanceof DefineSpriteTag) || this.isSpriteValid((DefineSpriteTag)t, new ArrayList<Integer>())) continue;
            this.tags.set(i, new TagStub(this, t.getId(), "InvalidSprite", t.getOriginalRange(), null));
        }
    }

    private boolean isSpriteValid(DefineSpriteTag sprite, List<Integer> path) {
        if (path.contains(sprite.spriteId)) {
            return false;
        }
        path.add(sprite.spriteId);
        for (Tag t : sprite.getTags()) {
            if (!(t instanceof DefineSpriteTag) || this.isSpriteValid((DefineSpriteTag)t, path)) continue;
            return false;
        }
        path.remove((Object)sprite.spriteId);
        return true;
    }

    @Override
    public Timeline getTimeline() {
        if (this.timeline == null) {
            this.timeline = new Timeline(this);
        }
        return this.timeline;
    }

    @Override
    public void resetTimeline() {
        if (this.timeline != null) {
            this.timeline.reset(this);
        }
    }

    public List<Tag> getTagData(int tagId) {
        ArrayList<Tag> ret = new ArrayList<Tag>();
        for (Tag tag : this.getTags()) {
            if (tag.getId() != tagId) continue;
            ret.add(tag);
        }
        return ret;
    }

    public void saveTo(OutputStream os) throws IOException {
        byte[] uncompressedData = this.saveToByteArray();
        SWF.compress(new ByteArrayInputStream(uncompressedData), os, this.compression, this.lzmaProperties);
    }

    public void saveTo(OutputStream os, boolean gfx) throws IOException {
        byte[] uncompressedData = this.saveToByteArray(gfx);
        SWF.compress(new ByteArrayInputStream(uncompressedData), os, this.compression, this.lzmaProperties);
    }

    public byte[] getHeaderBytes() {
        return SWF.getHeaderBytes(this.compression, this.gfx);
    }

    private static byte[] getHeaderBytes(SWFCompression compression, boolean gfx) {
        if (compression == SWFCompression.LZMA_ABC) {
            return new byte[]{65, 66, 67};
        }
        byte[] ret = new byte[3];
        ret[0] = compression == SWFCompression.LZMA ? 90 : (compression == SWFCompression.ZLIB ? 67 : (gfx ? 71 : 70));
        if (gfx) {
            ret[1] = 70;
            ret[2] = 88;
        } else {
            ret[1] = 87;
            ret[2] = 83;
        }
        return ret;
    }

    private byte[] saveToByteArray() throws IOException {
        return this.saveToByteArray(this.gfx);
    }

    private byte[] saveToByteArray(boolean gfx) throws IOException {
        byte[] data;
        Throwable throwable;
        SWFOutputStream sos;
        this.fixCharactersOrder(false);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            sos = new SWFOutputStream(baos, this.version);
            throwable = null;
            try {
                sos.write(SWF.getHeaderBytes(SWFCompression.NONE, gfx));
                sos.writeUI8(this.version);
                sos.writeUI32(0L);
                sos.writeRECT(this.displayRect);
                sos.writeFIXED8(this.frameRate);
                sos.writeUI16(this.frameCount);
                sos.writeTags(this.getLocalTags());
                if (this.hasEndTag) {
                    sos.writeUI16(0);
                }
                data = baos.toByteArray();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sos != null) {
                    if (throwable != null) {
                        try {
                            sos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        sos.close();
                    }
                }
            }
        }
        baos = new ByteArrayOutputStream();
        var4_3 = null;
        try {
            sos = new SWFOutputStream(baos, this.version);
            throwable = null;
            try {
                sos.writeUI32(data.length);
                byte[] lengthData = baos.toByteArray();
                System.arraycopy(lengthData, 0, data, 4, lengthData.length);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (sos != null) {
                    if (throwable != null) {
                        try {
                            sos.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        sos.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var4_3 = throwable6;
            throw throwable6;
        }
        finally {
            if (baos != null) {
                if (var4_3 != null) {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable7) {
                        var4_3.addSuppressed(throwable7);
                    }
                } else {
                    baos.close();
                }
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compress(InputStream is, OutputStream os, SWFCompression compression, byte[] lzmaProperties) throws IOException {
        long fileSize;
        boolean uncompressed;
        byte[] hdr = new byte[8];
        is.mark(8);
        if (is.read(hdr) != 8) {
            throw new SwfOpenException("SWF header is too short");
        }
        boolean bl = uncompressed = hdr[0] == 70 || hdr[0] == 71;
        if (!uncompressed) {
            is.reset();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SWF.decompress(is, baos, false);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            SWF.compress(bais, os, compression, lzmaProperties);
            return;
        }
        boolean gfx = hdr[1] == 70 && hdr[2] == 88;
        byte version = hdr[3];
        try (SWFInputStream sis = new SWFInputStream(null, Arrays.copyOfRange(hdr, 4, 8), 4L, 4);){
            fileSize = sis.readUI32("fileSize");
        }
        SWFOutputStream sos = new SWFOutputStream(os, version);
        sos.write(SWF.getHeaderBytes(compression, gfx));
        sos.writeUI8(version);
        sos.writeUI32(fileSize);
        if (compression == SWFCompression.LZMA || compression == SWFCompression.LZMA_ABC) {
            byte[] udata;
            long uncompressedLength = fileSize - 8L;
            Encoder enc = new Encoder();
            if (lzmaProperties == null) {
                lzmaProperties = new byte[]{93, 0, 0, 32, 0};
            }
            int val = lzmaProperties[0] & 0xFF;
            int lc = val % 9;
            int remainder = val / 9;
            int lp = remainder % 5;
            int pb = remainder / 5;
            int dictionarySize = 0;
            for (int i = 0; i < 4; ++i) {
                dictionarySize += (lzmaProperties[1 + i] & 0xFF) << i * 8;
            }
            if (Configuration.lzmaFastBytes.get() > 0) {
                enc.SetNumFastBytes(Configuration.lzmaFastBytes.get().intValue());
            }
            enc.SetDictionarySize(dictionarySize);
            enc.SetLcLpPb(lc, lp, pb);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            enc.SetEndMarkerMode(true);
            enc.Code(is, (OutputStream)baos, -1L, -1L, null);
            byte[] data = baos.toByteArray();
            if (compression == SWFCompression.LZMA) {
                udata = new byte[]{(byte)(data.length & 0xFF), (byte)(data.length >> 8 & 0xFF), (byte)(data.length >> 16 & 0xFF), (byte)(data.length >> 24 & 0xFF)};
                os.write(udata);
            }
            enc.WriteCoderProperties(os);
            if (compression == SWFCompression.LZMA_ABC) {
                udata = new byte[]{(byte)(uncompressedLength & 0xFFL), (byte)(uncompressedLength >> 8 & 0xFFL), (byte)(uncompressedLength >> 16 & 0xFFL), (byte)(uncompressedLength >> 24 & 0xFFL), (byte)(uncompressedLength >> 32 & 0xFFL), (byte)(uncompressedLength >> 40 & 0xFFL), (byte)(uncompressedLength >> 48 & 0xFFL), (byte)(uncompressedLength >> 56 & 0xFFL)};
                os.write(udata);
            }
            os.write(data);
        } else if (compression == SWFCompression.ZLIB) {
            DeflaterOutputStream dos = new DeflaterOutputStream(os);
            try {
                Helper.copyStream(is, dos);
            }
            finally {
                dos.finish();
            }
        } else {
            Helper.copyStream(is, os);
        }
    }

    @Override
    public boolean isModified() {
        if (this.isModified) {
            return true;
        }
        for (Tag tag : this.getTags()) {
            if (!tag.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setModified(boolean value) {
        this.isModified = value;
    }

    public void clearModified() {
        for (Tag tag : this.getTags()) {
            if (!tag.isModified()) continue;
            tag.createOriginalData();
            tag.setModified(false);
        }
        this.isModified = false;
        try {
            this.uncompressedData = this.saveToByteArray();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Cannot save SWF", ex);
        }
    }

    public SWF() {
        this.version = 10;
        this.displayRect = new RECT(0, 1, 0, 1);
    }

    public SWF(InputStream is, boolean parallelRead) throws IOException, InterruptedException {
        this(is, null, null, null, parallelRead, false, true);
    }

    public SWF(InputStream is, boolean parallelRead, boolean lazy) throws IOException, InterruptedException {
        this(is, null, null, null, parallelRead, false, lazy);
    }

    public SWF(InputStream is, String file, String fileTitle, boolean parallelRead) throws IOException, InterruptedException {
        this(is, file, fileTitle, null, parallelRead, false, true);
    }

    public SWF(InputStream is, ProgressListener listener, boolean parallelRead) throws IOException, InterruptedException {
        this(is, null, null, listener, parallelRead, false, true);
    }

    public SWF(InputStream is, String file, String fileTitle, ProgressListener listener, boolean parallelRead) throws IOException, InterruptedException {
        this(is, file, fileTitle, listener, parallelRead, false, true);
    }

    public SWF(InputStream is) throws IOException {
        SWF.decompress(is, new NulStream(), true);
    }

    public SWF(InputStream is, String file, String fileTitle, ProgressListener listener, boolean parallelRead, boolean checkOnly, boolean lazy) throws IOException, InterruptedException {
        this(is, file, fileTitle, listener, parallelRead, checkOnly, lazy, null);
    }

    public SWF(InputStream is, String file, String fileTitle, ProgressListener listener, boolean parallelRead, boolean checkOnly, boolean lazy, UrlResolver resolver) throws IOException, InterruptedException {
        this.file = file;
        this.fileTitle = fileTitle;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFHeader header = SWF.decompress(is, baos, true);
        this.gfx = header.gfx;
        this.compression = header.compression;
        this.lzmaProperties = header.lzmaProperties;
        this.uncompressedData = baos.toByteArray();
        this.originalUncompressedData = this.uncompressedData;
        SWFInputStream sis = new SWFInputStream(this, this.uncompressedData);
        this.dumpInfo = new DumpInfoSwfNode(this, "rootswf", "", null, 0L, 0L);
        sis.dumpInfo = this.dumpInfo;
        sis.skipBytesEx(3L, "signature");
        this.version = sis.readUI8("version");
        this.dumpInfo.lengthBytes = this.fileSize = sis.readUI32("fileSize");
        if (listener != null) {
            sis.addPercentListener(listener);
        }
        sis.setPercentMax(this.fileSize);
        this.displayRect = sis.readRECT("displayRect");
        this.frameRate = sis.readFIXED8("frameRate");
        this.frameCount = sis.readUI16("frameCount");
        List<Tag> tags = sis.readTagList(this, 0, parallelRead, true, !checkOnly, lazy);
        if (tags.size() > 0 && tags.get(tags.size() - 1).getId() == 0) {
            tags.remove(tags.size() - 1);
        } else {
            this.hasEndTag = false;
        }
        this.tags = tags;
        this.readOnlyTags = null;
        if (!checkOnly) {
            this.checkInvalidSprites();
            this.updateCharacters();
            this.assignExportNamesToSymbols();
            this.assignClassesToSymbols();
            if (resolver != null) {
                this.resolveImported(resolver);
            }
            SWFDecompilerPlugin.fireSwfParsed(this);
        } else {
            boolean hasNonUnknownTag = false;
            for (Tag tag : tags) {
                if (tag.getOriginalDataLength() <= 0 || !Tag.getRequiredTags().contains(tag.getId())) continue;
                hasNonUnknownTag = true;
            }
            if (!hasNonUnknownTag) {
                throw new IOException("Invalid SWF file. No known tag found.");
            }
        }
        if (Configuration.autoRenameIdentifiers.get().booleanValue()) {
            this.deobfuscateIdentifiers(RenameType.TYPENUMBER);
            AbcMultiNameCollisionFixer collisionFixer = new AbcMultiNameCollisionFixer();
            collisionFixer.fixCollisions(this);
            this.assignClassesToSymbols();
            this.clearScriptCache();
        }
        this.getASMs(true);
    }

    private void resolveImported(UrlResolver resolver) {
        for (int p = 0; p < this.tags.size(); ++p) {
            ImportTag importTag;
            SWF iSwf;
            Tag t = this.tags.get(p);
            if (!(t instanceof ImportTag) || (iSwf = resolver.resolveUrl((importTag = (ImportTag)((Object)t)).getUrl())) == null) continue;
            HashMap<Integer, String> exportedMap1 = new HashMap<Integer, String>();
            HashMap<Integer, String> classesMap1 = new HashMap<Integer, String>();
            for (Tag tag : iSwf.tags) {
                Map<Integer, String> m2;
                SymbolClassTypeTag sc;
                if (tag instanceof ExportAssetsTag) {
                    sc = (ExportAssetsTag)tag;
                    m2 = ((ExportAssetsTag)sc).getTagToNameMap();
                    for (int key : m2.keySet()) {
                        if (exportedMap1.containsKey(key)) continue;
                        exportedMap1.put(key, m2.get(key));
                    }
                }
                if (!(tag instanceof SymbolClassTag)) continue;
                sc = (SymbolClassTag)tag;
                m2 = ((SymbolClassTag)sc).getTagToNameMap();
                for (int key : m2.keySet()) {
                    if (classesMap1.containsKey(key)) continue;
                    classesMap1.put(key, m2.get(key));
                }
            }
            HashMap exportedMap2 = new HashMap();
            Iterator iterator = exportedMap1.keySet().iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                exportedMap2.put(exportedMap1.get(k), k);
            }
            HashMap hashMap = new HashMap();
            Iterator k = classesMap1.keySet().iterator();
            while (k.hasNext()) {
                int k2 = (Integer)k.next();
                hashMap.put(classesMap1.get(k2), k2);
            }
            Map<Integer, String> importedMap1 = importTag.getAssets();
            HashMap<String, Integer> importedMap2 = new HashMap<String, Integer>();
            for (int k3 : importedMap1.keySet()) {
                importedMap2.put(importedMap1.get(k3), k3);
            }
            int pos = 0;
            for (String key : importedMap2.keySet()) {
                if (!exportedMap2.containsKey(key)) continue;
                int exportedId = (Integer)exportedMap2.get(key);
                int importedId = (Integer)importedMap2.get(key);
                for (Tag cht : iSwf.tags) {
                    if (!(cht instanceof CharacterIdTag) || ((CharacterIdTag)((Object)cht)).getCharacterId() != exportedId || cht instanceof PlaceObjectTypeTag || cht instanceof RemoveTag) continue;
                    CharacterIdTag ch = (CharacterIdTag)((Object)cht);
                    cht.setSwf(this);
                    ch.setCharacterId(importedId);
                    cht.setImported(true);
                    this.tags.add(p + 1 + pos, cht);
                    ++pos;
                }
            }
            int newId = this.getNextCharacterId();
            pos = 0;
            for (String key : hashMap.keySet()) {
                int exportedId = (Integer)hashMap.get(key);
                int importedId = newId++;
                for (Tag cht : iSwf.tags) {
                    if (!(cht instanceof CharacterIdTag) || ((CharacterIdTag)((Object)cht)).getCharacterId() != exportedId || cht instanceof PlaceObjectTypeTag || cht instanceof RemoveTag) continue;
                    CharacterIdTag ch = (CharacterIdTag)((Object)cht);
                    cht.setSwf(this);
                    ch.setCharacterId(importedId);
                    cht.setImported(true);
                    this.tags.add(p + 1 + pos, cht);
                    ++pos;
                }
            }
            this.updateCharacters();
        }
    }

    @Override
    public SWF getSwf() {
        return this;
    }

    public SWF getRootSwf() {
        SWF result = this;
        while (result.binaryData != null) {
            result = result.binaryData.getSwf();
        }
        return result;
    }

    public String getFile() {
        return this.file;
    }

    public String getFileTitle() {
        if (this.fileTitle != null) {
            return this.fileTitle;
        }
        return this.file;
    }

    public String getShortFileName() {
        String title = this.getFileTitle();
        if (title == null) {
            return "";
        }
        return new File(title).getName();
    }

    public void setFile(String file) {
        this.file = file;
        this.fileTitle = null;
    }

    public Date getFileModificationDate() {
        try {
            long lastModified;
            String fileName;
            if (this.swfList != null && this.swfList.sourceInfo != null && (fileName = this.swfList.sourceInfo.getFile()) != null && (lastModified = new File(fileName).lastModified()) > 0L) {
                return new Date(lastModified);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return new Date();
    }

    private static void getAbcTags(Iterable<Tag> list, List<ABCContainerTag> actionScripts) {
        for (Tag t : list) {
            if (t instanceof DefineSpriteTag) {
                SWF.getAbcTags(((DefineSpriteTag)t).getTags(), actionScripts);
            }
            if (!(t instanceof ABCContainerTag)) continue;
            actionScripts.add((ABCContainerTag)((Object)t));
        }
    }

    public void assignExportNamesToSymbols() {
        HashMap<Integer, String> exportNames = new HashMap<Integer, String>();
        for (Tag t : this.getTags()) {
            if (!(t instanceof ExportAssetsTag)) continue;
            ExportAssetsTag eat = (ExportAssetsTag)t;
            for (int i = 0; i < eat.tags.size(); ++i) {
                Integer tagId = eat.tags.get(i);
                String name = eat.names.get(i);
                if (exportNames.containsKey(tagId) || exportNames.containsValue(name)) continue;
                exportNames.put(tagId, name);
            }
        }
        for (Tag t : this.getTags()) {
            CharacterTag ct;
            if (!(t instanceof CharacterTag) || !exportNames.containsKey((ct = (CharacterTag)t).getCharacterId())) continue;
            ct.setExportName((String)exportNames.get(ct.getCharacterId()));
        }
    }

    public void assignClassesToSymbols() {
        HashMap<Integer, String> classes = new HashMap<Integer, String>();
        for (Tag t : this.getTags()) {
            if (!(t instanceof SymbolClassTag)) continue;
            SymbolClassTag sct = (SymbolClassTag)t;
            for (int i = 0; i < sct.tags.size(); ++i) {
                if (classes.containsKey(sct.tags.get(i)) || classes.containsValue(sct.names.get(i))) continue;
                classes.put(sct.tags.get(i), sct.names.get(i));
            }
        }
        for (Tag t : this.getTags()) {
            CharacterTag ct;
            if (!(t instanceof CharacterTag) || !classes.containsKey((ct = (CharacterTag)t).getCharacterId())) continue;
            ct.setClassName((String)classes.get(ct.getCharacterId()));
        }
    }

    public static boolean compress(InputStream fis, OutputStream fos, SWFCompression compression) {
        try {
            SWF.compress(fis, fos, compression, null);
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static boolean decompress(InputStream fis, OutputStream fos) {
        try {
            SWF.decompress(fis, fos, false);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static void decodeLZMAStream(InputStream is, OutputStream os, byte[] lzmaProperties, long fileSize) throws IOException {
        Decoder decoder = new Decoder();
        if (!decoder.SetDecoderProperties(lzmaProperties)) {
            throw new IOException("LZMA:Incorrect stream properties");
        }
        if (!decoder.Code(is, os, fileSize - 8L)) {
            throw new IOException("LZMA:Error in data stream");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static SWFHeader decompress(InputStream is, OutputStream os, boolean allowUncompressed) throws IOException {
        hdr = new byte[8];
        if (is.read(hdr) != 8) {
            throw new SwfOpenException("SWF header is too short");
        }
        signature = new String(hdr, 0, 3, Utf8Helper.charset);
        if (!SWF.swfSignatures.contains(signature)) {
            throw new SwfOpenException("Invalid SWF file, wrong signature.");
        }
        version = hdr[3];
        sis = new SWFInputStream(null, Arrays.copyOfRange(hdr, 4, 8), 4L, 4);
        var9_7 = null;
        try {
            fileSize = sis.readUI32("fileSize");
        }
        catch (Throwable var10_10) {
            var9_7 = var10_10;
            throw var10_10;
        }
        finally {
            if (sis != null) {
                if (var9_7 != null) {
                    try {
                        sis.close();
                    }
                    catch (Throwable var10_9) {
                        var9_7.addSuppressed(var10_9);
                    }
                } else {
                    sis.close();
                }
            }
        }
        header = new SWFHeader();
        header.version = version;
        header.fileSize = fileSize;
        header.gfx = hdr[1] == 70 && hdr[2] == 88;
        sos = new SWFOutputStream(os, version);
        var10_11 = null;
        try {
            sos.write(SWF.getHeaderBytes(SWFCompression.NONE, header.gfx));
            sos.writeUI8(version);
            sos.writeUI32(fileSize);
            switch (hdr[0]) {
                case 67: {
                    Helper.copyStream(new InflaterInputStream(is), os, fileSize - 8L);
                    header.compression = SWFCompression.ZLIB;
                    break;
                }
                case 90: {
                    lzmaprop = new byte[9];
                    is.read(lzmaprop);
                    sis = new SWFInputStream(null, lzmaprop);
                    var13_18 = null;
                    sis.readUI32("LZMAsize");
                    propertiesSize = 5;
                    lzmaProperties = sis.readBytes(propertiesSize, "lzmaproperties");
                    if (lzmaProperties.length != propertiesSize) {
                        throw new IOException("LZMA:input .lzma file is too short");
                    }
                    SWF.decodeLZMAStream(is, os, lzmaProperties, fileSize);
                    header.compression = SWFCompression.LZMA;
                    header.lzmaProperties = lzmaProperties;
                    if (sis == null) break;
                    if (var13_18 == null) ** GOTO lbl67
                    try {
                        sis.close();
                    }
                    catch (Throwable var14_20) {
                        var13_18.addSuppressed(var14_20);
                    }
                    break;
lbl67:
                    // 1 sources

                    sis.close();
                    break;
                    catch (Throwable var14_21) {
                        try {
                            var13_18 = var14_21;
                            throw var14_21;
                        }
                        catch (Throwable var16_23) {
                            if (sis != null) {
                                if (var13_18 != null) {
                                    try {
                                        sis.close();
                                    }
                                    catch (Throwable var17_24) {
                                        var13_18.addSuppressed(var17_24);
                                    }
                                } else {
                                    sis.close();
                                }
                            }
                            throw var16_23;
                        }
                    }
                }
                case 65: {
                    lzmaProperties = new byte[5];
                    is.read(lzmaProperties);
                    uncompressedLength = new byte[8];
                    is.read(uncompressedLength);
                    SWF.decodeLZMAStream(is, os, lzmaProperties, fileSize);
                    header.compression = SWFCompression.LZMA_ABC;
                    header.lzmaProperties = lzmaProperties;
                    break;
                }
                default: {
                    if (allowUncompressed) {
                        Helper.copyStream(is, os, fileSize - 8L);
                        break;
                    }
                    throw new IOException("SWF is not compressed");
                }
            }
            var11_13 = header;
            return var11_13;
        }
        catch (Throwable var11_14) {
            var10_11 = var11_14;
            throw var11_14;
        }
        finally {
            if (sos != null) {
                if (var10_11 != null) {
                    try {
                        sos.close();
                    }
                    catch (Throwable var12_17) {
                        var10_11.addSuppressed(var12_17);
                    }
                } else {
                    sos.close();
                }
            }
        }
    }

    public static boolean renameInvalidIdentifiers(RenameType renameType, InputStream fis, OutputStream fos) {
        try {
            SWF swf = new SWF(fis, Configuration.parallelSpeedUp.get());
            int cnt = swf.deobfuscateIdentifiers(renameType);
            swf.assignClassesToSymbols();
            System.out.println(cnt + " identifiers renamed.");
            swf.saveTo(fos);
        }
        catch (IOException | InterruptedException ex) {
            return false;
        }
        return true;
    }

    public List<ScriptPack> getScriptPacksByClassNames(List<String> classNames) throws Exception {
        HashSet<ScriptPack> resultSet = new HashSet<ScriptPack>();
        List<ABCContainerTag> abcList = this.getAbcList();
        ArrayList<ABC> allAbcList = new ArrayList<ABC>();
        for (int i = 0; i < abcList.size(); ++i) {
            allAbcList.add(abcList.get(i).getABC());
        }
        for (String className : classNames) {
            for (int i = 0; i < abcList.size(); ++i) {
                ABC abc = abcList.get(i).getABC();
                List<ScriptPack> scrs = abc.findScriptPacksByPath(className, allAbcList);
                for (int j = 0; j < scrs.size(); ++j) {
                    ScriptPack scr = scrs.get(j);
                    resultSet.add(scr);
                }
            }
        }
        return new ArrayList<ScriptPack>(resultSet);
    }

    private List<ScriptPack> uniqueAS3Packs(List<ScriptPack> packs) {
        ArrayList<ScriptPack> ret = new ArrayList<ScriptPack>();
        HashSet<ClassPath> classPaths = new HashSet<ClassPath>();
        for (ScriptPack item : packs) {
            ClassPath key = item.getClassPath();
            if (classPaths.contains(key)) {
                logger.log(Level.SEVERE, "Duplicate pack path found (" + key + ")!");
                continue;
            }
            classPaths.add(key);
            ret.add(item);
        }
        return ret;
    }

    public List<ScriptPack> getAS3Packs() {
        ArrayList<ScriptPack> packs = new ArrayList<ScriptPack>();
        List<ABCContainerTag> abcList = this.getAbcList();
        ArrayList<ABC> allAbcList = new ArrayList<ABC>();
        for (int i = 0; i < abcList.size(); ++i) {
            allAbcList.add(abcList.get(i).getABC());
        }
        for (ABCContainerTag abcTag : abcList) {
            packs.addAll(abcTag.getABC().getScriptPacks(null, allAbcList));
        }
        return this.uniqueAS3Packs(packs);
    }

    @Override
    public RECT getRect() {
        return this.displayRect;
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        return this.displayRect;
    }

    public EventListener getExportEventListener() {
        EventListener evl = new EventListener(){

            @Override
            public void handleExportingEvent(String type, int index, int count, Object data) {
                for (EventListener listener : SWF.this.listeners) {
                    listener.handleExportingEvent(type, index, count, data);
                }
            }

            @Override
            public void handleExportedEvent(String type, int index, int count, Object data) {
                for (EventListener listener : SWF.this.listeners) {
                    listener.handleExportedEvent(type, index, count, data);
                }
            }

            @Override
            public void handleEvent(String event, Object data) {
                SWF.this.informListeners(event, data);
            }
        };
        return evl;
    }

    public List<File> exportActionScript(AbortRetryIgnoreHandler handler, String outdir, ScriptExportSettings exportSettings, boolean parallel, EventListener evl) throws IOException {
        return this.exportActionScript(handler, outdir, null, exportSettings, parallel, evl, true, true);
    }

    public List<File> exportActionScript(AbortRetryIgnoreHandler handler, String outdir, List<ScriptPack> as3scripts, ScriptExportSettings exportSettings, boolean parallel, EventListener evl, boolean as2, boolean as3) throws IOException {
        ArrayList<File> ret = new ArrayList<File>();
        if (this.isAS3()) {
            if (as3) {
                ret.addAll(new AS3ScriptExporter().exportActionScript3(this, handler, outdir, as3scripts, exportSettings, parallel, evl));
            }
        } else if (as2) {
            ret.addAll(new AS2ScriptExporter().exportAS2Scripts(handler, outdir, this.getASMs(true), exportSettings, parallel, evl));
        }
        return ret;
    }

    public Map<String, ASMSource> getASMs(boolean exportFileNames) {
        return this.getASMs(exportFileNames, new ArrayList<TreeItem>(), true);
    }

    public Map<String, ASMSource> getASMs(boolean exportFileNames, List<TreeItem> nodesToExport, boolean exportAll) {
        HashMap<String, ASMSource> asmsToExport = new HashMap<String, ASMSource>();
        for (TreeItem treeItem : this.getFirstLevelASMNodes(null)) {
            this.getASMs(exportFileNames, treeItem, nodesToExport, exportAll, asmsToExport, File.separator + this.getASMPath(exportFileNames, treeItem));
        }
        return asmsToExport;
    }

    /*
     * WARNING - void declaration
     */
    private void getASMs(boolean exportFileNames, TreeItem treeItem, List<TreeItem> nodesToExport, boolean exportAll, Map<String, ASMSource> asmsToExport, String path) {
        block8: {
            block9: {
                boolean exportNode;
                block7: {
                    TreeItem realItem;
                    exportNode = nodesToExport.contains(treeItem);
                    TreeItem treeItem2 = realItem = treeItem instanceof TagScript ? ((TagScript)treeItem).getTag() : treeItem;
                    if (realItem instanceof ASMSource && (exportAll || exportNode)) {
                        String npath = path;
                        Object exPath = path;
                        boolean bl = true;
                        while (asmsToExport.containsKey(npath)) {
                            void var11_12;
                            npath = path + (exportFileNames ? "[" + (int)var11_12 + "]" : "_" + (int)(++var11_12));
                            exPath = path + "[" + (int)var11_12 + "]";
                        }
                        ((ASMSource)realItem).setScriptName((String)exPath);
                        asmsToExport.put(npath, (ASMSource)realItem);
                    }
                    if (!(treeItem instanceof TagScript)) break block7;
                    TagScript tagScript = (TagScript)treeItem;
                    for (TreeItem treeItem3 : tagScript.getFrames()) {
                        this.getASMs(exportFileNames, treeItem3, nodesToExport, exportAll, asmsToExport, path + File.separator + this.getASMPath(exportFileNames, treeItem3));
                    }
                    break block8;
                }
                if (!(treeItem instanceof FrameScript)) break block9;
                FrameScript frameScript = (FrameScript)treeItem;
                Frame parentFrame = frameScript.getFrame();
                for (TreeItem treeItem4 : parentFrame.actionContainers) {
                    this.getASMs(exportFileNames, this.getASMWrapToTagScript(treeItem4), nodesToExport, exportAll || exportNode, asmsToExport, path + File.separator + this.getASMPath(exportFileNames, treeItem4));
                }
                for (TreeItem treeItem5 : parentFrame.actions) {
                    this.getASMs(exportFileNames, this.getASMWrapToTagScript(treeItem5), nodesToExport, exportAll || exportNode, asmsToExport, path + File.separator + this.getASMPath(exportFileNames, treeItem5));
                }
                break block8;
            }
            if (!(treeItem instanceof AS2Package)) break block8;
            AS2Package as2Package = (AS2Package)treeItem;
            for (TreeItem treeItem6 : as2Package.subPackages.values()) {
                this.getASMs(exportFileNames, treeItem6, nodesToExport, exportAll, asmsToExport, path + File.separator + this.getASMPath(exportFileNames, treeItem6));
            }
            for (TreeItem treeItem7 : as2Package.scripts.values()) {
                this.getASMs(exportFileNames, treeItem7, nodesToExport, exportAll, asmsToExport, path + File.separator + this.getASMPath(exportFileNames, treeItem7));
            }
        }
    }

    private String getASMPath(boolean exportFileName, TreeItem treeItem) {
        if (!exportFileName) {
            return treeItem.toString();
        }
        String result = treeItem instanceof Exportable ? ((Exportable)treeItem).getExportFileName() : treeItem.toString();
        return Helper.makeFileName(result);
    }

    private TreeItem getASMWrapToTagScript(TreeItem treeItem) {
        if (treeItem instanceof Tag) {
            Tag resultTag = (Tag)treeItem;
            ArrayList<TreeItem> subNodes = new ArrayList<TreeItem>();
            if (treeItem instanceof ASMSourceContainer) {
                for (ASMSource aSMSource : ((ASMSourceContainer)treeItem).getSubItems()) {
                    subNodes.add(aSMSource);
                }
            }
            TagScript tagScript = new TagScript(treeItem.getSwf(), resultTag, subNodes);
            return tagScript;
        }
        return treeItem;
    }

    public List<TreeItem> getFirstLevelASMNodes(Map<Tag, TagScript> tagScriptCache) {
        Timeline timeline = this.getTimeline();
        ArrayList<TreeItem> subNodes = new ArrayList<TreeItem>();
        ArrayList<TagScript> subFrames = new ArrayList<TagScript>();
        subNodes.addAll(timeline.getAS2RootPackage().subPackages.values());
        subNodes.addAll(timeline.getAS2RootPackage().scripts.values());
        for (Tag tag : timeline.otherTags) {
            boolean hasInnerFrames = false;
            ArrayList<TreeItem> tagSubNodes = new ArrayList<TreeItem>();
            if (tag instanceof Timelined) {
                Timeline timeline2 = ((Timelined)((Object)tag)).getTimeline();
                for (Frame frame : timeline2.getFrames()) {
                    if (frame.actions.isEmpty() && frame.actionContainers.isEmpty()) continue;
                    FrameScript frameScript = new FrameScript(this, frame);
                    tagSubNodes.add(frameScript);
                    hasInnerFrames = true;
                }
            }
            if (tag instanceof ASMSourceContainer) {
                for (ASMSource aSMSource : ((ASMSourceContainer)((Object)tag)).getSubItems()) {
                    tagSubNodes.add(aSMSource);
                }
            }
            if (tagSubNodes.isEmpty()) continue;
            TagScript ts = new TagScript(this, tag, tagSubNodes);
            if (tagScriptCache != null) {
                tagScriptCache.put(tag, ts);
            }
            if (hasInnerFrames) {
                subFrames.add(ts);
                continue;
            }
            subNodes.add(ts);
        }
        subNodes.addAll(subFrames);
        for (Frame frame : timeline.getFrames()) {
            if (frame.actions.isEmpty() && frame.actionContainers.isEmpty()) continue;
            FrameScript frameScript = new FrameScript(this, frame);
            subNodes.add(frameScript);
        }
        return subNodes;
    }

    public final void addEventListener(EventListener listener) {
        this.listeners.add(listener);
        for (Tag t : this.getTags()) {
            if (!(t instanceof ABCContainerTag)) continue;
            ((ABCContainerTag)((Object)t)).getABC().addEventListener(listener);
        }
    }

    public final void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
        for (Tag t : this.getTags()) {
            if (!(t instanceof ABCContainerTag)) continue;
            ((ABCContainerTag)((Object)t)).getABC().removeEventListener(listener);
        }
    }

    protected void informListeners(String event, Object data) {
        for (EventListener listener : this.listeners) {
            listener.handleEvent(event, data);
        }
    }

    public static void populateVideoFrames(int streamId, Iterable<Tag> tags, HashMap<Integer, VideoFrameTag> output) {
        for (Tag t : tags) {
            if (t instanceof VideoFrameTag) {
                VideoFrameTag videoFrameTag = (VideoFrameTag)t;
                if (videoFrameTag.streamID == streamId) {
                    output.put(videoFrameTag.frameNum, (VideoFrameTag)t);
                }
            }
            if (!(t instanceof DefineSpriteTag)) continue;
            SWF.populateVideoFrames(streamId, ((DefineSpriteTag)t).getTags(), output);
        }
    }

    private static void writeLE(OutputStream os, long val, int size) throws IOException {
        for (int i = 0; i < size; ++i) {
            os.write((int)(val & 0xFFL));
            val >>= 8;
        }
    }

    public static void createWavFromPcmData(OutputStream fos, int soundRateHz, boolean soundSize, boolean soundType, byte[] data) throws IOException {
        ByteArrayOutputStream subChunk1Data = new ByteArrayOutputStream();
        int audioFormat = 1;
        SWF.writeLE(subChunk1Data, audioFormat, 2);
        int numChannels = soundType ? 2 : 1;
        SWF.writeLE(subChunk1Data, numChannels, 2);
        int[] rateMap = new int[]{5512, 11025, 22050, 44100};
        int sampleRate = soundRateHz;
        SWF.writeLE(subChunk1Data, sampleRate, 4);
        int bitsPerSample = soundSize ? 16 : 8;
        int byteRate = sampleRate * numChannels * bitsPerSample / 8;
        SWF.writeLE(subChunk1Data, byteRate, 4);
        int blockAlign = numChannels * bitsPerSample / 8;
        SWF.writeLE(subChunk1Data, blockAlign, 2);
        SWF.writeLE(subChunk1Data, bitsPerSample, 2);
        ByteArrayOutputStream chunks = new ByteArrayOutputStream();
        chunks.write(Utf8Helper.getBytes("fmt "));
        byte[] subChunk1DataBytes = subChunk1Data.toByteArray();
        SWF.writeLE(chunks, subChunk1DataBytes.length, 4);
        chunks.write(subChunk1DataBytes);
        chunks.write(Utf8Helper.getBytes("data"));
        SWF.writeLE(chunks, data.length, 4);
        chunks.write(data);
        fos.write(Utf8Helper.getBytes("RIFF"));
        byte[] chunkBytes = chunks.toByteArray();
        SWF.writeLE(fos, 4 + chunkBytes.length, 4);
        fos.write(Utf8Helper.getBytes("WAVE"));
        fos.write(chunkBytes);
    }

    public static String getTypePrefix(CharacterTag c) {
        if (c instanceof ShapeTag) {
            return "shape";
        }
        if (c instanceof MorphShapeTag) {
            return "morphshape";
        }
        if (c instanceof DefineSpriteTag) {
            return "sprite";
        }
        if (c instanceof TextTag) {
            return "text";
        }
        if (c instanceof ButtonTag) {
            return "button";
        }
        if (c instanceof FontTag) {
            return "font";
        }
        if (c instanceof ImageTag) {
            return "image";
        }
        return "character";
    }

    public static void writeLibrary(SWF fswf, Set<Integer> library, OutputStream fos) throws IOException {
        for (int c : library) {
            StringBuilder sb;
            CharacterTag ch = fswf.getCharacter(c);
            if (ch instanceof FontTag) {
                sb = new StringBuilder();
                sb.append("function ").append(SWF.getTypePrefix(ch)).append(c).append("(ctx,ch,textColor){\r\n");
                ((FontTag)ch).toHtmlCanvas(sb, 1.0);
                sb.append("}\r\n\r\n");
                fos.write(Utf8Helper.getBytes(sb.toString()));
                continue;
            }
            if (ch instanceof ImageTag) {
                ImageTag image = (ImageTag)ch;
                ImageFormat format = image.getImageFormat();
                byte[] imageData = Helper.readStream(image.getImageData());
                String base64ImgData = Helper.byteArrayToBase64String(imageData);
                fos.write(Utf8Helper.getBytes("var imageObj" + c + " = document.createElement(\"img\");\r\nimageObj" + c + ".src=\"data:image/" + (Object)((Object)format) + ";base64," + base64ImgData + "\";\r\n"));
            }
            fos.write(Utf8Helper.getBytes("function " + SWF.getTypePrefix(ch) + c + "(ctx,ctrans,frame,ratio,time){\r\n"));
            if (ch instanceof DrawableTag) {
                sb = new StringBuilder();
                ((DrawableTag)ch).toHtmlCanvas(sb, 1.0);
                fos.write(Utf8Helper.getBytes(sb.toString()));
            }
            fos.write(Utf8Helper.getBytes("}\r\n\r\n"));
        }
    }

    private static void getVariables(ConstantPool constantPool, BaseLocalData localData, TranslateStack stack, List<GraphTargetItem> output, ActionGraphSource code, int ip, List<MyEntry<DirectValueActionItem, ConstantPool>> variables, List<GraphSourceItem> functions, HashMap<DirectValueActionItem, ConstantPool> strings, List<Integer> visited, HashMap<DirectValueActionItem, String> usageTypes, String path) throws InterruptedException {
        boolean debugMode = false;
        while (ip > -1 && ip < code.size() && !visited.contains(ip)) {
            GraphTargetItem top;
            GraphSourceItem ins = code.get(ip);
            if (debugMode) {
                System.err.println("Visit " + ip + ": ofs" + Helper.formatAddress(((Action)ins).getAddress()) + ":" + ((Action)ins).getASMSource(new ActionList(), new HashSet<Long>(), ScriptExportMode.PCODE) + " stack:" + Helper.stackToString(stack, LocalData.create(new ConstantPool())));
            }
            if (ins.isExit()) break;
            if (ins.isIgnored()) {
                ++ip;
                continue;
            }
            String usageType = "name";
            GraphTargetItem name = null;
            if (ins instanceof ActionGetVariable || ins instanceof ActionGetMember || ins instanceof ActionDefineLocal2 || ins instanceof ActionNewMethod || ins instanceof ActionNewObject || ins instanceof ActionCallMethod || ins instanceof ActionCallFunction) {
                if (stack.isEmpty()) break;
                name = stack.peek();
            }
            if (ins instanceof ActionGetVariable || ins instanceof ActionDefineLocal2) {
                usageType = "variable";
            }
            if (ins instanceof ActionGetMember) {
                usageType = "member";
            }
            if (ins instanceof ActionNewMethod || ins instanceof ActionNewObject) {
                usageType = "class";
            }
            if (ins instanceof ActionCallMethod) {
                usageType = "function";
            }
            if (ins instanceof ActionCallFunction) {
                usageType = "function";
            }
            if (ins instanceof ActionDefineFunction || ins instanceof ActionDefineFunction2) {
                functions.add(ins);
            }
            if (ins instanceof GraphSourceItemContainer) {
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)ins);
                List<Long> cntSizes = cnt.getContainerSizes();
                long addr = code.pos2adr(ip + 1);
                ip = code.adr2pos(addr);
                String cntName = cnt.getName();
                for (Long size : cntSizes) {
                    if (size == 0L) continue;
                    ip = code.adr2pos(addr);
                    int nextip = code.adr2pos(addr += size.longValue());
                    SWF.getVariables(variables, functions, strings, usageTypes, new ActionGraphSource(code.getActions().subList(ip, nextip), code.version, new HashMap<Integer, String>(), new HashMap<String, GraphTargetItem>(), new HashMap<String, GraphTargetItem>()), 0, path + (cntName == null ? "" : "/" + cntName));
                    ip = nextip;
                }
                ArrayList<List<GraphTargetItem>> r = new ArrayList<List<GraphTargetItem>>();
                r.add(new ArrayList());
                r.add(new ArrayList());
                r.add(new ArrayList());
                ((GraphSourceItemContainer)((Object)ins)).translateContainer(r, ins, stack, output, new HashMap<Integer, String>(), new HashMap<String, GraphTargetItem>(), new HashMap<String, GraphTargetItem>());
                continue;
            }
            if (ins instanceof ActionSetVariable || ins instanceof ActionSetMember || ins instanceof ActionDefineLocal) {
                if (stack.size() < 2) break;
                name = stack.get(stack.size() - 2);
            }
            if (ins instanceof ActionSetVariable || ins instanceof ActionDefineLocal) {
                usageType = "variable";
            }
            if (ins instanceof ActionSetMember) {
                usageType = "member";
            }
            if (name instanceof DirectValueActionItem) {
                variables.add(new MyEntry<DirectValueActionItem, ConstantPool>((DirectValueActionItem)name, constantPool));
                usageTypes.put((DirectValueActionItem)name, usageType);
            }
            if ((ins instanceof ActionEquals || ins instanceof ActionEquals2) && stack.size() == 1 && stack.peek() instanceof DirectValueActionItem) {
                stack.push(new DirectValueActionItem(null, null, 0, Null.INSTANCE, new ArrayList<String>()));
            }
            if (ins instanceof ActionConstantPool) {
                constantPool = new ConstantPool(((ActionConstantPool)ins).constantPool);
            }
            int staticOperation = 0;
            int requiredStackSize = ins.getStackPopCount(localData, stack);
            if (stack.size() < requiredStackSize) break;
            ins.translate(localData, stack, output, staticOperation, path);
            if (ins.isExit()) break;
            if (ins instanceof ActionPush && !stack.isEmpty() && (top = stack.peek()) instanceof DirectValueActionItem) {
                DirectValueActionItem dvt = (DirectValueActionItem)top;
                if (dvt.value instanceof String || dvt.value instanceof ConstantIndex) {
                    if (constantPool == null) {
                        constantPool = new ConstantPool(dvt.constants);
                    }
                    strings.put(dvt, constantPool);
                }
            }
            if (ins.isBranch() || ins.isJump()) {
                if (ins instanceof ActionIf) {
                    if (stack.isEmpty()) break;
                    stack.pop();
                }
                visited.add(ip);
                List<Integer> branches = ins.getBranches(code);
                for (int b : branches) {
                    TranslateStack brStack = (TranslateStack)stack.clone();
                    if (b >= 0) {
                        SWF.getVariables(constantPool, localData, brStack, output, code, b, variables, functions, strings, visited, usageTypes, path);
                        continue;
                    }
                    if (!debugMode) continue;
                    System.out.println("Negative branch:" + b);
                }
                break;
            }
            ++ip;
        }
    }

    private static void getVariables(List<MyEntry<DirectValueActionItem, ConstantPool>> variables, List<GraphSourceItem> functions, HashMap<DirectValueActionItem, ConstantPool> strings, HashMap<DirectValueActionItem, String> usageTypes, ActionGraphSource code, int addr, String path) throws InterruptedException {
        ActionLocalData localData = new ActionLocalData();
        SWF.getVariables(null, localData, new TranslateStack(path), new ArrayList<GraphTargetItem>(), code, code.adr2pos(addr), variables, functions, strings, new ArrayList<Integer>(), usageTypes, path);
    }

    private List<MyEntry<DirectValueActionItem, ConstantPool>> getVariables(List<MyEntry<DirectValueActionItem, ConstantPool>> variables, HashMap<ASMSource, ActionList> actionsMap, List<GraphSourceItem> functions, HashMap<DirectValueActionItem, ConstantPool> strings, HashMap<DirectValueActionItem, String> usageTypes, ASMSource src, String path) throws InterruptedException {
        ArrayList<MyEntry<DirectValueActionItem, ConstantPool>> ret = new ArrayList<MyEntry<DirectValueActionItem, ConstantPool>>();
        ActionList actions = src.getActions();
        actionsMap.put(src, actions);
        SWF.getVariables(variables, functions, strings, usageTypes, new ActionGraphSource(actions, this.version, new HashMap<Integer, String>(), new HashMap<String, GraphTargetItem>(), new HashMap<String, GraphTargetItem>()), 0, path);
        return ret;
    }

    private void getVariables(Iterable<Tag> tags, String path, List<MyEntry<DirectValueActionItem, ConstantPool>> variables, HashMap<ASMSource, ActionList> actionsMap, List<GraphSourceItem> functions, HashMap<DirectValueActionItem, ConstantPool> strings, HashMap<DirectValueActionItem, String> usageTypes) throws InterruptedException {
        ArrayList<String> processed = new ArrayList<String>();
        for (Tag t : tags) {
            String subPath = path + "/" + t.toString();
            if (t instanceof ASMSource) {
                this.addVariable((ASMSource)((Object)t), subPath, processed, variables, actionsMap, functions, strings, usageTypes);
            }
            if (t instanceof ASMSourceContainer) {
                ArrayList<String> processed2 = new ArrayList<String>();
                for (ASMSource aSMSource : ((ASMSourceContainer)((Object)t)).getSubItems()) {
                    this.addVariable(aSMSource, subPath + "/" + aSMSource.toString(), processed2, variables, actionsMap, functions, strings, usageTypes);
                }
            }
            if (!(t instanceof DefineSpriteTag)) continue;
            this.getVariables(((DefineSpriteTag)t).getTags(), path + "/" + t.toString(), variables, actionsMap, functions, strings, usageTypes);
        }
    }

    private void addVariable(ASMSource asm, String path, List<String> processed, List<MyEntry<DirectValueActionItem, ConstantPool>> variables, HashMap<ASMSource, ActionList> actionsMap, List<GraphSourceItem> functions, HashMap<DirectValueActionItem, ConstantPool> strings, HashMap<DirectValueActionItem, String> usageTypes) throws InterruptedException {
        int pos = 1;
        String infPath2 = path;
        while (processed.contains(infPath2)) {
            infPath2 = path + "[" + ++pos + "]";
        }
        processed.add(infPath2);
        this.informListeners("getVariables", infPath2);
        this.getVariables(variables, actionsMap, functions, strings, usageTypes, asm, path);
    }

    public boolean as3StringConstantExists(String str) {
        for (ABCContainerTag abcTag : this.getAbcList()) {
            ABC abc = abcTag.getABC();
            for (int i = 1; i < abc.constants.getStringCount(); ++i) {
                if (!abc.constants.getString(i).equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    public void fixAS3Code() {
        for (ABCContainerTag abcTag : this.getAbcList()) {
            ABC abc = abcTag.getABC();
            for (MethodBody body : abc.bodies) {
                AVM2Code code = body.getCode();
                body.setCodeBytes(code.getBytes());
            }
            ((Tag)((Object)abcTag)).setModified(true);
        }
    }

    public int deobfuscateAS3Identifiers(RenameType renameType) {
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof ABCContainerTag)) continue;
            ((ABCContainerTag)((Object)tag)).getABC().deobfuscateIdentifiers(this.deobfuscated, renameType, true);
            tag.setModified(true);
        }
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof ABCContainerTag)) continue;
            ((ABCContainerTag)((Object)tag)).getABC().deobfuscateIdentifiers(this.deobfuscated, renameType, false);
            tag.setModified(true);
        }
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof SymbolClassTag)) continue;
            SymbolClassTag sc = (SymbolClassTag)tag;
            for (int i = 0; i < sc.names.size(); ++i) {
                String newname = this.deobfuscation.deobfuscateNameWithPackage(true, sc.names.get(i), this.deobfuscated, renameType, this.deobfuscated);
                if (newname == null) continue;
                sc.names.set(i, newname);
            }
            sc.setModified(true);
        }
        this.deobfuscation.deobfuscateInstanceNames(true, this.deobfuscated, renameType, this.getTags(), new HashMap<DottedChain, DottedChain>());
        return this.deobfuscated.size();
    }

    public int deobfuscateIdentifiers(RenameType renameType) throws InterruptedException {
        FileAttributesTag fileAttributes = this.getFileAttributes();
        if (fileAttributes == null) {
            int cnt = 0;
            cnt += this.deobfuscateAS2Identifiers(renameType);
            return cnt += this.deobfuscateAS3Identifiers(renameType);
        }
        if (fileAttributes.actionScript3) {
            return this.deobfuscateAS3Identifiers(renameType);
        }
        return this.deobfuscateAS2Identifiers(renameType);
    }

    public void renameAS2Identifier(String identifier, String newname) throws InterruptedException {
        HashMap<DottedChain, DottedChain> selected = new HashMap<DottedChain, DottedChain>();
        selected.put(DottedChain.parseWithSuffix(identifier), DottedChain.parseWithSuffix(newname));
        this.renameAS2Identifiers(null, selected);
    }

    private int deobfuscateAS2Identifiers(RenameType renameType) throws InterruptedException {
        return this.renameAS2Identifiers(renameType, null);
    }

    /*
     * WARNING - void declaration
     */
    private int renameAS2Identifiers(RenameType renameType, Map<DottedChain, DottedChain> selected) throws InterruptedException {
        HashMap<ASMSource, ActionList> actionsMap = new HashMap<ASMSource, ActionList>();
        ArrayList<GraphSourceItem> allFunctions = new ArrayList<GraphSourceItem>();
        ArrayList<MyEntry<DirectValueActionItem, ConstantPool>> allVariableNames = new ArrayList<MyEntry<DirectValueActionItem, ConstantPool>>();
        HashMap<DirectValueActionItem, ConstantPool> allStrings = new HashMap<DirectValueActionItem, ConstantPool>();
        HashMap<DirectValueActionItem, String> usageTypes = new HashMap<DirectValueActionItem, String>();
        int ret = 0;
        this.getVariables(this.getTags(), "", allVariableNames, actionsMap, allFunctions, allStrings, usageTypes);
        this.informListeners("rename", "");
        int fc = 0;
        for (MyEntry myEntry : allVariableNames) {
            String name = ((DirectValueActionItem)myEntry.getKey()).toStringNoH((ConstantPool)myEntry.getValue());
            this.deobfuscation.allVariableNamesStr.add(name);
        }
        this.informListeners("rename", "classes");
        int classCount = 0;
        for (Object t : this.getTags()) {
            if (!(t instanceof DoInitActionTag)) continue;
            ++classCount;
        }
        boolean bl = false;
        for (Tag t : this.getTags()) {
            List<GraphTargetItem> dec;
            void var11_15;
            if (!(t instanceof DoInitActionTag)) continue;
            this.informListeners("rename", "class " + (int)(++var11_15) + "/" + classCount);
            DoInitActionTag dia = (DoInitActionTag)t;
            String string2 = this.getExportName(dia.spriteId);
            string2 = string2 != null ? string2 : "_unk_";
            String string3 = "__Packages.";
            String[] classNameParts = null;
            if (string2.startsWith("__Packages.")) {
                String className = string2.substring("__Packages.".length());
                classNameParts = className.contains(".") ? className.split("\\.") : new String[]{className};
            }
            int staticOperation = 0;
            try {
                dec = Action.actionsToTree(dia.getActions(), this.version, staticOperation, "");
            }
            catch (EmptyStackException ex) {
                continue;
            }
            GraphTargetItem name = null;
            for (GraphTargetItem it : dec) {
                if (it instanceof ClassActionItem) {
                    DirectValueActionItem dvf;
                    String changed;
                    ClassActionItem cti = (ClassActionItem)it;
                    ArrayList<GraphTargetItem> methods = new ArrayList<GraphTargetItem>();
                    methods.addAll(cti.functions);
                    methods.addAll(cti.staticFunctions);
                    for (GraphTargetItem graphTargetItem : methods) {
                        String fname;
                        if (!(graphTargetItem instanceof FunctionActionItem)) continue;
                        FunctionActionItem fun = (FunctionActionItem)graphTargetItem;
                        if (!(fun.calculatedFunctionName instanceof DirectValueActionItem) || (changed = this.deobfuscation.deobfuscateName(false, fname = (dvf = (DirectValueActionItem)fun.calculatedFunctionName).toStringNoH(null), false, "method", this.deobfuscated, renameType, selected)) == null) continue;
                        this.deobfuscated.put(DottedChain.parseWithSuffix(fname), DottedChain.parseWithSuffix(changed));
                    }
                    ArrayList<GraphTargetItem> vars = new ArrayList<GraphTargetItem>();
                    for (MyEntry<GraphTargetItem, GraphTargetItem> item : cti.vars) {
                        vars.add(item.getKey());
                    }
                    for (MyEntry<GraphTargetItem, GraphTargetItem> item : cti.staticVars) {
                        vars.add(item.getKey());
                    }
                    for (GraphTargetItem gti3 : vars) {
                        String vname;
                        if (!(gti3 instanceof DirectValueActionItem) || (changed = this.deobfuscation.deobfuscateName(false, vname = (dvf = (DirectValueActionItem)gti3).toStringNoH(null), false, "attribute", this.deobfuscated, renameType, selected)) == null) continue;
                        this.deobfuscated.put(DottedChain.parseWithSuffix(vname), DottedChain.parseWithSuffix(changed));
                    }
                    name = cti.className;
                    break;
                }
                if (!(it instanceof InterfaceActionItem)) continue;
                InterfaceActionItem ift = (InterfaceActionItem)it;
                name = ift.name;
            }
            if (name != null) {
                int pos = 0;
                while (name instanceof GetMemberActionItem) {
                    GetMemberActionItem mem = (GetMemberActionItem)name;
                    GraphTargetItem memberName = mem.memberName;
                    if (memberName instanceof DirectValueActionItem) {
                        void var26_61;
                        void var26_59;
                        String changedNameStr2;
                        DirectValueActionItem dvt = (DirectValueActionItem)memberName;
                        String nameStr = dvt.toStringNoH(null);
                        if (classNameParts != null && classNameParts.length - 1 - pos < 0) break;
                        String string4 = nameStr;
                        if (classNameParts != null) {
                            String string5 = classNameParts[classNameParts.length - 1 - pos];
                        }
                        if ((changedNameStr2 = this.deobfuscation.deobfuscateName(false, (String)var26_59, pos == 0, pos == 0 ? "class" : "package", this.deobfuscated, renameType, selected)) != null) {
                            String string6 = changedNameStr2;
                        }
                        ++ret;
                        this.deobfuscated.put(DottedChain.parseWithSuffix(nameStr), DottedChain.parseWithSuffix((String)var26_61));
                        ++pos;
                    }
                    name = mem.object;
                }
                if (name instanceof GetVariableActionItem) {
                    GetVariableActionItem var = (GetVariableActionItem)name;
                    if (var.name instanceof DirectValueActionItem) {
                        String string7;
                        DirectValueActionItem dvt = (DirectValueActionItem)var.name;
                        String nameStr = dvt.toStringNoH(null);
                        if (classNameParts != null && classNameParts.length - 1 - pos < 0) break;
                        String changedNameStr = nameStr;
                        if (classNameParts != null) {
                            changedNameStr = classNameParts[classNameParts.length - 1 - pos];
                        }
                        if ((string7 = this.deobfuscation.deobfuscateName(false, changedNameStr, pos == 0, pos == 0 ? "class" : "package", this.deobfuscated, renameType, selected)) != null) {
                            changedNameStr = string7;
                        }
                        ++ret;
                        this.deobfuscated.put(DottedChain.parseWithSuffix(nameStr), DottedChain.parseWithSuffix(changedNameStr));
                        ++pos;
                    }
                }
            }
            t.setModified(true);
        }
        for (GraphSourceItem fun : allFunctions) {
            String string;
            Object f;
            this.informListeners("rename", "function " + ++fc + "/" + allFunctions.size());
            if (fun instanceof ActionDefineFunction) {
                f = (ActionDefineFunction)fun;
                if (((ActionDefineFunction)f).functionName.isEmpty()) continue;
                String string8 = this.deobfuscation.deobfuscateName(false, ((ActionDefineFunction)f).functionName, false, "function", this.deobfuscated, renameType, selected);
                if (string8 != null) {
                    ((ActionDefineFunction)f).replacedFunctionName = string8;
                    ++ret;
                }
            }
            if (!(fun instanceof ActionDefineFunction2)) continue;
            f = (ActionDefineFunction2)fun;
            if (((ActionDefineFunction2)f).functionName.isEmpty() || (string = this.deobfuscation.deobfuscateName(false, ((ActionDefineFunction2)f).functionName, false, "function", this.deobfuscated, renameType, selected)) == null) continue;
            ((ActionDefineFunction2)f).replacedFunctionName = string;
            ++ret;
        }
        HashSet<String> stringsNoVarH = new HashSet<String>();
        ArrayList allVariableNamesDv = new ArrayList();
        for (MyEntry myEntry : allVariableNames) {
            allVariableNamesDv.add(myEntry.getKey());
        }
        for (DirectValueActionItem directValueActionItem : allStrings.keySet()) {
            if (allVariableNamesDv.contains(directValueActionItem)) continue;
            stringsNoVarH.add(System.identityHashCode(allStrings.get(directValueActionItem)) + "_" + directValueActionItem.toStringNoH(allStrings.get(directValueActionItem)));
        }
        int vc = 0;
        for (MyEntry myEntry : allVariableNames) {
            ++vc;
            String name = ((DirectValueActionItem)myEntry.getKey()).toStringNoH((ConstantPool)myEntry.getValue());
            String changed = this.deobfuscation.deobfuscateName(false, name, false, usageTypes.get(myEntry.getKey()), this.deobfuscated, renameType, selected);
            if (changed == null) continue;
            boolean addNew = false;
            String h = System.identityHashCode(myEntry.getKey()) + "_" + name;
            if (stringsNoVarH.contains(h)) {
                addNew = true;
            }
            ActionPush pu = (ActionPush)((DirectValueActionItem)myEntry.getKey()).getSrc();
            if (pu.replacement == null) {
                pu.replacement = new ArrayList<Object>();
                pu.replacement.addAll(pu.values);
            }
            if (pu.replacement.get(((DirectValueActionItem)myEntry.getKey()).pos) instanceof ConstantIndex) {
                ConstantIndex ci = (ConstantIndex)pu.replacement.get(((DirectValueActionItem)myEntry.getKey()).pos);
                ConstantPool pool = (ConstantPool)myEntry.getValue();
                if (pool == null || pool.constants == null) continue;
                if (addNew) {
                    pool.constants.add(changed);
                    ci.index = pool.constants.size() - 1;
                } else {
                    pool.constants.set(ci.index, changed);
                }
            } else {
                pu.replacement.set(((DirectValueActionItem)myEntry.getKey()).pos, changed);
            }
            ++ret;
        }
        for (ASMSource aSMSource : actionsMap.keySet()) {
            actionsMap.get(aSMSource).removeNops();
            aSMSource.setActions(actionsMap.get(aSMSource));
            aSMSource.setModified();
        }
        this.deobfuscation.deobfuscateInstanceNames(false, this.deobfuscated, renameType, this.getTags(), selected);
        return ret;
    }

    public IdentifiersDeobfuscation getDeobfuscation() {
        return this.deobfuscation;
    }

    public void exportFla(AbortRetryIgnoreHandler handler, String outfile, String swfName, String generator, String generatorVerName, String generatorVersion, boolean parallel, FLAVersion version) throws IOException, InterruptedException {
        XFLExportSettings settings = new XFLExportSettings();
        settings.compressed = true;
        this.exportXfl(handler, outfile, swfName, generator, generatorVerName, generatorVersion, parallel, version, settings);
    }

    public void exportXfl(AbortRetryIgnoreHandler handler, String outfile, String swfName, String generator, String generatorVerName, String generatorVersion, boolean parallel, FLAVersion version) throws IOException, InterruptedException {
        XFLExportSettings settings = new XFLExportSettings();
        settings.compressed = false;
        this.exportXfl(handler, outfile, swfName, generator, generatorVerName, generatorVersion, parallel, version, settings);
    }

    public void exportXfl(AbortRetryIgnoreHandler handler, String outfile, String swfName, String generator, String generatorVerName, String generatorVersion, boolean parallel, FLAVersion version, XFLExportSettings settings) throws IOException, InterruptedException {
        new XFLConverter().convertSWF(handler, this, swfName, outfile, settings, generator, generatorVerName, generatorVersion, parallel, version);
        this.clearAllCache();
    }

    public static AffineTransform matrixToTransform(MATRIX mat) {
        return new AffineTransform(mat.getScaleXFloat(), mat.getRotateSkew0Float(), mat.getRotateSkew1Float(), mat.getScaleYFloat(), mat.translateX, mat.translateY);
    }

    public SerializableImage getFromCache(String key) {
        if (this.frameCache.contains(key)) {
            return this.frameCache.get(key);
        }
        return null;
    }

    public byte[] getFromCache(SoundTag soundTag) {
        if (this.soundCache.contains(soundTag)) {
            return this.soundCache.get(soundTag);
        }
        return null;
    }

    public void putToCache(String key, SerializableImage img) {
        if (Configuration.useFrameCache.get().booleanValue()) {
            this.frameCache.put(key, img);
        }
    }

    public void putToCache(SoundTag soundTag, byte[] data) {
        this.soundCache.put(soundTag, data);
    }

    public void clearImageCache() {
        this.jtt = null;
        this.frameCache.clear();
        this.rectCache.clear();
        for (Tag tag : this.getTags()) {
            if (tag instanceof ImageTag) {
                ((ImageTag)tag).clearCache();
                continue;
            }
            if (!(tag instanceof DefineCompactedFont)) continue;
            ((DefineCompactedFont)tag).rebuildShapeCache();
        }
    }

    public void clearSoundCache() {
        this.soundCache.clear();
    }

    public void clearScriptCache() {
        this.as2PcodeCache.clear();
        this.as2Cache.clear();
        this.as3Cache.clear();
        IdentifiersDeobfuscation.clearCache();
    }

    public void clearReadOnlyListCache() {
        this.readOnlyTags = null;
        for (Tag tag : this.tags) {
            if (!(tag instanceof DefineSpriteTag)) continue;
            ((DefineSpriteTag)tag).clearReadOnlyListCache();
        }
    }

    public static void clearAllStaticCache() {
        Cache.clearAll();
        Helper.clearShapeCache();
        System.gc();
    }

    public void clearAbcListCache() {
        this.abcList = null;
    }

    public void clearAllCache() {
        this.characters = null;
        this.characterIdTags = null;
        this.clearAbcListCache();
        this.timeline = null;
        this.clearReadOnlyListCache();
        this.clearImageCache();
        this.clearScriptCache();
        SWF.clearAllStaticCache();
    }

    public static void uncache(ASMSource src) {
        if (src != null) {
            SWF swf = src.getSwf();
            swf.as2Cache.remove(src);
            swf.as2PcodeCache.remove(src);
        }
    }

    public static void uncache(ScriptPack pack) {
        if (pack != null) {
            pack.getSwf().as3Cache.remove(pack);
        }
    }

    public static boolean isCached(ASMSource src) {
        return src.getSwf().as2Cache.contains(src);
    }

    public static boolean isCached(ScriptPack pack) {
        return pack.getSwf().as3Cache.contains(pack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionList getCachedActionList(ASMSource src, List<DisassemblyListener> listeners) throws InterruptedException {
        ASMSource aSMSource = src;
        synchronized (aSMSource) {
            int deobfuscationMode;
            SWF swf = src.getSwf();
            int n = deobfuscationMode = Configuration.autoDeobfuscate.get() != false ? 1 : 0;
            if (swf != null && swf.as2PcodeCache.contains(src)) {
                ActionList result = swf.as2PcodeCache.get(src);
                if (result.deobfuscationMode == deobfuscationMode) {
                    return result;
                }
            }
            try {
                ByteArrayRange actionBytes = src.getActionBytes();
                int prevLength = actionBytes.getPos();
                SWFInputStream rri = new SWFInputStream(swf, actionBytes.getArray());
                if (prevLength != 0) {
                    rri.seek(prevLength);
                }
                int version = swf == null ? 10 : swf.version;
                ActionList list = ActionListReader.readActionListTimeout(listeners, rri, version, prevLength, prevLength + actionBytes.getLength(), src.toString(), deobfuscationMode);
                list.fileData = actionBytes.getArray();
                list.deobfuscationMode = deobfuscationMode;
                if (swf != null) {
                    swf.as2PcodeCache.put(src, list);
                }
                return list;
            }
            catch (InterruptedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
                return new ActionList();
            }
        }
    }

    public static HighlightedText getFromCache(ASMSource src) {
        SWF swf = src.getSwf();
        if (swf.as2Cache.contains(src)) {
            return swf.as2Cache.get(src);
        }
        return null;
    }

    public static HighlightedText getCached(ASMSource src, ActionList actions) throws InterruptedException {
        SWF swf = src.getSwf();
        if (swf.as2Cache.contains(src)) {
            return swf.as2Cache.get(src);
        }
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
        writer.startFunction("!script");
        src.getActionScriptSource(writer, actions);
        writer.endFunction();
        HighlightedText res = new HighlightedText(writer);
        swf.as2Cache.put(src, res);
        return res;
    }

    public static HighlightedText getCached(ScriptPack pack) throws InterruptedException {
        SWF swf = pack.getSwf();
        if (swf.as3Cache.contains(pack)) {
            return swf.as3Cache.get(pack);
        }
        int scriptIndex = pack.scriptIndex;
        ScriptInfo script = null;
        if (scriptIndex > -1) {
            script = pack.abc.script_info.get(scriptIndex);
        }
        boolean parallel = Configuration.parallelSpeedUp.get();
        HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
        pack.toSource(writer, script == null ? null : script.traits.traits, new ConvertData(), ScriptExportMode.AS, parallel);
        HighlightedText res = new HighlightedText(writer);
        swf.as3Cache.put(pack, res);
        return res;
    }

    public Cache<CharacterTag, RECT> getRectCache() {
        return this.rectCache;
    }

    public Cache<SHAPE, ShapeExportData> getShapeExportDataCache() {
        return this.shapeExportDataCache;
    }

    public static RECT fixRect(RECT rect) {
        RECT ret = new RECT();
        ret.Xmin = rect.Xmin;
        ret.Xmax = rect.Xmax;
        ret.Ymin = rect.Ymin;
        ret.Ymax = rect.Ymax;
        if (ret.Xmax <= 0) {
            ret.Xmax = ret.getWidth();
            ret.Xmin = 0;
        }
        if (ret.Ymax <= 0) {
            ret.Ymax = ret.getHeight();
            ret.Ymin = 0;
        }
        if (ret.Xmin < 0) {
            ret.Xmax += -ret.Xmin;
            ret.Xmin = 0;
        }
        if (ret.Ymin < 0) {
            ret.Ymax += -ret.Ymin;
            ret.Ymin = 0;
        }
        if (ret.getWidth() < 1 || ret.getHeight() < 1) {
            ret.Xmin = 0;
            ret.Ymin = 0;
            ret.Xmax = 20;
            ret.Ymax = 20;
        }
        return ret;
    }

    public static SerializableImage frameToImageGet(Timeline timeline, int frame, int time, Point cursorPosition, int mouseButton, RECT displayRect, Matrix transformation, ColorTransform colorTransform, Color backGroundColor, double zoom) {
        if (timeline.getFrameCount() == 0) {
            return new SerializableImage(1, 1, SerializableImage.TYPE_INT_ARGB_PRE);
        }
        RECT rect = displayRect;
        SerializableImage image = new SerializableImage((int)((double)rect.getWidth() * zoom / 20.0) + 1, (int)((double)rect.getHeight() * zoom / 20.0) + 1, SerializableImage.TYPE_INT_ARGB_PRE);
        if (backGroundColor == null) {
            image.fillTransparent();
        } else {
            Graphics2D g = (Graphics2D)image.getBufferedImage().getGraphics();
            g.setComposite(AlphaComposite.Src);
            g.setColor(backGroundColor);
            g.fill(new Rectangle(image.getWidth(), image.getHeight()));
        }
        Matrix m = transformation.clone();
        m.translate((double)(-rect.Xmin) * zoom, (double)(-rect.Ymin) * zoom);
        m.scale(zoom);
        RenderContext renderContext = new RenderContext();
        renderContext.cursorPosition = cursorPosition;
        renderContext.mouseButton = mouseButton;
        timeline.toImage(frame, time, renderContext, image, false, m, transformation, m, colorTransform);
        return image;
    }

    private void removeTagWithDependenciesFromTimeline(Tag toRemove, Timeline timeline) {
        HashMap<Integer, Integer> stage = new HashMap<Integer, Integer>();
        Set<Object> dependingChars = new HashSet();
        Timelined timelined = timeline.timelined;
        ReadOnlyTagList tags = timelined.getTags();
        if (toRemove instanceof CharacterTag) {
            int characterId = ((CharacterTag)toRemove).getCharacterId();
            dependingChars = this.getDependentCharacters(characterId);
            dependingChars.add(characterId);
        }
        for (int i = 0; i < tags.size(); ++i) {
            CharacterIdTag c;
            RemoveTag rt;
            int depth;
            Tag t = tags.get(i);
            if (t instanceof RemoveTag && stage.containsKey(depth = (rt = (RemoveTag)t).getDepth())) {
                int currentCharId = (Integer)stage.get(depth);
                stage.remove(depth);
                if (dependingChars.contains(currentCharId)) {
                    timelined.removeTag(i);
                    --i;
                    continue;
                }
            }
            if (t instanceof PlaceObjectTypeTag) {
                PlaceObjectTypeTag po = (PlaceObjectTypeTag)t;
                int placeCharId = po.getCharacterId();
                int depth2 = po.getDepth();
                if (placeCharId >= 0) {
                    stage.put(depth2, placeCharId);
                } else if (stage.containsKey(depth2)) {
                    placeCharId = (Integer)stage.get(depth2);
                }
                if (placeCharId >= 0 && dependingChars.contains(placeCharId)) {
                    timelined.removeTag(i);
                    --i;
                    continue;
                }
            }
            if (t instanceof CharacterIdTag && dependingChars.contains((c = (CharacterIdTag)((Object)t)).getCharacterId())) {
                timelined.removeTag(i);
                --i;
                continue;
            }
            if (t == toRemove) {
                timelined.removeTag(i);
                --i;
                continue;
            }
            if (!(t instanceof Timelined)) continue;
            this.removeTagWithDependenciesFromTimeline(toRemove, ((Timelined)((Object)t)).getTimeline());
        }
    }

    private boolean removeTagFromTimeline(Tag toRemove, Timeline timeline) {
        boolean modified = false;
        int characterId = -1;
        if (toRemove instanceof CharacterTag) {
            characterId = ((CharacterTag)toRemove).getCharacterId();
            modified = timeline.removeCharacter(characterId);
        }
        Timelined timelined = timeline.timelined;
        ReadOnlyTagList tags = timelined.getTags();
        for (int i = 0; i < tags.size(); ++i) {
            Tag t = tags.get(i);
            if (t == toRemove) {
                timelined.removeTag(t);
                --i;
                continue;
            }
            if (toRemove instanceof CharacterTag && t.removeCharacter(characterId)) {
                modified = true;
                i = -1;
                continue;
            }
            if (!(t instanceof DefineSpriteTag)) continue;
            DefineSpriteTag spr = (DefineSpriteTag)t;
            boolean sprModified = this.removeTagFromTimeline(toRemove, spr.getTimeline());
            if (sprModified) {
                spr.setModified(true);
            }
            modified |= sprModified;
        }
        return modified;
    }

    public void removeTags(Collection<Tag> tags, boolean removeDependencies) {
        HashSet<Timelined> timelineds = new HashSet<Timelined>();
        for (Tag tag : tags) {
            Timelined timelined = tag.getTimelined();
            timelineds.add(timelined);
            this.removeTagInternal(timelined, tag, removeDependencies);
        }
        for (Timelined timelined : timelineds) {
            this.resetTimelines(timelined);
        }
        this.updateCharacters();
        this.clearImageCache();
    }

    @Override
    public void removeTag(int index) {
        this.setModified(true);
        this.tags.remove(index);
        this.updateCharacters();
    }

    @Override
    public void removeTag(Tag tag) {
        this.setModified(true);
        this.tags.remove(tag);
        this.updateCharacters();
    }

    public void removeTag(Tag tag, boolean removeDependencies) {
        Timelined timelined = tag.getTimelined();
        this.removeTagInternal(timelined, tag, removeDependencies);
        this.resetTimelines(timelined);
        this.updateCharacters();
        this.clearImageCache();
    }

    private void removeTagInternal(Timelined timelined, Tag tag, boolean removeDependencies) {
        if (tag instanceof ShowFrameTag || ShowFrameTag.isNestedTagType(tag.getId())) {
            timelined.removeTag(tag);
            timelined.setModified(true);
            timelined.resetTimeline();
        } else if (removeDependencies) {
            this.removeTagWithDependenciesFromTimeline(tag, timelined.getTimeline());
            timelined.setModified(true);
        } else {
            boolean modified = this.removeTagFromTimeline(tag, timelined.getTimeline());
            if (modified) {
                timelined.setModified(true);
            }
        }
    }

    @Override
    public ReadOnlyTagList getTags() {
        if (this.readOnlyTags == null) {
            this.readOnlyTags = new ReadOnlyTagList(this.tags);
        }
        return this.readOnlyTags;
    }

    public ReadOnlyTagList getLocalTags() {
        ArrayList<Tag> localTags = new ArrayList<Tag>();
        for (Tag t : this.tags) {
            if (t.isImported()) continue;
            localTags.add(t);
        }
        return new ReadOnlyTagList(localTags);
    }

    @Override
    public void addTag(Tag tag) {
        this.setModified(true);
        this.tags.add(tag);
        this.updateCharacters();
    }

    @Override
    public void addTag(int index, Tag tag) {
        this.setModified(true);
        this.tags.add(index, tag);
        this.updateCharacters();
    }

    public void replaceTag(Tag oldTag, Tag newTag) {
        this.setModified(true);
        int index = this.tags.indexOf(oldTag);
        if (index != -1) {
            this.tags.set(index, newTag);
            this.updateCharacters();
        }
    }

    public void addTag(Tag tag, TreeItem targetTreeItem) {
        int index;
        SWF swf = tag.getSwf();
        Frame frame = targetTreeItem instanceof Frame ? (Frame)targetTreeItem : null;
        Timelined timelined = frame != null ? frame.timeline.timelined : swf.getTimelined(targetTreeItem);
        tag.setTimelined(timelined);
        ReadOnlyTagList tags = timelined.getTags();
        if (frame != null) {
            index = frame.showFrameTag != null ? tags.indexOf(frame.showFrameTag) : -1;
        } else if (timelined instanceof DefineSpriteTag) {
            index = -1;
        } else if (targetTreeItem instanceof Tag) {
            if (tag instanceof CharacterIdTag && !(tag instanceof CharacterTag) && targetTreeItem instanceof CharacterTag) {
                ((CharacterIdTag)((Object)tag)).setCharacterId(((CharacterTag)targetTreeItem).getCharacterId());
            }
            index = tags.indexOf((Tag)targetTreeItem);
        } else {
            index = -1;
            if (tag instanceof CharacterTag) {
                for (int i = tags.size() - 1; i >= 0; --i) {
                    if (!(tags.get(i) instanceof ShowFrameTag)) continue;
                    index = i;
                    break;
                }
            }
        }
        if (index > -1) {
            timelined.addTag(index, tag);
        } else {
            timelined.addTag(tag);
        }
        timelined.resetTimeline();
        if (timelined instanceof DefineSpriteTag) {
            DefineSpriteTag sprite = (DefineSpriteTag)timelined;
            sprite.frameCount = timelined.getTimeline().getFrameCount();
        }
    }

    public Timelined getTimelined(TreeItem treeItem) {
        if (treeItem instanceof Frame) {
            return ((Frame)treeItem).timeline.timelined;
        }
        if (treeItem instanceof DefineSpriteTag) {
            return (DefineSpriteTag)treeItem;
        }
        return treeItem.getSwf();
    }

    public void packCharacterIds() {
        int maxId = this.getNextCharacterId();
        int id = 1;
        for (int i = 1; i < maxId; ++i) {
            CharacterTag charactertag = this.getCharacter(i);
            if (charactertag != null) {
                if (i != id) {
                    this.replaceCharacter(i, id);
                }
                ++id;
                continue;
            }
            this.replaceCharacter(i, 0);
        }
    }

    public void sortCharacterIds() {
        CharacterTag characterTag;
        int maxId;
        int id = maxId = Math.max(this.tags.size(), this.getNextCharacterId());
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof CharacterTag)) continue;
            characterTag = (CharacterTag)tag;
            this.replaceCharacter(characterTag.getCharacterId(), id++);
        }
        id = 1;
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof CharacterTag)) continue;
            characterTag = (CharacterTag)tag;
            this.replaceCharacter(characterTag.getCharacterId(), id++);
        }
    }

    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        for (Tag tag : this.getTags()) {
            CharacterIdTag characterIdTag;
            boolean modified2 = false;
            if (tag instanceof CharacterIdTag && (characterIdTag = (CharacterIdTag)((Object)tag)).getCharacterId() == oldCharacterId) {
                characterIdTag.setCharacterId(newCharacterId);
                modified2 = true;
            }
            if (modified2 |= tag.replaceCharacter(oldCharacterId, newCharacterId)) {
                tag.setModified(true);
            }
            modified |= modified2;
        }
        return modified;
    }

    public void replaceCharacterTags(CharacterTag characterTag, int newCharacterId) {
        int characterId = characterTag.getCharacterId();
        CharacterTag newCharacter = this.getCharacter(newCharacterId);
        newCharacter.setCharacterId(characterId);
        characterTag.setCharacterId(newCharacterId);
        newCharacter.setModified(true);
        characterTag.setModified(true);
        this.assignExportNamesToSymbols();
        this.assignClassesToSymbols();
        this.clearImageCache();
        this.updateCharacters();
    }

    public String toString() {
        return this.getShortFileName();
    }

    public void deobfuscate(DeobfuscationLevel level) throws InterruptedException {
        List<ABCContainerTag> atags = this.getAbcList();
        for (ABCContainerTag tag : atags) {
            if (level == DeobfuscationLevel.LEVEL_REMOVE_DEAD_CODE) {
                tag.getABC().removeDeadCode();
            } else if (level == DeobfuscationLevel.LEVEL_REMOVE_TRAPS) {
                tag.getABC().removeTraps();
            } else if (level == DeobfuscationLevel.LEVEL_RESTORE_CONTROL_FLOW) {
                tag.getABC().removeTraps();
            }
            ((Tag)((Object)tag)).setModified(true);
        }
    }

    public void enableDebugging(boolean injectAS3Code, File decompileDir) {
        this.enableDebugging(injectAS3Code, decompileDir, false);
    }

    public void enableDebugging() {
        this.enableDebugging(false, null, false);
    }

    public void enableDebugging(boolean injectAS3Code, File decompileDir, boolean telemetry) {
        this.enableDebugging(injectAS3Code, decompileDir, telemetry, false);
    }

    public void injectAS3PcodeDebugInfo() {
        List<ScriptPack> packs = this.getAS3Packs();
        for (ScriptPack s : packs) {
            int abcIndex = s.allABCs.indexOf(s.abc);
            if (!s.isSimple) continue;
            s.injectPCodeDebugInfo(abcIndex);
        }
    }

    public void injectAS3DebugInfo(File decompileDir) {
        List<ScriptPack> packs = this.getAS3Packs();
        for (ScriptPack s : packs) {
            if (!s.isSimple) continue;
            s.injectDebugInfo(decompileDir);
        }
    }

    public void enableDebugging(boolean injectAS3Code, File decompileDir, boolean telemetry, boolean pcodeLevel) {
        if (injectAS3Code) {
            if (pcodeLevel) {
                this.injectAS3PcodeDebugInfo();
            } else {
                this.injectAS3DebugInfo(decompileDir);
            }
        }
        int pos = 0;
        boolean hasEnabled = false;
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag t = this.tags.get(i);
            if (t instanceof MetadataTag) {
                pos = i + 1;
            }
            if (t instanceof FileAttributesTag) {
                pos = i + 1;
            }
            if (this.version >= 6 && t instanceof EnableDebugger2Tag) {
                hasEnabled = true;
                break;
            }
            if (this.version == 5 && t instanceof EnableDebuggerTag) {
                hasEnabled = true;
                break;
            }
            if (this.version >= 5 || !(t instanceof ProtectTag)) continue;
            hasEnabled = true;
            break;
        }
        if (!hasEnabled) {
            if (this.version >= 6) {
                this.tags.add(pos, new EnableDebugger2Tag(this));
            } else if (this.version == 5) {
                this.tags.add(pos, new EnableDebuggerTag(this));
            } else {
                this.tags.add(pos, new ProtectTag(this));
            }
        }
        this.getOrAddDebugId();
    }

    public DebugIDTag getDebugId() {
        for (Tag t : this.getTags()) {
            if (!(t instanceof DebugIDTag)) continue;
            return (DebugIDTag)t;
        }
        return null;
    }

    public DebugIDTag getOrAddDebugId() {
        DebugIDTag r = this.getDebugId();
        if (r == null) {
            for (int i = 0; i < this.tags.size(); ++i) {
                Tag t = this.tags.get(i);
                if (!(t instanceof EnableDebuggerTag) && !(t instanceof EnableDebugger2Tag)) continue;
                r = new DebugIDTag(this);
                this.tags.add(i + 1, r);
                new Random().nextBytes(r.debugId);
                break;
            }
        }
        return r;
    }

    public boolean generatePCodeSwdFile(File file, Map<String, Set<Integer>> breakpoints) throws IOException {
        DebugIDTag dit = this.getDebugId();
        if (dit == null) {
            return false;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        Map<String, ASMSource> asms = this.getASMs(true);
        try {
            items.add(new SWD.DebugId(dit.debugId));
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "message", t);
            return false;
        }
        int moduleId = 0;
        ArrayList<String> names = new ArrayList<String>(asms.keySet());
        Collections.sort(names);
        for (String name : names) {
            String sname = "#PCODE " + name;
            int bitmap = 1;
            items.add(new SWD.DebugScript(++moduleId, bitmap, sname, ""));
            HighlightedTextWriter writer = new HighlightedTextWriter(Configuration.getCodeFormatting(), true);
            try {
                asms.get(name).getASMSource(ScriptExportMode.PCODE, writer, null);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            List<Highlighting> hls = writer.instructionHilights;
            TreeMap<Integer, Integer> offsetToLine = new TreeMap<Integer, Integer>();
            String txt = writer.toString();
            txt = txt.replace("\r", "");
            int line = 1;
            for (int i = 0; i < txt.length(); ++i) {
                int of;
                Highlighting h = Highlighting.searchPos(hls, i);
                if (h != null && (of = (int)h.getProperties().fileOffset) > -1 && !offsetToLine.containsKey(of) && !offsetToLine.containsValue(line)) {
                    offsetToLine.put(of, line);
                }
                if (txt.charAt(i) != '\n') continue;
                ++line;
            }
            Iterator i = offsetToLine.keySet().iterator();
            while (i.hasNext()) {
                int ofs = (Integer)i.next();
                items.add(new SWD.DebugOffset(moduleId, ((Integer)offsetToLine.get(ofs)).intValue(), ofs));
            }
            if (!breakpoints.containsKey(sname)) continue;
            Set<Integer> bplines = breakpoints.get(sname);
            for (int bpline : bplines) {
                if (!offsetToLine.containsValue(bpline)) continue;
                try {
                    SWD.DebugBreakpoint dbp = new SWD.DebugBreakpoint(moduleId, bpline);
                    items.add(dbp);
                }
                catch (IllegalArgumentException iex) {
                    logger.log(Level.WARNING, "Cannot generate breakpoint to SWD: {0}", iex.getMessage());
                }
            }
        }
        SWD swd = new SWD(7, items);
        try (FileOutputStream fis = new FileOutputStream(file);){
            swd.saveTo((OutputStream)fis);
        }
        return true;
    }

    public boolean generateSwdFile(File file, Map<String, Set<Integer>> breakpoints) throws IOException {
        DebugIDTag dit = this.getDebugId();
        if (dit == null) {
            return false;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        Map<String, ASMSource> asms = this.getASMs(true);
        try {
            items.add(new SWD.DebugId(dit.debugId));
            int moduleId = 0;
            ArrayList<String> names = new ArrayList<String>(asms.keySet());
            Collections.sort(names);
            for (String name : names) {
                Object curRegIndexes;
                HighlightedText cs;
                ArrayList<SWD.DebugRegisters> regitems = new ArrayList<SWD.DebugRegisters>();
                ++moduleId;
                try {
                    cs = SWF.getCached(asms.get(name), null);
                }
                catch (InterruptedException ex) {
                    return false;
                }
                String txt = cs.text.replace("\r", "");
                int line = 1;
                HashMap<Integer, Integer> lineToOffset = new HashMap<Integer, Integer>();
                HashMap<Integer, String> regNames = new HashMap<Integer, String>();
                for (int pos = 0; pos < txt.length(); ++pos) {
                    Highlighting h = Highlighting.searchPos(cs.getInstructionHighlights(), pos);
                    if (h != null) {
                        int n = (int)h.getProperties().firstLineOffset;
                        if (!(n <= -1 || !h.getProperties().declaration || h.getProperties().regIndex <= -1 || regNames.containsKey(h.getProperties().regIndex) && ((String)regNames.get(h.getProperties().regIndex)).equals(h.getProperties().localName))) {
                            regNames.put(h.getProperties().regIndex, h.getProperties().localName);
                            curRegIndexes = new ArrayList(regNames.keySet());
                            ArrayList curRegNames = new ArrayList();
                            for (int i = 0; i < curRegIndexes.size(); ++i) {
                                curRegNames.add(regNames.get(curRegIndexes.get(i)));
                            }
                            regitems.add(new SWD.DebugRegisters((int)h.getProperties().firstLineOffset, (List)curRegIndexes, curRegNames));
                        }
                        if (n != -1 && !lineToOffset.containsKey(line)) {
                            lineToOffset.put(line, n);
                        }
                    }
                    if (txt.charAt(pos) != '\n') continue;
                    ++line;
                }
                TreeMap offSetToLine = new TreeMap();
                for (Map.Entry entry : lineToOffset.entrySet()) {
                    offSetToLine.put(entry.getValue(), entry.getKey());
                }
                String sname = name;
                int n = 1;
                items.add(new SWD.DebugScript(moduleId, n, sname, txt));
                curRegIndexes = offSetToLine.keySet().iterator();
                while (curRegIndexes.hasNext()) {
                    int ofs = (Integer)curRegIndexes.next();
                    items.add(new SWD.DebugOffset(moduleId, ((Integer)offSetToLine.get(ofs)).intValue(), ofs));
                }
                if (breakpoints.containsKey(name)) {
                    Set<Integer> bplines = breakpoints.get(name);
                    for (int bpline : bplines) {
                        if (!lineToOffset.containsKey(bpline)) continue;
                        try {
                            SWD.DebugBreakpoint dbp = new SWD.DebugBreakpoint(moduleId, bpline);
                            items.add(dbp);
                        }
                        catch (IllegalArgumentException iex) {
                            logger.log(Level.WARNING, "Cannot generate breakpoint to SWD: {0}", iex.getMessage());
                        }
                    }
                }
                items.addAll(regitems);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "message", t);
            return false;
        }
        SWD swd = new SWD(7, items);
        FileOutputStream fis = new FileOutputStream(file);
        Object object = null;
        try {
            swd.saveTo((OutputStream)fis);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fis != null) {
                if (object != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fis.close();
                }
            }
        }
        return true;
    }

    public boolean enableTelemetry(String password) {
        EnableTelemetryTag et = this.getEnableTelemetry();
        if (et == null) {
            FileAttributesTag fat = this.getFileAttributes();
            if (fat == null) {
                return false;
            }
            int insertTo = this.tags.indexOf(fat) + 1;
            MetadataTag mt = this.getMetadata();
            if (mt != null) {
                insertTo = this.tags.indexOf(mt) + 1;
            }
            et = new EnableTelemetryTag(this);
            this.tags.add(insertTo, et);
        }
        et.setPassword(password);
        return true;
    }

    public String getFlexMainClass(List<String> ignoredClasses, List<String> ignoredNs) {
        Trait firstTrait;
        String documentClass = this.getDocumentClass();
        ScriptPack documentPack = null;
        for (ScriptPack item : this.getAS3Packs()) {
            if (!item.getClassPath().toString().equals(documentClass)) continue;
            documentPack = item;
            break;
        }
        if (documentPack != null && !documentPack.traitIndices.isEmpty() && (firstTrait = documentPack.abc.script_info.get((int)documentPack.scriptIndex).traits.traits.get(documentPack.traitIndices.get(0))) instanceof TraitClass) {
            int cindex = ((TraitClass)firstTrait).class_info;
            Multiname superName = documentPack.abc.constants.getMultiname(documentPack.abc.instance_info.get((int)cindex).super_index);
            String parentClass = superName.getNameWithNamespace(documentPack.abc.constants, true).toRawString();
            if ("mx.managers.SystemManager".equals(parentClass)) {
                for (Trait t : documentPack.abc.instance_info.get((int)cindex).instance_traits.traits) {
                    if (!(t instanceof TraitMethodGetterSetter) || !"info".equals(t.getName(documentPack.abc).getName(documentPack.abc.constants, new ArrayList<DottedChain>(), true, true))) continue;
                    int mi = ((TraitMethodGetterSetter)t).method_info;
                    try {
                        documentPack.abc.findBody(mi).convert(new ConvertData(), "??", ScriptExportMode.AS, true, mi, documentPack.scriptIndex, cindex, documentPack.abc, t, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new ArrayList<Traits>(), true);
                        List<GraphTargetItem> infos = documentPack.abc.findBody((int)mi).convertedItems;
                        if (infos.isEmpty() || !(infos.get(0) instanceof IfItem)) continue;
                        IfItem ift = (IfItem)infos.get(0);
                        if (ift.onTrue.isEmpty() || !(ift.onTrue.get(0) instanceof InitPropertyAVM2Item) || !(ift.onTrue.get((int)0).value instanceof NewObjectAVM2Item)) continue;
                        NewObjectAVM2Item no = (NewObjectAVM2Item)ift.onTrue.get((int)0).value;
                        ArrayList<String> compiledLocales = new ArrayList<String>();
                        ArrayList<String> compiledResourceBundleNames = new ArrayList<String>();
                        ArrayList<String> mixins = new ArrayList<String>();
                        String mainClassName = null;
                        block16: for (NameValuePair nvp : no.pairs) {
                            String n;
                            if (!(nvp.name instanceof StringAVM2Item)) continue;
                            switch (n = ((StringAVM2Item)nvp.name).getValue()) {
                                case "compiledLocales": {
                                    if (!(nvp.value instanceof NewArrayAVM2Item)) break;
                                    NewArrayAVM2Item na = (NewArrayAVM2Item)nvp.value;
                                    for (GraphTargetItem tv : na.values) {
                                        compiledLocales.add("" + tv.getResult());
                                    }
                                    continue block16;
                                }
                                case "compiledResourceBundleNames": {
                                    if (!(nvp.value instanceof NewArrayAVM2Item)) break;
                                    NewArrayAVM2Item na = (NewArrayAVM2Item)nvp.value;
                                    for (GraphTargetItem tv : na.values) {
                                        compiledResourceBundleNames.add("" + tv.getResult());
                                    }
                                    continue block16;
                                }
                                case "mixins": {
                                    if (!(nvp.value instanceof NewArrayAVM2Item)) break;
                                    NewArrayAVM2Item na = (NewArrayAVM2Item)nvp.value;
                                    for (GraphTargetItem tv : na.values) {
                                        mixins.add("" + tv.getResult());
                                    }
                                    continue block16;
                                }
                                case "mainClassName": {
                                    mainClassName = "" + nvp.value.getResult();
                                }
                            }
                        }
                        ignoredClasses.add(documentClass);
                        for (String loc : compiledLocales) {
                            ignoredClasses.add(loc + "$controls_properties");
                            for (String res : compiledResourceBundleNames) {
                                ignoredClasses.add(loc + "$" + res + "_properties");
                            }
                        }
                        ignoredClasses.addAll(mixins);
                        for (ScriptPack p : this.getAS3Packs()) {
                            for (String m : mixins) {
                                if (!m.equals(p.getClassPath().toRawString())) continue;
                                for (int ti : p.traitIndices) {
                                    Trait tr = p.abc.script_info.get((int)p.scriptIndex).traits.traits.get(ti);
                                    if (!(tr instanceof TraitClass)) continue;
                                    int ci = ((TraitClass)tr).class_info;
                                    int cinit = p.abc.class_info.get((int)ci).cinit_index;
                                    p.abc.findBody(cinit).convert(new ConvertData(), "??", ScriptExportMode.AS, true, cinit, p.scriptIndex, cindex, p.abc, t, new ScopeStack(), 0, new NulWriter(), new ArrayList<DottedChain>(), new ArrayList<Traits>(), true);
                                    List<GraphTargetItem> cinitBody = p.abc.findBody((int)cinit).convertedItems;
                                    for (GraphTargetItem cit : cinitBody) {
                                        if (!(cit instanceof SetPropertyAVM2Item) || !(cit.value instanceof GetLexAVM2Item)) continue;
                                        GetLexAVM2Item gl = (GetLexAVM2Item)cit.value;
                                        ignoredClasses.add(gl.propertyName.getNameWithNamespace(p.abc.constants, true).toRawString());
                                    }
                                }
                            }
                        }
                        ignoredNs.add("mx");
                        ignoredNs.add("spark");
                        ignoredNs.add("flashx");
                        return mainClassName;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }
        return null;
    }

    @Override
    public void replaceTag(int index, Tag newTag) {
        this.removeTag(index);
        this.addTag(index, newTag);
    }
}

