/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.proxy;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Pattern;

public class Replacement {
    public String urlPattern;
    public String targetFile;
    public Calendar lastAccess;

    public Replacement(String urlPattern, String targetFile) {
        this.urlPattern = urlPattern;
        this.targetFile = targetFile;
    }

    public boolean matches(String url) {
        String pat = Pattern.quote(this.urlPattern);
        pat = pat.replace("*", "\\E.*\\Q");
        return Pattern.matches(pat, url);
    }

    private static String byteCountStr(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public String toString() {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        long size = new File(this.targetFile).length();
        String sizeS = Replacement.byteCountStr(size, false);
        while (sizeS.length() < 12) {
            sizeS = " " + sizeS;
        }
        if (this.lastAccess == null) {
            return "         | " + sizeS + " | " + this.urlPattern;
        }
        return format.format(this.lastAccess.getTime()) + " | " + sizeS + " | " + this.urlPattern;
    }
}

