/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.proxy;

import com.jpexs.proxy.ProxyConfig;
import com.jpexs.proxy.Reply;

class HttpError {
    StringBuffer content = null;
    Reply reply = null;

    HttpError(int code, String message) {
        String error;
        switch (code) {
            case 400: {
                error = "Bad Request";
                break;
            }
            case 403: {
                error = "Forbidden";
                break;
            }
            case 404: {
                error = "Not found";
                break;
            }
            case 503: {
                error = "Service Unavailable";
                break;
            }
            default: {
                error = "Error";
            }
        }
        this.reply = new Reply();
        this.reply.statusLine = "HTTP/1.0 " + code + " " + error;
        this.reply.setHeaderField("Content-type", "text/html");
        this.reply.setHeaderField("Server", ProxyConfig.appName + "/" + ProxyConfig.appVersion);
        this.content = new StringBuffer();
        this.content.append(message);
    }

    Reply getReply() {
        return this.reply;
    }

    String getContent() {
        if (this.content == null) {
            return null;
        }
        return this.content.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.reply != null) {
            buf.append(this.reply.toString());
        }
        if (this.content != null) {
            buf.append(this.content.toString());
        }
        return buf.toString();
    }
}

