/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.protocol.crypto.signature;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.protocol.constants.HashAlgorithm;
import de.rub.nds.protocol.constants.SignatureAlgorithm;
import de.rub.nds.protocol.crypto.ec.EllipticCurve;
import de.rub.nds.protocol.crypto.ec.Point;
import de.rub.nds.protocol.crypto.hash.HashCalculator;
import de.rub.nds.protocol.crypto.key.DsaPrivateKey;
import de.rub.nds.protocol.crypto.key.EcdsaPrivateKey;
import de.rub.nds.protocol.crypto.key.EddsaPrivateKey;
import de.rub.nds.protocol.crypto.key.PrivateKeyContainer;
import de.rub.nds.protocol.crypto.key.RsaPrivateKey;
import de.rub.nds.protocol.crypto.signature.DsaSignatureComputations;
import de.rub.nds.protocol.crypto.signature.EcdsaSignatureComputations;
import de.rub.nds.protocol.crypto.signature.EddsaSignatureComputations;
import de.rub.nds.protocol.crypto.signature.GostSignatureComputations;
import de.rub.nds.protocol.crypto.signature.NoSignatureComputations;
import de.rub.nds.protocol.crypto.signature.RsaPkcs1SignatureComputations;
import de.rub.nds.protocol.crypto.signature.RsaSsaPssSignatureComputations;
import de.rub.nds.protocol.crypto.signature.SignatureComputations;
import de.rub.nds.protocol.exception.CryptoException;
import de.rub.nds.protocol.util.SilentByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SignatureCalculator {
    private static final Logger LOGGER = LogManager.getLogger();

    public void computeSignature(SignatureComputations computations, PrivateKeyContainer privateKey, byte[] toBeSignedBytes, SignatureAlgorithm signatureAlgorithm, HashAlgorithm hashAlgorithm) {
        if (computations instanceof RsaSsaPssSignatureComputations) {
            if (!(privateKey instanceof RsaPrivateKey)) {
                throw new IllegalArgumentException("RSA SignatureComputations must be used with a RSA PrivateKey");
            }
            if (((RsaSsaPssSignatureComputations)computations).getSalt() == null) {
                throw new IllegalArgumentException("PSS must be used with a salt already prepared in the computations class");
            }
            this.computeRsaPssSignature((RsaSsaPssSignatureComputations)computations, (RsaPrivateKey)privateKey, toBeSignedBytes, hashAlgorithm, (byte[])((RsaSsaPssSignatureComputations)computations).getSalt().getValue());
        } else if (computations instanceof RsaPkcs1SignatureComputations) {
            if (!(privateKey instanceof RsaPrivateKey)) {
                throw new IllegalArgumentException("RSA SignatureComputations must be used with a RSA PrivateKey");
            }
            this.computeRsaPkcs1Signature((RsaPkcs1SignatureComputations)computations, (RsaPrivateKey)privateKey, toBeSignedBytes, hashAlgorithm);
        } else if (computations instanceof DsaSignatureComputations) {
            if (!(privateKey instanceof DsaPrivateKey)) {
                throw new IllegalArgumentException("DSA SignatureComputations must be used with a DSA PrivateKey");
            }
            this.computeDsaSignature((DsaSignatureComputations)computations, (DsaPrivateKey)privateKey, toBeSignedBytes, hashAlgorithm);
        } else if (computations instanceof EcdsaSignatureComputations) {
            if (!(privateKey instanceof EcdsaPrivateKey)) {
                throw new IllegalArgumentException("ECDSA SignatureComputations must be used with a ECDSA PrivateKey");
            }
            this.computeEcdsaSignature((EcdsaSignatureComputations)computations, (EcdsaPrivateKey)privateKey, toBeSignedBytes, hashAlgorithm);
        } else if (computations instanceof EddsaSignatureComputations) {
            if (!(privateKey instanceof EddsaPrivateKey)) {
                throw new IllegalArgumentException("EdDSA SignatureComputations must be used with a EdDSA PrivateKey");
            }
            this.computeEddsaSignature((EddsaSignatureComputations)computations, (EddsaPrivateKey)privateKey, toBeSignedBytes, hashAlgorithm);
        } else {
            if (computations instanceof GostSignatureComputations) {
                throw new UnsupportedOperationException("Unsupported operation");
            }
            if (!(computations instanceof NoSignatureComputations)) {
                throw new UnsupportedOperationException("Unsupported operation");
            }
        }
    }

    public void computeEddsaSignature(EddsaSignatureComputations computations, EddsaPrivateKey privateKey, byte[] toBeSignedBytes, HashAlgorithm hashAlgorithm) {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    public void computeRsaPssSignature(RsaSsaPssSignatureComputations computations, RsaPrivateKey privateKey, byte[] toBeSignedBytes, HashAlgorithm hashAlgorithm, byte[] salt) {
        LOGGER.trace("Computing RSA-PSS signature");
        computations.setPrivateKey(privateKey.getPrivateExponent());
        computations.setModulus(privateKey.getModulus());
        computations.setToBeSignedBytes(toBeSignedBytes);
        computations.setHashAlgorithm(hashAlgorithm);
        computations.setSalt(salt);
        byte[] digest = HashCalculator.compute((byte[])computations.getToBeSignedBytes().getValue(), hashAlgorithm);
        computations.setDigestBytes(digest);
        digest = (byte[])computations.getDigestBytes().getValue();
        LOGGER.debug("Digest: {}", (Object)digest);
        byte[] paddedSaltedDigest = ArrayConverter.concatenate((byte[][])new byte[][]{new byte[8], digest, (byte[])computations.getSalt().getValue()});
        computations.setPaddedSaltedDigest(paddedSaltedDigest);
        paddedSaltedDigest = (byte[])computations.getPaddedSaltedDigest().getValue();
        LOGGER.debug("Padded salted digest: {}", (Object)paddedSaltedDigest);
        byte[] hValue = HashCalculator.compute(paddedSaltedDigest, hashAlgorithm);
        computations.setHValue(hValue);
        hValue = (byte[])computations.getHValue().getValue();
        LOGGER.debug("H: {}", (Object)hValue);
        int emBits = ((BigInteger)computations.getModulus().getValue()).bitLength() - 1;
        int emLength = (emBits + 7) / 8;
        int psLenght = emLength - ((byte[])computations.getSalt().getValue()).length - hValue.length - 2;
        if (psLenght < 0) {
            LOGGER.warn("PS length is negative. Overwritting with 0");
            psLenght = 0;
        }
        byte[] psValue = new byte[psLenght];
        computations.setPsValue(psValue);
        psValue = (byte[])computations.getPsValue().getValue();
        LOGGER.debug("Ps value: {}", (Object)psValue);
        byte[] db = ArrayConverter.concatenate((byte[][])new byte[][]{psValue, {1}, (byte[])computations.getSalt().getValue()});
        computations.setDbValue(db);
        db = (byte[])computations.getDbValue().getValue();
        LOGGER.debug("DB: {}", (Object)db);
        byte[] dbMask = this.maskGeneratorFunction1(hValue, hashAlgorithm, emLength - hValue.length - 1);
        LOGGER.debug("DB mask: {}", (Object)dbMask);
        byte[] maskedDB = this.mask(db, dbMask);
        computations.setMaskedDb(maskedDB);
        maskedDB = (byte[])computations.getMaskedDb().getValue();
        LOGGER.debug("Masked DB: {}", (Object)maskedDB);
        computations.setTfValue(new byte[]{-68});
        int firstByteMask = 255 >>> emLength * 8 - emBits;
        if (maskedDB.length > 0) {
            maskedDB[0] = (byte)(maskedDB[0] & firstByteMask);
        }
        byte[] em = ArrayConverter.concatenate((byte[][])new byte[][]{maskedDB, hValue, (byte[])computations.getTfValue().getValue()});
        computations.setEmValue(em);
        em = (byte[])computations.getEmValue().getValue();
        LOGGER.debug("EM: {}", (Object)em);
        BigInteger emInteger = new BigInteger(1, em);
        BigInteger signature = emInteger.modPow((BigInteger)computations.getPrivateKey().getValue(), (BigInteger)computations.getModulus().getValue());
        computations.setSignatureBytes(ArrayConverter.bigIntegerToByteArray((BigInteger)signature));
        computations.setSignatureValid(true);
    }

    private byte[] mask(byte[] value, byte[] mask) {
        int length = Math.min(value.length, mask.length);
        byte[] maskedValue = new byte[value.length];
        int i = 0;
        while (i < length) {
            maskedValue[i] = (byte)(value[i] ^ mask[i]);
            ++i;
        }
        return maskedValue;
    }

    private byte[] maskGeneratorFunction1(byte[] input, HashAlgorithm mgfAlgorithm, int length) {
        int mgfhLen = mgfAlgorithm.getBitLength() / 8;
        byte[] mask = new byte[length];
        byte[] hashBuf = new byte[mgfhLen];
        byte[] counterBytes = new byte[4];
        int counter = 0;
        while (counter < length / mgfhLen) {
            counterBytes = ArrayConverter.intToBytes((int)counter, (int)4);
            hashBuf = HashCalculator.compute(ArrayConverter.concatenate((byte[][])new byte[][]{input, counterBytes}), mgfAlgorithm);
            System.arraycopy(hashBuf, 0, mask, counter * mgfhLen, mgfhLen);
            ++counter;
        }
        if (counter * mgfhLen < length) {
            counterBytes = ArrayConverter.intToBytes((int)counter, (int)4);
            hashBuf = HashCalculator.compute(ArrayConverter.concatenate((byte[][])new byte[][]{input, counterBytes}), mgfAlgorithm);
            System.arraycopy(hashBuf, 0, mask, counter * mgfhLen, mask.length - counter * mgfhLen);
        }
        return mask;
    }

    public void computeRsaPkcs1Signature(RsaPkcs1SignatureComputations computations, RsaPrivateKey privateKey, byte[] toBeSignedBytes, HashAlgorithm hashAlgorithm) {
        byte[] derEncoded;
        LOGGER.trace("Computing RSA signature");
        computations.setPrivateKey(privateKey.getPrivateExponent());
        computations.setModulus(privateKey.getModulus());
        computations.setToBeSignedBytes(toBeSignedBytes);
        computations.setHashAlgorithm(hashAlgorithm);
        if (hashAlgorithm != HashAlgorithm.NONE) {
            byte[] digest = HashCalculator.compute(toBeSignedBytes, hashAlgorithm);
            computations.setDigestBytes(digest);
            digest = (byte[])computations.getDigestBytes().getValue();
            derEncoded = this.derEncodePkcs1(hashAlgorithm, digest);
            computations.setDerEncodedDigest(derEncoded);
            derEncoded = (byte[])computations.getDerEncodedDigest().getValue();
        } else {
            computations.setDigestBytes((byte[])computations.getToBeSignedBytes().getValue());
            computations.setDerEncodedDigest((byte[])computations.getDigestBytes().getValue());
            derEncoded = (byte[])computations.getDerEncodedDigest().getValue();
        }
        int modLength = ArrayConverter.bigIntegerToByteArray((BigInteger)((BigInteger)computations.getModulus().getValue())).length;
        byte[] padding = this.computePkcs1Padding(derEncoded.length, modLength);
        computations.setPadding(padding);
        padding = (byte[])computations.getPadding().getValue();
        byte[] plainData = ArrayConverter.concatenate((byte[][])new byte[][]{padding, derEncoded});
        computations.setPlainToBeSigned(plainData);
        plainData = (byte[])computations.getPlainToBeSigned().getValue();
        BigInteger plainInteger = new BigInteger(plainData);
        BigInteger signature = plainInteger.modPow((BigInteger)computations.getPrivateKey().getValue(), (BigInteger)computations.getModulus().getValue());
        computations.setSignatureBytes(ArrayConverter.bigIntegerToByteArray((BigInteger)signature, (int)modLength, (boolean)true));
        computations.setSignatureValid(true);
    }

    private byte[] computePkcs1Padding(int toBePaddedLength, int modLengthInByte) {
        if (toBePaddedLength + 3 >= modLengthInByte) {
            return new byte[0];
        }
        SilentByteArrayOutputStream stream = new SilentByteArrayOutputStream();
        byte[] byArray = new byte[2];
        byArray[1] = 1;
        stream.write(byArray);
        while (stream.size() < modLengthInByte - toBePaddedLength - 1) {
            stream.write(-1);
        }
        stream.write(0);
        return stream.toByteArray();
    }

    private byte[] derEncodePkcs1(HashAlgorithm algorithm, byte[] data) {
        ASN1ObjectIdentifier asn1objectIdnetifier = new ASN1ObjectIdentifier(algorithm.getHashAlgorithmIdentifierOid());
        DEROctetString asn1octetString = new DEROctetString(data);
        ASN1Encodable[] encodables = new ASN1Encodable[]{asn1objectIdnetifier, DERNull.INSTANCE};
        DERSequence derSequence = new DERSequence(encodables);
        ASN1Encodable[] encodables2 = new ASN1Encodable[]{derSequence, asn1octetString};
        DERSequence derSequence2 = new DERSequence(encodables2);
        try {
            return derSequence2.getEncoded();
        }
        catch (IOException ex) {
            LOGGER.error("Could not encode der sequence", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void computeDsaSignature(DsaSignatureComputations computations, DsaPrivateKey privateKey, byte[] toBeSignedBytes, HashAlgorithm hashAlgorithm) {
        computations.setQ(privateKey.getQ());
        computations.setP(privateKey.getModulus());
        computations.setG(privateKey.getGenerator());
        computations.setNonce(privateKey.getK());
        computations.setPrivateKey(privateKey.getX());
        LOGGER.trace("Computing DSA signature");
        int groupSize = ArrayConverter.bigIntegerToByteArray((BigInteger)privateKey.getQ()).length;
        LOGGER.debug("g: " + String.valueOf(computations.getG().getValue()));
        LOGGER.debug("p: " + String.valueOf(computations.getP().getValue()));
        LOGGER.debug("q: " + String.valueOf(computations.getQ().getValue()));
        LOGGER.debug("Nonce: " + String.valueOf(computations.getNonce().getValue()));
        computations.setToBeSignedBytes(toBeSignedBytes);
        byte[] digest = HashCalculator.compute((byte[])computations.getToBeSignedBytes().getValue(), hashAlgorithm);
        computations.setDigestBytes(digest);
        digest = (byte[])computations.getDigestBytes().getValue();
        LOGGER.debug("toBeSignedBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])computations.getToBeSignedBytes().getValue())));
        LOGGER.debug("Digest: " + ArrayConverter.bytesToHexString((byte[])((byte[])computations.getDigestBytes().getValue())));
        byte[] truncatedHashBytes = Arrays.copyOfRange(digest, 0, Math.min(groupSize, digest.length));
        computations.setTruncatedHashBytes(truncatedHashBytes);
        BigInteger truncatedHashNumber = new BigInteger(1, (byte[])computations.getTruncatedHashBytes().getValue());
        LOGGER.debug("Truncated message digest: " + String.valueOf(truncatedHashNumber));
        BigInteger randomKey = (BigInteger)computations.getNonce().getValue();
        BigInteger r = ((BigInteger)computations.getG().getValue()).modPow(randomKey, (BigInteger)computations.getP().getValue()).mod((BigInteger)computations.getQ().getValue());
        computations.setR(r);
        r = (BigInteger)computations.getR().getValue();
        BigInteger inverseNonce = randomKey.modInverse((BigInteger)computations.getQ().getValue());
        computations.setInverseNonce(inverseNonce);
        inverseNonce = (BigInteger)computations.getInverseNonce().getValue();
        BigInteger xr = ((BigInteger)computations.getPrivateKey().getValue()).multiply(r).mod((BigInteger)computations.getQ().getValue());
        computations.setXr(xr);
        xr = (BigInteger)computations.getXr().getValue();
        LOGGER.debug("Xr: " + String.valueOf(xr));
        BigInteger s = inverseNonce.multiply(truncatedHashNumber.add(xr)).mod((BigInteger)computations.getQ().getValue());
        computations.setS(s);
        s = (BigInteger)computations.getS().getValue();
        LOGGER.debug("s: " + ArrayConverter.bytesToHexString((byte[])s.toByteArray()));
        LOGGER.debug("r: " + ArrayConverter.bytesToHexString((byte[])r.toByteArray()));
        ASN1Integer asn1IntegerR = new ASN1Integer(r);
        ASN1Integer asn1IntegerS = new ASN1Integer(s);
        ASN1Encodable[] encodables = new ASN1Encodable[]{asn1IntegerR, asn1IntegerS};
        DERSequence derSequence = new DERSequence(encodables);
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        try {
            derSequence.encodeTo((OutputStream)outputStream);
        }
        catch (IOException ex) {
            throw new CryptoException("Could not write Signature to output stream");
        }
        byte[] completeSignature = outputStream.toByteArray();
        computations.setSignatureBytes(completeSignature);
        computations.setSignatureValid(true);
    }

    public void computeRawEcdsaSignature(EcdsaSignatureComputations computations, EcdsaPrivateKey privateKey, byte[] toBeSignedBytes, HashAlgorithm hashAlgorithm) {
        LOGGER.trace("Computing ECDSA signature");
        computations.setEcParameters(privateKey.getParameters());
        computations.setHashAlgorithm(hashAlgorithm);
        computations.setNonce(privateKey.getNonce());
        computations.setPrivateKey(privateKey.getPrivateKey());
        computations.setToBeSignedBytes(toBeSignedBytes);
        EllipticCurve curve = computations.getEcParameters().getGroup();
        Point basePoint = curve.getBasePoint();
        BigInteger groupOrder = curve.getBasePointOrder();
        LOGGER.debug("Group order: " + String.valueOf(groupOrder));
        int groupSize = groupOrder.bitLength() / 8;
        LOGGER.debug("Group size: " + groupSize);
        byte[] hash = HashCalculator.compute((byte[])computations.getToBeSignedBytes().getValue(), hashAlgorithm);
        computations.setDigestBytes(hash);
        hash = (byte[])computations.getDigestBytes().getValue();
        LOGGER.debug("Digest: " + ArrayConverter.bytesToHexString((byte[])hash));
        byte[] truncatedHashBytes = Arrays.copyOfRange(hash, 0, Math.min(groupSize, hash.length));
        computations.setTruncatedHashBytes(truncatedHashBytes);
        LOGGER.debug("TruncatedHashBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])computations.getTruncatedHashBytes().getValue())));
        computations.setTruncatedHash(new BigInteger(1, (byte[])computations.getTruncatedHashBytes().getValue()));
        BigInteger truncatedHash = (BigInteger)computations.getTruncatedHash().getValue();
        LOGGER.debug("Truncated hash: {}", (Object)truncatedHash);
        Point randomPoint = curve.mult((BigInteger)computations.getNonce().getValue(), basePoint);
        BigInteger r = randomPoint.getFieldX().getData().mod(curve.getBasePointOrder());
        computations.setR(r);
        r = (BigInteger)computations.getR().getValue();
        LOGGER.debug("R: " + String.valueOf(r));
        BigInteger inverseNonce = ((BigInteger)computations.getPrivateKey().getValue()).modInverse(curve.getBasePointOrder());
        computations.setInverseNonce(inverseNonce);
        inverseNonce = (BigInteger)computations.getInverseNonce().getValue();
        LOGGER.debug("Inverse Nonce: {}", (Object)inverseNonce);
        LOGGER.debug("Verify: {}", (Object)inverseNonce.multiply((BigInteger)computations.getNonce().getValue()).mod(curve.getBasePointOrder()));
        BigInteger rd = r.multiply(privateKey.getPrivateKey());
        rd = rd.mod(curve.getBasePointOrder());
        BigInteger multiplier = rd.add(truncatedHash);
        multiplier = multiplier.mod(curve.getBasePointOrder());
        BigInteger s = inverseNonce.multiply(multiplier);
        s = s.mod(curve.getBasePointOrder());
        computations.setS(s);
        s = (BigInteger)computations.getS().getValue();
        LOGGER.debug("S: {}", (Object)s);
        LOGGER.debug("CurveBasePointOrder: {}", (Object)curve.getBasePointOrder().toByteArray());
        LOGGER.debug("Modulus: {}", (Object)curve.getModulus().toByteArray());
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        outputStream.write(ArrayConverter.bigIntegerToByteArray((BigInteger)r, (int)32, (boolean)true));
        outputStream.write(ArrayConverter.bigIntegerToByteArray((BigInteger)s, (int)32, (boolean)true));
        byte[] completeSignature = outputStream.toByteArray();
        computations.setSignatureBytes(completeSignature);
        computations.setSignatureValid(true);
    }

    public void computeEcdsaSignature(EcdsaSignatureComputations computations, EcdsaPrivateKey privateKey, byte[] toBeSignedBytes, HashAlgorithm hashAlgorithm) {
        LOGGER.trace("Computing ECDSA signature");
        computations.setEcParameters(privateKey.getParameters());
        computations.setHashAlgorithm(hashAlgorithm);
        computations.setNonce(privateKey.getNonce());
        computations.setPrivateKey(privateKey.getPrivateKey());
        computations.setToBeSignedBytes(toBeSignedBytes);
        EllipticCurve curve = computations.getEcParameters().getGroup();
        Point basePoint = curve.getBasePoint();
        BigInteger groupOrder = curve.getBasePointOrder();
        LOGGER.debug("Group order: " + String.valueOf(groupOrder));
        int groupSize = groupOrder.bitLength() / 8;
        LOGGER.debug("Group size: " + groupSize);
        byte[] hash = HashCalculator.compute((byte[])computations.getToBeSignedBytes().getValue(), hashAlgorithm);
        computations.setDigestBytes(hash);
        hash = (byte[])computations.getDigestBytes().getValue();
        LOGGER.debug("Digest: " + ArrayConverter.bytesToHexString((byte[])hash));
        byte[] truncatedHashBytes = Arrays.copyOfRange(hash, 0, Math.min(groupSize, hash.length));
        computations.setTruncatedHashBytes(truncatedHashBytes);
        LOGGER.debug("TruncatedHashBytes: " + ArrayConverter.bytesToHexString((byte[])((byte[])computations.getTruncatedHashBytes().getValue())));
        computations.setTruncatedHash(new BigInteger(1, (byte[])computations.getTruncatedHashBytes().getValue()));
        BigInteger truncatedHash = (BigInteger)computations.getTruncatedHash().getValue();
        LOGGER.debug("Truncated hash: {}", (Object)truncatedHash);
        Point randomPoint = curve.mult((BigInteger)computations.getNonce().getValue(), basePoint);
        BigInteger r = randomPoint.getFieldX().getData().mod(curve.getBasePointOrder());
        computations.setR(r);
        r = (BigInteger)computations.getR().getValue();
        LOGGER.debug("R: {}", (Object)r);
        BigInteger inverseNonce = ((BigInteger)computations.getNonce().getValue()).modInverse(curve.getBasePointOrder());
        computations.setInverseNonce(inverseNonce);
        inverseNonce = (BigInteger)computations.getInverseNonce().getValue();
        LOGGER.debug("Inverse Nonce: {}", (Object)inverseNonce);
        LOGGER.debug("Verify: {}", (Object)inverseNonce.multiply((BigInteger)computations.getNonce().getValue()).mod(curve.getBasePointOrder()));
        BigInteger rd = r.multiply(privateKey.getPrivateKey());
        rd = rd.mod(curve.getBasePointOrder());
        BigInteger multiplier = rd.add(truncatedHash);
        multiplier = multiplier.mod(curve.getBasePointOrder());
        BigInteger s = inverseNonce.multiply(multiplier);
        s = s.mod(curve.getBasePointOrder());
        computations.setS(s);
        s = (BigInteger)computations.getS().getValue();
        LOGGER.debug("S: {}", (Object)s);
        LOGGER.debug("CurveBasePointOrder: {}", (Object)curve.getBasePointOrder().toByteArray());
        LOGGER.debug("Modulus: {}", (Object)curve.getModulus().toByteArray());
        ASN1Integer asn1IntegerR = new ASN1Integer(r);
        ASN1Integer asn1IntegerS = new ASN1Integer(s);
        ASN1Encodable[] encodables = new ASN1Encodable[]{asn1IntegerR, asn1IntegerS};
        DERSequence derSequence = new DERSequence(encodables);
        SilentByteArrayOutputStream outputStream = new SilentByteArrayOutputStream();
        try {
            derSequence.encodeTo((OutputStream)outputStream);
        }
        catch (IOException ex) {
            throw new CryptoException("Could not write Signature to output stream");
        }
        byte[] completeSignature = outputStream.toByteArray();
        computations.setSignatureBytes(completeSignature);
        computations.setSignatureValid(true);
    }

    public SignatureComputations createSignatureComputations(SignatureAlgorithm signatureAlgorithm) {
        if (signatureAlgorithm == null) {
            return new NoSignatureComputations();
        }
        switch (signatureAlgorithm) {
            case DSA: {
                return new DsaSignatureComputations();
            }
            case ECDSA: {
                return new EcdsaSignatureComputations();
            }
            case ED25519: 
            case ED448: {
                return new EddsaSignatureComputations();
            }
            case GOSTR34102001: 
            case GOSTR34102012_256: 
            case GOSTR34102012_512: {
                return new GostSignatureComputations();
            }
            case RSA_PKCS1: {
                return new RsaPkcs1SignatureComputations();
            }
            case RSA_SSA_PSS: {
                return new RsaSsaPssSignatureComputations();
            }
        }
        throw new UnsupportedOperationException("Unsupported signature algorithm: " + String.valueOf((Object)signatureAlgorithm));
    }
}

